/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.core.links;

import de.plans.lib.util.collections.ArrayUtil;

public class LinkFailures {
    public static final int UNKNOWN = 0;
    public static final int ILLEGAL_STATE = 6;
    public static final int UNKNOWN_LINK_TYPE = 5;
    public static final int MISSING_MODULE_DATA = 1;
    public static final int MISSING_LINKABLE_OBJECT = 2;
    public static final int LOCK = 3;
    public static final int CARDINALITY = 4;
    public static final int OPERATION_ADD_LINK = 1;
    public static final int OPERATION_DELETE_LINK = 2;
    public static final int OPERATION_LOCKING = 3;
    public static final int[] REASON_CODES;
    public static final String[] REASON_DESCRIPTIONS;
    public static final int[] OPERATION_CODES;
    public static final String[] OPERATION_DESCRIPTIONS;

    static {
        int[] nArray = new int[7];
        nArray[1] = 6;
        nArray[2] = 5;
        nArray[3] = 1;
        nArray[4] = 2;
        nArray[5] = 3;
        nArray[6] = 4;
        REASON_CODES = nArray;
        REASON_DESCRIPTIONS = new String[]{"Unknown reason", "Illegal link manager state", "Unknown link type", "Missing link start item(MD)", "Missing link end item (LO)", "Couldn't acquire lock", "Violated cardinality constraint"};
        int[] nArray2 = new int[4];
        nArray2[1] = 1;
        nArray2[2] = 2;
        nArray2[3] = 3;
        OPERATION_CODES = nArray2;
        OPERATION_DESCRIPTIONS = new String[]{"Unknown operation", "Link addition", "Link deletion", "Acquiring locks for link"};
    }

    private LinkFailures() {
    }

    public static String getReasonDescription(int reason) {
        assert (ArrayUtil.isIntValueOf((int)reason, (int[])REASON_CODES)) : "Unknown failure reason";
        return REASON_DESCRIPTIONS[ArrayUtil.indexOf((int)reason, (int[])REASON_CODES)];
    }

    public static String getOperationDescription(int operation) {
        assert (ArrayUtil.isIntValueOf((int)operation, (int[])OPERATION_CODES)) : "Unknown operation";
        return OPERATION_DESCRIPTIONS[ArrayUtil.indexOf((int)operation, (int[])OPERATION_CODES)];
    }
}

