/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.core.framedata.transactionmanagement;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeType;
import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.global.license.IClientFunctionLicenseType;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.Messages;
import com.arcway.cockpit.frame.client.project.core.framedata.ModificationProblem;
import com.arcway.cockpit.frame.client.project.core.framedata.transactionmanagement.ILocksAndPermissionsTransactionController;
import com.arcway.cockpit.frame.client.project.core.framedata.transactionmanagement.ILocksAndPermissionsTransactionListener;
import com.arcway.cockpit.frame.client.project.core.locking.LockRequest;
import com.arcway.cockpit.frame.client.project.core.locking.LockResult;
import com.arcway.cockpit.frame.client.project.core.permissions.CockpitPermissionTemplate;
import com.arcway.cockpit.frame.client.project.core.userdefinedattributetypes.IParentOperandTree;
import com.arcway.cockpit.frame.client.project.planagents.IPlanAgentProjectAgent;
import com.arcway.cockpit.frame.shared.ILockable;
import com.arcway.cockpit.frame.shared.message.EOLock;
import com.arcway.lib.ui.IModificationProblem;
import java.util.ArrayList;
import java.util.Collection;

public class LocksAndPermissionsTransactionController
implements ILocksAndPermissionsTransactionController {
    private final IFrameProjectAgent projectAgent;
    private final Collection<ILocksAndPermissionsTransactionListener> listeners = new ArrayList<ILocksAndPermissionsTransactionListener>();
    private final Collection<LockRequest> lockRequests = new ArrayList<LockRequest>();
    private final Collection<LockResult> storedLockResults = new ArrayList<LockResult>();
    private final Collection<LockRequest> locksToCheckOnlyRequests = new ArrayList<LockRequest>();
    private final Collection<AttributeModPermissionRequest> attributeModPermissions = new ArrayList<AttributeModPermissionRequest>();
    private final Collection<PermissionRequest> permissionRequests = new ArrayList<PermissionRequest>();
    private final Collection<IModificationProblem> externalLockModificationProblems = new ArrayList<IModificationProblem>();
    private final Collection<IModificationProblem> externalPermissionModificationProblems = new ArrayList<IModificationProblem>();
    private final Collection<IClientFunctionLicenseType> neededLicenseTypes = new ArrayList<IClientFunctionLicenseType>();
    private boolean projectLockRequest = false;

    public LocksAndPermissionsTransactionController(IFrameProjectAgent projectAgent) {
        this.projectAgent = projectAgent;
    }

    public LocksAndPermissionsTransactionController(IPlanAgentProjectAgent projectAgent) {
        this.projectAgent = ProjectMgr.getProjectMgr().getProjectAgent(projectAgent.getProjectUID());
    }

    @Override
    public void clear() {
        this.lockRequests.clear();
        this.attributeModPermissions.clear();
        this.permissionRequests.clear();
        this.externalLockModificationProblems.clear();
        this.externalPermissionModificationProblems.clear();
        this.storedLockResults.clear();
    }

    @Override
    public void addLock(ILockable lockable, String operation) {
        LockRequest lr = new LockRequest(lockable, operation);
        if (!this.lockRequests.contains(lr)) {
            this.lockRequests.add(lr);
        }
    }

    @Override
    public void addProjectLock() {
        this.projectLockRequest = true;
    }

    @Override
    public void addLockToTest(ILockable lockable, String operation) {
        LockRequest lr = new LockRequest(lockable, operation);
        if (!this.locksToCheckOnlyRequests.contains(lr)) {
            this.locksToCheckOnlyRequests.add(lr);
        }
    }

    @Override
    public void addAttributeModificationPermission(IAttributeType attributeType, IParentOperandTree operandTree) {
        this.addAttributeModificationPermission(attributeType, operandTree, false);
    }

    @Override
    public void addAttributeModificationPermission(IAttributeType attributeType, IParentOperandTree operandTree, boolean forCreation) {
        this.attributeModPermissions.add(new AttributeModPermissionRequest(attributeType, operandTree, forCreation));
    }

    @Override
    public void addPermission(String operation, String operation2, IParentOperandTree operandTree) {
        this.permissionRequests.add(new PermissionRequest(operation, operation2, operandTree));
    }

    @Override
    public void addPermissionModificationProblem(IModificationProblem modificationProblem) {
        this.externalPermissionModificationProblems.add(modificationProblem);
    }

    @Override
    public void addLockModificationProblem(IModificationProblem modificationProblem) {
        this.externalLockModificationProblems.add(modificationProblem);
    }

    @Override
    public void addLockModificationProblems(Collection<IModificationProblem> newModificationProblems) {
        this.externalLockModificationProblems.addAll(newModificationProblems);
    }

    @Override
    public void addClientLicenseType(IClientFunctionLicenseType clientLicenseType) {
        if (!this.neededLicenseTypes.contains(clientLicenseType)) {
            this.neededLicenseTypes.add(clientLicenseType);
        }
    }

    @Override
    public Collection<IModificationProblem> checkConditions(boolean includingLocks, boolean includingPermissions) {
        ArrayList<IModificationProblem> messages = new ArrayList<IModificationProblem>();
        messages.addAll(this.checkLicenses());
        if (includingPermissions) {
            messages.addAll(this.checkPermissions());
        }
        if (includingLocks) {
            Collection<Object> conflictingLocks = new ArrayList();
            try {
                conflictingLocks = this.projectAgent.getFrameLockManager().getConflictingLocks(this.locksToCheckOnlyRequests);
            }
            catch (Exception exception) {
                messages.add(new ModificationProblem(exception, Messages.getString("LocksAndPermissionsTransactionController.CannotExecuteOperation")));
            }
            for (EOLock eOLock : conflictingLocks) {
                messages.add(new ModificationProblem(eOLock, Messages.getString("LocksAndPermissionsTransactionController.CannotExecuteOperation")));
            }
        }
        return messages;
    }

    @Override
    public Collection<IModificationProblem> allocateLocks() {
        ArrayList<IModificationProblem> lockMessages = new ArrayList<IModificationProblem>();
        if (this.externalLockModificationProblems.isEmpty()) {
            LockResult lockResult;
            if (this.projectLockRequest) {
                lockResult = this.projectAgent.getFrameLockManager().setExclusiveProjectLock();
                this.storedLockResults.add(lockResult);
            } else {
                lockResult = null;
            }
            if (lockResult == null || lockResult.wasSuccessful()) {
                ArrayList<EOLock> locksToCheck = new ArrayList<EOLock>();
                ArrayList<EOLock> locksToBeSet = new ArrayList<EOLock>();
                for (LockRequest lockRequest : this.locksToCheckOnlyRequests) {
                    locksToCheck.add(lockRequest.createEOLock());
                }
                for (LockRequest lockRequest : this.lockRequests) {
                    locksToBeSet.add(lockRequest.createEOLock());
                }
                lockResult = this.projectAgent.getFrameLockManager().atomicCheckAndSetLocks(locksToCheck, locksToBeSet, false);
                this.storedLockResults.add(lockResult);
            }
            if (!lockResult.wasSuccessful()) {
                Collection<EOLock> conflictingLocks = lockResult.getConflictingLocks();
                if (conflictingLocks.isEmpty()) {
                    lockMessages.add(new ModificationProblem(lockResult.getPossibleServerException(), Messages.getString("LocksAndPermissionsTransactionController.CannotExecuteOperation")));
                } else {
                    for (EOLock lock : conflictingLocks) {
                        lockMessages.add(new ModificationProblem(lock, Messages.getString("LocksAndPermissionsTransactionController.CannotExecuteOperation")));
                    }
                }
            }
        } else {
            lockMessages.addAll(this.externalLockModificationProblems);
        }
        return lockMessages;
    }

    @Override
    public Collection<IModificationProblem> execute() {
        ArrayList<IModificationProblem> result = new ArrayList<IModificationProblem>();
        result.addAll(this.checkPermissions());
        result.addAll(this.checkLicenses());
        if (result.isEmpty()) {
            Collection<IModificationProblem> lockMessages = this.allocateLocks();
            result.addAll(lockMessages);
        }
        for (ILocksAndPermissionsTransactionListener listener : this.listeners) {
            listener.transactionExecuted(result);
        }
        return result;
    }

    private Collection<IModificationProblem> checkLicenses() {
        ArrayList<IModificationProblem> licenseMessages = new ArrayList<IModificationProblem>();
        for (IClientFunctionLicenseType licenseType : this.neededLicenseTypes) {
            if (this.projectAgent.getServerLicenseManager().isLicenseOperationAllowed(licenseType)) continue;
            licenseMessages.add(new ModificationProblem(licenseType, Messages.getString("LocksAndPermissionsTransactionController.CannotExecuteOperation")));
        }
        return licenseMessages;
    }

    private Collection<IModificationProblem> checkPermissions() {
        ArrayList<IModificationProblem> permissionMessages = new ArrayList<IModificationProblem>();
        if (this.externalPermissionModificationProblems.isEmpty()) {
            for (AttributeModPermissionRequest request : this.attributeModPermissions) {
                if (this.projectAgent.getFramePermissionChecker().hasAttributeModificationPermission(request.getAttributeType(), request.getOperandTree(), request.forCreation())) continue;
                permissionMessages.add(new ModificationProblem(request.getAttributeType(), request.getOperandTree(), this.projectAgent));
            }
            for (PermissionRequest permissionRequest : this.permissionRequests) {
                if (this.projectAgent.getFramePermissionChecker().hasPermission(permissionRequest.getOperation(), permissionRequest.getOperation2(), permissionRequest.getOperandTree())) continue;
                CockpitPermissionTemplate template = new CockpitPermissionTemplate(permissionRequest.getOperation(), permissionRequest.getOperation2(), permissionRequest.getOperandTree().getBaseOperand().getPermissionOperandType());
                permissionMessages.add(new ModificationProblem(template, Messages.getString("LocksAndPermissionsTransactionController.CannotExecuteOperation"), this.projectAgent));
            }
        } else {
            permissionMessages.addAll(this.externalPermissionModificationProblems);
        }
        return permissionMessages;
    }

    @Override
    public void rollback() {
        for (ILocksAndPermissionsTransactionListener listener : this.listeners) {
            listener.transactionRolledBack();
        }
        ArrayList<EOLock> locksToRelease = new ArrayList<EOLock>();
        for (LockResult lockResult : this.storedLockResults) {
            if (!lockResult.wasSuccessful()) continue;
            locksToRelease.addAll(lockResult.getAllRequestedLocks());
        }
        this.projectAgent.getFrameLockManager().releaseLocks(locksToRelease);
    }

    @Override
    public void addTransactionListener(ILocksAndPermissionsTransactionListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    @Override
    public void removeTransactionListener(ILocksAndPermissionsTransactionListener listener) {
        this.listeners.remove(listener);
    }

    private class AttributeModPermissionRequest {
        private final IAttributeType attributeType;
        private final IParentOperandTree operandTree;
        private final boolean forCreation;

        public AttributeModPermissionRequest(IAttributeType attributeType, IParentOperandTree operandTree, boolean forCreation) {
            this.attributeType = attributeType;
            this.operandTree = operandTree;
            this.forCreation = forCreation;
        }

        public IAttributeType getAttributeType() {
            return this.attributeType;
        }

        public IParentOperandTree getOperandTree() {
            return this.operandTree;
        }

        public boolean forCreation() {
            return this.forCreation;
        }
    }

    private class PermissionRequest {
        private final String operation;
        private final String operation2;
        private final IParentOperandTree operandTree;

        public PermissionRequest(String operation, String operation2, IParentOperandTree operandTree) {
            this.operandTree = operandTree;
            this.operation = operation;
            this.operation2 = operation2;
        }

        public IParentOperandTree getOperandTree() {
            return this.operandTree;
        }

        public String getOperation() {
            return this.operation;
        }

        public String getOperation2() {
            return this.operation2;
        }
    }
}

