/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.core.framedata.datatypes.filters;

import com.arcway.cockpit.cockpitlib.client.filter.AbstractTextValuesFilter;
import com.arcway.cockpit.cockpitlib.client.filter.gui.TableListFilterItem;
import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.lib.dataviews.util.IModuleProjectSwitchListener;
import com.arcway.cockpit.frame.client.lib.dataviews.util.IModuleProjectSwitchListenerManager;
import com.arcway.cockpit.frame.client.project.core.categories.ObjectTypeCategory;
import com.arcway.cockpit.frame.client.project.modules.IModuleProjectAgent;
import com.arcway.lib.ui.editor.ObjectTypeCategoryLabels;
import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class ObjectTypeCategoryTableListFilterItem
extends TableListFilterItem
implements IModuleProjectSwitchListener {
    private IModuleProjectAgent projectAgent;
    private final String dataTypeUid;

    public ObjectTypeCategoryTableListFilterItem(String name, String dataTypeUid, IModuleProjectSwitchListenerManager projectSwitchListenerManager, AbstractTextValuesFilter filter) {
        super(name, filter);
        this.projectAgent = null;
        projectSwitchListenerManager.registerProjectSwitchListener(this);
        this.dataTypeUid = dataTypeUid;
    }

    public ObjectTypeCategoryTableListFilterItem(String name, String dataTypeUid, IModuleProjectAgent projectAgent, AbstractTextValuesFilter filter) {
        super(name, filter);
        this.projectAgent = projectAgent;
        this.dataTypeUid = dataTypeUid;
    }

    public Control createContent(Composite parent) {
        if (this.projectAgent != null) {
            ArrayList<ObjectTypeCategory> items = new ArrayList<ObjectTypeCategory>(this.projectAgent.getObjectTypeCategoriesManager().getAllCategoriesForObjectTypeSorted(this.dataTypeUid));
            this.clearFilterValues();
            this.addFilterValue(ObjectTypeCategoryLabels.LABEL_DEFAULTCATEGORY, "");
            for (ObjectTypeCategory objectTypeCategory : items) {
                this.addFilterValue(objectTypeCategory.getDisplayName(), objectTypeCategory.getUID());
            }
        } else {
            this.setFilterValues(Collections.emptyList());
        }
        return super.createContent(parent);
    }

    @Override
    public void projectSwitched(String projectUID) {
        this.projectAgent = ProjectMgr.getProjectMgr().getProjectAgent(projectUID);
    }
}

