/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.core.framedata.datatypes.filters;

import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.filters.EONumberFilterValue;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import de.plans.lib.xml.encoding.EXEncoderException;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.lib.xml.encoding.XMLContext;
import de.plans.lib.xml.primitiveTypes.EOInteger;

public class EOIntegerFilterValue
extends EONumberFilterValue {
    private static final ILogger logger = Logger.getLogger(EOIntegerFilterValue.class);
    public static final String XML_NAME = "frame.datatypes.integerfiltervalue";
    public static final EONumberFilterValue STANDARD_FILTER_VALUE = new EOIntegerFilterValue(0, 0, 1);

    public EOIntegerFilterValue() {
        super(XML_NAME);
    }

    public EOIntegerFilterValue(int int1, int int2) {
        super(XML_NAME, new Integer(int1), new Integer(int2));
    }

    public EOIntegerFilterValue(int int1, int int2, int filterMethod) {
        super(XML_NAME, new Integer(int1), new Integer(int2), filterMethod);
    }

    public EOIntegerFilterValue(XMLContext xmlContext) {
        super(XML_NAME, xmlContext);
    }

    @Override
    public EONumberFilterValue getStandardValue() {
        return STANDARD_FILTER_VALUE;
    }

    @Override
    protected void writeChild(Number number, String role, EncodableObjectBase.WriteContext context, int depth) throws EXEncoderException {
        EOInteger child1 = new EOInteger(new Integer(number.intValue()), role);
        child1.writeXMLBody(context, depth);
    }

    @Override
    protected Number extractValue(EncodableObjectBase eo) throws ClassCastException {
        return ((EOInteger)eo).getInteger();
    }
}

