/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.core.framedata.datatypes.filters;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttribute;
import com.arcway.cockpit.client.base.interfaces.frame.gui.IAttributeFilter;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.filters.EODateFilterValue;
import de.plans.lib.xml.encoding.EOEncodableObject;
import java.util.Date;

public class DateAttributeFilter
implements IAttributeFilter {
    private static final DateAttributeFilter instance = new DateAttributeFilter();

    private DateAttributeFilter() {
    }

    public static DateAttributeFilter getInstance() {
        return instance;
    }

    public boolean select(EOEncodableObject filterValue, IAttribute attribute) {
        if (filterValue == null) {
            return true;
        }
        if (filterValue instanceof EODateFilterValue && attribute.getAttributeValue() instanceof String) {
            EODateFilterValue dateFilterValue = (EODateFilterValue)filterValue;
            Date date1 = dateFilterValue.getDate1();
            Date date2 = dateFilterValue.getDate2();
            Date value = this.getDate(attribute.getAttributeValue());
            if (value == null) {
                return false;
            }
            int filterMethod = dateFilterValue.getFilterMethod();
            switch (filterMethod) {
                case 1: {
                    return value.after(date1);
                }
                case 0: {
                    return value.before(date1);
                }
                case 2: {
                    return value.after(date1) && value.before(date2);
                }
            }
            return true;
        }
        return true;
    }

    public EOEncodableObject getStandardFilterValue() {
        return EODateFilterValue.STANDARD_FILTER_VALUE;
    }

    private Date getDate(Object date) {
        if (date instanceof String && !date.equals("")) {
            return new Date(Long.parseLong((String)date));
        }
        return null;
    }
}

