/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.core.framedata.datatypes.filters;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeTypeDataType;
import com.arcway.cockpit.cockpitlib.client.filter.AbstractFilter;
import com.arcway.cockpit.cockpitlib.client.filter.gui.AbstractFilterItem;
import com.arcway.cockpit.cockpitlib.client.filter.gui.Messages;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.filters.ClientMessageDataFactory;
import com.arcway.cockpit.frame.shared.userdefinedattributes.ExInvalidDataType;
import com.arcway.lib.codec.EXDecoderException;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import de.plans.lib.xml.encoding.EOEncodableObject;
import de.plans.lib.xml.encoding.EXEncoderException;
import de.plans.lib.xml.encoding.IEncodableObjectFactory;
import de.plans.lib.xml.encoding.XMLDecoder;
import de.plans.lib.xml.primitiveTypes.EOString;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class AttributeSubstringFilterItem
extends AbstractFilterItem {
    private static String EMPTY_XML_STRING = null;
    private final AbstractFilter filter;
    private Text substringText;
    private String value;
    private final IAttributeTypeDataType dataType;
    private static final ILogger logger = Logger.getLogger(AttributeSubstringFilterItem.class);
    private static final ClientMessageDataFactory factory = ClientMessageDataFactory.getInstance();
    private static final XMLDecoder decoder = new XMLDecoder();

    private static String get_EMPTY_XML_STRING() throws EXEncoderException {
        if (EMPTY_XML_STRING == null) {
            EMPTY_XML_STRING = new EOString("").toXMLString(false);
        }
        return EMPTY_XML_STRING;
    }

    public AttributeSubstringFilterItem(String name, AbstractFilter filter, IAttributeTypeDataType dataType) {
        super(name, filter);
        this.filter = filter;
        this.dataType = dataType;
        this.value = this.convertFromXMLString(filter.getFilterValue());
    }

    public void doConfirmSelection() {
        try {
            if (this.value == null) {
                this.filter.setFilterValue(AttributeSubstringFilterItem.get_EMPTY_XML_STRING());
            } else {
                String xmlStr = this.convertToXMLString(this.value);
                this.filter.setFilterValue(xmlStr);
            }
        }
        catch (ExInvalidDataType e) {
            logger.error((Throwable)e);
        }
        catch (EXEncoderException e) {
            logger.error("Could not set filter Value", (Throwable)e);
        }
    }

    public void resetFilterValueToFilterState() {
        this.value = this.convertFromXMLString(this.filter.getFilterValue());
    }

    public void refresh() {
        this.substringText.setText(this.value != null ? this.value : "");
    }

    public void filterHasChanged() {
        String valueString = this.filter.getFilterValue();
        this.value = this.convertFromXMLString(valueString);
    }

    public String getFilterInfo() {
        if (this.substringText != null) {
            String substring = this.substringText.getText();
            return substring;
        }
        return null;
    }

    public Control createContent(Composite parent) {
        Group group = new Group(parent, 0);
        GridLayout groupLayout = new GridLayout(1, false);
        groupLayout.verticalSpacing = 2;
        groupLayout.horizontalSpacing = 2;
        group.setLayout((Layout)groupLayout);
        GridData groupGD = new GridData(1808);
        group.setLayoutData((Object)groupGD);
        group.setText(this.getName());
        Label lbl = new Label((Composite)group, 0);
        lbl.setText(Messages.getString((String)"SubstringFilterItem.0"));
        this.substringText = new Text((Composite)group, 2052);
        this.substringText.setLayoutData((Object)new GridData(768));
        this.substringText.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                AttributeSubstringFilterItem.this.substringText.selectAll();
            }

            public void focusLost(FocusEvent e) {
                AttributeSubstringFilterItem.this.updateFilter();
                AttributeSubstringFilterItem.this.fireValueChanged();
            }
        });
        this.refresh();
        return group;
    }

    private void updateFilter() {
        this.value = this.substringText.getText().trim();
        this.setSelected(this.value.length() != 0);
        if (this.isUserConfirmationNecessary()) {
            this.confirmSelection();
        }
    }

    public boolean isNoFilterValuesSet() {
        return this.substringText.getText().trim().length() == 0;
    }

    public boolean isAllFilterValuesSet() {
        return !this.isNoFilterValuesSet();
    }

    private String convertToXMLString(String value) throws EXEncoderException {
        EOEncodableObject eo = this.dataType.getValueAsEO((Object)value, null);
        return eo.toXMLString(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String convertFromXMLString(String xmlString) {
        Class<AttributeSubstringFilterItem> clazz = AttributeSubstringFilterItem.class;
        synchronized (AttributeSubstringFilterItem.class) {
            try {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return ((EOString)decoder.decodeXML(xmlString, (IEncodableObjectFactory)factory, true)).getString();
            }
            catch (EXDecoderException e) {
                logger.error((Throwable)e);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return "";
            }
        }
    }
}

