/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.core.framedata.datatypes.filters;

import com.arcway.cockpit.cockpitlib.client.filter.AbstractFilter;
import com.arcway.cockpit.cockpitlib.client.filter.gui.AbstractFilterItem;
import com.arcway.cockpit.cockpitlib.client.filter.gui.Messages;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.filters.ClientMessageDataFactory;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.filters.EODateFilterValue;
import com.arcway.cockpit.frame.shared.userdefinedattributes.ExInvalidDataType;
import com.arcway.lib.codec.EXDecoderException;
import com.arcway.lib.eclipse.gui.widgets.DatePickerDialog;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import de.plans.lib.xml.encoding.EXEncoderException;
import de.plans.lib.xml.encoding.IEncodableObjectFactory;
import de.plans.lib.xml.encoding.XMLDecoder;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Date;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class AttributeDateFilterItem
extends AbstractFilterItem {
    private final AbstractFilter filter;
    private EODateFilterValue value;
    private Combo filterMethodCombo;
    private Text firstDateText;
    private Text secondDateText;
    private Button firstDateButton;
    private Button secondDateButton;
    private static final ILogger logger = Logger.getLogger(AttributeDateFilterItem.class);
    private static final ClientMessageDataFactory factory = ClientMessageDataFactory.getInstance();
    private static final XMLDecoder decoder = new XMLDecoder();
    private static final int METHOD_BEFORE = 0;
    private static final int METHOD_AFTER = 1;
    private static final int METHOD_BETWEEN = 2;
    private static final int[] METHODS;
    private static final String METHOD_NAME_BEFORE;
    private static final String METHOD_NAME_AFTER;
    private static final String METHOD_NAME_BETWEEN;
    private static final String[] METHOD_NAMES;

    static {
        int[] nArray = new int[3];
        nArray[1] = 1;
        nArray[2] = 2;
        METHODS = nArray;
        METHOD_NAME_BEFORE = Messages.getString((String)"DateFilterItem.1");
        METHOD_NAME_AFTER = Messages.getString((String)"DateFilterItem.2");
        METHOD_NAME_BETWEEN = Messages.getString((String)"DateFilterItem.5");
        METHOD_NAMES = new String[]{METHOD_NAME_BEFORE, METHOD_NAME_AFTER, METHOD_NAME_BETWEEN};
    }

    public AttributeDateFilterItem(String name, AbstractFilter filter) {
        super(name, filter);
        this.filter = filter;
        this.value = this.convertFromXMLString(filter.getFilterValue());
    }

    public void doConfirmSelection() {
        try {
            if (this.value == null) {
                this.filter.setFilterValue(EODateFilterValue.STANDARD_FILTER_VALUE.toXMLString(false));
            } else {
                String xmlString = this.convertToXMLString(this.value);
                this.filter.setFilterValue(xmlString);
            }
        }
        catch (ExInvalidDataType e) {
            logger.error((Throwable)e);
        }
        catch (EXEncoderException e) {
            logger.error("Could not set filter Value", (Throwable)e);
        }
    }

    public void resetFilterValueToFilterState() {
        this.value = this.convertFromXMLString(this.filter.getFilterValue());
    }

    public void refresh() {
        DateFormat dateFormat = DateFormat.getDateInstance();
        this.showSecondDate(false);
        this.filterMethodCombo.select(Arrays.binarySearch(METHODS, this.value.getFilterMethod()));
        this.firstDateText.setText(dateFormat.format(this.value.getDate1()));
        if (this.value.getDate2() != null) {
            this.secondDateText.setText(dateFormat.format(this.value.getDate2()));
        }
        this.enableDateFields();
    }

    public void filterHasChanged() {
        String valueString = this.filter.getFilterValue();
        this.value = this.convertFromXMLString(valueString);
    }

    public String getFilterInfo() {
        if (this.isNoFilterValuesSet()) {
            return null;
        }
        String filterInfo = String.valueOf(METHOD_NAMES[this.value.getFilterMethod()]) + " " + this.firstDateText.getText();
        if (this.value.getFilterMethod() == 2) {
            filterInfo = String.valueOf(filterInfo) + " " + this.secondDateText.getText();
        }
        return filterInfo;
    }

    public Control createContent(final Composite parent) {
        Group group = new Group(parent, 0);
        GridLayout groupLayout = new GridLayout(3, false);
        groupLayout.verticalSpacing = 2;
        groupLayout.horizontalSpacing = 2;
        group.setLayout((Layout)groupLayout);
        GridData groupGD = new GridData(1808);
        groupGD.widthHint = 200;
        group.setLayoutData((Object)groupGD);
        group.setText(this.getName());
        this.filterMethodCombo = new Combo((Composite)group, 12);
        GridData filterMethodComboGD = new GridData();
        filterMethodComboGD.widthHint = 50;
        this.filterMethodCombo.setLayoutData((Object)filterMethodComboGD);
        String[] stringArray = METHOD_NAMES;
        int n = METHOD_NAMES.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            this.filterMethodCombo.add(element);
            ++n2;
        }
        this.filterMethodCombo.select(2);
        this.filterMethodCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AttributeDateFilterItem.this.enableDateFields();
                AttributeDateFilterItem.this.updateFilter();
                AttributeDateFilterItem.this.fireValueChanged();
            }
        });
        this.firstDateText = new Text((Composite)group, 2052);
        GridData firstDateTextGD = new GridData();
        firstDateTextGD.widthHint = 75;
        this.firstDateText.setLayoutData((Object)firstDateTextGD);
        this.firstDateText.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                AttributeDateFilterItem.this.firstDateText.selectAll();
            }

            public void focusLost(FocusEvent e) {
                AttributeDateFilterItem.this.updateFilter();
                AttributeDateFilterItem.this.fireValueChanged();
            }
        });
        this.firstDateButton = new Button((Composite)group, 8);
        this.firstDateButton.setText(Messages.getString((String)"DateFilterItem.3"));
        this.firstDateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Date newDate = AttributeDateFilterItem.this.openDatePicker(parent.getShell(), AttributeDateFilterItem.this.firstDateText.getText());
                if (newDate != null) {
                    AttributeDateFilterItem.this.updateFirstDateField(newDate);
                    AttributeDateFilterItem.this.updateFilter();
                    AttributeDateFilterItem.this.fireValueChanged();
                }
            }
        });
        this.secondDateText = new Text((Composite)group, 2052);
        GridData secondDateTextGD = new GridData();
        secondDateTextGD.widthHint = 75;
        secondDateTextGD.horizontalSpan = 2;
        secondDateTextGD.horizontalAlignment = 3;
        this.secondDateText.setLayoutData((Object)secondDateTextGD);
        this.secondDateText.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                AttributeDateFilterItem.this.secondDateText.selectAll();
            }

            public void focusLost(FocusEvent e) {
                AttributeDateFilterItem.this.updateFilter();
                AttributeDateFilterItem.this.fireValueChanged();
            }
        });
        this.secondDateButton = new Button((Composite)group, 8);
        this.secondDateButton.setText(Messages.getString((String)"DateFilterItem.3"));
        this.secondDateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Date newDate = AttributeDateFilterItem.this.openDatePicker(parent.getShell(), AttributeDateFilterItem.this.secondDateText.getText());
                if (newDate != null) {
                    AttributeDateFilterItem.this.updateSecondDateField(newDate);
                    AttributeDateFilterItem.this.updateFilter();
                    AttributeDateFilterItem.this.fireValueChanged();
                }
            }
        });
        this.refresh();
        return group;
    }

    private void updateFirstDateField(Date newDate) {
        try {
            DateFormat dateFormat = DateFormat.getDateInstance();
            String secondDateString = this.secondDateText.getText();
            Date secondDate = dateFormat.parse(secondDateString);
            if (secondDate.getTime() < newDate.getTime()) {
                this.secondDateText.setText(dateFormat.format(newDate));
            }
            this.firstDateText.setText(dateFormat.format(newDate));
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    private void updateSecondDateField(Date newDate) {
        try {
            DateFormat dateFormat = DateFormat.getDateInstance();
            String firstDateString = this.firstDateText.getText();
            Date firstDate = dateFormat.parse(firstDateString);
            if (firstDate.getTime() > newDate.getTime()) {
                this.firstDateText.setText(dateFormat.format(newDate));
            }
            this.secondDateText.setText(dateFormat.format(newDate));
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    private Date openDatePicker(Shell shell, String initialDate) {
        Date date = null;
        try {
            DateFormat dateFormat = DateFormat.getDateInstance();
            date = dateFormat.parse(initialDate);
        }
        catch (ParseException dateFormat) {
            // empty catch block
        }
        DatePickerDialog datePickerDialog = new DatePickerDialog(shell, date);
        if (datePickerDialog.open() == 0) {
            return datePickerDialog.getDate();
        }
        return null;
    }

    private void enableDateFields() {
        if (this.filterMethodCombo.getText().equals(METHOD_NAME_BETWEEN)) {
            this.showFirstDate(true);
            this.showSecondDate(true);
        } else {
            this.showFirstDate(true);
            this.showSecondDate(false);
        }
    }

    private void showFirstDate(boolean value_) {
        this.firstDateText.setVisible(value_);
        this.firstDateButton.setVisible(value_);
    }

    private void showSecondDate(boolean value_) {
        this.secondDateText.setVisible(value_);
        this.secondDateButton.setVisible(value_);
    }

    private void updateFilter() {
        this.setSelected(this.firstDateText.getText().length() > 0);
        DateFormat dateFormat = DateFormat.getDateInstance();
        String dateString = this.firstDateText.getText();
        try {
            Date _firstDate = dateFormat.parse(dateString);
            this.value.setDate1(_firstDate);
        }
        catch (ParseException _firstDate) {
            // empty catch block
        }
        String secondDateString = this.secondDateText.getText();
        try {
            Date _secondDate = dateFormat.parse(secondDateString);
            this.value.setDate2(_secondDate);
        }
        catch (ParseException _secondDate) {
            // empty catch block
        }
        int shownFilterMethod = METHODS[this.filterMethodCombo.getSelectionIndex()];
        this.value.setFilterMethod(shownFilterMethod);
        if (!this.isUserConfirmationNecessary()) {
            this.confirmSelection();
        }
    }

    public boolean isNoFilterValuesSet() {
        return this.firstDateText.getText().length() == 0;
    }

    public boolean isAllFilterValuesSet() {
        return this.firstDateText.getText().length() > 0;
    }

    private String convertToXMLString(EODateFilterValue value_) throws EXEncoderException {
        return value_.toXMLString(false);
    }

    private EODateFilterValue convertFromXMLString(String xmlString) {
        try {
            return (EODateFilterValue)decoder.decodeXML(xmlString, (IEncodableObjectFactory)factory, true);
        }
        catch (EXDecoderException e) {
            logger.error((Throwable)e);
            return null;
        }
    }
}

