/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.core.framedata.datatypes.filters;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeTypeDataType;
import com.arcway.cockpit.cockpitlib.client.filter.AbstractFilter;
import com.arcway.cockpit.cockpitlib.client.filter.gui.AbstractFilterItem;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.filters.ClientMessageDataFactory;
import com.arcway.cockpit.frame.shared.message.MessageDataFactory;
import com.arcway.cockpit.frame.shared.userdefinedattributes.ExInvalidDataType;
import com.arcway.lib.codec.EXDecoderException;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import de.plans.lib.xml.encoding.EXEncoderException;
import de.plans.lib.xml.encoding.IEncodableObjectFactory;
import de.plans.lib.xml.encoding.XMLDecoder;
import de.plans.lib.xml.primitiveTypes.EOBoolean;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class AttributeBooleanFilterItem
extends AbstractFilterItem {
    private final AbstractFilter filter;
    private boolean value;
    private final String name;
    private final IAttributeTypeDataType dataType;
    private Button checkBoolean;
    private static final XMLDecoder decoder = new XMLDecoder();
    private static final ClientMessageDataFactory factory = ClientMessageDataFactory.getInstance();
    private static final ILogger logger = Logger.getLogger(AttributeBooleanFilterItem.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AttributeBooleanFilterItem(String name, AbstractFilter filter, IAttributeTypeDataType dataType) {
        super(name, filter);
        this.name = name;
        this.filter = filter;
        this.dataType = dataType;
        ByteArrayInputStream stream = new ByteArrayInputStream(filter.getFilterValue().getBytes());
        Class<AttributeBooleanFilterItem> clazz = AttributeBooleanFilterItem.class;
        synchronized (AttributeBooleanFilterItem.class) {
            try {
                this.value = ((EOBoolean)decoder.decodeXML((InputStream)stream, (IEncodableObjectFactory)MessageDataFactory.getInstance(), true)).getBoolean();
            }
            catch (EXDecoderException e) {
                logger.error("Could not decode XML string", (Throwable)e);
            }
            return;
        }
    }

    public void doConfirmSelection() {
        try {
            this.filter.setFilterValue(this.dataType.getValueAsEO((Object)this.value, null).toXMLString(false));
        }
        catch (ExInvalidDataType e) {
            logger.error((Throwable)e);
        }
        catch (EXEncoderException e) {
            logger.error("Could not set filter Value", (Throwable)e);
        }
    }

    public void refresh() {
        this.checkBoolean.setSelection(this.value);
    }

    public void filterHasChanged() {
        try {
            this.value = ((EOBoolean)decoder.decodeXML(this.filter.getFilterValue(), (IEncodableObjectFactory)factory, true)).getBoolean();
        }
        catch (EXDecoderException e) {
            logger.error((Throwable)e);
        }
    }

    public String getFilterInfo() {
        return this.value ? "On" : "Off";
    }

    public Control createContent(Composite parent) {
        Group group = new Group(parent, 0);
        GridLayout groupLayout = new GridLayout(2, false);
        groupLayout.verticalSpacing = 2;
        groupLayout.horizontalSpacing = 2;
        group.setLayout((Layout)groupLayout);
        GridData groupGD = new GridData(1808);
        group.setLayoutData((Object)groupGD);
        group.setText(this.getName());
        this.checkBoolean = new Button((Composite)group, 32);
        this.checkBoolean.setLayoutData((Object)new GridData(768));
        this.checkBoolean.setText(this.name);
        this.checkBoolean.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AttributeBooleanFilterItem.this.updateFilter();
                AttributeBooleanFilterItem.this.fireValueChanged();
            }
        });
        this.update();
        return group;
    }

    private void update() {
        this.checkBoolean.setSelection(this.value);
    }

    private void updateFilter() {
        this.value = this.checkBoolean.getSelection();
        super.setSelected(true);
        if (!this.isUserConfirmationNecessary()) {
            this.confirmSelection();
        }
    }

    public void resetFilterValueToFilterState() {
        try {
            this.value = ((EOBoolean)decoder.decodeXML(this.filter.getFilterValue(), (IEncodableObjectFactory)factory, true)).getBoolean();
        }
        catch (EXDecoderException e) {
            logger.error((Throwable)e);
        }
    }

    public boolean isNoFilterValuesSet() {
        return !this.value;
    }

    public boolean isAllFilterValuesSet() {
        return this.value;
    }
}

