/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.core.framedata.datatypes.filemanager;

import com.arcway.cockpit.frame.client.global.Messages;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.core.files.FileID;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.filemanager.DataTypeImage;
import com.arcway.lib.eclipse.gui.ImageInCanvasPainter;
import com.arcway.lib.eclipse.gui.dialogs.FileSystemErrorMessageDialogue;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.resource.FileResource;
import com.arcway.lib.resource.IStreamResource;
import com.arcway.lib.resource.JvmExternalResourceInteractionException;
import java.io.File;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ImageSWTControlFactory
implements DisposeListener {
    private static final ILogger logger = Logger.getLogger(ImageSWTControlFactory.class);
    private final Composite baseArea;
    private final Canvas imageArea;
    private final ImageInCanvasPainter paintListener;
    private Image image;
    private final IFrameProjectAgent projectAgent;
    private final DataTypeImage dataType;
    private final Button removeButton;
    private final Button addButton;
    private boolean enableRemoveButton = true;
    private FileID imageID;
    private FileID originalImageID;

    public ImageSWTControlFactory(Composite parent, int style, DataTypeImage dataType_, IFrameProjectAgent projectAgent_, final IModificationListenerNotifier listenerNotifier) {
        this.dataType = dataType_;
        this.projectAgent = projectAgent_;
        this.imageID = FileID.NO_FILE;
        this.baseArea = new BaseArea(parent, style);
        this.baseArea.setLayoutData((Object)new GridData(1808));
        this.baseArea.setLayout((Layout)new GridLayout());
        this.baseArea.setData((Object)this);
        this.baseArea.addDisposeListener((DisposeListener)this);
        this.imageArea = new Canvas(this.baseArea, 0);
        GridData gridData = new GridData(1808);
        gridData.horizontalAlignment = 0x1000000;
        this.imageArea.setLayoutData((Object)gridData);
        this.paintListener = new ImageInCanvasPainter(this.imageArea, true, false);
        this.imageArea.addPaintListener((PaintListener)this.paintListener);
        Composite buttonArea = new Composite(this.baseArea, 0);
        buttonArea.setLayoutData((Object)new GridData(768));
        buttonArea.setLayout((Layout)new GridLayout(2, true));
        this.addButton = new Button(buttonArea, 0);
        this.addButton.setLayoutData((Object)new GridData());
        this.addButton.setText(Messages.getString("ImageSWTControlFactory.change"));
        this.addButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (ImageSWTControlFactory.this.findLogo()) {
                    listenerNotifier.informModificationListeners(ImageSWTControlFactory.this.imageID, null);
                    ImageSWTControlFactory.this.removeButton.setEnabled(true);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.removeButton = new Button(buttonArea, 0);
        this.removeButton.setLayoutData((Object)new GridData());
        this.removeButton.setText(Messages.getString("ImageSWTControlFactory.remove"));
        this.removeButton.setEnabled(false);
        this.removeButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (!ImageSWTControlFactory.this.imageID.equals(FileID.NO_FILE) && !ImageSWTControlFactory.this.imageID.equals(ImageSWTControlFactory.this.originalImageID)) {
                    ImageSWTControlFactory.this.image.dispose();
                    ImageSWTControlFactory.this.projectAgent.getFilesManager().removeFileFromTemporaryStorage(ImageSWTControlFactory.this.imageID);
                }
                ImageSWTControlFactory.this.imageID = FileID.NO_FILE;
                ImageSWTControlFactory.this.image = null;
                ImageSWTControlFactory.this.paintListener.setImage(null);
                listenerNotifier.informModificationListeners(ImageSWTControlFactory.this.imageID, null);
                ImageSWTControlFactory.this.removeButton.setEnabled(false);
                ImageSWTControlFactory.this.imageArea.redraw();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    public void setInitialValue(FileID imageID) {
        this.originalImageID = imageID;
        this.imageID = imageID;
        if (!imageID.equals(FileID.NO_FILE)) {
            this.image = this.dataType.getImage(imageID);
            this.paintListener.setImage(this.image);
            this.removeButton.setEnabled(this.enableRemoveButton);
        } else {
            this.removeButton.setEnabled(false);
        }
    }

    public void widgetDisposed(DisposeEvent e) {
        if (!this.imageID.equals(this.originalImageID)) {
            this.image.dispose();
        }
    }

    private boolean findLogo() {
        FileDialog fileChooser = new FileDialog(this.baseArea.getShell());
        fileChooser.setText(Messages.getString("PropertyAdvancedProject.8"));
        fileChooser.setFilterExtensions(new String[]{"*.gif; *.jpg; *.png; *.ico; *.bmp"});
        fileChooser.setFilterNames(new String[]{String.valueOf(Messages.getString("PropertyAdvancedProject.10")) + " (gif, jpeg, png, ico, bmp)"});
        String filename = fileChooser.open();
        if (filename != null) {
            try {
                File file = new File(filename);
                FileResource fileResource = new FileResource(file);
                FileID newImageID = this.projectAgent.getFilesManager().loadFileIntoTemporaryStorage((IStreamResource)fileResource);
                if (!this.imageID.equals(FileID.NO_FILE) && !this.imageID.equals(this.originalImageID)) {
                    this.image.dispose();
                    this.projectAgent.getFilesManager().removeFileFromTemporaryStorage(this.imageID);
                }
                this.imageID = newImageID;
                this.image = new Image((Device)this.baseArea.getDisplay(), filename);
                this.paintListener.setImage(this.image);
                this.imageArea.redraw();
                return true;
            }
            catch (SWTException e) {
                logger.error("invalid file", (Throwable)e);
            }
            catch (SWTError e) {
                logger.error("cannot read image file", (Throwable)e);
            }
            catch (JvmExternalResourceInteractionException jeriE) {
                FileSystemErrorMessageDialogue.openFileSystemError((Shell)this.baseArea.getShell());
            }
        }
        return false;
    }

    public void addMouseListener(MouseListener mouseListener) {
        this.imageArea.addMouseListener(mouseListener);
    }

    public Image getImage() {
        return this.image;
    }

    public Control getControl() {
        return this.baseArea;
    }

    public void disposeResources() {
        if (!this.imageID.equals(FileID.NO_FILE) && !this.imageID.equals(this.originalImageID)) {
            this.image.dispose();
            this.projectAgent.getFilesManager().removeFileFromTemporaryStorage(this.imageID);
        }
    }

    private class BaseArea
    extends Composite {
        public BaseArea(Composite parent, int style) {
            super(parent, style);
        }

        public void setEnabled(boolean enabled) {
            ImageSWTControlFactory.this.removeButton.setEnabled(enabled);
            ImageSWTControlFactory.this.enableRemoveButton = enabled;
            ImageSWTControlFactory.this.addButton.setEnabled(enabled);
        }

        public boolean getEnabled() {
            return ImageSWTControlFactory.this.enableRemoveButton;
        }
    }

    public static interface IModificationListenerNotifier {
        public void informModificationListeners(Object var1, Object var2);
    }
}

