/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.core.framedata.datatypes.filemanager;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttribute;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeType;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeTypeDataType;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeTypeID;
import com.arcway.cockpit.frame.client.project.IFrameDataManager;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.core.files.FileID;
import com.arcway.cockpit.frame.client.project.core.framedata.IAttributeOwnerRW;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.filemanager.AbstractDataTypeWithFile;
import java.util.ArrayList;
import java.util.Collection;

public class FilesAsAttributeValuesHelper {
    public static Collection<FileID> getAllFilesUsedAsAttributeValues(IFrameProjectAgent projectAgent) {
        final ArrayList<FileID> filesUsedAsAttributeValues = new ArrayList<FileID>();
        FilesAsAttributeValuesHelper.visitAllFileAttributes(projectAgent, new IFileAttributeVisitor(){

            @Override
            public void visit(IAttributeOwnerRW attributeOwnerRW, IAttribute attribute) {
                FileID fileID = (FileID)attribute.getAttributeValue();
                if (!fileID.equals(FileID.NO_FILE)) {
                    filesUsedAsAttributeValues.add(fileID);
                }
            }
        });
        return filesUsedAsAttributeValues;
    }

    public static void visitAllFileAttributes(IFrameProjectAgent projectAgent, final IFileAttributeVisitor fileAttributeVisitor) {
        IAttributeOwnerRW.IVisitor attributeOwnerVisitor = new IAttributeOwnerRW.IVisitor(){

            @Override
            public void visit(IAttributeOwnerRW attributeOwnerRW) {
                for (IAttribute attribute : attributeOwnerRW.getAllAttributes()) {
                    IAttributeTypeID attributeTypeID = attribute.getAttributeTypeID();
                    IAttributeType attributeType = attributeOwnerRW.getAttributeType(attributeTypeID);
                    IAttributeTypeDataType attributeTypeDataType = attributeType.getDataType();
                    if (!(attributeTypeDataType instanceof AbstractDataTypeWithFile)) continue;
                    fileAttributeVisitor.visit(attributeOwnerRW, attribute);
                }
            }
        };
        for (IFrameDataManager iFrameDataManager : projectAgent.getDataManagers()) {
            iFrameDataManager.visitAllAttributeOwnerRWs(attributeOwnerVisitor);
        }
    }

    public static interface IFileAttributeVisitor {
        public void visit(IAttributeOwnerRW var1, IAttribute var2);
    }
}

