/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.core.framedata.datatypes.filemanager;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IValueRange;
import com.arcway.cockpit.frame.client.global.FramePlugin;
import com.arcway.cockpit.frame.client.global.Icons;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.core.files.FileID;
import com.arcway.cockpit.frame.client.project.core.files.FileMetaInformationItem;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.AbstractDataType;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.Messages;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.filemanager.AbstractDataTypeWithFile;
import com.arcway.cockpit.frame.shared.userdefinedattributes.ExInvalidDataType;
import com.arcway.lib.eclipse.file.UrlLauncher;
import com.arcway.lib.eclipse.file.tmp.CheckOutTempFileProvider;
import com.arcway.lib.eclipse.gui.dialogs.FileChooserDialog;
import com.arcway.lib.eclipse.gui.dialogs.FileSystemErrorMessageDialogue;
import com.arcway.lib.io.AbstractFileWatcher;
import com.arcway.lib.io.DataCopyHelper;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.operating.PeriodicTaskScheduler;
import com.arcway.lib.resource.FileResource;
import com.arcway.lib.resource.FileResourceWithOverwrittenName;
import com.arcway.lib.resource.IStreamResource;
import com.arcway.lib.resource.JvmExternalResourceInteractionException;
import de.plans.psc.client.communication.ExPrematureEndOfTransfer;
import de.plans.psc.client.communication.LoginCanceledException;
import de.plans.psc.client.communication.ServerNotAvailableException;
import de.plans.psc.client.communication.UnknownServerException;
import de.plans.psc.shared.serverexceptions.EXServerException;
import java.io.File;
import java.text.DateFormat;
import java.util.Locale;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;

public class DataTypeFile
extends AbstractDataTypeWithFile {
    private static final ILogger LOGGER = Logger.getLogger(DataTypeFile.class);
    public static final String DATA_TYPE_ID = "file";
    private static final ImageDescriptor imgDescriptorCheckOut = FramePlugin.getImageDescriptor("pencil.png");
    private static final ImageDescriptor imgDescriptorCheckIn = FramePlugin.getImageDescriptor("pencil_ok.png");
    private static final ImageDescriptor imgDescriptorCheckOutCancel = FramePlugin.getImageDescriptor("pencil_stop.png");

    public DataTypeFile(IFrameProjectAgent projectAgent) {
        super(projectAgent);
    }

    public String getID() {
        return DATA_TYPE_ID;
    }

    public String getDisplayName() {
        return this.getDisplayName(Locale.getDefault());
    }

    public String getDisplayName(Locale locale) {
        return Messages.getString("DataTypeFile.file", locale);
    }

    @Override
    protected AbstractDataType.SWTControlForModification createSWTControlForModifying_internal(Composite parent, Object initialValue, IValueRange valueRange) {
        final BaseComposite baseComposite = new BaseComposite(parent, 0);
        FileID fd = (FileID)initialValue;
        baseComposite.setInitialValue(fd);
        AbstractDataType.SWTControlForModification wrapper = new AbstractDataType.SWTControlForModification(this, (Control)baseComposite, new Runnable(){

            @Override
            public void run() {
                baseComposite.disposeResources();
            }
        }, new Runnable(){

            @Override
            public void run() {
                baseComposite.handleCheckOutCancel();
            }
        });
        baseComposite.setModificationListenerKey(wrapper);
        return wrapper;
    }

    public int getSWTHeightHint() {
        return -1;
    }

    public Control createSWTControlForViewing(Composite parent, Object value, IValueRange valueRange) {
        FileID fileID;
        IWorkbenchPage page;
        if (!(value instanceof FileID)) {
            throw new ExInvalidDataType(value.getClass().toString(), FileID.class.toString());
        }
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (page = window.getActivePage()) != null && !(fileID = (FileID)value).equals(FileID.NO_FILE)) {
            FileMetaInformationItem metaInformation = this.getProjectAgent().getFilesManager().getFileMetaInformation(fileID);
            Hyperlink hyperlink = new Hyperlink(parent, 0);
            hyperlink.setText(metaInformation.getOriginalFileName());
            hyperlink.setFont(parent.getFont());
            hyperlink.setForeground(hyperlink.getDisplay().getSystemColor(9));
            hyperlink.setUnderlined(true);
            hyperlink.setBackground(parent.getBackground());
            hyperlink.addHyperlinkListener(new IHyperlinkListener(){

                public void linkEntered(HyperlinkEvent e) {
                }

                public void linkExited(HyperlinkEvent e) {
                }

                public void linkActivated(HyperlinkEvent e) {
                }
            });
            MenuManager menuManager = new MenuManager();
            menuManager.setRemoveAllWhenShown(true);
            Menu contextMenu = menuManager.createContextMenu((Control)hyperlink);
            hyperlink.setMenu(contextMenu);
            menuManager.addMenuListener(new IMenuListener(){

                public void menuAboutToShow(IMenuManager manager) {
                    manager.removeAll();
                }
            });
            return hyperlink;
        }
        Label label = new Label(parent, 0);
        label.setVisible(false);
        return label;
    }

    private class BaseComposite
    extends Composite {
        private boolean enabled;
        private final Text txtFilePath;
        private final Button btnChooseFile;
        private final Button btnDelete;
        private final Button btnCheckInOut;
        private final Button btnCheckOutCancel;
        private SelectionListener checkInOutButtonMouseListener;
        private AbstractDataType.SWTControlForModification modificationListenerKey;
        private FileID originalFileID;
        private FileID fileID;
        private File checkedOutFile;
        private File lastCheckedOutFile;
        private final Image imgCheckOut;
        private final Image imgCheckIn;
        private final Image imgCheckOutCancel;
        private FileWatcher fileWatcher;

        public BaseComposite(Composite parent, int style) {
            super(parent, style);
            this.enabled = true;
            this.fileID = FileID.NO_FILE;
            GridLayout layout = new GridLayout(5, false);
            layout.marginBottom = 0;
            layout.marginHeight = 0;
            layout.marginLeft = 0;
            layout.marginRight = 0;
            layout.marginTop = 0;
            layout.marginWidth = 0;
            this.setLayout((Layout)layout);
            this.txtFilePath = new Text((Composite)this, 2050);
            this.txtFilePath.setEditable(false);
            GridData gd = new GridData(4, 4, true, true);
            gd.minimumHeight = this.txtFilePath.computeSize((int)-1, (int)-1).y * 2 - this.txtFilePath.getBorderWidth();
            this.txtFilePath.setLayoutData((Object)gd);
            this.imgCheckOut = (Image)imgDescriptorCheckOut.createResource((Device)this.getDisplay());
            this.imgCheckIn = (Image)imgDescriptorCheckIn.createResource((Device)this.getDisplay());
            this.imgCheckOutCancel = (Image)imgDescriptorCheckOutCancel.createResource((Device)this.getDisplay());
            this.btnChooseFile = new Button((Composite)this, 0);
            this.btnChooseFile.setLayoutData((Object)new GridData());
            this.btnChooseFile.setImage(Icons.getImageForSection());
            this.btnChooseFile.setToolTipText(Messages.getString("DataTypeFile.ButtonChoose.Tooltip"));
            this.btnChooseFile.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    BaseComposite.this.chooseFile();
                }
            });
            this.btnDelete = new Button((Composite)this, 0);
            this.btnDelete.setLayoutData((Object)new GridData());
            this.btnDelete.setImage(Icons.getImageForDelete());
            this.btnDelete.setEnabled(false);
            this.btnDelete.setToolTipText(Messages.getString("DataTypeFile.ButtonDelete.Tooltip"));
            this.btnDelete.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    BaseComposite.this.removeFileFromTemporaryStorageIfNecessary(BaseComposite.this.fileID);
                    BaseComposite.this.fileID = FileID.NO_FILE;
                    BaseComposite.this.updateControls();
                    BaseComposite.this.updateTextField();
                    DataTypeFile.this.informSWTModifyListeners(BaseComposite.this.modificationListenerKey, BaseComposite.this.fileID, null);
                }
            });
            this.btnCheckInOut = new Button((Composite)this, 0);
            this.btnCheckInOut.setLayoutData((Object)new GridData());
            this.btnCheckInOut.setImage(this.imgCheckOut);
            this.btnCheckInOut.setEnabled(false);
            this.btnCheckInOut.setToolTipText(Messages.getString("DataTypeFile.CheckOut.Tooltip"));
            this.btnCheckOutCancel = new Button((Composite)this, 0);
            this.btnCheckOutCancel.setImage(this.imgCheckOutCancel);
            this.btnCheckOutCancel.setEnabled(false);
            this.btnCheckOutCancel.setToolTipText(Messages.getString("DataTypeFile.CheckOutCancel.Tooltip"));
            this.btnCheckOutCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    BaseComposite.this.handleCheckOutCancel();
                }
            });
        }

        public void setModificationListenerKey(AbstractDataType.SWTControlForModification key) {
            this.modificationListenerKey = key;
        }

        public void setInitialValue(FileID fileID) {
            this.originalFileID = fileID;
            this.fileID = fileID;
            this.updateControls();
            this.updateTextField();
        }

        public void disposeResources() {
            this.stopFileWatcher();
            this.removeFileFromTemporaryStorageIfNecessary(this.fileID);
            imgDescriptorCheckOut.destroyResource((Object)this.imgCheckOut);
            imgDescriptorCheckIn.destroyResource((Object)this.imgCheckIn);
            imgDescriptorCheckOutCancel.destroyResource((Object)this.imgCheckOutCancel);
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
            this.updateControls();
        }

        public boolean getEnabled() {
            return this.enabled;
        }

        private void chooseFile() {
            FileChooserDialog dialog = new FileChooserDialog(new String[0], this.getShell());
            File file = dialog.openForLoad();
            if (file != null && file.exists()) {
                this.setFile(file);
                this.lastCheckedOutFile = null;
            }
        }

        private boolean setFile(File file) {
            return this.setFile(file, null);
        }

        private boolean setFile(File file, String fileName) {
            boolean success = false;
            Object fileResource = fileName == null ? new FileResource(file) : new FileResourceWithOverwrittenName(file, fileName);
            try {
                FileID newFileID = this.loadFileIntoTemporaryStorage((IStreamResource)fileResource);
                if (newFileID != null) {
                    this.removeFileFromTemporaryStorageIfNecessary(this.fileID);
                    this.fileID = newFileID;
                    this.updateTextField();
                    this.updateControls();
                    DataTypeFile.this.informSWTModifyListeners(this.modificationListenerKey, this.fileID, file);
                    success = true;
                }
            }
            catch (JvmExternalResourceInteractionException jeriE) {
                FileSystemErrorMessageDialogue.openFileSystemError((Shell)this.getShell());
            }
            return success;
        }

        private FileID loadFileIntoTemporaryStorage(IStreamResource file) throws JvmExternalResourceInteractionException {
            return DataTypeFile.this.getProjectAgent().getFilesManager().loadFileIntoTemporaryStorage(file);
        }

        private void removeFileFromTemporaryStorageIfNecessary(FileID fileID_) {
            if (!this.fileID.equals(FileID.NO_FILE) && !this.fileID.equals(this.originalFileID)) {
                DataTypeFile.this.getProjectAgent().getFilesManager().removeFileFromTemporaryStorage(fileID_);
            }
        }

        private void handleCheckOut() {
            if (!FileID.NO_FILE.equals(this.fileID)) {
                try {
                    Boolean newCheckOut = null;
                    if (this.lastCheckedOutFile != null && this.lastCheckedOutFile.canRead()) {
                        MessageDialog dialog = new MessageDialog(this.getShell(), Messages.getString("DataTypeFile.DialogOpenProjectOrLocal.Title"), this.getDisplay().getSystemImage(4), Messages.getString("DataTypeFile.DialogOpenProjectOrLocal.Question"), 3, new String[]{Messages.getString("DataTypeFile.DialogOpenProjectOrLocal.OpenFromProject"), Messages.getString("DataTypeFile.DialogOpenProjectOrLocal.OpenLocal")}, 0);
                        int dialogAnswerCode = dialog.open();
                        if (dialogAnswerCode == 0) {
                            newCheckOut = Boolean.TRUE;
                        } else if (dialogAnswerCode == 1) {
                            newCheckOut = Boolean.FALSE;
                        }
                    } else {
                        newCheckOut = Boolean.TRUE;
                    }
                    if (newCheckOut != null) {
                        if (newCheckOut.booleanValue()) {
                            FileMetaInformationItem metaInformation = DataTypeFile.this.getProjectAgent().getFilesManager().getFileMetaInformation(this.fileID);
                            File targetCheckOutFile = new CheckOutTempFileProvider(metaInformation.getOriginalFileName()).createTemporaryDirectory().createTemporaryFile();
                            File sourceCheckOutFile = DataTypeFile.this.getProjectAgent().getFilesManager().getFile(this.fileID);
                            DataCopyHelper.copyFile((File)sourceCheckOutFile, (File)targetCheckOutFile);
                            this.checkedOutFile = targetCheckOutFile;
                        } else {
                            this.checkedOutFile = this.lastCheckedOutFile;
                        }
                        UrlLauncher.launchFile_noEx((File)this.checkedOutFile, null);
                        this.startFileWatcher();
                        this.updateControls();
                        DataTypeFile.this.setModificationInProgress(this.modificationListenerKey);
                        this.lastCheckedOutFile = this.checkedOutFile;
                    }
                }
                catch (Throwable ex) {
                    LOGGER.error("Error during check out", ex);
                    if (ex instanceof JvmExternalResourceInteractionException) {
                        FileSystemErrorMessageDialogue.openFileSystemError((Shell)this.getShell());
                    }
                    if (ex instanceof ServerNotAvailableException || ex instanceof EXServerException || ex instanceof LoginCanceledException || ex instanceof UnknownServerException || ex instanceof ExPrematureEndOfTransfer) {
                        this.showServerErrorMessageBox();
                    }
                    FileSystemErrorMessageDialogue.openFileSystemError((Shell)this.getShell());
                }
            }
        }

        private void handleCheckIn() {
            if (this.checkedOutFile != null && this.checkedOutFile.exists()) {
                boolean doCheckIn = true;
                this.fileWatcher.check();
                if (!this.fileWatcher.isChanged()) {
                    MessageDialog dialog = new MessageDialog(this.getShell(), Messages.getString("DataTypeFile.NoChangesDetectedDialog.Title"), null, Messages.getString("DataTypeFile.NoChangesDetectedDialog.Message"), 4, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 1);
                    boolean bl = doCheckIn = dialog.open() == 0;
                }
                if (doCheckIn) {
                    FileMetaInformationItem metaInformation = DataTypeFile.this.getProjectAgent().getFilesManager().getFileMetaInformation(this.fileID);
                    if (this.setFile(this.checkedOutFile, metaInformation.getOriginalFileName())) {
                        DataTypeFile.this.unsetModificationInProgress(this.modificationListenerKey);
                        this.stopFileWatcher();
                        this.checkedOutFile = null;
                    }
                    this.updateControls();
                }
            } else {
                FileSystemErrorMessageDialogue.openFileSystemError((Shell)this.getShell());
            }
        }

        private void handleCheckOutCancel() {
            DataTypeFile.this.unsetModificationInProgress(this.modificationListenerKey);
            this.checkedOutFile = null;
            this.stopFileWatcher();
            this.updateTextField();
            this.updateControls();
        }

        private void startFileWatcher() {
            assert (this.fileWatcher == null) : "Cannot start new fileWatcher while old one is still running.";
            this.fileWatcher = new FileWatcher(this.checkedOutFile);
            PeriodicTaskScheduler.addScheduledTask((Runnable)this.fileWatcher);
        }

        private void stopFileWatcher() {
            if (this.fileWatcher != null) {
                PeriodicTaskScheduler.removeScheduledTask((Runnable)this.fileWatcher);
                this.fileWatcher = null;
            }
        }

        private void updateTextField() {
            String text = "";
            if (!this.fileID.equals(FileID.NO_FILE)) {
                FileMetaInformationItem metaInformation = DataTypeFile.this.getProjectAgent().getFilesManager().getFileMetaInformation(this.fileID);
                String filename = metaInformation.getOriginalFileName();
                if (filename != null) {
                    text = String.valueOf(text) + filename;
                }
                if (this.fileWatcher == null && !DataTypeFile.this.getProjectAgent().getFilesManager().hasFileInTemporaryStorage(this.fileID)) {
                    text = String.valueOf(text) + "\n(";
                    text = metaInformation.getCommitCount() >= 1 ? String.valueOf(text) + DataTypeFile.this.getProjectAgent().getCockpitController().getCommitInformation(metaInformation.getCommitCount()).getCommitingUserInformation().getRealName() : String.valueOf(text) + DataTypeFile.this.getProjectAgent().getCockpitController().getWorkspaceInformation().getLastUserInformation().getRealName();
                    text = String.valueOf(text) + " / " + DateFormat.getDateTimeInstance(2, 3).format(new Long(metaInformation.getCreationDate())) + ")";
                } else if (this.fileWatcher != null) {
                    text = String.valueOf(text) + "\n(";
                    if (this.fileWatcher.getLastModifiedTime() > 0L) {
                        if (!this.fileWatcher.isChanged()) {
                            text = String.valueOf(text) + Messages.getString("DataTypeFile.FileCurrentlyCheckedOutAndNotModified");
                        } else {
                            String minutes = String.valueOf(this.fileWatcher.getLastModifiedDifferenceInMinutes());
                            String time = DateFormat.getTimeInstance(2).format(new Long(this.fileWatcher.getLastModifiedTime()));
                            text = String.valueOf(text) + NLS.bind((String)Messages.getString("DataTypeFile.FileCurrentlyCheckedOutAndModified"), (Object)minutes, (Object)time);
                        }
                    } else {
                        text = String.valueOf(text) + Messages.getString("DataTypeFile.FileCurrentlyCheckedOutWithoutStatus");
                    }
                    text = String.valueOf(text) + ")";
                }
            }
            this.txtFilePath.setText(text);
        }

        private void updateControls() {
            boolean fileSelected = !FileID.NO_FILE.equals(this.fileID);
            boolean fileCheckedOut = this.checkedOutFile != null;
            this.txtFilePath.setEnabled(this.enabled);
            this.btnChooseFile.setEnabled(this.enabled && !fileCheckedOut);
            this.btnDelete.setEnabled(this.enabled && fileSelected && !fileCheckedOut);
            this.btnCheckInOut.setEnabled(this.enabled && fileSelected);
            this.btnCheckOutCancel.setEnabled(this.enabled && fileCheckedOut);
            this.setCheckInOutMouseListener(!fileCheckedOut);
            if (!fileCheckedOut) {
                this.txtFilePath.setBackground(null);
                this.btnCheckInOut.setImage(this.imgCheckOut);
                this.btnCheckInOut.setToolTipText(Messages.getString("DataTypeFile.CheckOut.Tooltip"));
            } else {
                this.txtFilePath.setBackground(this.txtFilePath.getDisplay().getSystemColor(7));
                this.btnCheckInOut.setImage(this.imgCheckIn);
                this.btnCheckInOut.setToolTipText(Messages.getString("DataTypeFile.CheckIn.Tooltip"));
            }
            this.updateTextField();
        }

        private void setCheckInOutMouseListener(boolean checkout) {
            if (this.btnCheckInOut != null && !this.btnCheckInOut.isDisposed()) {
                if (this.checkInOutButtonMouseListener != null) {
                    this.btnCheckInOut.removeSelectionListener(this.checkInOutButtonMouseListener);
                }
                this.checkInOutButtonMouseListener = checkout ? new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        BaseComposite.this.handleCheckOut();
                    }
                } : new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        BaseComposite.this.handleCheckIn();
                    }
                };
                this.btnCheckInOut.addSelectionListener(this.checkInOutButtonMouseListener);
            }
        }

        private void showServerErrorMessageBox() {
            MessageDialog mDialog = new MessageDialog(null, Messages.getString("DataTypeFile.ServerError.Title"), null, Messages.getString("DataTypeFile.ServerError.Message"), 1, new String[]{IDialogConstants.OK_LABEL}, 0);
            mDialog.open();
        }

        private class FileWatcher
        extends AbstractFileWatcher
        implements Runnable {
            public FileWatcher(File checkedOutFile) {
                super(checkedOutFile);
            }

            @Override
            public void run() {
                this.check();
            }

            protected void update() {
                if (BaseComposite.this.txtFilePath != null && !BaseComposite.this.txtFilePath.isDisposed()) {
                    BaseComposite.this.txtFilePath.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (BaseComposite.this.txtFilePath != null && !BaseComposite.this.txtFilePath.isDisposed()) {
                                BaseComposite.this.updateTextField();
                            }
                        }
                    });
                }
            }
        }
    }
}

