/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.core.framedata.datatypes.filemanager;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.EXInvalidValue;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeType;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IValueRange;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IValueRangeDefiner;
import com.arcway.cockpit.client.base.interfaces.frame.gui.DetailsElement;
import com.arcway.cockpit.frame.client.global.gui.views.details.element.DetailsElementList;
import com.arcway.cockpit.frame.client.global.gui.views.details.element.ListEntryParameter;
import com.arcway.cockpit.frame.client.global.gui.views.details.value.DetailsValueList;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.core.files.FileID;
import com.arcway.cockpit.frame.client.project.core.files.FileMetaInformationItem;
import com.arcway.cockpit.frame.client.project.core.files.IFilesManager;
import com.arcway.cockpit.frame.client.project.core.framedata.ModificationProblem;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.AbstractDataType;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.Messages;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.filemanager.IDataTypeWithFile;
import com.arcway.cockpit.frame.shared.message.EOFileID;
import com.arcway.cockpit.frame.shared.userdefinedattributes.ExInvalidDataType;
import com.arcway.lib.eclipse.file.UrlLauncher;
import com.arcway.lib.eclipse.gui.ModificationProblemsDialog;
import com.arcway.lib.eclipse.gui.dialogs.FileChooserDialog;
import com.arcway.lib.io.FileHelper;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.resource.JvmExternalResourceInteractionException;
import de.plans.lib.xml.encoding.EOEncodableObject;
import de.plans.psc.client.communication.ExPrematureEndOfTransfer;
import de.plans.psc.client.communication.LoginCanceledException;
import de.plans.psc.client.communication.ServerNotAvailableException;
import de.plans.psc.client.communication.UnknownServerException;
import de.plans.psc.shared.serverexceptions.EXServerException;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public abstract class AbstractDataTypeWithFile
extends AbstractDataType
implements IDataTypeWithFile {
    private static final ILogger logger = Logger.getLogger(AbstractDataTypeWithFile.class);
    private final IFrameProjectAgent projectAgent;

    public AbstractDataTypeWithFile(IFrameProjectAgent projectAgent) {
        this.projectAgent = projectAgent;
    }

    public IFrameProjectAgent getProjectAgent() {
        return this.projectAgent;
    }

    public boolean supportsValue(Object value, IValueRange valueRange) {
        if (!(value instanceof FileID)) {
            return false;
        }
        FileID dataID = (FileID)value;
        if (dataID.equals(FileID.NO_FILE)) {
            return true;
        }
        IFilesManager mgr = this.projectAgent.getFilesManager();
        return mgr.hasFile(dataID) || mgr.hasFileInTemporaryStorage(dataID) || mgr.hasLocalFileForRollback(dataID);
    }

    public Object getCopy(Object originalValue, IValueRange valueRange) {
        FileID fileID = (FileID)originalValue;
        return new FileID(fileID.getFileUID());
    }

    public String getValueAsSingleLineString(Object value, IValueRange valueRange, String separator, Locale locale) {
        String result;
        if (!(value instanceof FileID)) {
            throw new ExInvalidDataType(value.getClass().toString(), FileID.class.toString());
        }
        FileID fileID = (FileID)value;
        if (!fileID.equals(FileID.NO_FILE)) {
            FileMetaInformationItem fileMetaInformation = this.projectAgent.getFilesManager().getFileMetaInformation(fileID);
            result = fileMetaInformation.getOriginalFileName();
        } else {
            result = "";
        }
        return result;
    }

    public EOEncodableObject getValueAsEO(Object value, IValueRange baseValueRange) throws ExInvalidDataType {
        if (!(value instanceof FileID)) {
            throw new ExInvalidDataType(value.getClass().toString(), FileID.class.toString());
        }
        FileID fileDescription = (FileID)value;
        return new EOFileID(fileDescription.getFileUID());
    }

    @Override
    public File getFileCopy(Object value) throws ServerNotAvailableException, EXServerException, LoginCanceledException, UnknownServerException, ExPrematureEndOfTransfer {
        if (!(value instanceof FileID)) {
            throw new ExInvalidDataType(value.getClass().toString(), FileID.class.toString());
        }
        FileID fileID = (FileID)value;
        return this.projectAgent.getFilesManager().getFile(fileID);
    }

    public Object getEOAsValue(EOEncodableObject eo) throws ExInvalidDataType {
        if (!(eo instanceof EOFileID)) {
            throw new ExInvalidDataType(eo.getClass().toString(), EOFileID.class.toString());
        }
        EOFileID eoFileID = (EOFileID)eo;
        return new FileID(eoFileID.getFileID());
    }

    @Override
    public void notifyAboutValueBeeingInUse(Object newValue) throws EXInvalidValue {
        super.notifyAboutValueBeeingInUse(newValue);
        IFilesManager fileManager = this.getProjectAgent().getFilesManager();
        FileID newFileID = (FileID)newValue;
        if (!newFileID.equals(FileID.NO_FILE)) {
            fileManager.markFileAsBeeingReferenced(newFileID);
        }
    }

    @Override
    public void notifyAboutValueNotBeeingInUseAnymore(Object oldValue) throws EXInvalidValue {
        super.notifyAboutValueNotBeeingInUseAnymore(oldValue);
        IFilesManager fileManager = this.getProjectAgent().getFilesManager();
        FileID fileID = (FileID)oldValue;
        if (!fileID.equals(FileID.NO_FILE)) {
            fileManager.markFileAsBeeingNotReferenced(fileID);
        }
    }

    public Object getDefaultValue() {
        return FileID.NO_FILE;
    }

    public IValueRangeDefiner getValueRangeHelper() {
        return null;
    }

    public Object getAttributeValueFromString(String valueAsString, IValueRange valueRange, String separator) {
        return null;
    }

    @Override
    public DetailsElement getDetailsElement(IAttributeType attributeType, Object attributeValue, Locale locale, Shell shell, IWorkbenchPage workbenchPage) {
        if (!(attributeValue instanceof FileID)) {
            throw new ExInvalidDataType(attributeValue.getClass().toString(), FileID.class.toString());
        }
        FileID fileID = (FileID)attributeValue;
        DetailsValueList detailsValue = new DetailsValueList();
        detailsValue.addListElement(this.getValueAsSingleLineString(fileID, null, "", locale), null, !fileID.equals(FileID.NO_FILE) ? new ListEntryParameter(this.getFileSelectionRunnable(fileID, shell, workbenchPage), this.getContextMenuActions(fileID, shell, workbenchPage), null) : null);
        return new DetailsElementList(String.valueOf(attributeType.getCockpitDataTypeID()) + "-" + attributeType.getHumanReadableID(), attributeType.getDisplayName(), detailsValue);
    }

    protected final Runnable getFileSelectionRunnable(final FileID fileID, final Shell shell, final IWorkbenchPage workbenchPage) {
        return new Runnable(){

            @Override
            public void run() {
                Throwable throwable = null;
                try {
                    File file = AbstractDataTypeWithFile.this.getFileCopy(fileID);
                    if (file != null) {
                        file.setReadOnly();
                        UrlLauncher.launchFile_noEx((File)file, (IWorkbenchPage)workbenchPage);
                    } else {
                        throwable = new Exception("File can not be found.");
                    }
                }
                catch (ServerNotAvailableException e) {
                    throwable = e;
                }
                catch (EXServerException e) {
                    throwable = e;
                }
                catch (LoginCanceledException e) {
                    throwable = e;
                }
                catch (UnknownServerException e) {
                    throwable = e;
                }
                catch (ExPrematureEndOfTransfer e) {
                    throwable = e;
                }
                if (throwable != null) {
                    logger.error("Error during file open.", throwable);
                    FileMetaInformationItem metaInformation = AbstractDataTypeWithFile.this.projectAgent.getFilesManager().getFileMetaInformation(fileID);
                    String fileName = metaInformation != null ? metaInformation.getOriginalFileName() : Messages.getString("DataTypeFile.OpenFileAction.UnknownFileName");
                    String dialogTitle = Messages.getString("DataTypeFile.OpenFileAction.Title.Failed");
                    String humanReadableDescriptionOfConsequence = NLS.bind((String)Messages.getString("DataTypeFile.OpenFileAction.Consequence.Failed"), (Object)fileName);
                    String exGenericMessage = NLS.bind((String)Messages.getString("DataTypeFile.OpenFileAction.Generic.Failed"), (Object)fileName);
                    AbstractDataTypeWithFile.this.handleFileOperationThrowable(throwable, shell, humanReadableDescriptionOfConsequence, exGenericMessage, dialogTitle);
                }
            }
        };
    }

    protected final List<IContributionItem> getContextMenuActions(FileID fileID, Shell shell, IWorkbenchPage workbenchPage) {
        ArrayList<IContributionItem> contributionItems = new ArrayList<IContributionItem>(2);
        contributionItems.add((IContributionItem)new ActionContributionItem((IAction)new OpenFileAction(fileID, shell, workbenchPage)));
        contributionItems.add((IContributionItem)new ActionContributionItem((IAction)new SaveFileAction(fileID, shell)));
        return contributionItems;
    }

    private void handleFileOperationThrowable(Throwable th, Shell parentShell, String humanReadableDescriptionOfConsequence, String exGenericMessage, String dialogTitle) {
        Exception userShownEx;
        Throwable thToHandle = th instanceof ExPrematureEndOfTransfer && th.getCause() != null ? th.getCause() : th;
        if (thToHandle instanceof Exception) {
            userShownEx = (Exception)thToHandle;
        } else {
            userShownEx = new Exception(exGenericMessage);
            userShownEx.initCause(thToHandle);
        }
        ModificationProblem mProblem = new ModificationProblem(userShownEx, 2, humanReadableDescriptionOfConsequence);
        ArrayList<ModificationProblem> mProblems = new ArrayList<ModificationProblem>();
        mProblems.add(mProblem);
        ModificationProblemsDialog mpDialog = new ModificationProblemsDialog(mProblems, dialogTitle, parentShell);
        mpDialog.open();
    }

    private class OpenFileAction
    extends Action {
        private final FileID fileToOpen;
        private final Shell shell;
        private final IWorkbenchPage workbenchPage;

        public OpenFileAction(FileID fileToOpen, Shell shell, IWorkbenchPage workbenchPage) {
            this.fileToOpen = fileToOpen;
            this.shell = shell;
            this.workbenchPage = workbenchPage;
            this.setText(Messages.getString("DataTypeFile.open"));
        }

        public void run() {
            AbstractDataTypeWithFile.this.getFileSelectionRunnable(this.fileToOpen, this.shell, this.workbenchPage).run();
        }
    }

    private class SaveFileAction
    extends Action {
        private final FileID fileToSave;
        private final Shell shell;

        public SaveFileAction(FileID fileToSave, Shell shell) {
            this.fileToSave = fileToSave;
            this.shell = shell;
            this.setText(Messages.getString("DataTypeFile.save_as"));
        }

        public void run() {
            IFilesManager filesManager = AbstractDataTypeWithFile.this.projectAgent.getFilesManager();
            FileMetaInformationItem metaInformation = filesManager.getFileMetaInformation(this.fileToSave);
            FileChooserDialog dialog = new FileChooserDialog(new String[0], this.shell);
            dialog.setStartFileName(metaInformation.getOriginalFileName());
            File destination = dialog.openForSave();
            if (destination != null) {
                Throwable throwable = null;
                try {
                    File tempFile = AbstractDataTypeWithFile.this.getFileCopy(this.fileToSave);
                    if (tempFile == null) {
                        throwable = new Exception("Can not fetch or find file.");
                    } else {
                        FileHelper.deleteFileOrDirectory((File)destination);
                        FileHelper.moveFile((File)tempFile, (File)destination);
                    }
                }
                catch (JvmExternalResourceInteractionException e) {
                    throwable = e;
                }
                catch (ServerNotAvailableException e) {
                    throwable = e;
                }
                catch (EXServerException e) {
                    throwable = e;
                }
                catch (LoginCanceledException e) {
                    throwable = e;
                }
                catch (UnknownServerException e) {
                    throwable = e;
                }
                catch (ExPrematureEndOfTransfer e) {
                    throwable = e;
                }
                if (throwable != null) {
                    logger.error("Error during file save.", throwable);
                    String dialogTitle = Messages.getString("DataTypeFile.SaveFileAction.Title.Failed");
                    String humanReadableDescriptionOfConsequence = NLS.bind((String)Messages.getString("DataTypeFile.SaveFileAction.Consequence.Failed"), (Object)metaInformation.getOriginalFileName());
                    String exGenericMessage = NLS.bind((String)Messages.getString("DataTypeFile.SaveFileAction.Generic.Failed"), (Object)metaInformation.getOriginalFileName());
                    AbstractDataTypeWithFile.this.handleFileOperationThrowable(throwable, this.shell, humanReadableDescriptionOfConsequence, exGenericMessage, dialogTitle);
                }
            }
        }
    }
}

