/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.core.framedata.datatypes;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeType;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IValueRange;
import com.arcway.cockpit.client.base.interfaces.frame.gui.DetailsElement;
import com.arcway.cockpit.frame.client.global.gui.views.details.element.DetailsElementMulti;
import com.arcway.cockpit.frame.client.global.gui.views.details.value.DetailsValueMulti;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.DataTypeString;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.Messages;
import com.arcway.cockpit.frame.shared.userdefinedattributes.ExInvalidDataType;
import com.arcway.lib.stringtools.StringUtil;
import java.util.Locale;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPage;

public class DataTypeText
extends DataTypeString {
    private static final DataTypeText INSTANCE = new DataTypeText();
    public static final String SUB_DATA_TYPE_ID = "text";

    public static DataTypeText getInstanceText() {
        return INSTANCE;
    }

    private DataTypeText() {
    }

    @Override
    public String getDisplayName(Locale locale) {
        return Messages.getString("DataTypeText.text", locale);
    }

    @Override
    protected Text createTextControlForModifying(Composite parent) {
        Text text = new Text(parent, 2626);
        text.setLayoutData((Object)new GridData(1808));
        return text;
    }

    @Override
    public Control createSWTControlForViewing(Composite parent, Object value, IValueRange valueRange) throws ExInvalidDataType {
        if (!(value instanceof String)) {
            throw new ExInvalidDataType(value.getClass().toString(), String.class.toString());
        }
        StyledText text = new StyledText(parent, 66);
        text.setText(this.getValueAsString(value));
        text.setEditable(false);
        return text;
    }

    @Override
    public DetailsElement getDetailsElement(IAttributeType attributeType, Object attributeValue, Locale locale, Shell shell, IWorkbenchPage workbenchPage) {
        return new DetailsElementMulti(String.valueOf(attributeType.getCockpitDataTypeID()) + "-" + attributeType.getHumanReadableID(), attributeType.getDisplayName(), new DetailsValueMulti(this.getValueAsString(attributeValue)), true);
    }

    @Override
    public int getSWTHeightHint() {
        return 200;
    }

    @Override
    public int getSWTVerticalFillHint() {
        return 4;
    }

    @Override
    public String getID() {
        return SUB_DATA_TYPE_ID;
    }

    public final String getValueAsMultiLineString(Object value) {
        return this.getValueAsString(value);
    }

    @Override
    protected final String getValueAsString(Object value) {
        return (String)value;
    }

    @Override
    public Object getAttributeValueFromString(String valueAsString, IValueRange valueRange, String separator) {
        return StringUtil.replaceLineBreaksWithWindowsLineBreaks((String)valueAsString);
    }
}

