/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.core.framedata.datatypes;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeType;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IValueRange;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IValueRangeDefiner;
import com.arcway.cockpit.client.base.interfaces.frame.gui.DetailsElement;
import com.arcway.cockpit.frame.client.global.gui.views.details.element.DetailsElementSingle;
import com.arcway.cockpit.frame.client.global.gui.views.details.value.DetailsValueSingle;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.AbstractDataType;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.Messages;
import com.arcway.cockpit.frame.client.project.docgenerator.interFace.IReportOutputTemplateType;
import com.arcway.cockpit.frame.client.project.modules.IProjectCloseListener;
import de.plans.lib.xml.encoding.EOEncodableObject;
import de.plans.lib.xml.primitiveTypes.EOString;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public class DataTypeReportOutputTemplateType
extends AbstractDataType {
    private static final Map<IFrameProjectAgent, DataTypeReportOutputTemplateType> types = new HashMap<IFrameProjectAgent, DataTypeReportOutputTemplateType>();
    private static final String DISPLAY_NAME_UNKNOWN = Messages.getString("DataTypeReportType.unknown_report_type");
    private static final String DESCRIPTION_UNKNOWN = Messages.getString("DataTypeReportType.report_type_not_installed");
    private static final Comparator comparator = new Comparator(){

        public int compare(Object o1, Object o2) {
            try {
                String s1 = (String)o1;
                String s2 = (String)o2;
                return s1.compareToIgnoreCase(s2);
            }
            catch (ClassCastException e) {
                return 0;
            }
        }
    };
    private final IFrameProjectAgent projectAgent;

    public static DataTypeReportOutputTemplateType getDataType(IFrameProjectAgent projectAgent) {
        DataTypeReportOutputTemplateType dataType = types.get(projectAgent);
        if (dataType == null) {
            dataType = new DataTypeReportOutputTemplateType(projectAgent);
            types.put(projectAgent, dataType);
            projectAgent.addProjectCloseListener(new IProjectCloseListener(){

                @Override
                public void closeProject(IFrameProjectAgent closedProjectAgent) {
                    types.remove(closedProjectAgent);
                }
            });
        }
        return dataType;
    }

    private DataTypeReportOutputTemplateType(IFrameProjectAgent projectAgent) {
        this.projectAgent = projectAgent;
    }

    public String getID() {
        return "reporttype";
    }

    public boolean supportsValue(Object value, IValueRange valueRange) {
        return value instanceof String;
    }

    public String getDisplayName() {
        return this.getDisplayName(Locale.getDefault());
    }

    public String getDisplayName(Locale locale) {
        return Messages.getString("DataTypeReportType.reporttype", locale);
    }

    public String getValueAsSingleLineString(Object value, IValueRange valueRange, String separator, Locale locale) {
        return (String)value;
    }

    public EOEncodableObject getValueAsEO(Object value, IValueRange baseValueRange) {
        return new EOString((String)value);
    }

    public Object getEOAsValue(EOEncodableObject eo) {
        EOString eoString = (EOString)eo;
        return eoString.getString();
    }

    @Override
    protected AbstractDataType.SWTControlForModification createSWTControlForModifying_internal(Composite parent, Object initialValue, IValueRange valueRange) {
        final Combo combo = new Combo(parent, 8);
        Collection<IReportOutputTemplateType> reportOutputTemplateTypes = this.projectAgent.getDocGeneratorManager().getAllReportOutputTemplateTypes();
        ArrayList<IReportOutputTemplateType> reportOutputTemplateTypeList = new ArrayList<IReportOutputTemplateType>(reportOutputTemplateTypes);
        Collections.sort(reportOutputTemplateTypeList, new Comparator<IReportOutputTemplateType>(){

            @Override
            public int compare(IReportOutputTemplateType arg0, IReportOutputTemplateType arg1) {
                return arg0.getDisplayName().compareToIgnoreCase(arg1.getDisplayName());
            }
        });
        for (IReportOutputTemplateType reportOutputTemplateType : reportOutputTemplateTypeList) {
            combo.add(reportOutputTemplateType.getDisplayName());
            int index = combo.getItemCount() - 1;
            combo.setData(String.valueOf(index), (Object)reportOutputTemplateType);
        }
        combo.setLayoutData((Object)new GridData(768));
        this.setContentForSWTControl(combo, initialValue);
        final AbstractDataType.SWTControlForModification wrapper = new AbstractDataType.SWTControlForModification(this, (Control)combo, null);
        combo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DataTypeReportOutputTemplateType.this.informSWTModifyListeners(wrapper, DataTypeReportOutputTemplateType.this.getAttributeValueFromSWTControl(combo), null);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        return wrapper;
    }

    private void setContentForSWTControl(Combo combo, Object value) {
        String currentReportOutputTemplateTypeID = (String)value;
        if (currentReportOutputTemplateTypeID.length() > 0) {
            int nrOfItems = combo.getItemCount();
            int i = 0;
            while (i < nrOfItems) {
                IReportOutputTemplateType reportOutputTemplateType = (IReportOutputTemplateType)combo.getData(String.valueOf(i));
                if (reportOutputTemplateType.getID().equals(currentReportOutputTemplateTypeID)) {
                    combo.select(i);
                    break;
                }
                ++i;
            }
            if (combo.getSelectionIndex() == -1) {
                combo.setText(DISPLAY_NAME_UNKNOWN);
                combo.setData("-1", null);
            }
        }
    }

    private Object getAttributeValueFromSWTControl(Combo combo) {
        IReportOutputTemplateType reportOutputTemplateType = (IReportOutputTemplateType)combo.getData(String.valueOf(combo.getSelectionIndex()));
        if (reportOutputTemplateType != null) {
            return reportOutputTemplateType.getID();
        }
        return "";
    }

    public Object getDefaultValue() {
        return "";
    }

    public Object getCopy(Object originalValue, IValueRange valueRange) {
        return originalValue;
    }

    public int getSWTHeightHint() {
        return -1;
    }

    public Control createSWTControlForViewing(Composite parent, Object value, IValueRange valueRange) {
        StyledText text = new StyledText(parent, 66);
        text.setText(this.getReportOutputTemplateTypeName((String)value));
        text.setEditable(false);
        return text;
    }

    @Override
    public DetailsElement getDetailsElement(IAttributeType attributeType, Object attributeValue, Locale locale, Shell shell, IWorkbenchPage workbenchPage) {
        return new DetailsElementSingle(String.valueOf(attributeType.getCockpitDataTypeID()) + "-" + attributeType.getHumanReadableID(), attributeType.getDisplayName(), new DetailsValueSingle(this.getReportOutputTemplateTypeName((String)attributeValue)));
    }

    public IValueRangeDefiner getValueRangeHelper() {
        return null;
    }

    private String getReportOutputTemplateTypeName(String typeID) {
        IReportOutputTemplateType outputTemplateType = this.projectAgent.getDocGeneratorManager().getReportOutputTemplateType(typeID);
        return outputTemplateType != null ? outputTemplateType.getDisplayName() : "";
    }

    public Object getAttributeValueFromString(String valueAsString, IValueRange valueRange, String separator) {
        for (IReportOutputTemplateType reportOutputTemplateType : this.projectAgent.getDocGeneratorManager().getAllReportOutputTemplateTypes()) {
            if (!reportOutputTemplateType.getID().equals(valueAsString) && !reportOutputTemplateType.getDisplayName().equals(valueAsString)) continue;
            return reportOutputTemplateType.getID();
        }
        return null;
    }

    public Comparator getComparator(IValueRange valueRange) {
        return comparator;
    }
}

