/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.core.framedata.datatypes;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IValueRange;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IValueRangeDefiner;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.AbstractDataType;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.Messages;
import com.arcway.cockpit.frame.shared.userdefinedattributes.ExInvalidDataType;
import com.arcway.lib.java.locale.LocaleHelper;
import de.plans.lib.xml.encoding.EOEncodableObject;
import de.plans.lib.xml.primitiveTypes.EOString;
import java.util.Locale;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class DataTypeLanguage
extends AbstractDataType {
    private static final String NO_LANGUAGE = "no_language";

    public String getID() {
        return "language";
    }

    public boolean supportsValue(Object value, IValueRange valueRange) {
        return value instanceof String;
    }

    public Object getCopy(Object originalValue, IValueRange valueRange) {
        if (!this.supportsValue(originalValue, valueRange)) {
            throw new ExInvalidDataType(originalValue.getClass().toString(), "String with system supported language");
        }
        return originalValue;
    }

    public String getDisplayName() {
        return this.getDisplayName(Locale.getDefault());
    }

    public String getDisplayName(Locale locale) {
        return Messages.getString("DataTypeLanguage.language", locale);
    }

    public EOEncodableObject getValueAsEO(Object value, IValueRange baseValueRange) throws ExInvalidDataType {
        if (!this.supportsValue(value, null)) {
            throw new ExInvalidDataType(value.getClass().toString(), "String with supported language");
        }
        String language = (String)value;
        return new EOString(language);
    }

    public Object getEOAsValue(EOEncodableObject eo) throws ExInvalidDataType {
        if (!(eo instanceof EOString)) {
            throw new ExInvalidDataType(eo.getClass().toString(), EOString.class.toString());
        }
        EOString eoString = (EOString)eo;
        return eoString.getString();
    }

    @Override
    protected AbstractDataType.SWTControlForModification createSWTControlForModifying_internal(Composite parent, Object initialValue, IValueRange valueRange) {
        throw new UnsupportedOperationException();
    }

    public Object getDefaultValue() {
        return NO_LANGUAGE;
    }

    public IValueRangeDefiner getValueRangeHelper() {
        return null;
    }

    public int getSWTHeightHint() {
        return -1;
    }

    public Control createSWTControlForViewing(Composite parent, Object value, IValueRange valueRange) throws ExInvalidDataType {
        StyledText text = new StyledText(parent, 0);
        text.setText(this.getValueAsSingleLineString(value, valueRange, "", Locale.getDefault()));
        text.setEditable(false);
        return text;
    }

    public String getValueAsSingleLineString(Object value, IValueRange valueRange, String separator, Locale locale) {
        Locale[] locals;
        if (!this.supportsValue(value, null)) {
            throw new ExInvalidDataType(value.getClass().toString(), "String with supported language");
        }
        String language = (String)value;
        Locale[] localeArray = locals = LocaleHelper.getAvailableLocales();
        int n = locals.length;
        int n2 = 0;
        while (n2 < n) {
            Locale element = localeArray[n2];
            if (element.getLanguage().equals(language)) {
                return LocaleHelper.getDisplayLanguage((Locale)element);
            }
            ++n2;
        }
        return Messages.getString("DataTypeLanguage.unknown_language", locale);
    }

    public Object getAttributeValueFromString(String valueAsString, IValueRange valueRange, String separator) {
        Locale[] locals;
        Locale[] localeArray = locals = LocaleHelper.getAvailableLocales();
        int n = locals.length;
        int n2 = 0;
        while (n2 < n) {
            Locale element = localeArray[n2];
            if (element.getLanguage().equals(valueAsString) || LocaleHelper.getDisplayLanguage((Locale)element).equals(valueAsString)) {
                return element.getLanguage();
            }
            ++n2;
        }
        return null;
    }
}

