/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.core.framedata.datatypes;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.EnumerationEntry;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeType;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeTypeDataType;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IValueRange;
import com.arcway.cockpit.client.base.interfaces.frame.gui.DetailsElement;
import com.arcway.cockpit.frame.client.global.gui.views.details.element.DetailsElementList;
import com.arcway.cockpit.frame.client.global.gui.views.details.value.DetailsValueList;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.AbstractDataType;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.DataTypeEnumerationNEW;
import com.arcway.cockpit.frame.shared.userdefinedattributes.ExInvalidDataType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public class DataTypeEnumerationMultiple
extends DataTypeEnumerationNEW {
    public DataTypeEnumerationMultiple(IAttributeTypeDataType baseDataType, IValueRange baseValueRange, boolean tolerantConcerningValueRange) {
        super(baseDataType, baseValueRange, true, tolerantConcerningValueRange);
    }

    @Override
    protected AbstractDataType.SWTControlForModification createSWTControlForModifying_internal(Composite parent, Object initialValue, IValueRange valueRange) {
        if (!(valueRange.getValueRange() instanceof List)) {
            throw new ExInvalidDataType(valueRange.getValueRange().getClass().toString(), List.class.toString());
        }
        BaseComposite baseComposite = new BaseComposite(parent, (List)valueRange.getValueRange());
        List selectedElements = (List)initialValue;
        baseComposite.setSelectedEntries(selectedElements);
        AbstractDataType.SWTControlForModification wrapper = new AbstractDataType.SWTControlForModification(this, (Control)baseComposite, null);
        baseComposite.setModificationListenerKey(wrapper);
        return wrapper;
    }

    public Object getAttributeValueFromString(String valueAsString, IValueRange valueRange, String separator) {
        String[] splittedValues = valueAsString.split(separator);
        HashMap<String, EnumerationEntry> map_value_entry = new HashMap<String, EnumerationEntry>();
        for (EnumerationEntry entry : (List)valueRange.getValueRange()) {
            String valueAsSingleLineString = this.getBaseDataType().getValueAsSingleLineString(entry.getValue(), null, "", Locale.getDefault());
            if (valueAsSingleLineString != null) {
                assert (valueAsSingleLineString.trim().length() == 0 || valueAsSingleLineString.length() == valueAsSingleLineString.trim().length());
                valueAsSingleLineString = valueAsSingleLineString.trim();
            } else assert (false);
            map_value_entry.put(valueAsSingleLineString, entry);
        }
        ArrayList<EnumerationEntry> multipleEnumerationValue = new ArrayList<EnumerationEntry>(splittedValues.length);
        String[] stringArray = splittedValues;
        int n = splittedValues.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            EnumerationEntry entry = (EnumerationEntry)map_value_entry.get(element.trim());
            if (entry == null) {
                return null;
            }
            multipleEnumerationValue.add(entry);
            ++n2;
        }
        if (new HashSet(multipleEnumerationValue).size() < multipleEnumerationValue.size()) {
            return null;
        }
        return multipleEnumerationValue;
    }

    @Override
    public DetailsElement getDetailsElement(IAttributeType attributeType, Object attributeValue, Locale locale, Shell shell, IWorkbenchPage workbenchPage) {
        DetailsValueList detailsValue = new DetailsValueList();
        List<String> enumerationItems = this.getValueAsStrings(attributeValue, attributeType.getValueRange(), locale);
        if (!enumerationItems.isEmpty()) {
            for (String enumerationItem : enumerationItems) {
                detailsValue.addListElement(enumerationItem, null, null);
            }
        } else {
            detailsValue.addListElement("-", null, null);
        }
        return new DetailsElementList(String.valueOf(attributeType.getCockpitDataTypeID()) + "-" + attributeType.getHumanReadableID(), attributeType.getDisplayName(), detailsValue);
    }

    private class BaseComposite
    extends Composite {
        private final int buttonStyle;
        private final Map<Button, EnumerationEntry> buttons_entry;
        private AbstractDataType.SWTControlForModification modificationListenerKey;

        public BaseComposite(Composite parent, List<EnumerationEntry> valueRange) {
            super(parent, 0);
            this.buttons_entry = new HashMap<Button, EnumerationEntry>();
            this.buttonStyle = 32;
            this.setLayout((Layout)new GridLayout());
            this.createContent(valueRange);
        }

        public void setModificationListenerKey(AbstractDataType.SWTControlForModification key) {
            this.modificationListenerKey = key;
        }

        public void setSelectedEntries(List entriesToSelect) {
            for (Map.Entry<Button, EnumerationEntry> buttons_entry_entry : this.buttons_entry.entrySet()) {
                EnumerationEntry entry = buttons_entry_entry.getValue();
                if (!entriesToSelect.contains(entry)) continue;
                Button button = buttons_entry_entry.getKey();
                button.setSelection(true);
            }
        }

        public List<EnumerationEntry> getSelectedEntries() {
            ArrayList<EnumerationEntry> selectedEntries = new ArrayList<EnumerationEntry>();
            for (Map.Entry<Button, EnumerationEntry> buttons_entry_entry : this.buttons_entry.entrySet()) {
                Button button = buttons_entry_entry.getKey();
                if (!button.getSelection()) continue;
                EnumerationEntry entry = buttons_entry_entry.getValue();
                selectedEntries.add(entry);
            }
            return selectedEntries;
        }

        public void setEnabled(boolean enabled) {
            for (Button button : this.buttons_entry.keySet()) {
                button.setEnabled(enabled);
            }
        }

        private void createContent(List<EnumerationEntry> valueRange) {
            for (EnumerationEntry entry : valueRange) {
                Button button = new Button((Composite)this, this.buttonStyle);
                button.setLayoutData((Object)new GridData(768));
                button.setText(DataTypeEnumerationMultiple.this.getBaseDataType().getValueAsSingleLineString(entry.getValue(), null, " ", Locale.getDefault()));
                button.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        DataTypeEnumerationMultiple.this.informSWTModifyListeners(BaseComposite.this.modificationListenerKey, BaseComposite.this.getSelectedEntries(), null);
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }
                });
                this.buttons_entry.put(button, entry);
            }
        }
    }
}

