/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.core.framedata.datatypes;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IValueRange;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IValueRangeDefiner;
import com.arcway.cockpit.client.base.interfaces.frame.gui.IAttributeFilter;
import com.arcway.cockpit.cockpitlib.client.filter.AbstractFilter;
import com.arcway.cockpit.cockpitlib.client.filter.gui.IFilterItem;
import com.arcway.cockpit.frame.client.global.Icons;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.AbstractDataType;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.Messages;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.filters.AttributeDateFilterItem;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.filters.DateAttributeFilter;
import com.arcway.cockpit.frame.shared.userdefinedattributes.ExInvalidDataType;
import com.arcway.lib.eclipse.gui.widgets.DatePickerDialog;
import de.plans.lib.localisation.DateFormatHelper;
import de.plans.lib.xml.encoding.EOEncodableObject;
import de.plans.lib.xml.primitiveTypes.EOString;
import java.util.Comparator;
import java.util.Date;
import java.util.Locale;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class DataTypeDate
extends AbstractDataType {
    private static final DataTypeDate singleInstance = new DataTypeDate();
    public static final String DATA_TYPE_ID = "date";

    public static DataTypeDate getSingleInstance() {
        return singleInstance;
    }

    private DataTypeDate() {
    }

    public String getID() {
        return DATA_TYPE_ID;
    }

    public boolean supportsValue(Object value, IValueRange valueRange) {
        if (value instanceof String) {
            String str = (String)value;
            if (!str.equals("")) {
                try {
                    Long.valueOf(str);
                    return true;
                }
                catch (NumberFormatException numberFormatException) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public static Long getValueAsLong(Object value) {
        String str = (String)value;
        if (!str.equals("")) {
            try {
                return Long.valueOf(str);
            }
            catch (NumberFormatException e) {
                throw new ExInvalidDataType(str, "must contain a Long");
            }
        }
        return null;
    }

    public static Date getValueAsDate(Object value) {
        Long dateAsLong = DataTypeDate.getValueAsLong(value);
        if (dateAsLong != null) {
            return new Date(dateAsLong);
        }
        return null;
    }

    public Object getCopy(Object originalValue, IValueRange valueRange) {
        if (!this.supportsValue(originalValue, valueRange)) {
            throw new ExInvalidDataType(originalValue.getClass().toString(), String.class.toString());
        }
        return originalValue;
    }

    public String getDisplayName() {
        return this.getDisplayName(Locale.getDefault());
    }

    public String getDisplayName(Locale locale) {
        return Messages.getString("DataTypeDate.date", locale);
    }

    public EOEncodableObject getValueAsEO(Object value, IValueRange baseValueRange) throws ExInvalidDataType {
        if (!this.supportsValue(value, null)) {
            throw new ExInvalidDataType(value.getClass().toString(), String.valueOf(String.class.toString()) + " containing a long");
        }
        return new EOString((String)value);
    }

    public Object getEOAsValue(EOEncodableObject eo) throws ExInvalidDataType {
        if (!(eo instanceof EOString)) {
            throw new ExInvalidDataType(eo.getClass().toString(), EOString.class.toString());
        }
        EOString eoString = (EOString)eo;
        return eoString.getString();
    }

    @Override
    protected AbstractDataType.SWTControlForModification createSWTControlForModifying_internal(Composite parent, Object initialValue, IValueRange valueRange) {
        BaseComposite baseComposite = new BaseComposite(parent, 0);
        Text textWidget = baseComposite.getText();
        String strValue = (String)initialValue;
        if (!strValue.equals("")) {
            long ms = Long.valueOf(strValue);
            Date date = new Date(ms);
            strValue = DateFormatHelper.getDefault().getDateFormat(Locale.getDefault()).format(date);
        }
        textWidget.setText(strValue);
        AbstractDataType.SWTControlForModification wrapper = new AbstractDataType.SWTControlForModification(this, (Control)baseComposite, null);
        baseComposite.setModificationListenerKey(wrapper);
        return wrapper;
    }

    public int getSWTHeightHint() {
        return -1;
    }

    public Control createSWTControlForViewing(Composite parent, Object value, IValueRange valueRange) throws ExInvalidDataType {
        String str = this.getValueAsSingleLineString(value, valueRange, "", Locale.getDefault());
        StyledText text = new StyledText(parent, 0);
        text.setText(str);
        text.setEditable(false);
        return text;
    }

    public String getValueAsSingleLineString(Object value, IValueRange valueRange, String separator, Locale locale) {
        if (!this.supportsValue(value, null)) {
            throw new ExInvalidDataType(value.getClass().toString(), String.class.toString());
        }
        String str = (String)value;
        if (!str.equals("")) {
            try {
                long ms = Long.valueOf(str);
                Date date = new Date(ms);
                str = DateFormatHelper.getDefault().getDateFormat(locale).format(date);
            }
            catch (NumberFormatException e) {
                throw new ExInvalidDataType(str, "must contain a Long");
            }
        }
        return str;
    }

    public Object getDefaultValue() {
        return "";
    }

    public IValueRangeDefiner getValueRangeHelper() {
        return null;
    }

    private Object getAttributeValueFromSWTControl(BaseComposite base) throws ExInvalidDataType {
        Text text = base.getText();
        String str = text.getText();
        if (str == null) {
            str = "";
        }
        str = str.trim();
        Date date = DateFormatHelper.getDefault().parse(str, null);
        if (date != null) {
            return new Long(date.getTime()).toString();
        }
        return "";
    }

    @Override
    public IAttributeFilter getFilter() {
        return DateAttributeFilter.getInstance();
    }

    @Override
    public Comparator<Object> getComparator(IValueRange valueRange) {
        return new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                try {
                    String dateString1 = (String)o1;
                    String dateString2 = (String)o2;
                    try {
                        long l1 = Long.parseLong(dateString1);
                        long l2 = Long.parseLong(dateString2);
                        return l1 < l2 ? -1 : (l1 > l2 ? 1 : 0);
                    }
                    catch (NumberFormatException e) {
                        return 0;
                    }
                }
                catch (ClassCastException e) {
                    return 0;
                }
            }
        };
    }

    @Override
    public IFilterItem createFilterItem(String filterName, AbstractFilter filter, IValueRange vaueRange) {
        return new AttributeDateFilterItem(filterName, filter);
    }

    public Object getAttributeValueFromString(String valueAsString, IValueRange valueRange, String separator) {
        return this.getAttributeValueFromString(valueAsString, null);
    }

    public Object getAttributeValueFromString(String valueAsString, Locale locale) {
        Date date = DateFormatHelper.getDefault().parse(valueAsString, locale);
        if (date != null) {
            return new Long(date.getTime()).toString();
        }
        return "";
    }

    private class BaseComposite
    extends Composite {
        private Text text;
        private Button btnChoose;
        private Button btnClear;
        private AbstractDataType.SWTControlForModification modificationListenerKey;

        public BaseComposite(Composite parent, int style) {
            super(parent, style);
            GridLayout layout = new GridLayout(3, false);
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            this.setLayout((Layout)layout);
            this.create();
        }

        public void setModificationListenerKey(AbstractDataType.SWTControlForModification key) {
            this.modificationListenerKey = key;
        }

        public void setEnabled(boolean enabled) {
            this.btnChoose.setEnabled(enabled);
            this.btnClear.setEnabled(enabled);
        }

        public Text getText() {
            return this.text;
        }

        private void create() {
            this.text = new Text((Composite)this, 2048);
            this.text.setText("");
            this.text.setEditable(false);
            this.text.setLayoutData((Object)new GridData(768));
            this.btnChoose = new Button((Composite)this, 0);
            this.btnChoose.setImage(Icons.getCalendarImage());
            this.btnChoose.setLayoutData((Object)new GridData());
            this.btnChoose.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    Date currentDate = DateFormatHelper.getDefault().parse(BaseComposite.this.text.getText(), null);
                    DatePickerDialog dialog = new DatePickerDialog(BaseComposite.this.getShell(), currentDate);
                    dialog.open();
                    Date utilDate = dialog.getDate();
                    if (utilDate != null) {
                        Date sqlDate = new Date(utilDate.getTime());
                        String strDate = DateFormatHelper.getDefault().getDateFormat(Locale.getDefault()).format(sqlDate);
                        BaseComposite.this.text.setText(strDate);
                        DataTypeDate.this.informSWTModifyListeners(BaseComposite.this.modificationListenerKey, DataTypeDate.this.getAttributeValueFromSWTControl(BaseComposite.this), null);
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            this.btnClear = new Button((Composite)this, 0);
            this.btnClear.setImage(Icons.getImageForDelete());
            this.btnClear.setLayoutData((Object)new GridData());
            this.btnClear.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    BaseComposite.this.text.setText("");
                    DataTypeDate.this.informSWTModifyListeners(BaseComposite.this.modificationListenerKey, DataTypeDate.this.getAttributeValueFromSWTControl(BaseComposite.this), null);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
        }
    }
}

