/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.core.framedata.datatypes;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IValueRange;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IValueRangeDefiner;
import com.arcway.cockpit.client.base.interfaces.frame.gui.IAttributeFilter;
import com.arcway.cockpit.cockpitlib.client.filter.AbstractFilter;
import com.arcway.cockpit.cockpitlib.client.filter.gui.IFilterItem;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.AbstractDataType;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.Messages;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.filters.AttributeBooleanFilterItem;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.filters.BooleanAttributeFilter;
import com.arcway.cockpit.frame.shared.userdefinedattributes.ExInvalidDataType;
import com.arcway.lib.java.collectionmaps.MapMap;
import de.plans.lib.xml.encoding.EOEncodableObject;
import de.plans.lib.xml.primitiveTypes.EOBoolean;
import java.util.Comparator;
import java.util.Locale;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class DataTypeBoolean
extends AbstractDataType {
    private static DataTypeBoolean singleInstance;
    private final MapMap<String, Locale, String> messagesCache = new MapMap();

    public static DataTypeBoolean getSingleInstance() {
        if (singleInstance == null) {
            singleInstance = new DataTypeBoolean();
        }
        return singleInstance;
    }

    private DataTypeBoolean() {
    }

    public String getID() {
        return "boolean";
    }

    public boolean supportsValue(Object value, IValueRange valueRange) {
        return value instanceof Boolean;
    }

    public Object getCopy(Object originalValue, IValueRange valueRange) {
        if (!this.supportsValue(originalValue, valueRange)) {
            throw new ExInvalidDataType(originalValue.getClass().toString(), Boolean.class.toString());
        }
        return (boolean)((Boolean)originalValue);
    }

    public String getValueAsSingleLineString(Object value, IValueRange valueRange, String separator, Locale locale) {
        if (!(value instanceof Boolean)) {
            throw new ExInvalidDataType(value.getClass().toString(), Boolean.class.toString());
        }
        Boolean bool = (Boolean)value;
        if (bool.booleanValue()) {
            return this.getMessage_cached("DataTypeBoolean.true", locale);
        }
        return this.getMessage_cached("DataTypeBoolean.false", locale);
    }

    public String getDisplayName() {
        return this.getDisplayName(Locale.getDefault());
    }

    public String getDisplayName(Locale locale) {
        return this.getMessage_cached("DataTypeBoolean.boolean", locale);
    }

    public EOEncodableObject getValueAsEO(Object value, IValueRange baseValueRange) throws ExInvalidDataType {
        if (!(value instanceof Boolean)) {
            throw new ExInvalidDataType(value.getClass().toString(), this.getDisplayName());
        }
        return new EOBoolean((Boolean)value);
    }

    public Object getEOAsValue(EOEncodableObject eo) throws ExInvalidDataType {
        if (!(eo instanceof EOBoolean)) {
            throw new ExInvalidDataType(eo.getClass().toString(), EOBoolean.class.toString());
        }
        EOBoolean eoBoolean = (EOBoolean)eo;
        return eoBoolean.getBoolean();
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof DataTypeBoolean;
    }

    public Object getDefaultValue() {
        return Boolean.FALSE;
    }

    public IValueRangeDefiner getValueRangeHelper() {
        return null;
    }

    @Override
    protected AbstractDataType.SWTControlForModification createSWTControlForModifying_internal(Composite parent, Object initialValue, IValueRange valueRange) {
        final Button button = new Button(parent, 32);
        Boolean bool = (Boolean)initialValue;
        button.setSelection(bool.booleanValue());
        final AbstractDataType.SWTControlForModification wrapper = new AbstractDataType.SWTControlForModification(this, (Control)button, null);
        button.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DataTypeBoolean.this.informSWTModifyListeners(wrapper, button.getSelection(), null);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        return wrapper;
    }

    public int getSWTHeightHint() {
        return -1;
    }

    public Control createSWTControlForViewing(Composite parent, Object value, IValueRange valueRange) throws ExInvalidDataType {
        StyledText text = new StyledText(parent, 0);
        text.setText(this.getValueAsSingleLineString(value, valueRange, "", Locale.getDefault()));
        text.setEditable(false);
        return text;
    }

    @Override
    public IFilterItem createFilterItem(String filterName, AbstractFilter filter, IValueRange vaueRange) {
        return new AttributeBooleanFilterItem(filterName, filter, this);
    }

    public Comparator getComparator(IValueRange valueRange) {
        return new Comparator(){

            public int compare(Object o1, Object o2) {
                boolean b1 = (Boolean)o1;
                boolean b2 = (Boolean)o2;
                if (b1 && !b2) {
                    return -1;
                }
                if (b2 && !b1) {
                    return 1;
                }
                return 0;
            }
        };
    }

    @Override
    public IAttributeFilter getFilter() {
        return BooleanAttributeFilter.getDefault();
    }

    public Object getAttributeValueFromString(String valueAsString, IValueRange valueRange, String separator) {
        if (valueAsString.equalsIgnoreCase("true")) {
            return Boolean.TRUE;
        }
        if (valueAsString.equalsIgnoreCase("false")) {
            return Boolean.FALSE;
        }
        return null;
    }

    private synchronized String getMessage_cached(String key, Locale locale) {
        String message = (String)this.messagesCache.get((Object)key, (Object)locale);
        if (message == null) {
            message = Messages.getString(key, locale);
            assert (message != null);
            this.messagesCache.put((Object)key, (Object)locale, (Object)message);
        }
        return message;
    }
}

