/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.core.framedata.datamanager;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.AddedItem;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.DeletedItem;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAddedItem;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.ICockpitDataType;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IDataLabelProvider;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IDeletedItem;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.ILocalModificationContainer;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IModifiedItem;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.ModifiedItem;
import com.arcway.cockpit.cockpitlib.client.files.FileContentProviderForXMLFilesWithFixContent;
import com.arcway.cockpit.cockpitlib.client.files.IFileContentProviderForXMLFiles;
import com.arcway.cockpit.cockpitlib.client.files.IXMLDataAccessor;
import com.arcway.cockpit.cockpitlib.client.files.atomic.FileKey;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.core.framedata.IFrameDataRW;
import com.arcway.cockpit.frame.client.project.core.framedata.datamanager.IFrameDataFactory;
import com.arcway.cockpit.frame.shared.message.MessageDataFactory;
import com.arcway.cockpit.frame.shared.message.genericframedata.EOFrameData;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import de.plans.lib.xml.encoding.EOList;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.lib.xml.encoding.IEncodableObjectFactory;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.graphics.Image;

public class FrameDataModificationManager
implements ILocalModificationContainer {
    private static final ILogger logger = Logger.getLogger(FrameDataModificationManager.class);
    private static final String ROLE_ADDED = "added";
    private static final String ROLE_MODIFIED = "modified";
    private static final String ROLE_REMOVED = "removed";
    private final IXMLDataAccessor<EOList<EOList<? extends EOFrameData>>> modificationFileAccessor;
    private final IFrameDataFactory frameDataFactory;
    private final ICockpitDataType cockpitDataType;
    private final IDataLabelProvider dataLabelProvider;
    private final Map<String, IFrameDataRW> addedData = new HashMap<String, IFrameDataRW>();
    private final Map<String, IFrameDataRW> modifiedData = new HashMap<String, IFrameDataRW>();
    private final Map<String, IFrameDataRW> removedData = new HashMap<String, IFrameDataRW>();

    public FrameDataModificationManager(IFrameProjectAgent projectAgent, ICockpitDataType cockpitDataType, IFrameDataFactory frameDataFactory, FileKey modificationsFileKey, IDataLabelProvider dataLabelProvider) {
        this.frameDataFactory = frameDataFactory;
        this.cockpitDataType = cockpitDataType;
        this.dataLabelProvider = dataLabelProvider;
        this.modificationFileAccessor = projectAgent.getAtomicModificationDataAccessor().getXMLFileAccessor(modificationsFileKey, (IEncodableObjectFactory)MessageDataFactory.getInstance());
        try {
            this.read();
        }
        catch (Exception e) {
            logger.error("could not execute", (Throwable)e);
        }
    }

    private void read() throws Exception {
        EOList allLists = (EOList)this.modificationFileAccessor.read();
        if (allLists != null) {
            for (EOList eoList : allLists) {
                if (ROLE_ADDED.equals(eoList.getRole())) {
                    this.readEOList((EOList<? extends EOFrameData>)eoList, this.addedData);
                    continue;
                }
                if (ROLE_MODIFIED.equals(eoList.getRole())) {
                    this.readEOList((EOList<? extends EOFrameData>)eoList, this.modifiedData);
                    continue;
                }
                this.readEOList((EOList<? extends EOFrameData>)eoList, this.removedData);
            }
        }
    }

    private void readEOList(EOList<? extends EOFrameData> eoList, Map<String, IFrameDataRW> map) {
        map.clear();
        for (EOFrameData eo : eoList) {
            IFrameDataRW frameData = this.frameDataFactory.createFrameData(eo);
            this.frameDataFactory.setAttributeModificationManager(frameData);
            map.put(frameData.getUID(), frameData);
        }
    }

    public void write() {
        this.modificationFileAccessor.write((IFileContentProviderForXMLFiles)new IFileContentProviderForXMLFiles<EOList<EOList<? extends EOFrameData>>>(){

            public EOList<EOList<? extends EOFrameData>> getFileContent() {
                EOList allLists = new EOList();
                allLists.add((EncodableObjectBase)FrameDataModificationManager.this.createEOList(FrameDataModificationManager.this.addedData.values(), FrameDataModificationManager.ROLE_ADDED));
                allLists.add((EncodableObjectBase)FrameDataModificationManager.this.createEOList(FrameDataModificationManager.this.modifiedData.values(), FrameDataModificationManager.ROLE_MODIFIED));
                allLists.add((EncodableObjectBase)FrameDataModificationManager.this.createEOList(FrameDataModificationManager.this.removedData.values(), FrameDataModificationManager.ROLE_REMOVED));
                return allLists;
            }
        });
    }

    private EOList<? extends EOFrameData> createEOList(Collection<? extends IFrameDataRW> baseList, String role) {
        EOList list = new EOList(role);
        for (IFrameDataRW iFrameDataRW : baseList) {
            list.add((EncodableObjectBase)iFrameDataRW.createEncodableObject());
        }
        return list;
    }

    public void delete() {
        this.modificationFileAccessor.write((IFileContentProviderForXMLFiles)new FileContentProviderForXMLFilesWithFixContent(null));
    }

    public IAddedItem[] getAddedItems() {
        IAddedItem[] addedItems = new IAddedItem[this.addedData.size()];
        int nr = 0;
        for (IFrameDataRW frameData : this.addedData.values()) {
            AddedItem item = new AddedItem((Object)frameData);
            addedItems[nr++] = item;
        }
        return addedItems;
    }

    public IModifiedItem[] getModifiedItems() {
        IModifiedItem[] modifiedItems = new IModifiedItem[this.modifiedData.size()];
        int nr = 0;
        for (IFrameDataRW frameData : this.modifiedData.values()) {
            ModifiedItem item = new ModifiedItem((Object)frameData);
            modifiedItems[nr++] = item;
        }
        return modifiedItems;
    }

    public IDeletedItem[] getDeletedItems() {
        IDeletedItem[] deletedItems = new IDeletedItem[this.removedData.size()];
        int nr = 0;
        for (IFrameDataRW frameData : this.removedData.values()) {
            DeletedItem item = new DeletedItem((Object)frameData);
            deletedItems[nr++] = item;
        }
        return deletedItems;
    }

    public IDataLabelProvider getDataLabelProvider() {
        return this.dataLabelProvider;
    }

    public String getTypeIDOfContainedData() {
        return this.cockpitDataType.getCockpitDataTypeID();
    }

    public Image getGeneralImage() {
        return this.cockpitDataType.getIcon();
    }

    public String getGeneralDescription() {
        return this.cockpitDataType.getDisplayName();
    }

    public void clear() {
        this.addedData.clear();
        this.modifiedData.clear();
        this.removedData.clear();
    }

    public void addAddedData(IFrameDataRW frameData) {
        this.addedData.put(frameData.getUID(), frameData);
    }

    public void removeAddedData(String dataUID) {
        this.addedData.remove(dataUID);
    }

    public boolean isAddedData(String dataUID) {
        return this.addedData.containsKey(dataUID);
    }

    public Collection<? extends IFrameDataRW> getAddedData() {
        return this.addedData.values();
    }

    public void addModifiedData(IFrameDataRW frameData) {
        this.modifiedData.put(frameData.getUID(), frameData);
    }

    public boolean isModifiedData(String dataUID) {
        return this.modifiedData.containsKey(dataUID);
    }

    public Collection<? extends IFrameDataRW> getModifiedData() {
        return this.modifiedData.values();
    }

    public void removeModifiedData(String dataUID) {
        this.modifiedData.remove(dataUID);
    }

    public void addRemovedData(IFrameDataRW frameData) {
        this.removedData.put(frameData.getUID(), frameData);
    }

    public boolean isRemovedData(String dataUID) {
        return this.removedData.containsKey(dataUID);
    }

    public void removeRemovedData(String dataUID) {
        this.removedData.remove(dataUID);
    }

    public Collection<? extends IFrameDataRW> getRemovedData() {
        return this.removedData.values();
    }

    public boolean isEmpty() {
        return this.addedData.isEmpty() && this.modifiedData.isEmpty() && this.removedData.isEmpty();
    }
}

