/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.core.framedata.datamanager;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.EXCorruptProjectData;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttribute;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeOwner;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeType;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeTypeDataType;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.ICockpitDataType;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IDataLabelProvider;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.ILocalModificationContainer;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.ObjectTypeCategoryID;
import com.arcway.cockpit.client.base.interfaces.frame.permissions.EXNoPermission;
import com.arcway.cockpit.client.base.interfaces.frame.propertychanges.IPropertyChanges;
import com.arcway.cockpit.client.base.interfaces.frame.propertychanges.PropertyChanges;
import com.arcway.cockpit.cockpitlib.client.files.atomic.FileKey;
import com.arcway.cockpit.frame.client.global.license.IClientFunctionLicenseType;
import com.arcway.cockpit.frame.client.project.IFrameDataManager;
import com.arcway.cockpit.frame.client.project.IFrameDataManagerAdministrator;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.Messages;
import com.arcway.cockpit.frame.client.project.core.framedata.AbstractFrameData;
import com.arcway.cockpit.frame.client.project.core.framedata.FrameDataTypes;
import com.arcway.cockpit.frame.client.project.core.framedata.IAttributeOwnerRW;
import com.arcway.cockpit.frame.client.project.core.framedata.IAttributeTypesProvider;
import com.arcway.cockpit.frame.client.project.core.framedata.IFrameDataRW;
import com.arcway.cockpit.frame.client.project.core.framedata.IReportTemplateFolder;
import com.arcway.cockpit.frame.client.project.core.framedata.ModificationProblem;
import com.arcway.cockpit.frame.client.project.core.framedata.RenameDataValidator;
import com.arcway.cockpit.frame.client.project.core.framedata.datamanager.FrameDataCache;
import com.arcway.cockpit.frame.client.project.core.framedata.datamanager.FrameDataModificationManager;
import com.arcway.cockpit.frame.client.project.core.framedata.datamanager.IFrameDataFactory;
import com.arcway.cockpit.frame.client.project.core.framedata.datamanager.ServerStateAccessAgent;
import com.arcway.cockpit.frame.client.project.core.framedata.transactionmanagement.FrameDataTransactionListener;
import com.arcway.cockpit.frame.client.project.core.framedata.transactionmanagement.ILocksAndPermissionsTransactionController;
import com.arcway.cockpit.frame.client.project.core.framedata.transactionmanagement.LocksAndPermissionsTransactionController;
import com.arcway.cockpit.frame.client.project.core.links.IFrameLinkManager;
import com.arcway.cockpit.frame.client.project.core.links.linkableobjects.ILOLinkAccessFacade;
import com.arcway.cockpit.frame.client.project.core.links.linktypes.CardinalityN1;
import com.arcway.cockpit.frame.client.project.core.links.linktypes.ILinkTypeLinkAccessFacade;
import com.arcway.cockpit.frame.client.project.core.links.linktypes.LinkType;
import com.arcway.cockpit.frame.client.project.core.serverproxy.ServerDataContainer;
import com.arcway.cockpit.frame.client.project.core.userdefinedattributetypes.IParentOperandTree;
import com.arcway.cockpit.frame.shared.ILockable;
import com.arcway.cockpit.frame.shared.IPermissionOperand;
import com.arcway.cockpit.frame.shared.message.EOFrameDataModification;
import com.arcway.cockpit.frame.shared.message.EOLink;
import com.arcway.cockpit.frame.shared.message.EOLock;
import com.arcway.cockpit.frame.shared.message.genericframedata.EOFrameData;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.ui.IModificationProblem;
import de.plans.lib.xml.encoding.EOList;
import de.plans.psc.client.communication.LoginCanceledException;
import de.plans.psc.client.communication.ServerNotAvailableException;
import de.plans.psc.client.communication.UnknownServerException;
import de.plans.psc.shared.serverexceptions.EXServerException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Image;

public abstract class DataManager
implements IFrameDataManager {
    public static final String PARENT_CHILD_LINK_PREFIX = "parent_child_";
    private static final ILogger logger = Logger.getLogger(DataManager.class);
    private final FileKey MOD_FILEKEY;
    private final ICockpitDataType DATATYPE;
    private final IAttributeTypesProvider attributeTypesProvider;
    private final Class<? extends IFrameDataRW> implementingClass;
    private FrameDataCache<IFrameDataRW> dataCache;
    private FrameDataModificationManager modManager;
    private ServerStateAccessAgent serverStateAccessAgent;
    private IFrameProjectAgent projectAgent;
    private final IFrameLinkManager linkManager;
    private IDataLabelProvider dataLabelProvider;
    private final IFrameDataFactory dataFactory;
    private final Collection<ICockpitDataType> parentTypes;
    private final Map<String, String> parentLinkTypeIDs = new HashMap<String, String>();
    private final Map<String, ILinkTypeLinkAccessFacade> parentLinkFacades = new HashMap<String, ILinkTypeLinkAccessFacade>();
    private final Map<ILocksAndPermissionsTransactionController, Collection<? extends FrameDataTransactionListener>> approvedAddRequests = new HashMap<ILocksAndPermissionsTransactionController, Collection<? extends FrameDataTransactionListener>>();
    private final Map<ILocksAndPermissionsTransactionController, Collection<? extends FrameDataTransactionListener>> approvedMoveRequests = new HashMap<ILocksAndPermissionsTransactionController, Collection<? extends FrameDataTransactionListener>>();
    private final Map<ILocksAndPermissionsTransactionController, Collection<? extends FrameDataTransactionListener>> approvedDeleteRequests = new HashMap<ILocksAndPermissionsTransactionController, Collection<? extends FrameDataTransactionListener>>();

    public static String getLockTypeForUniqueNameLock(IAttributeOwner modifiedChild, String newChildName) {
        return "uniqueName_" + modifiedChild.getTypeID() + "_" + newChildName.toLowerCase();
    }

    public static IParentOperandTree getParentOperandTree(final IAttributeOwner data, final IFrameProjectAgent projectAgent) {
        return new IParentOperandTree(){

            @Override
            public IPermissionOperand getBaseOperand() {
                IAttributeOwner operand = data;
                while (operand != null && !(operand instanceof IPermissionOperand)) {
                    IFrameDataManager dataManager = projectAgent.getDataManager(operand.getTypeID());
                    operand = dataManager.getParent(operand);
                }
                return (IPermissionOperand)operand;
            }

            @Override
            public IPermissionOperand getParent(IPermissionOperand childOperand) {
                IAttributeOwner child = (IAttributeOwner)childOperand;
                IFrameDataManager dataManager = projectAgent.getDataManager(child.getTypeID());
                IAttributeOwner parent = dataManager.getParent(child);
                while (parent != null && !(parent instanceof IPermissionOperand)) {
                    dataManager = projectAgent.getDataManager(parent.getTypeID());
                    parent = dataManager.getParent(parent);
                }
                return (IPermissionOperand)parent;
            }
        };
    }

    public DataManager(FileKey modificationsFileKey, ICockpitDataType dataType, IFrameDataFactory dataFactory, IAttributeTypesProvider attributeTypesProvider, Class<? extends IFrameDataRW> implementingClass, IFrameLinkManager linkManager, Collection<ICockpitDataType> parentTypes) {
        this.MOD_FILEKEY = modificationsFileKey;
        this.DATATYPE = dataType;
        this.attributeTypesProvider = attributeTypesProvider;
        this.implementingClass = implementingClass;
        this.parentTypes = parentTypes;
        this.linkManager = linkManager;
        this.createDataLabelProvider();
        this.dataFactory = dataFactory;
    }

    private String getParentLinkTypeID(ICockpitDataType parentDataType) {
        return PARENT_CHILD_LINK_PREFIX + parentDataType.getCockpitDataTypeID() + "_" + this.DATATYPE.getCockpitDataTypeID();
    }

    private void createDataLabelProvider() {
        this.dataLabelProvider = new IDataLabelProvider(){

            public Image getImageOfType(String dataTypeID) {
                return DataManager.this.DATATYPE.getIcon();
            }

            public String getTypeDisplayName(String dataTypeID) {
                if (!$assertionsDisabled && !dataTypeID.equals(DataManager.this.DATATYPE.getCockpitDataTypeID())) {
                    throw new AssertionError();
                }
                return DataManager.this.DATATYPE.getDisplayName();
            }

            public Image getImage(Object element) {
                IAttributeOwner attributeOwner = (IAttributeOwner)element;
                return DataManager.this.DATATYPE.getImage((ICockpitProjectData)attributeOwner);
            }

            public String getText(Object element) {
                IAttributeOwner attributeOwner = (IAttributeOwner)element;
                return DataManager.this.DATATYPE.getDisplayName((ICockpitProjectData)attributeOwner);
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }
        };
    }

    @Override
    public void initializeBeforePermissionsCheck(IFrameDataManagerAdministrator administrator, ServerDataContainer serverDataContainer) throws EXCorruptProjectData {
    }

    @Override
    public void initializeAfterPermissionsCheck(IFrameDataManagerAdministrator administrator, ServerDataContainer serverDataContainer) throws EXCorruptProjectData {
        this.projectAgent = administrator.getFrameProjectAgent();
        for (ICockpitDataType parentType : this.parentTypes) {
            String linkTypeID = this.getParentLinkTypeID(parentType);
            String displayName = String.valueOf(Messages.getString("DataManager.ParentChildDisplayNamePrefix")) + " '" + this.DATATYPE.getDisplayName() + "' -> '" + parentType.getDisplayName() + "'";
            LinkType linkType = new LinkType(linkTypeID, displayName, parentType.getCockpitDataTypeID(), this.DATATYPE.getCockpitDataTypeID(), new CardinalityN1(), "frame", null, false, false);
            ILinkTypeLinkAccessFacade linkFacade = this.linkManager.registerLinkType(linkType);
            this.parentLinkTypeIDs.put(parentType.getCockpitDataTypeID(), linkTypeID);
            this.parentLinkFacades.put(parentType.getCockpitDataTypeID(), linkFacade);
        }
        Collection eoDatas = serverDataContainer.getFrameData(this.DATATYPE.getCockpitDataTypeID());
        this.serverStateAccessAgent = new ServerStateAccessAgent(eoDatas, this.dataFactory);
        ArrayList<IFrameDataRW> originalData = new ArrayList<IFrameDataRW>(eoDatas.size());
        for (EOFrameData eo : eoDatas) {
            IFrameDataRW data = this.dataFactory.createFrameData(eo);
            this.dataFactory.setAttributeModificationManager(data);
            originalData.add(data);
        }
        this.dataCache = new FrameDataCache(originalData);
        this.modManager = new FrameDataModificationManager(this.projectAgent, this.DATATYPE, this.dataFactory, this.MOD_FILEKEY, this.dataLabelProvider);
        this.dataCache.putDataItems(this.modManager.getAddedData());
        this.dataCache.putDataItems(this.modManager.getModifiedData());
        this.dataCache.removeDataItems(this.modManager.getRemovedData());
    }

    @Override
    public void finishInitialization(IFrameDataManagerAdministrator administrator, ServerDataContainer serverDataContainer) {
    }

    @Override
    public String getLocalizedManagerName() {
        return "Report templates manager";
    }

    @Override
    public void discardLocalModifications() {
        if (!this.modManager.getAddedData().isEmpty()) {
            for (IFrameDataRW iFrameDataRW : this.modManager.getAddedData()) {
                if (!(iFrameDataRW instanceof IPermissionOperand)) continue;
                this.projectAgent.getProjectPermissionModificationModel().permissionOperandRemoved((IPermissionOperand)iFrameDataRW);
            }
            try {
                this.projectAgent.getProjectPermissionModificationModel().commit();
            }
            catch (EXServerException eXServerException) {
                logger.error("Unable to remove permission of locally added data from server.", (Throwable)eXServerException);
            }
            catch (ServerNotAvailableException serverNotAvailableException) {
                logger.error("Unable to remove permission of locally added data from server.", (Throwable)serverNotAvailableException);
            }
            catch (UnknownServerException unknownServerException) {
                logger.error("Unable to remove permission of locally added data from server.", (Throwable)unknownServerException);
            }
            catch (LoginCanceledException loginCanceledException) {
                logger.error("Unable to remove permission of locally added data from server.", (Throwable)loginCanceledException);
            }
        }
        this.modManager.clear();
        this.modManager.delete();
        this.dataCache = new FrameDataCache(this.serverStateAccessAgent.getServerData());
    }

    @Override
    public boolean hasLocalModifications() {
        return !this.modManager.isEmpty();
    }

    @Override
    public boolean handlesDataType(String cockpitDataTypeID) {
        return this.DATATYPE.getCockpitDataTypeID().equals(cockpitDataTypeID);
    }

    @Override
    public boolean itemExistsOnServer(String cockpitDataUID) {
        return this.serverStateAccessAgent.getServerData(cockpitDataUID) != null;
    }

    @Override
    public ICockpitProjectData getCockpitProjectData(String cockpitDataUID) {
        Collection<? extends IAttributeOwner> datas = this.getData();
        for (IAttributeOwner iAttributeOwner : datas) {
            if (!iAttributeOwner.getUID().equals(cockpitDataUID)) continue;
            return iAttributeOwner;
        }
        return null;
    }

    @Override
    public IDataLabelProvider getDataLabelProvider() {
        return this.dataLabelProvider;
    }

    @Override
    public ILocalModificationContainer[] getLocalModifications(boolean displayableOnly) {
        return new ILocalModificationContainer[]{this.modManager};
    }

    @Override
    public Map<IAttributeTypeDataType, Collection<IAttribute>> getAllAttributesOfType(Class<? extends IAttributeTypeDataType> dataTypeClazz) {
        Collection<? extends IAttributeOwner> folders = this.getData();
        HashMap<IAttributeTypeDataType, Collection<IAttribute>> dataTypes_attributes = new HashMap<IAttributeTypeDataType, Collection<IAttribute>>();
        Collection<IAttributeType> allTypes = this.attributeTypesProvider.getAttributeTypes();
        for (IAttributeType attributeType : allTypes) {
            IAttributeTypeDataType attributeTypeDataType = attributeType.getDataType();
            if (!dataTypeClazz.isAssignableFrom(attributeTypeDataType.getClass())) continue;
            Collection<IAttribute> attributes = this.getAttributes(folders, attributeType);
            dataTypes_attributes.put(attributeTypeDataType, attributes);
        }
        return dataTypes_attributes;
    }

    private Collection<IAttribute> getAttributes(Collection<? extends IAttributeOwner> attributeOwners, IAttributeType attributeType) {
        ArrayList<IAttribute> attributes = new ArrayList<IAttribute>();
        for (IAttributeOwner iAttributeOwner : attributeOwners) {
            IAttribute attribute = iAttributeOwner.getAttribute(attributeType.getAttributeTypeID());
            attributes.add(attribute);
        }
        return attributes;
    }

    @Override
    public Collection<IAttributeType> getAllAttributeTypes(Class<? extends IAttributeTypeDataType> dataTypeClass) {
        ArrayList<IAttributeType> allAttributeTypes = new ArrayList<IAttributeType>(this.attributeTypesProvider.getAttributeTypes());
        Iterator i = allAttributeTypes.iterator();
        while (i.hasNext()) {
            IAttributeType attributeType = (IAttributeType)i.next();
            if (dataTypeClass.isAssignableFrom(attributeType.getDataType().getClass())) continue;
            i.remove();
        }
        return allAttributeTypes;
    }

    @Override
    public void requestDataDeletePermission(IAttributeOwner data, ILocksAndPermissionsTransactionController transactionController) {
        transactionController.addPermission("deleteChild", data.getTypeID(), DataManager.getParentOperandTree(this.getParent(data), this.projectAgent));
        transactionController.addLockToTest((ILockable)data, "add");
        transactionController.addLockToTest((ILockable)data, "delete");
        transactionController.addLockToTest((ILockable)data, "modify");
        transactionController.addLock((ILockable)data, "modify");
        transactionController.addLock((ILockable)data, "delete");
        for (IClientFunctionLicenseType iClientFunctionLicenseType : this.getNeededLicenseTypesForDelete()) {
            transactionController.addClientLicenseType(iClientFunctionLicenseType);
        }
        for (IAttributeOwner iAttributeOwner : this.getChildren(data)) {
            IFrameDataManager dataManager = this.projectAgent.getDataManager(iAttributeOwner.getTypeID());
            dataManager.requestDataDeletePermission(iAttributeOwner, transactionController);
        }
        new FrameDataTransactionListener((IFrameDataRW)data, this.approvedDeleteRequests, transactionController);
    }

    @Override
    public void deleteData(ILocksAndPermissionsTransactionController transactionController) throws EXNoPermission {
        ArrayList<? extends FrameDataTransactionListener> listeners = new ArrayList<FrameDataTransactionListener>(this.approvedDeleteRequests.get(transactionController));
        ArrayList<IFrameDataRW> deletedData = new ArrayList<IFrameDataRW>();
        for (FrameDataTransactionListener frameDataTransactionListener : listeners) {
            IFrameDataRW data = frameDataTransactionListener.getData();
            this.deleteChildren(data, transactionController);
            this.linkManager.getLOLinkAccessFacade(data.getTypeID()).linkableObjectDeleted((ICockpitProjectData)data);
            if (this.modManager.isAddedData(data.getUID())) {
                if (data instanceof IPermissionOperand) {
                    this.projectAgent.getProjectPermissionModificationModel().permissionOperandRemoved((IPermissionOperand)data);
                    try {
                        this.projectAgent.getProjectPermissionModificationModel().commit();
                    }
                    catch (EXServerException e) {
                        logger.error("Could not remove permission while removing locally added data.", (Throwable)e);
                    }
                    catch (ServerNotAvailableException e) {
                        logger.error("Could not remove permission while removing locally added data.", (Throwable)e);
                    }
                    catch (UnknownServerException e) {
                        logger.error("Could not remove permission while removing locally added data.", (Throwable)e);
                    }
                    catch (LoginCanceledException e) {
                        logger.error("Could not remove permission while removing locally added data.", (Throwable)e);
                    }
                }
                this.modManager.removeAddedData(data.getUID());
            } else {
                this.modManager.removeModifiedData(data.getUID());
                this.modManager.addRemovedData(data);
            }
            this.dataCache.removeDataItem(data);
            deletedData.add(data);
            frameDataTransactionListener.kill();
        }
        this.modManager.write();
        PropertyChanges propertyChanges = new PropertyChanges(null, null, deletedData);
        this.projectAgent.getPropertyChangesProviderManager().modelRefreshed((IPropertyChanges)propertyChanges, this.implementingClass);
    }

    private void deleteChildren(IFrameDataRW data, ILocksAndPermissionsTransactionController transactionController) throws EXNoPermission {
        ArrayList<IFrameDataManager> childManagers = new ArrayList<IFrameDataManager>();
        for (IAttributeOwner iAttributeOwner : this.getChildren(data)) {
            IFrameDataManager dataManager = this.projectAgent.getDataManager(iAttributeOwner.getTypeID());
            if (childManagers.contains(dataManager)) continue;
            childManagers.add(dataManager);
        }
        for (IFrameDataManager iFrameDataManager : childManagers) {
            iFrameDataManager.deleteData(transactionController);
        }
    }

    public void applySynchronousModification(EOFrameDataModification frameDataModification) {
        this.applyServerResponse((EOFrameDataModification<? extends EOFrameData>)frameDataModification, true, true, true, false);
    }

    public void applyAsynchronousModifications(EOFrameDataModification frameDataModification) {
        this.applyServerResponse((EOFrameDataModification<? extends EOFrameData>)frameDataModification, true, true, false, true);
    }

    private void applyServerResponse(EOFrameDataModification<? extends EOFrameData> frameDataModification, boolean updateClientCache, boolean updateServerCache, boolean updateModificationCache, boolean firePropertyChange) {
        IFrameDataRW frameData;
        EOFrameData eo;
        Map<EOFrameData, IFrameDataRW> created = this.getFrameData((EOList<? extends EOFrameData>)frameDataModification.getCreatedData());
        Map<EOFrameData, IFrameDataRW> modified = this.getFrameData((EOList<? extends EOFrameData>)frameDataModification.getModifiedData());
        Map<EOFrameData, IFrameDataRW> deleted = this.getFrameData((EOList<? extends EOFrameData>)frameDataModification.getDeletedData());
        for (Map.Entry<EOFrameData, IFrameDataRW> entry : created.entrySet()) {
            eo = entry.getKey();
            frameData = entry.getValue();
            if (updateClientCache) {
                this.dataFactory.setAttributeModificationManager(frameData);
                this.dataCache.putDataItem(frameData);
            }
            if (updateModificationCache) {
                this.modManager.removeAddedData(eo.getUID());
            }
            if (!updateServerCache) continue;
            this.serverStateAccessAgent.putServerData(eo);
        }
        for (Map.Entry<EOFrameData, IFrameDataRW> entry : modified.entrySet()) {
            eo = entry.getKey();
            frameData = entry.getValue();
            if (updateClientCache) {
                this.dataFactory.setAttributeModificationManager(frameData);
                this.dataCache.putDataItem(frameData);
            }
            if (updateModificationCache) {
                this.modManager.removeModifiedData(eo.getUID());
            }
            if (!updateServerCache) continue;
            this.serverStateAccessAgent.putServerData(eo);
        }
        for (Map.Entry<EOFrameData, IFrameDataRW> entry : deleted.entrySet()) {
            eo = entry.getKey();
            frameData = entry.getValue();
            if (updateClientCache) {
                this.dataCache.removeDataItem(frameData);
            }
            if (updateModificationCache) {
                this.modManager.removeRemovedData(eo.getUID());
            }
            if (!updateServerCache) continue;
            this.serverStateAccessAgent.removeServerData(eo.getUID());
        }
        if (updateModificationCache) {
            this.modManager.write();
        }
        if (firePropertyChange) {
            PropertyChanges changes = new PropertyChanges(created.values(), modified.values(), deleted.values(), true);
            this.projectAgent.getPropertyChangesProviderManager().modelRefreshed((IPropertyChanges)changes, this.implementingClass);
        }
    }

    private Map<EOFrameData, IFrameDataRW> getFrameData(EOList<? extends EOFrameData> eos) {
        HashMap<EOFrameData, IFrameDataRW> frameDatas = new HashMap<EOFrameData, IFrameDataRW>();
        for (EOFrameData eo : eos) {
            IFrameDataRW frameData = this.dataFactory.createFrameData(eo);
            frameDatas.put(eo, frameData);
        }
        return frameDatas;
    }

    @Override
    public void requestAddPermission(String name, ObjectTypeCategoryID objectTypeCategoryID, Collection<IAttribute> attributes, IAttributeOwner parent, boolean forImport, ILocksAndPermissionsTransactionController transactionController) {
        if (!this.parentLinkTypeIDs.containsKey(parent.getTypeID())) {
            ICockpitDataType wantedParentDataType = FrameDataTypes.getDataType(parent.getTypeID());
            transactionController.addLockModificationProblem(new ModificationProblem(String.valueOf(Messages.getString("DataManager.may_not_add1")) + this.DATATYPE.getDisplayName() + Messages.getString("DataManager.may_not_add2") + wantedParentDataType.getDisplayName() + Messages.getString("DataManager.may_not_add3"), Messages.getString("DataManager.can_not_add")));
        } else {
            RenameDataValidator validator = new RenameDataValidator(this.DATATYPE.getCockpitDataTypeID(), parent, this.projectAgent);
            String msg = validator.isValid(name);
            if (msg != null) {
                transactionController.addLockModificationProblem(new ModificationProblem(msg, Messages.getString("DataManager.can_not_add")));
            }
            transactionController.addPermission("addChild", this.DATATYPE.getCockpitDataTypeID(), DataManager.getParentOperandTree(parent, this.projectAgent));
            for (IAttribute attribute : attributes) {
                this.checkAttributeOnCreation(attribute, transactionController);
            }
            IFrameDataRW newFrameData = this.dataFactory.createFrameData(attributes);
            ((AbstractFrameData)newFrameData).setCategoryID(objectTypeCategoryID);
            transactionController.addLockToTest((ILockable)parent, "delete");
            transactionController.addLock((ILockable)parent, "add");
            String lockTypeIDUniqueNameLock = DataManager.getLockTypeForUniqueNameLock(newFrameData, name);
            transactionController.addLockToTest((ILockable)parent, lockTypeIDUniqueNameLock);
            transactionController.addLock((ILockable)parent, lockTypeIDUniqueNameLock);
            for (IClientFunctionLicenseType clientLicenseType : this.getNeededLicenseTypesForAdd()) {
                transactionController.addClientLicenseType(clientLicenseType);
            }
            new FrameDataTransactionListener(newFrameData, Collections.singletonMap("unspecified", parent), this.approvedAddRequests, transactionController);
        }
    }

    public abstract void checkAttributeOnCreation(IAttribute var1, ILocksAndPermissionsTransactionController var2);

    public abstract Collection<IClientFunctionLicenseType> getNeededLicenseTypesForAdd();

    public abstract Collection<IClientFunctionLicenseType> getNeededLicenseTypesForDelete();

    public Collection<IAttributeOwner> addData(ILocksAndPermissionsTransactionController transactionController) throws EXNoPermission {
        Collection<? extends FrameDataTransactionListener> listeners = this.approvedAddRequests.get(transactionController);
        if (listeners == null) {
            throw new EXNoPermission("add-permission was not granted!");
        }
        ArrayList<IAttributeOwner> addedData = new ArrayList<IAttributeOwner>();
        for (FrameDataTransactionListener frameDataTransactionListener : listeners) {
            IFrameDataRW newFrameData = frameDataTransactionListener.getData();
            this.dataFactory.setAttributeModificationManager(newFrameData);
            this.modManager.addAddedData(newFrameData);
            this.dataCache.putDataItem(newFrameData);
            addedData.add(newFrameData);
            IAttributeOwner parent = frameDataTransactionListener.getAdditionalData("unspecified");
            String linkTypeID = this.parentLinkTypeIDs.get(parent.getTypeID());
            ILinkTypeLinkAccessFacade linkFacade = this.parentLinkFacades.get(parent.getTypeID());
            EOLink link = new EOLink(this.projectAgent.getProjectUID(), parent.getUID(), newFrameData.getUID(), "frame", linkTypeID);
            linkFacade.addLink(link);
        }
        this.modManager.write();
        PropertyChanges propertyChanges = new PropertyChanges(addedData, null, null);
        this.projectAgent.getPropertyChangesProviderManager().modelRefreshed((IPropertyChanges)propertyChanges, this.implementingClass);
        return addedData;
    }

    @Override
    public List<IFrameDataRW> importDataFromEO(List<EOFrameData> eos) {
        ArrayList<IFrameDataRW> newData = new ArrayList<IFrameDataRW>();
        for (EOFrameData eo : eos) {
            IFrameDataRW frameData = this.dataFactory.createFrameData(eo);
            this.dataFactory.setAttributeModificationManager(frameData);
            this.modManager.addAddedData(frameData);
            this.dataCache.putDataItem(frameData);
            newData.add(frameData);
        }
        this.modManager.write();
        return newData;
    }

    @Override
    public IAttributeOwner getParent(IAttributeOwner childFolder) {
        for (ILinkTypeLinkAccessFacade linkFacade : this.parentLinkFacades.values()) {
            Collection<ICockpitProjectData> parents = linkFacade.getLinkableObjects(childFolder.getUID());
            if (parents.isEmpty()) continue;
            return (IAttributeOwner)parents.iterator().next();
        }
        return null;
    }

    @Override
    public Collection<? extends IAttributeOwner> getChildren(IAttributeOwner parent) {
        ILOLinkAccessFacade loLinkFacade = this.linkManager.getLOLinkAccessFacade(parent.getTypeID());
        Collection<EOLink> links = loLinkFacade.getParentChildLinks(parent.getUID());
        ArrayList<IAttributeOwner> childObjects = new ArrayList<IAttributeOwner>(links.size());
        for (EOLink link : links) {
            ICockpitProjectData moduleDataItem = this.linkManager.getModuleDataItem(link);
            if (!(moduleDataItem instanceof IAttributeOwner)) continue;
            childObjects.add((IAttributeOwner)moduleDataItem);
        }
        return childObjects;
    }

    @Override
    public Collection<? extends IAttributeOwner> getData() {
        return this.dataCache.getAllDataItems();
    }

    @Override
    public void visitAllAttributeOwnerRWs(IAttributeOwnerRW.IVisitor visitor) {
        IAttributeOwnerRW.Visitor.visitAllAttributeOwnerRWs(this.getData(), visitor);
    }

    @Override
    public boolean managesChildrenForType(String dataTypeID) {
        for (ICockpitDataType dataType : this.parentTypes) {
            if (!dataType.getCockpitDataTypeID().equals(dataTypeID)) continue;
            return true;
        }
        return false;
    }

    @Override
    public IFrameDataFactory getDataFactory() {
        return this.dataFactory;
    }

    @Override
    public IAttributeOwner getServerState(String dataUID) {
        return this.serverStateAccessAgent.getServerData(dataUID);
    }

    @Override
    public void requestMovePermission(IAttributeOwner data, IAttributeOwner newParent, ILocksAndPermissionsTransactionController transactionController) {
        assert (data.getTypeID().equals(this.DATATYPE.getCockpitDataTypeID()));
        transactionController.addLockModificationProblem(new ModificationProblem("A " + this.DATATYPE.getDisplayName() + " cannot be moved.", "Can not move data."));
    }

    @Override
    public void moveData(ILocksAndPermissionsTransactionController transactionController) throws EXNoPermission {
        Collection<? extends FrameDataTransactionListener> listeners = this.approvedMoveRequests.get(transactionController);
        if (listeners == null) {
            throw new EXNoPermission("Permission for moving was not requested before!");
        }
        for (FrameDataTransactionListener frameDataTransactionListener : listeners) {
            IFrameDataRW dataToMove = frameDataTransactionListener.getData();
            IAttributeOwner newParent = frameDataTransactionListener.getAdditionalData("unspecified");
            IAttributeOwner oldParent = this.getParent(dataToMove);
            ILinkTypeLinkAccessFacade lf = this.parentLinkFacades.get(oldParent.getTypeID());
            Set<EOLink> linksToParents = lf.getLinksForModuleDataItem(dataToMove.getUID());
            assert (linksToParents.size() == 1);
            EOLink link = (EOLink)linksToParents.iterator().next();
            lf.deleteLink(link);
            String linkTypeID = this.parentLinkTypeIDs.get(newParent.getTypeID());
            EOLink newLink = new EOLink(this.projectAgent.getProjectUID(), newParent.getUID(), dataToMove.getUID(), "frame", linkTypeID);
            ILinkTypeLinkAccessFacade newParentsLinkFacade = this.parentLinkFacades.get(newParent.getUID());
            newParentsLinkFacade.addLink(newLink);
        }
    }

    @Override
    public void dataModified(IAttributeOwner data) {
        IFrameDataRW modifiedData = (IFrameDataRW)data;
        if (!this.modManager.isAddedData(modifiedData.getUID())) {
            this.modManager.addModifiedData(modifiedData);
        }
        this.modManager.write();
        PropertyChanges changes = new PropertyChanges(null, (Object)modifiedData, null);
        this.projectAgent.getPropertyChangesProviderManager().modelRefreshed((IPropertyChanges)changes, modifiedData.getClass());
    }

    @Override
    public boolean isLocallyModified(String dataUID) {
        return this.modManager.isModifiedData(dataUID);
    }

    @Override
    public boolean isLocallyAdded(String dataUID) {
        return this.modManager.isAddedData(dataUID);
    }

    protected IFrameProjectAgent getProjectAgent() {
        return this.projectAgent;
    }

    public Collection<IModificationProblem> checkAdditionPermission(IReportTemplateFolder parent, ICockpitDataType dataType) {
        ArrayList<IModificationProblem> problems = new ArrayList<IModificationProblem>();
        LocksAndPermissionsTransactionController transactionController = new LocksAndPermissionsTransactionController(this.projectAgent);
        transactionController.addPermission("addChild", dataType.getCockpitDataTypeID(), DataManager.getParentOperandTree((IAttributeOwner)parent, this.projectAgent));
        transactionController.addLockToTest((ILockable)parent, "delete");
        problems.addAll(transactionController.checkConditions(true, true));
        Throwable serverException = null;
        try {
            EOLock conflictingLock = this.projectAgent.getFrameLockManager().anotherClientHasProjectLock();
            if (conflictingLock != null) {
                problems.add(new ModificationProblem(conflictingLock, Messages.getString("SectionManager.cannot_addChildrenCauseOfLock")));
            }
        }
        catch (ServerNotAvailableException e) {
            serverException = e;
        }
        catch (LoginCanceledException e) {
            serverException = e;
        }
        catch (EXServerException e) {
            serverException = e;
        }
        catch (UnknownServerException e) {
            serverException = e;
        }
        if (serverException != null) {
            problems.add(new ModificationProblem((Exception)serverException, Messages.getString("ProjectAttributeModificationManager.project_cannot_be_modified")));
        }
        return problems;
    }
}

