/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.core.framedata;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeType;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeTypeDataType;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeTypeID;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeTypeSortCriterium;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.ICockpitDataType;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IValueRange;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IValueRangeDefiner;
import com.arcway.cockpit.frame.client.global.gui.properties.AttributeTypeID;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.core.framedata.AttributeTypeSortCriterium;
import com.arcway.cockpit.frame.client.project.core.framedata.FrameDataTypes;
import com.arcway.cockpit.frame.shared.message.genericframedata.EOAttributeTypeID;
import com.arcway.cockpit.frame.shared.userdefinedattributes.EOUserDefinedAttributeType;
import com.arcway.cockpit.frame.shared.userdefinedattributes.ExInvalidDataType;
import com.arcway.lib.java.Assert;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import de.plans.lib.xml.encoding.EOEncodableObject;
import java.sql.Timestamp;
import java.util.Collection;

public class AttributeType
implements IAttributeType {
    private static final ILogger logger = Logger.getLogger(AttributeType.class);
    public static final String ID_PREFIX = "custom.";
    private static final String ID_PREFIX_FIXED = "custom.migrated_from_fixed_attribute.";
    private final IAttributeTypeID attributeTypeID;
    private String humanReadableID;
    private String displayName;
    private IAttributeTypeSortCriterium sortCriterium;
    private final IAttributeTypeDataType dataType;
    private IValueRange valueRange;
    private String projectUID;
    private ICockpitDataType cockpitDataType;
    private final String cockpitDataTypeID;
    private final boolean displayToUser;
    private final boolean isEditableByUser;
    private final boolean isMetaAttribute;
    private final boolean accessIsRestricted;
    private final boolean accessIsRestrictedOnCreation;
    private Timestamp modTime;
    private int modCount = 0;

    public static String createHumanReadableIDForCustomPropertyType(String idWithoutPrefix) {
        String humanReadableID = ID_PREFIX + idWithoutPrefix;
        return humanReadableID;
    }

    public static int getMaximumLengthOfCustomPropertyIDWithoutPrefix() {
        return 255 - ID_PREFIX.length();
    }

    public AttributeType(String projectUID, IAttributeTypeID uID, String humanReadableID, String displayName, IAttributeTypeSortCriterium sortCriterium, IAttributeTypeDataType dataType, String cockpitDataTypeID, IValueRange valueRange, boolean displayToUser, boolean isEditableByUser, boolean isMetaAttribute, boolean accessIsRestricted, boolean accessIsRestrictedOnCreation) {
        assert (cockpitDataTypeID != null);
        assert (humanReadableID != null);
        this.attributeTypeID = uID;
        this.humanReadableID = humanReadableID;
        this.displayName = displayName;
        this.sortCriterium = sortCriterium;
        this.dataType = dataType;
        this.projectUID = projectUID;
        this.cockpitDataType = FrameDataTypes.getDataType(cockpitDataTypeID);
        this.cockpitDataTypeID = cockpitDataTypeID;
        this.displayToUser = displayToUser;
        this.isEditableByUser = isEditableByUser;
        this.isMetaAttribute = isMetaAttribute;
        this.valueRange = valueRange;
        this.accessIsRestricted = accessIsRestricted;
        this.accessIsRestrictedOnCreation = accessIsRestrictedOnCreation;
        this.modTime = new Timestamp(System.currentTimeMillis());
    }

    public AttributeType(String projectUID, IAttributeTypeID uID, String humanReadableID, String displayName, IAttributeTypeSortCriterium sortCriterium, IAttributeTypeDataType dataType, ICockpitDataType cockpitDataType, IValueRange valueRange, boolean displayToUser, boolean isEditableByUser, boolean isMetaAttribute, boolean accessIsRestricted, boolean accessIsRestrictedOnCreation) {
        assert (humanReadableID != null);
        this.attributeTypeID = uID;
        this.humanReadableID = humanReadableID;
        this.displayName = displayName;
        this.sortCriterium = sortCriterium;
        this.dataType = dataType;
        this.projectUID = projectUID;
        this.cockpitDataType = cockpitDataType;
        this.cockpitDataTypeID = cockpitDataType.getCockpitDataTypeID();
        this.displayToUser = displayToUser;
        this.isEditableByUser = isEditableByUser;
        this.isMetaAttribute = isMetaAttribute;
        this.valueRange = valueRange;
        this.accessIsRestricted = accessIsRestricted;
        this.accessIsRestrictedOnCreation = accessIsRestrictedOnCreation;
        this.modTime = new Timestamp(System.currentTimeMillis());
    }

    public AttributeType(IAttributeType attributeType) {
        this.attributeTypeID = attributeType.getAttributeTypeID();
        this.humanReadableID = attributeType.getHumanReadableID();
        this.displayName = attributeType.getDisplayName();
        this.sortCriterium = attributeType.getSortCriterium();
        this.dataType = attributeType.getDataType();
        this.cockpitDataType = attributeType.getCockpitDataType();
        this.cockpitDataTypeID = attributeType.getCockpitDataTypeID();
        this.valueRange = attributeType.getValueRange();
        this.projectUID = attributeType.getProjectUID();
        this.displayToUser = attributeType.displayToUser();
        this.isEditableByUser = attributeType.isEditableByUser();
        this.isMetaAttribute = attributeType.isMetaAttribute();
        this.accessIsRestricted = attributeType.restrictedAccess();
        this.accessIsRestrictedOnCreation = attributeType.restrictedAccessOnCreation();
        this.modTime = new Timestamp(System.currentTimeMillis());
    }

    public void setCockpitDataType(ICockpitDataType cockpitDataType) {
        this.cockpitDataType = cockpitDataType;
    }

    public Timestamp getModTime() {
        return this.modTime;
    }

    public void setModTime(Timestamp modTime) {
        this.modTime = modTime;
    }

    public void setModCount(int modCount) {
        this.modCount = modCount;
    }

    public int getModCount() {
        return this.modCount;
    }

    public void setProjectUID(String projectUID) {
        this.projectUID = projectUID;
    }

    public static AttributeType createAttributeType(EOUserDefinedAttributeType eo, IFrameProjectAgent projectAgent) throws ExInvalidDataType {
        IAttributeTypeDataType dataType = projectAgent.getFrameUserDefinedAttributeTypesManager().getDataType(eo.getDataTypeID());
        if (dataType == null) {
            throw new ExInvalidDataType("any other", eo.getDataTypeID());
        }
        IValueRangeDefiner valueRangeHelper = dataType.getValueRangeHelper();
        EOEncodableObject eoValueRange = eo.getValueRangeAsEO();
        IValueRange valueRange = null;
        if (valueRangeHelper != null && eoValueRange != null) {
            valueRange = valueRangeHelper.getEOAsValueRange(eoValueRange);
        }
        AttributeTypeSortCriterium sortCriterium = new AttributeTypeSortCriterium(eo.getSortCriteriumCategory(), eo.getSortCriteriumString());
        AttributeType type = new AttributeType(eo.getProjectUID(), (IAttributeTypeID)AttributeTypeID.getAttributeTypeID(eo.getUID()), eo.getUID().getHumanreadableID(), eo.getDisplayName(), (IAttributeTypeSortCriterium)sortCriterium, dataType, eo.getCockpitDataTypeID(), valueRange, true, true, false, true, true);
        return type;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public IAttributeTypeSortCriterium getSortCriterium() {
        return this.sortCriterium;
    }

    public IAttributeTypeDataType getDataType() {
        return this.dataType;
    }

    public ICockpitDataType getCockpitDataType() {
        if (this.cockpitDataType == null) {
            Collection<ICockpitDataType> customPropertyDataTypes = FrameDataTypes.getDataTypesWithCustomProperties();
            for (ICockpitDataType typeDescription : customPropertyDataTypes) {
                if (!typeDescription.getCockpitDataTypeID().equals(this.cockpitDataTypeID)) continue;
                this.cockpitDataType = typeDescription;
                break;
            }
        }
        return this.cockpitDataType;
    }

    public String getCockpitDataTypeID() {
        return this.cockpitDataTypeID;
    }

    public IAttributeTypeID getAttributeTypeID() {
        return this.attributeTypeID;
    }

    public void setHumanReadableID(String humanReadableID) {
        assert (Assert.checkArgumentBeeingNotNull((Object)humanReadableID));
        this.humanReadableID = humanReadableID;
    }

    public void setDisplayName(String newDisplayName) {
        this.displayName = newDisplayName;
    }

    public void convertToCustomProperty(String idWithoutPrefix) {
        assert (this.humanReadableID != null);
        this.humanReadableID = AttributeType.createHumanReadableIDForCustomPropertyType(idWithoutPrefix);
    }

    public void setValueRange(IValueRange valueRange) {
        this.valueRange = valueRange;
    }

    public void setSortCriterium(IAttributeTypeSortCriterium sortCriterium) {
        this.sortCriterium = sortCriterium;
    }

    public IValueRange getValueRange() {
        return this.valueRange;
    }

    public EOUserDefinedAttributeType createEOUserDefinedAttributeType() {
        try {
            EOEncodableObject eoValueRange = null;
            IValueRangeDefiner valueRangeHelper = this.dataType.getValueRangeHelper();
            if (valueRangeHelper != null && this.valueRange != null) {
                eoValueRange = valueRangeHelper.getValueAsEO(this.valueRange, null);
            }
            EOUserDefinedAttributeType eo = new EOUserDefinedAttributeType(this.projectUID, new EOAttributeTypeID(this.attributeTypeID.getUID(), this.humanReadableID), this.displayName, this.sortCriterium.getCategory(), this.sortCriterium.getSortString(), this.cockpitDataType.getCockpitDataTypeID(), this.dataType.getID(), eoValueRange, this.getModTime(), this.getModCount());
            return eo;
        }
        catch (ExInvalidDataType e) {
            logger.error("could not create eo", (Throwable)e);
            return null;
        }
    }

    public boolean isUserDefined() {
        return this.humanReadableID.startsWith(ID_PREFIX);
    }

    public boolean isMigratedFromFixedAttribute() {
        return this.humanReadableID.startsWith(ID_PREFIX_FIXED);
    }

    public String getHumanReadableID() {
        return this.humanReadableID;
    }

    public String getHumanReadableIDWithoutPrefix() {
        String idWithoutPrefix = this.isMigratedFromFixedAttribute() ? this.humanReadableID.substring(ID_PREFIX_FIXED.length()) : (this.isUserDefined() ? this.humanReadableID.substring(ID_PREFIX.length()) : this.humanReadableID);
        return idWithoutPrefix;
    }

    public boolean isMetaAttribute() {
        return this.isMetaAttribute;
    }

    public String getProjectUID() {
        return this.projectUID;
    }

    public boolean displayToUser() {
        return this.displayToUser;
    }

    public boolean isEditableByUser() {
        return this.isEditableByUser;
    }

    public boolean restrictedAccess() {
        return this.accessIsRestricted;
    }

    public boolean restrictedAccessOnCreation() {
        return this.accessIsRestrictedOnCreation;
    }

    public boolean equals(Object obj) {
        if (obj != this) {
            if (obj instanceof IAttributeType) {
                IAttributeType attributeType = (IAttributeType)obj;
                return this.getAttributeTypeID().equals(attributeType.getAttributeTypeID());
            }
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.getAttributeTypeID().hashCode();
    }
}

