/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.core.framedata;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttribute;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeOwner;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class AttributeOwnerHelper {
    public static List<IAttribute> getSortedAttributes(final IAttributeOwner attributeOwner, Collection<IAttribute> allAttributes) {
        assert (attributeOwner != null) : "attributeOwner must not be null";
        assert (allAttributes != null) : "allAttributes must not be null";
        ArrayList<IAttribute> sortedAttributes = new ArrayList<IAttribute>(allAttributes);
        Collections.sort(sortedAttributes, new Comparator<IAttribute>(){

            @Override
            public int compare(IAttribute arg0, IAttribute arg1) {
                IAttributeType t0 = attributeOwner.getAttributeType(arg0.getAttributeTypeID());
                IAttributeType t1 = attributeOwner.getAttributeType(arg1.getAttributeTypeID());
                return AttributeOwnerHelper.compareAttributeTypes(t0, t1);
            }
        });
        return sortedAttributes;
    }

    public static List<IAttributeType> getSortedAttributeTypes(Collection<IAttributeType> allAttributeTypes) {
        assert (allAttributeTypes != null) : "allAttributes must not be null";
        ArrayList<IAttributeType> sortedAttributeTypes = new ArrayList<IAttributeType>(allAttributeTypes);
        Collections.sort(sortedAttributeTypes, new Comparator<IAttributeType>(){

            @Override
            public int compare(IAttributeType arg0, IAttributeType arg1) {
                return AttributeOwnerHelper.compareAttributeTypes(arg0, arg1);
            }
        });
        return sortedAttributeTypes;
    }

    private static int compareAttributeTypes(IAttributeType t0, IAttributeType t1) {
        return t0.getSortCriterium().compareTo((Object)t1.getSortCriterium());
    }
}

