/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.core.framedata;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeType;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeTypeDataType;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeTypeID;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeTypeSortCriterium;
import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.global.gui.properties.AttributeTypeID;
import com.arcway.cockpit.frame.client.project.Messages;
import com.arcway.cockpit.frame.client.project.ProjectAgent;
import com.arcway.cockpit.frame.client.project.core.framedata.AttributeType;
import com.arcway.cockpit.frame.client.project.core.framedata.AttributeTypeSortCriterium;
import com.arcway.cockpit.frame.client.project.core.framedata.IAttributeTypesProvider;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.DataTypeDate;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.DataTypeString;
import com.arcway.cockpit.frame.client.project.core.userdefinedattributetypes.IFrameUserDefinedAttributeTypesManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public abstract class AbstractAttributeTypesProvider
implements IAttributeTypesProvider {
    public static final String ATTRHRID_CREATOR = "creator";
    public static final IAttributeTypeID ATTRID_CREATOR = AbstractAttributeTypesProvider.getAttributeTypeID("creator");
    public static final String ATTRNAME_CREATOR = Messages.getString("AbstractAttributetypesProvider.Creator");
    public static final String ATTRHRID_CREATION_DATE = "creationDate";
    public static final IAttributeTypeID ATTRID_CREATION_DATE = AbstractAttributeTypesProvider.getAttributeTypeID("creationDate");
    public static final String ATTRNAME_CREATION_DATE = Messages.getString("AbstractAttributetypesProvider.CreationDate");
    public static final String ATTRHRID_LAST_EDITOR = "lastEditor";
    public static final IAttributeTypeID ATTRID_LAST_EDITOR = AbstractAttributeTypesProvider.getAttributeTypeID("lastEditor");
    public static final String ATTRNAME_LAST_EDITOR = Messages.getString("AbstractAttributetypesProvider.LastEditor");
    public static final String ATTRHRID_LAST_EDIT_DATE = "lastEditDate";
    public static final IAttributeTypeID ATTRID_LAST_EDIT_DATE = AbstractAttributeTypesProvider.getAttributeTypeID("lastEditDate");
    public static final String ATTRNAME_LAST_EDIT_DATE = Messages.getString("AbstractAttributetypesProvider.LastEditDate");
    private static final String ATTRID_PREFIX = "framedata.";
    protected final String projectUID;
    private final String dataTypeID;
    private final IFrameUserDefinedAttributeTypesManager userDefinedAttributeTypesManager;
    private HashMap<IAttributeTypeID, IAttributeType> attributeTypesByID;
    private List<IAttributeType> attributeTypes;

    private static IAttributeTypeID getAttributeTypeID(String humanreadableID) {
        return AttributeTypeID.getAttributeTypeID(ATTRID_PREFIX + humanreadableID);
    }

    public AbstractAttributeTypesProvider(String dataTypeID, String projectUID) {
        this.dataTypeID = dataTypeID;
        this.projectUID = projectUID;
        ProjectAgent projectAgent = ProjectMgr.getProjectMgr().getProjectAgent(projectUID);
        this.userDefinedAttributeTypesManager = projectAgent.getFrameUserDefinedAttributeTypesManager();
        this.attributeTypesByID = null;
        this.attributeTypes = null;
    }

    private void initializeAttributeTypesCache() {
        this.attributeTypesByID = new HashMap(16, 0.5f);
        this.attributeTypes = new ArrayList<IAttributeType>();
        AttributeType creator = new AttributeType(this.projectUID, ATTRID_CREATOR, ATTRHRID_CREATOR, ATTRNAME_CREATOR, (IAttributeTypeSortCriterium)new AttributeTypeSortCriterium(1, IAttributeTypeSortCriterium.CATEGORY_META_ATTRIBUTE), (IAttributeTypeDataType)DataTypeString.getInstanceString(), this.dataTypeID, null, true, false, true, false, false);
        AttributeType creationData = new AttributeType(this.projectUID, ATTRID_CREATION_DATE, ATTRHRID_CREATION_DATE, ATTRNAME_CREATION_DATE, (IAttributeTypeSortCriterium)new AttributeTypeSortCriterium(2, IAttributeTypeSortCriterium.CATEGORY_META_ATTRIBUTE), (IAttributeTypeDataType)DataTypeDate.getSingleInstance(), this.dataTypeID, null, true, false, true, false, false);
        AttributeType lastEditor = new AttributeType(this.projectUID, ATTRID_LAST_EDITOR, ATTRHRID_LAST_EDITOR, ATTRNAME_LAST_EDITOR, (IAttributeTypeSortCriterium)new AttributeTypeSortCriterium(3, IAttributeTypeSortCriterium.CATEGORY_META_ATTRIBUTE), (IAttributeTypeDataType)DataTypeString.getInstanceString(), this.dataTypeID, null, true, false, true, false, false);
        AttributeType lastEditDate = new AttributeType(this.projectUID, ATTRID_LAST_EDIT_DATE, ATTRHRID_LAST_EDIT_DATE, ATTRNAME_LAST_EDIT_DATE, (IAttributeTypeSortCriterium)new AttributeTypeSortCriterium(4, IAttributeTypeSortCriterium.CATEGORY_META_ATTRIBUTE), (IAttributeTypeDataType)DataTypeDate.getSingleInstance(), this.dataTypeID, null, true, false, true, false, false);
        this.putAttributeType(creator);
        this.putAttributeType(creationData);
        this.putAttributeType(lastEditor);
        this.putAttributeType(lastEditDate);
        for (IAttributeType attributeType : this.getDataTypeSpecificFixAttributeTypes()) {
            this.putAttributeType(attributeType);
        }
        for (IAttributeType attributeType : this.userDefinedAttributeTypesManager.getSortedAttributeTypes(this.dataTypeID)) {
            this.putAttributeType(attributeType);
        }
        this.attributeTypes = Collections.unmodifiableList(this.attributeTypes);
    }

    private void putAttributeType(IAttributeType creator) {
        IAttributeType oldValue = this.attributeTypesByID.put(creator.getAttributeTypeID(), creator);
        if (oldValue != null) {
            this.attributeTypes.remove(oldValue);
        }
        this.attributeTypes.add(creator);
    }

    @Override
    public void refreshAttributeTypesCache() {
        this.attributeTypesByID = null;
        this.attributeTypes = null;
    }

    @Override
    public Collection<IAttributeType> getAttributeTypes() {
        if (this.attributeTypes == null) {
            this.initializeAttributeTypesCache();
        }
        return this.attributeTypes;
    }

    @Override
    public IAttributeType getAttributeType(IAttributeTypeID attributeTypeID) {
        if (this.attributeTypesByID == null) {
            this.initializeAttributeTypesCache();
        }
        return this.attributeTypesByID.get(attributeTypeID);
    }

    @Override
    public IAttributeType getAttributeTypeByHumanreadableID(String humanreadableID) {
        for (IAttributeType attributeType : this.getAttributeTypes()) {
            if (!attributeType.getHumanReadableID().equals(humanreadableID)) continue;
            return attributeType;
        }
        return null;
    }

    protected abstract Collection<IAttributeType> getDataTypeSpecificFixAttributeTypes();
}

