/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.core.files;

import com.arcway.cockpit.client.base.interfaces.frame.ProjectDirectoryLayout;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.EXCorruptProjectData;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttribute;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeOwner;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeType;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeTypeDataType;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IDataLabelProvider;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.ILocalModificationContainer;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.ObjectTypeCategoryID;
import com.arcway.cockpit.client.base.interfaces.frame.permissions.EXNoPermission;
import com.arcway.cockpit.cockpitlib.client.files.IFileContentProviderForXMLFiles;
import com.arcway.cockpit.cockpitlib.client.files.IModificationAccessTransactionListeners;
import com.arcway.cockpit.cockpitlib.client.files.IXMLDataAccessor;
import com.arcway.cockpit.frame.client.project.IFrameDataManager;
import com.arcway.cockpit.frame.client.project.IFrameDataManagerAdministrator;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.Messages;
import com.arcway.cockpit.frame.client.project.ProjectAgent;
import com.arcway.cockpit.frame.client.project.core.files.FileID;
import com.arcway.cockpit.frame.client.project.core.files.FileMetaInformationFromSourceProject;
import com.arcway.cockpit.frame.client.project.core.files.FileMetaInformationItem;
import com.arcway.cockpit.frame.client.project.core.files.FileMetaInformationItemBody;
import com.arcway.cockpit.frame.client.project.core.files.IFilesManager;
import com.arcway.cockpit.frame.client.project.core.framedata.IAttributeOwnerRW;
import com.arcway.cockpit.frame.client.project.core.framedata.IAttributeTypesProvider;
import com.arcway.cockpit.frame.client.project.core.framedata.IFrameDataRW;
import com.arcway.cockpit.frame.client.project.core.framedata.datamanager.IFrameDataFactory;
import com.arcway.cockpit.frame.client.project.core.framedata.transactionmanagement.ILocksAndPermissionsTransactionController;
import com.arcway.cockpit.frame.client.project.core.serverproxy.ServerDataContainer;
import com.arcway.cockpit.frame.shared.message.EOCockpitProjectData;
import com.arcway.cockpit.frame.shared.message.EOFileMetaInformation;
import com.arcway.cockpit.frame.shared.message.EOFileModification;
import com.arcway.cockpit.frame.shared.message.EOFrameDataModification;
import com.arcway.cockpit.frame.shared.message.MessageDataFactory;
import com.arcway.cockpit.frame.shared.message.genericframedata.EOFrameData;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.lib.UUIDGenerator;
import com.arcway.lib.eclipse.file.tmp.SessionTempDirectoryManager;
import com.arcway.lib.io.DataCopyHelper;
import com.arcway.lib.io.FileHelper;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.resource.IStreamResource;
import com.arcway.lib.resource.JvmExternalResourceInteractionException;
import de.plans.lib.xml.encoding.IEncodableObjectFactory;
import de.plans.psc.client.communication.ExPrematureEndOfTransfer;
import de.plans.psc.client.communication.LoginCanceledException;
import de.plans.psc.client.communication.ServerNotAvailableException;
import de.plans.psc.client.communication.UnknownServerException;
import de.plans.psc.shared.serverexceptions.EXServerException;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.ImageData;

public class FilesManager
implements IFilesManager,
IFrameDataManager {
    private static final ILogger logger = Logger.getLogger(FilesManager.class);
    private final IFrameProjectAgent projectAgent;
    private final Map<FileID, FileMetaInformationItem> metaInformationOfGlobalFiles;
    private final Map<FileID, FileMetaInformationItem> metaInformationOfLocalAndTemporaryFiles;
    private final Map<FileID, FileMetaInformationFromSourceProject> metaInformationOfLocalAndTemporaryFilesFromSourceProject;
    private final Collection<FileID> filesInTemporaryStorageForFileReceipt;
    private final Map<FileID, Integer> referenceCountForLocalFiles;
    private final Collection<FileID> localFilesThatCouldNotBeCopied;
    private final IXMLDataAccessor<EOFileModification> modificationFileAccessor;
    private static final ThreadLocal<String> prefixThreadLocal = new ThreadLocal();

    public FilesManager(IFrameProjectAgent projectAgent) {
        this.projectAgent = projectAgent;
        this.metaInformationOfGlobalFiles = new HashMap<FileID, FileMetaInformationItem>();
        this.metaInformationOfLocalAndTemporaryFiles = new HashMap<FileID, FileMetaInformationItem>();
        this.metaInformationOfLocalAndTemporaryFilesFromSourceProject = new HashMap<FileID, FileMetaInformationFromSourceProject>();
        this.filesInTemporaryStorageForFileReceipt = new HashSet<FileID>();
        this.referenceCountForLocalFiles = new HashMap<FileID, Integer>();
        this.localFilesThatCouldNotBeCopied = new ArrayList<FileID>();
        this.modificationFileAccessor = projectAgent.getAtomicModificationDataAccessor().getXMLFileAccessor(ProjectDirectoryLayout.FILEKEY_FILEMANAGER_MODIFICATIONS_FILE, (IEncodableObjectFactory)MessageDataFactory.getInstance(), (IModificationAccessTransactionListeners)new XMLFileAccessTransactionListener());
    }

    @Override
    public FileID loadFileIntoTemporaryStorage(IStreamResource file) throws JvmExternalResourceInteractionException {
        assert (file != null);
        assert (file.getName() != null);
        return this.loadFileIntoTemporaryStorage(file, new FileMetaInformationItemBody(file.getName(), System.currentTimeMillis()));
    }

    @Override
    public FileID loadFileIntoTemporaryStorage(IStreamResource file, FileMetaInformationItemBody explicitMetaInformation) throws JvmExternalResourceInteractionException {
        assert (file != null);
        assert (explicitMetaInformation != null);
        FileID newFileID = new FileID(UUIDGenerator.getUniqueID());
        this.loadFileIntoTemporaryStorage(file, explicitMetaInformation, newFileID, null);
        return newFileID;
    }

    @Override
    public boolean loadFileIntoTemporaryStorage(IStreamResource file, FileID originalFileID, FileMetaInformationFromSourceProject sourceMetaInformation) throws JvmExternalResourceInteractionException {
        assert (file != null);
        assert (originalFileID != null && !FileID.NO_FILE.equals(originalFileID));
        if (this.hasFile(originalFileID) || this.hasFileInTemporaryStorage(originalFileID)) {
            return false;
        }
        this.loadFileIntoTemporaryStorage(file, sourceMetaInformation.getBody(), originalFileID, sourceMetaInformation);
        return true;
    }

    private void loadFileIntoTemporaryStorage(IStreamResource file, FileMetaInformationItemBody explicitMetaInformation, FileID newFileID, FileMetaInformationFromSourceProject sourceMetaInformation) throws JvmExternalResourceInteractionException {
        assert (explicitMetaInformation != null);
        FileMetaInformationItem newFileMetaInformation = new FileMetaInformationItem(newFileID, this.projectAgent.getProjectUID(), 0, explicitMetaInformation);
        try {
            File tmpFile = this.getFileInTemporaryStorageForFileReceipt(newFileID);
            if (tmpFile.exists()) {
                tmpFile.delete();
            }
            DataCopyHelper.copyFile((IStreamResource)file, (File)tmpFile);
            this.filesInTemporaryStorageForFileReceipt.add(newFileID);
            this.metaInformationOfLocalAndTemporaryFiles.put(newFileID, newFileMetaInformation);
            this.metaInformationOfLocalAndTemporaryFilesFromSourceProject.put(newFileID, sourceMetaInformation);
        }
        catch (JvmExternalResourceInteractionException e) {
            logger.error("Can not copy file into temporary storage.", (Throwable)e);
            throw e;
        }
    }

    @Override
    public boolean hasFileInTemporaryStorage(FileID fileID) {
        return this.filesInTemporaryStorageForFileReceipt.contains(fileID);
    }

    @Override
    public void removeFileFromTemporaryStorage(FileID fileID) {
        if (this.metaInformationOfGlobalFiles.containsKey(fileID)) {
            return;
        }
        assert (this.hasFileInTemporaryStorage(fileID));
        if (!this.localFilesThatCouldNotBeCopied.contains(fileID)) {
            this.deleteTemporaryFileFromTemporaryStorage(fileID);
        }
        this.filesInTemporaryStorageForFileReceipt.remove(fileID);
        if (this.referenceCountForLocalFiles.get(fileID) == null) {
            this.metaInformationOfLocalAndTemporaryFiles.remove(fileID);
        }
        this.metaInformationOfLocalAndTemporaryFilesFromSourceProject.remove(fileID);
    }

    private void deleteTemporaryFileFromTemporaryStorage(FileID fileID) {
        File file = this.getFileInTemporaryStorageForFileReceipt(fileID);
        try {
            FileHelper.deleteExistingFileOrDirectory((File)file);
        }
        catch (JvmExternalResourceInteractionException e) {
            logger.error("Could not delete file from temporary storage for file receipt.", (Throwable)e);
        }
    }

    private boolean isLocalFile(FileID fileID) {
        return this.referenceCountForLocalFiles.containsKey(fileID) && this.referenceCountForLocalFiles.get(fileID) > 0;
    }

    @Override
    public void markFileAsBeeingReferenced(FileID fileID) {
        if (this.metaInformationOfGlobalFiles.containsKey(fileID)) {
            return;
        }
        Integer referenceCount = this.referenceCountForLocalFiles.get(fileID);
        if (referenceCount == null) {
            assert (this.hasFileInTemporaryStorage(fileID));
            Throwable failure = this.copyLocalFileIntoUploadArea(fileID);
            if (failure != null) {
                this.localFilesThatCouldNotBeCopied.add(fileID);
            }
            this.referenceCountForLocalFiles.put(fileID, 1);
        } else {
            this.referenceCountForLocalFiles.put(fileID, referenceCount + 1);
        }
        this.writeModifications();
    }

    @Override
    public void markFileAsBeeingNotReferenced(FileID fileID) {
        if (this.metaInformationOfGlobalFiles.containsKey(fileID)) {
            return;
        }
        assert (this.isLocalFile(fileID));
        Integer referenceCount = this.referenceCountForLocalFiles.get(fileID);
        this.referenceCountForLocalFiles.put(fileID, referenceCount - 1);
        this.writeModifications();
    }

    @Override
    public boolean hasLocalFileForRollback(FileID fileID) {
        Integer referenceCount = this.referenceCountForLocalFiles.get(fileID);
        return referenceCount != null && referenceCount == 0;
    }

    private Throwable copyLocalFileIntoUploadArea(FileID fileID) {
        File tempFile = this.getFileInTemporaryStorageForFileReceipt(fileID);
        File cacheFile = this.getFileInDirectoryForDownloadCacheAndFilesToUpload(fileID);
        try {
            DataCopyHelper.copyFile((File)tempFile, (File)cacheFile);
            return null;
        }
        catch (JvmExternalResourceInteractionException e) {
            logger.error("Error copying file from temporary storage to upload area.", (Throwable)e);
            return e;
        }
    }

    private void deleteLocalFileFromUploadArea(FileID fileID) {
        File cacheFile = this.getFileInDirectoryForDownloadCacheAndFilesToUpload(fileID);
        try {
            FileHelper.deleteFileOrDirectory((File)cacheFile);
        }
        catch (JvmExternalResourceInteractionException e) {
            logger.error("Can't delete file from upload area.", (Throwable)e);
        }
    }

    @Override
    public boolean hasFile(FileID fileID) {
        if (this.metaInformationOfGlobalFiles.containsKey(fileID)) {
            return true;
        }
        return this.isLocalFile(fileID);
    }

    @Override
    public FileMetaInformationItem getFileMetaInformation(FileID fileID) {
        if (this.hasFileInTemporaryStorage(fileID) || this.isLocalFile(fileID)) {
            return this.metaInformationOfLocalAndTemporaryFiles.get(fileID);
        }
        return this.metaInformationOfGlobalFiles.get(fileID);
    }

    @Override
    public FileMetaInformationFromSourceProject getFileMetaInformationFromSourceProject(FileID fileID) {
        if (!this.hasFile(fileID)) {
            return this.metaInformationOfLocalAndTemporaryFilesFromSourceProject.get(fileID);
        }
        return null;
    }

    @Override
    public void downloadFileIntoCache(FileID fileID) throws ServerNotAvailableException, EXServerException, LoginCanceledException, UnknownServerException, ExPrematureEndOfTransfer {
        if (this.hasFile(fileID)) {
            this.ensureFileIsInDownloadCache(fileID);
        }
    }

    public static void doWithPrefix(String prefix, Runnable runnable) {
        try {
            prefixThreadLocal.set(prefix);
            runnable.run();
        }
        finally {
            prefixThreadLocal.remove();
        }
    }

    @Override
    public File getFile(FileID fileID) throws ServerNotAvailableException, EXServerException, LoginCanceledException, UnknownServerException, ExPrematureEndOfTransfer {
        if (this.hasFile(fileID) || this.hasFileInTemporaryStorage(fileID)) {
            try {
                SessionTempDirectoryManager.SessionTempDirectory newEmptyTempDirectory;
                File copy;
                boolean success;
                String prefix;
                FileMetaInformationItem metaInformation = this.getFileMetaInformation(fileID);
                String fileName = "unknown.tmp";
                if (metaInformation.getOriginalFileName() != null) {
                    fileName = FileHelper.convertStringToPortableFileName((String)metaInformation.getOriginalFileName());
                }
                if ((prefix = prefixThreadLocal.get()) != null) {
                    fileName = String.valueOf(prefix) + fileName;
                }
                return (success = this.getFile(fileID, copy = new File((File)(newEmptyTempDirectory = SessionTempDirectoryManager.createSessionTempSubDirectory((String)"file-archive-")), fileName))) ? copy : null;
            }
            catch (JvmExternalResourceInteractionException e) {
                logger.error("Could not create a temporary file.", (Throwable)e);
                return null;
            }
        }
        return null;
    }

    private boolean getFile(FileID fileID, File targetFile) throws ServerNotAvailableException, EXServerException, LoginCanceledException, UnknownServerException, ExPrematureEndOfTransfer {
        File cacheFile = null;
        if (this.hasFile(fileID)) {
            cacheFile = this.ensureFileIsInDownloadCache(fileID);
        } else if (this.hasFileInTemporaryStorage(fileID)) {
            cacheFile = this.getFileInTemporaryStorageForFileReceipt(fileID);
        }
        if (cacheFile != null) {
            try {
                DataCopyHelper.copyFile((File)cacheFile, (File)targetFile);
                return true;
            }
            catch (JvmExternalResourceInteractionException e) {
                logger.error("Could not copy a file from the cache to the temporary location.", (Throwable)e);
                return false;
            }
        }
        return false;
    }

    private File ensureFileIsInDownloadCache(FileID fileID) throws ServerNotAvailableException, EXServerException, LoginCanceledException, UnknownServerException, ExPrematureEndOfTransfer {
        File cacheFile = null;
        if (this.localFilesThatCouldNotBeCopied.contains(fileID)) {
            cacheFile = this.getFileInTemporaryStorageForFileReceipt(fileID);
            if (!cacheFile.exists()) {
                logger.error("Local file that could not yet be copied into the upload area is no longer in temporary storage for file receipt (File ID: " + fileID + ")");
                cacheFile = null;
            }
        } else {
            cacheFile = this.getFileInDirectoryForDownloadCacheAndFilesToUpload(fileID);
            if (!cacheFile.exists()) {
                this.projectAgent.getFrameServerProxy().downloadFile(fileID, cacheFile);
                if (!cacheFile.exists()) {
                    logger.warn("File " + fileID.getFileUID() + " could not be downloaded from the server.");
                    cacheFile = null;
                }
            }
        }
        return cacheFile;
    }

    @Override
    public ImageData getImageFromFile(FileID fileId, String errorMessage) {
        if (fileId == null || fileId.equals(FileID.NO_FILE)) {
            return null;
        }
        try {
            File iconFile = null;
            if (this.hasFile(fileId)) {
                iconFile = this.ensureFileIsInDownloadCache(fileId);
            } else if (this.hasFileInTemporaryStorage(fileId)) {
                iconFile = this.getFileInTemporaryStorageForFileReceipt(fileId);
            }
            if (iconFile != null) {
                return new ImageData(iconFile.getAbsolutePath());
            }
            return null;
        }
        catch (ServerNotAvailableException e) {
            logger.error(errorMessage, (Throwable)e);
        }
        catch (EXServerException e) {
            logger.error(errorMessage, (Throwable)e);
        }
        catch (LoginCanceledException e) {
            logger.error(errorMessage, (Throwable)e);
        }
        catch (UnknownServerException e) {
            logger.error(errorMessage, (Throwable)e);
        }
        catch (ExPrematureEndOfTransfer e) {
            logger.error(errorMessage, (Throwable)e);
        }
        catch (SWTException e) {
            logger.error(errorMessage, (Throwable)e);
        }
        return null;
    }

    @Override
    public void initializeBeforePermissionsCheck(IFrameDataManagerAdministrator administrator, ServerDataContainer serverDataContainer) throws EXCorruptProjectData {
    }

    @Override
    public void initializeAfterPermissionsCheck(IFrameDataManagerAdministrator administrator, ServerDataContainer serverDataContainer) throws EXCorruptProjectData {
        this.metaInformationOfGlobalFiles.clear();
        for (EOFileMetaInformation fileMetaInformationItemAsEO : serverDataContainer.getFileMetaInformation()) {
            FileMetaInformationItem fileMetaInformationItem = new FileMetaInformationItem(fileMetaInformationItemAsEO);
            this.metaInformationOfGlobalFiles.put(fileMetaInformationItem.getFileID(), fileMetaInformationItem);
        }
        try {
            this.readModifications();
        }
        catch (Exception e) {
            logger.error("could not execute", (Throwable)e);
        }
    }

    @Override
    public void finishInitialization(IFrameDataManagerAdministrator administrator, ServerDataContainer serverDataContainer) {
    }

    @Override
    public boolean hasLocalModifications() {
        for (Map.Entry<FileID, Integer> referenceCount : this.referenceCountForLocalFiles.entrySet()) {
            if (referenceCount.getValue() <= 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public void discardLocalModifications() {
        this.clearLocalFiles();
        this.dispose();
        this.writeModifications();
    }

    private void clearLocalFiles() {
        HashMap<FileID, Integer> referenceCountForLocalFiles_tempCopy = new HashMap<FileID, Integer>(this.referenceCountForLocalFiles);
        for (Map.Entry fileIDAndReferenceCount : referenceCountForLocalFiles_tempCopy.entrySet()) {
            FileID fileID = (FileID)fileIDAndReferenceCount.getKey();
            this.referenceCountForLocalFiles.remove(fileID);
            this.deleteLocalFileFromUploadArea(fileID);
            if (this.filesInTemporaryStorageForFileReceipt.contains(fileID)) continue;
            this.metaInformationOfLocalAndTemporaryFiles.remove(fileID);
        }
    }

    private EOFileModification getLocalModifications_internal(boolean uploadFilesAndInsertTransferIDs, boolean considerNonReferencedLocalFiles) throws ServerNotAvailableException, EXServerException, LoginCanceledException, UnknownServerException, ExPrematureEndOfTransfer {
        EOFileModification modifications = new EOFileModification();
        Iterator<String> transferIDIterator = null;
        if (uploadFilesAndInsertTransferIDs) {
            ArrayList<File> filesToUpload = new ArrayList<File>(this.referenceCountForLocalFiles.size());
            for (Map.Entry<FileID, Integer> entry : this.referenceCountForLocalFiles.entrySet()) {
                if (!considerNonReferencedLocalFiles && entry.getValue() <= 0) continue;
                filesToUpload.add(this.getFileInDirectoryForDownloadCacheAndFilesToUpload(entry.getKey()));
            }
            List<String> transferIDs = this.projectAgent.getFrameServerProxy().uploadFiles(filesToUpload);
            transferIDIterator = transferIDs.iterator();
        }
        for (Map.Entry<FileID, Integer> entry : this.referenceCountForLocalFiles.entrySet()) {
            if (!considerNonReferencedLocalFiles && entry.getValue() <= 0) continue;
            modifications.addFileModification(FilesManager.convertIntoEncodableObject(this.metaInformationOfLocalAndTemporaryFiles.get(entry.getKey())), entry.getValue().intValue(), uploadFilesAndInsertTransferIDs ? transferIDIterator.next() : null);
        }
        return modifications;
    }

    private void writeModifications() {
        this.modificationFileAccessor.write((IFileContentProviderForXMLFiles)new IFileContentProviderForXMLFiles<EOFileModification>(){

            public EOFileModification getFileContent() {
                try {
                    return FilesManager.this.getLocalModifications_internal(false, true);
                }
                catch (ServerNotAvailableException serverNotAvailableException) {
                }
                catch (EXServerException eXServerException) {
                }
                catch (LoginCanceledException loginCanceledException) {
                }
                catch (UnknownServerException unknownServerException) {
                }
                catch (ExPrematureEndOfTransfer exPrematureEndOfTransfer) {
                    // empty catch block
                }
                return null;
            }
        });
    }

    private void readModifications() throws Exception {
        this.metaInformationOfLocalAndTemporaryFiles.keySet().retainAll(this.filesInTemporaryStorageForFileReceipt);
        this.referenceCountForLocalFiles.clear();
        EOFileModification modifications = (EOFileModification)this.modificationFileAccessor.read();
        if (modifications != null) {
            int index = modifications.getNumberOfEntries() - 1;
            while (index >= 0) {
                EOFileMetaInformation metaInformation_asEO = modifications.getFileMetaInformation(index);
                FileID fileID = new FileID(metaInformation_asEO.getFileUID());
                FileMetaInformationItem metaInformation = new FileMetaInformationItem(metaInformation_asEO);
                int referenceCount = modifications.getReferenceCount(index);
                this.metaInformationOfLocalAndTemporaryFiles.put(fileID, metaInformation);
                this.referenceCountForLocalFiles.put(fileID, referenceCount);
                --index;
            }
        }
    }

    @Override
    public EOFileModification getLocalModificationsForCommit() throws ServerNotAvailableException, EXServerException, LoginCanceledException, UnknownServerException, ExPrematureEndOfTransfer {
        return this.getLocalModifications_internal(true, false);
    }

    @Override
    public void dataCommitted(EOFileModification committedModifications) {
        int index = committedModifications.getNumberOfEntries() - 1;
        while (index >= 0) {
            EOFileMetaInformation metaInformation_asEO = committedModifications.getFileMetaInformation(index);
            FileID fileID = new FileID(metaInformation_asEO.getFileUID());
            if (this.filesInTemporaryStorageForFileReceipt.contains(fileID)) {
                this.removeFileFromTemporaryStorage(fileID);
            } else {
                this.metaInformationOfLocalAndTemporaryFiles.remove(fileID);
            }
            this.referenceCountForLocalFiles.remove(fileID);
            this.metaInformationOfGlobalFiles.put(fileID, new FileMetaInformationItem(metaInformation_asEO));
            --index;
        }
        this.clearLocalFiles();
        this.writeModifications();
    }

    @Override
    public void asynchronousUpdateReceived(EOFileModification modifications) {
        int index = modifications.getNumberOfEntries() - 1;
        while (index >= 0) {
            EOFileMetaInformation metaInformation_asEO = modifications.getFileMetaInformation(index);
            FileID fileID = new FileID(metaInformation_asEO.getFileUID());
            this.metaInformationOfGlobalFiles.put(fileID, new FileMetaInformationItem(metaInformation_asEO));
            --index;
        }
    }

    @Override
    public Collection<EOFileMetaInformation> doExportFiles(File targetDirectory) throws ServerNotAvailableException, EXServerException, LoginCanceledException, UnknownServerException, ExPrematureEndOfTransfer {
        ArrayList<FileID> allFilesForExport = new ArrayList<FileID>();
        allFilesForExport.addAll(this.metaInformationOfGlobalFiles.keySet());
        for (Map.Entry<FileID, Integer> referenceCount : this.referenceCountForLocalFiles.entrySet()) {
            if (referenceCount.getValue() <= 0) continue;
            allFilesForExport.add(referenceCount.getKey());
        }
        return this.doExportFiles(allFilesForExport, targetDirectory);
    }

    @Override
    public Collection<EOFileMetaInformation> doExportFiles(Collection<FileID> filesToExport, File targetDirectory) throws ServerNotAvailableException, EXServerException, LoginCanceledException, UnknownServerException, ExPrematureEndOfTransfer {
        ArrayList<EOFileMetaInformation> metaInformationCollectionForExport = new ArrayList<EOFileMetaInformation>();
        for (FileID fileID : filesToExport) {
            FileMetaInformationItem metaInformation = this.getFileMetaInformation(fileID);
            try {
                boolean success = this.getFile(fileID, new File(targetDirectory, FilesManager.getFileNameForFileID(fileID)));
                if (!success) continue;
                metaInformationCollectionForExport.add(FilesManager.convertIntoEncodableObject(metaInformation));
            }
            catch (Exception e) {
                logger.error("Exception when retrieving file for export", (Throwable)e);
            }
        }
        return metaInformationCollectionForExport;
    }

    public static File getFileInExport(FileID fileID, File exportDirectory) {
        File file = new File(exportDirectory, FilesManager.getFileNameForFileID(fileID));
        if (file.exists()) {
            return file;
        }
        return null;
    }

    private static EOFileMetaInformation convertIntoEncodableObject(FileMetaInformationItem fileMetaInformationItem) {
        return new EOFileMetaInformation(fileMetaInformationItem.getFileID().getFileUID(), fileMetaInformationItem.getProjectUID(), fileMetaInformationItem.getCommitCount(), fileMetaInformationItem.getOriginalFileName(), fileMetaInformationItem.getCreationDate());
    }

    public void dispose() {
        try {
            FileHelper.deleteExistingFileOrDirectory((File)this.getTemporaryStorageForFileReceipt());
        }
        catch (JvmExternalResourceInteractionException e) {
            logger.error("Error deleting temporary files.", (Throwable)e);
        }
    }

    private File getFileInTemporaryStorageForFileReceipt(FileID fileID) {
        File temporaryStorageForFileReceipt = this.getTemporaryStorageForFileReceipt();
        File tempFile = new File(temporaryStorageForFileReceipt, FilesManager.getFileNameForFileID(fileID));
        return tempFile;
    }

    private File getFileInDirectoryForDownloadCacheAndFilesToUpload(FileID fileID) {
        File downloadAndUploadDirectory = this.getDirectoryForDownloadCacheAndFilesToUpload();
        File cacheFile = new File(downloadAndUploadDirectory, FilesManager.getFileNameForFileID(fileID));
        return cacheFile;
    }

    public static String getFileNameForFileID(FileID fileID) {
        return fileID.getFileUID();
    }

    private File getDirectoryForDownloadCacheAndFilesToUpload() {
        File dir = new File(this.getRootDirectoryForFiles(), "cache");
        if (!dir.exists()) {
            dir.mkdir();
        }
        return dir;
    }

    private File getTemporaryStorageForFileReceipt() {
        File dir = new File(this.getRootDirectoryForFiles(), "tmp");
        if (!dir.exists()) {
            dir.mkdir();
        }
        return dir;
    }

    private File getRootDirectoryForFiles() {
        return this.projectAgent.getProjectSubFolder(ProjectAgent.PROJECT_SUBFOLDER_FILES);
    }

    @Override
    public String getLocalizedManagerName() {
        return Messages.getString("FilesForDataTypesManager.files_manager");
    }

    @Override
    public boolean handlesDataType(String cockpitDataTypeID) {
        return false;
    }

    @Override
    public boolean itemExistsOnServer(String cockpitDataUID) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ICockpitProjectData getCockpitProjectData(String cockpitDataUID) {
        return null;
    }

    @Override
    public IDataLabelProvider getDataLabelProvider() {
        return null;
    }

    @Override
    public ILocalModificationContainer[] getLocalModifications(boolean displayableOnly) {
        return null;
    }

    @Override
    public Map<IAttributeTypeDataType, Collection<IAttribute>> getAllAttributesOfType(Class<? extends IAttributeTypeDataType> clazz) {
        return null;
    }

    @Override
    public Collection<IAttributeType> getAllAttributeTypes(Class<? extends IAttributeTypeDataType> dataTypeClass) {
        return null;
    }

    @Override
    public void requestDataDeletePermission(IAttributeOwner data, ILocksAndPermissionsTransactionController transactionController) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void deleteData(ILocksAndPermissionsTransactionController transactionController) throws EXNoPermission {
        throw new UnsupportedOperationException();
    }

    @Override
    public void applySynchronousModification(EOFrameDataModification<? extends EOCockpitProjectData> frameDataModification) {
    }

    @Override
    public void applyAsynchronousModifications(EOFrameDataModification<? extends EOCockpitProjectData> frameDataModification) {
    }

    @Override
    public Collection<? extends IAttributeOwner> getData() {
        return null;
    }

    @Override
    public IAttributeOwner getParent(IAttributeOwner child) {
        return null;
    }

    @Override
    public Collection<? extends IAttributeOwner> getChildren(IAttributeOwner parent) {
        return null;
    }

    @Override
    public void requestAddPermission(String name, ObjectTypeCategoryID objectTypeCategoryID, Collection<IAttribute> attributes, IAttributeOwner parent, boolean forImport, ILocksAndPermissionsTransactionController transactionController) {
    }

    @Override
    public Collection<? extends IAttributeOwner> addData(ILocksAndPermissionsTransactionController transactionController) throws EXNoPermission {
        return null;
    }

    @Override
    public boolean managesChildrenForType(String dataTypeID) {
        return false;
    }

    @Override
    public void requestMovePermission(IAttributeOwner dataToMove, IAttributeOwner newParent, ILocksAndPermissionsTransactionController transactionController) {
    }

    @Override
    public void moveData(ILocksAndPermissionsTransactionController transactionController) throws EXNoPermission {
    }

    @Override
    public void dataModified(IAttributeOwner attributeOwner) {
    }

    @Override
    public List<IFrameDataRW> importDataFromEO(List<EOFrameData> eos) {
        return null;
    }

    @Override
    public boolean isLocallyModified(String dataUID) {
        return false;
    }

    @Override
    public boolean isLocallyAdded(String dataUID) {
        return false;
    }

    @Override
    public IFrameDataFactory getDataFactory() {
        return null;
    }

    @Override
    public IAttributeOwner getServerState(String dataUID) {
        return null;
    }

    @Override
    public void visitAllAttributeOwnerRWs(IAttributeOwnerRW.IVisitor visitor) {
    }

    @Override
    public IAttributeTypesProvider getAttributeTypesProvider() {
        return null;
    }

    private class XMLFileAccessTransactionListener
    implements IModificationAccessTransactionListeners {
        private XMLFileAccessTransactionListener() {
        }

        public void xmlFileAccessTransactionStarted() {
        }

        public Throwable canXMLFileAccessTransactionBeSaved() {
            Throwable failure = null;
            Iterator localFilesStillToBeCopiedIterator = FilesManager.this.localFilesThatCouldNotBeCopied.iterator();
            while (localFilesStillToBeCopiedIterator.hasNext()) {
                FileID localFileStillToBeCopied = (FileID)localFilesStillToBeCopiedIterator.next();
                failure = FilesManager.this.copyLocalFileIntoUploadArea(localFileStillToBeCopied);
                if (failure != null) break;
                localFilesStillToBeCopiedIterator.remove();
                FilesManager.this.deleteTemporaryFileFromTemporaryStorage(localFileStillToBeCopied);
            }
            return failure;
        }

        public void xmlFileAccessTransactionCompleted(boolean successful) {
        }
    }
}

