/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.core.constructionelements;

import com.arcway.cockpit.frame.client.global.EXConstructionElementTypeUnknown;
import com.arcway.cockpit.frame.client.global.ExtensionMgr;
import com.arcway.cockpit.frame.client.project.core.constructionelements.ConstructionElementTypeDescription;
import com.arcway.cockpit.frame.client.project.core.constructionelements.IConstructionElementCategory;
import com.arcway.cockpit.frame.client.project.core.constructionelements.IConstructionElementTypeDescription;

public class PlanElementConstructionElementAssignment
implements IConstructionElementCategory {
    private final String planElementTypeID;
    private final String constructionElementTypeID;
    private final String categoryID;

    public PlanElementConstructionElementAssignment(String planElementTypeID, String constructionElementTypeID, String categoryID) {
        assert (planElementTypeID != null && constructionElementTypeID != null);
        this.planElementTypeID = planElementTypeID;
        this.constructionElementTypeID = constructionElementTypeID;
        this.categoryID = categoryID;
    }

    public String getPlanElementTypeID() {
        return this.planElementTypeID;
    }

    public String getConstructionElementTypeID() {
        return this.constructionElementTypeID;
    }

    public String getResultingCategoryID() {
        String resultingCategoryID;
        try {
            IConstructionElementTypeDescription constructionElementTypeDescription = this.getConstructionElementTypeDescription();
            resultingCategoryID = constructionElementTypeDescription.isOfCategoryAlwaysUnique() || constructionElementTypeDescription.isOfCategoryNeverUnique() || !ConstructionElementTypeDescription.isValidCategoryID(this.categoryID) ? constructionElementTypeDescription.getCategoryID() : this.categoryID;
        }
        catch (EXConstructionElementTypeUnknown e) {
            resultingCategoryID = "never unique";
        }
        return resultingCategoryID;
    }

    @Override
    public final boolean isOfCategoryNeverUnique() {
        return "never unique".equals(this.getResultingCategoryID());
    }

    @Override
    public final boolean isOfCategoryAlwaysUnique() {
        return "always unique".equals(this.getResultingCategoryID());
    }

    @Override
    public final boolean isOfCategoryPreferredUnique() {
        return "preferred unique".equals(this.getResultingCategoryID());
    }

    @Override
    public final boolean isOfCategoryPreferredNotUnique() {
        return "preferred not unique".equals(this.getResultingCategoryID());
    }

    private IConstructionElementTypeDescription getConstructionElementTypeDescription() throws EXConstructionElementTypeUnknown {
        return ExtensionMgr.getDefault().getConstructionElementTypeDescriptionForType(this.constructionElementTypeID);
    }
}

