/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.core.categories;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.ObjectTypeCategoryID;
import com.arcway.cockpit.client.base.interfaces.frame.propertychanges.IPropertyChanges;
import com.arcway.cockpit.client.base.interfaces.frame.propertychanges.IPropertyChangesListener;
import com.arcway.cockpit.cockpitlib.client.gui.DeferredRefresher;
import com.arcway.cockpit.cockpitlib.client.gui.IRefreshableDisplay;
import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.ProjectAgent;
import com.arcway.cockpit.frame.client.project.core.categories.ObjectTypeCategory;
import com.arcway.cockpit.frame.client.project.core.files.FileID;
import com.arcway.cockpit.frame.client.project.modules.IProjectCloseListener;
import com.arcway.lib.eclipse.resources.DecoratedImage;
import com.arcway.lib.graphics.Alignment;
import com.arcway.lib.java.collectionmaps.MapMap;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.resource.FileResource;
import com.arcway.lib.resource.IStreamResource;
import de.plans.lib.resources.IIconResource;
import de.plans.lib.resources.ImageIconResource;
import de.plans.lib.resources.StreamIconResource;
import de.plans.psc.client.communication.ExPrematureEndOfTransfer;
import de.plans.psc.client.communication.LoginCanceledException;
import de.plans.psc.client.communication.ServerNotAvailableException;
import de.plans.psc.client.communication.UnknownServerException;
import de.plans.psc.shared.serverexceptions.EXServerException;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.widgets.Display;

public class ObjectTypeCategoryIconProvider
implements IProjectCloseListener,
ProjectMgr.IProjectClosedListener {
    private static final ILogger LOGGER = Logger.getLogger(ObjectTypeCategoryIconProvider.class);
    private final MapMap<String, ObjectTypeCategoryID, StreamIconResourceWithImage> map_projectUID_category_iconStreamResourceWithImage = new MapMap();
    private final MapMap<String, ObjectTypeCategoryID, Map<Image, ImageIconResource>> map_projectUID_category_decoratorToIconStreamResource = new MapMap();
    private final Set<String> projectsAtWhichPropertyChangesListenersAreRegistered = new HashSet<String>();
    private DeferredRefresher disposeDelayer;
    private final Collection<StreamIconResourceWithImage> streamIconResourcesToBeDisposed = new ArrayList<StreamIconResourceWithImage>(30);
    private final Collection<ImageIconResource> imageIconResourcesToBeDisposed = new ArrayList<ImageIconResource>(30);
    private static ObjectTypeCategoryIconProvider singletonInstance = null;
    private final IPropertyChangesListener PROPERTY_CHANGES_LISTENER_PRE = new IPropertyChangesListener(){

        public void modelRefreshed(IPropertyChanges<?> changes, Class<?> clazz, String projectUID) {
            ObjectTypeCategoryIconProvider.this.markItemsToBeDisposed(projectUID);
        }
    };
    private final IPropertyChangesListener PROPERTY_CHANGES_LISTENER_POST = new IPropertyChangesListener(){

        public void modelRefreshed(IPropertyChanges<?> changes, Class<?> clazz, String projectUID) {
            ObjectTypeCategoryIconProvider.this.disposeItemsToBeDiposed();
        }
    };

    public static ObjectTypeCategoryIconProvider getDefault() {
        if (singletonInstance == null) {
            singletonInstance = new ObjectTypeCategoryIconProvider();
        }
        return singletonInstance;
    }

    private ObjectTypeCategoryIconProvider() {
        ProjectMgr.getProjectMgr().addProjectClosedListener(this);
        this.startDisposeDelayer();
    }

    public Image getObjectTypeCategoryIcon(String projectUID, ObjectTypeCategoryID categoryID) {
        IIconResource iconResource = this.findCategoryIcon(projectUID, categoryID);
        return iconResource != null ? iconResource.getImage() : null;
    }

    public IIconResource getObjectTypeCategoryIconResource(String projectUID, ObjectTypeCategoryID categoryID) {
        return this.findCategoryIcon(projectUID, categoryID);
    }

    private IIconResource findCategoryIcon(String projectUID, ObjectTypeCategoryID categoryID) {
        StreamIconResourceWithImage icon = (StreamIconResourceWithImage)((Object)this.map_projectUID_category_iconStreamResourceWithImage.get((Object)projectUID, (Object)categoryID));
        if (icon == null) {
            icon = this.loadCategoryIcon(projectUID, categoryID);
            this.map_projectUID_category_iconStreamResourceWithImage.put((Object)projectUID, (Object)categoryID, (Object)icon);
        }
        return icon;
    }

    public Image getDecoratedObjectTypeCategoryIcon(String projectUID, ObjectTypeCategoryID categoryID, IIconResource decorator) {
        IIconResource decoratedIconResource = this.findDecoratedCategoryIcon(projectUID, categoryID, decorator);
        return decoratedIconResource != null ? decoratedIconResource.getImage() : null;
    }

    public IIconResource getDecoratedObjectTypeCategoryIconResource(String projectUID, ObjectTypeCategoryID categoryID, IIconResource decorator) {
        return this.findDecoratedCategoryIcon(projectUID, categoryID, decorator);
    }

    private IIconResource findDecoratedCategoryIcon(String projectUID, ObjectTypeCategoryID categoryID, IIconResource decorator) {
        ImageIconResource iconResource;
        HashMap<Image, ImageIconResource> map_decorator_iconStreamResource = (HashMap<Image, ImageIconResource>)this.map_projectUID_category_decoratorToIconStreamResource.get((Object)projectUID, (Object)categoryID);
        if (map_decorator_iconStreamResource == null) {
            map_decorator_iconStreamResource = new HashMap<Image, ImageIconResource>();
            this.map_projectUID_category_decoratorToIconStreamResource.put((Object)projectUID, (Object)categoryID, map_decorator_iconStreamResource);
        }
        if ((iconResource = (ImageIconResource)map_decorator_iconStreamResource.get(decorator.getImage())) == null) {
            iconResource = this.loadDecoratedCategoryIcon(projectUID, categoryID, decorator);
            map_decorator_iconStreamResource.put(decorator.getImage(), iconResource);
        }
        return iconResource;
    }

    private StreamIconResourceWithImage loadCategoryIcon(String projectUID, ObjectTypeCategoryID categoryID) {
        ProjectAgent projectAgent;
        ObjectTypeCategory category;
        FileID iconFileID;
        StreamIconResourceWithImage loadedCategoryIcon = null;
        if (categoryID != null && !(iconFileID = (category = (projectAgent = ProjectMgr.getProjectMgr().getProjectAgent(projectUID)).getObjectTypeCategoriesManager().getCategory(categoryID)).getIcon()).equals(FileID.NO_FILE)) {
            try {
                File iconFile = projectAgent.getFilesManager().getFile(iconFileID);
                ImageData iconImageData = new ImageData(iconFile.getAbsolutePath());
                Image iconImage = new Image((Device)Display.getCurrent(), iconImageData);
                loadedCategoryIcon = new StreamIconResourceWithImage(iconFile, iconImage);
                this.registerChangesListenerForProject(projectAgent);
            }
            catch (ServerNotAvailableException e) {
                ObjectTypeCategoryIconProvider.handleCategoryIconNotFound(category, e);
            }
            catch (EXServerException e) {
                ObjectTypeCategoryIconProvider.handleCategoryIconNotFound(category, e);
            }
            catch (LoginCanceledException e) {
                ObjectTypeCategoryIconProvider.handleCategoryIconNotFound(category, e);
            }
            catch (UnknownServerException e) {
                ObjectTypeCategoryIconProvider.handleCategoryIconNotFound(category, e);
            }
            catch (ExPrematureEndOfTransfer e) {
                ObjectTypeCategoryIconProvider.handleCategoryIconNotFound(category, e);
            }
        }
        return loadedCategoryIcon;
    }

    private ImageIconResource loadDecoratedCategoryIcon(String projectUID, ObjectTypeCategoryID categoryID, IIconResource decorator) {
        ImageIconResource decoratedCategoryImageIconResource = null;
        Image objectTypeCategoryIcon = this.getObjectTypeCategoryIcon(projectUID, categoryID);
        if (objectTypeCategoryIcon != null) {
            Image decoratorImage = decorator.getImage();
            DecoratedImage decoratedCategoryImageSpec = new DecoratedImage(objectTypeCategoryIcon, decoratorImage, new Alignment(4, 32));
            Image decoratedCategoryImage = DecoratedImage.createImage((Display)Display.getCurrent(), (DecoratedImage)decoratedCategoryImageSpec);
            decoratedCategoryImageIconResource = new ImageIconResource("Decorated Category Image", decoratedCategoryImage);
        }
        return decoratedCategoryImageIconResource;
    }

    private static void handleCategoryIconNotFound(ObjectTypeCategory category, Throwable e) {
        LOGGER.error("Error retrieving Object Type Category Icon for category: " + category.getDisplayName(), e);
    }

    private void registerChangesListenerForProject(ProjectAgent projectAgent) {
        if (!this.projectsAtWhichPropertyChangesListenersAreRegistered.contains(projectAgent.getProjectUID())) {
            projectAgent.addProjectCloseListener(this);
            projectAgent.getPropertyChangesListenerManager().register(this.PROPERTY_CHANGES_LISTENER_PRE, ObjectTypeCategory.class, -5);
            projectAgent.getPropertyChangesListenerManager().register(this.PROPERTY_CHANGES_LISTENER_POST, ObjectTypeCategory.class, 5);
            this.projectsAtWhichPropertyChangesListenersAreRegistered.add(projectAgent.getProjectUID());
        }
    }

    @Override
    public void closeProject(IFrameProjectAgent projectAgent) {
        projectAgent.getPropertyChangesListenerManager().deregister(this.PROPERTY_CHANGES_LISTENER_PRE);
        projectAgent.getPropertyChangesListenerManager().deregister(this.PROPERTY_CHANGES_LISTENER_POST);
        this.projectsAtWhichPropertyChangesListenersAreRegistered.remove(projectAgent.getProjectUID());
    }

    @Override
    public void projectClosed(String projectUID) {
        this.markItemsToBeDisposed(projectUID);
        this.disposeItemsToBeDiposed();
    }

    private synchronized void markItemsToBeDisposed(String projectUID) {
        HashMap decoratedIconCacheForProject;
        HashMap iconCacheForProject = this.map_projectUID_category_iconStreamResourceWithImage.removeAll((Object)projectUID);
        if (iconCacheForProject != null) {
            for (StreamIconResourceWithImage image : iconCacheForProject.values()) {
                this.streamIconResourcesToBeDisposed.add(image);
            }
        }
        if ((decoratedIconCacheForProject = this.map_projectUID_category_decoratorToIconStreamResource.removeAll((Object)projectUID)) != null) {
            for (Map mapForCategory : decoratedIconCacheForProject.values()) {
                this.imageIconResourcesToBeDisposed.addAll(mapForCategory.values());
            }
        }
    }

    private void disposeItemsToBeDiposed() {
        this.disposeDelayer.scheduleDeferredRefresh();
    }

    private synchronized void actuallyDisposeItemsToBeDiposed() {
        for (StreamIconResourceWithImage streamIconResourceWithImage : this.streamIconResourcesToBeDisposed) {
            if (streamIconResourceWithImage == null) continue;
            streamIconResourceWithImage.getImage().dispose();
            streamIconResourceWithImage.getFile().delete();
        }
        this.streamIconResourcesToBeDisposed.clear();
        for (ImageIconResource imageIconResource : this.imageIconResourcesToBeDisposed) {
            if (imageIconResource == null) continue;
            imageIconResource.getImage().dispose();
        }
    }

    private void startDisposeDelayer() {
        final Display currentDisplay = Display.getCurrent();
        this.disposeDelayer = new DeferredRefresher(new IRefreshableDisplay(){

            public void refresh() {
                ObjectTypeCategoryIconProvider.this.actuallyDisposeItemsToBeDiposed();
            }

            public boolean isDisposed() {
                return false;
            }

            public Display getDisplay() {
                return currentDisplay;
            }
        }, 1000L, "Object Type Category Icon Cache Deferred Disposer");
        this.disposeDelayer.start();
    }

    private static class StreamIconResourceWithImage
    extends StreamIconResource {
        private final Image image;
        private final File file;

        public StreamIconResourceWithImage(File file, Image image) {
            super((IStreamResource)new FileResource(file));
            this.image = image;
            this.file = file;
        }

        public Image getImage() {
            return this.image;
        }

        File getFile() {
            return this.file;
        }
    }
}

