/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.core.categories;

import com.arcway.cockpit.client.base.datamanager.DataAccessAgent;
import com.arcway.cockpit.client.base.datamanager.IDataHandler_DataWithID;
import com.arcway.cockpit.client.base.datamanager.IObjectKey;
import com.arcway.cockpit.client.base.datamanager.Key_UID;
import com.arcway.cockpit.client.base.datamanager.PropertyChangesManager;
import com.arcway.cockpit.client.base.interfaces.frame.IProjectAgent;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttribute;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeOwner;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeType;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeTypeDataType;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IDataLabelProvider2;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.ObjectTypeCategoryID;
import com.arcway.cockpit.client.base.interfaces.frame.permissions.EXNoPermission;
import com.arcway.cockpit.frame.client.project.AbstractFrameDataManager;
import com.arcway.cockpit.frame.client.project.IFrameDataManager;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.Messages;
import com.arcway.cockpit.frame.client.project.core.categories.IObjectTypeCategoryModifier;
import com.arcway.cockpit.frame.client.project.core.categories.ObjectTypeCategory;
import com.arcway.cockpit.frame.client.project.core.framedata.IAttributeOwnerRW;
import com.arcway.cockpit.frame.client.project.core.framedata.IAttributeTypesProvider;
import com.arcway.cockpit.frame.client.project.core.framedata.IFrameDataRW;
import com.arcway.cockpit.frame.client.project.core.framedata.ModificationProblem;
import com.arcway.cockpit.frame.client.project.core.framedata.datamanager.IFrameDataFactory;
import com.arcway.cockpit.frame.client.project.core.framedata.transactionmanagement.ILocksAndPermissionsTransactionController;
import com.arcway.cockpit.frame.client.project.core.locking.EXNoLock;
import com.arcway.cockpit.frame.client.project.core.serverproxy.ServerDataContainer;
import com.arcway.cockpit.frame.shared.message.EOObjectTypeCategory;
import com.arcway.cockpit.frame.shared.message.MessageDataFactory;
import com.arcway.cockpit.frame.shared.message.genericframedata.EOFrameData;
import com.arcway.lib.java.Equals;
import com.arcway.lib.java.ObjectWrapper;
import com.arcway.lib.java.collections.IHasher_;
import de.plans.lib.xml.encoding.AbstractEncodableObjectFactory;
import de.plans.lib.xml.encoding.EOList;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;

public class ObjectTypeCategoriesManager
extends AbstractFrameDataManager<ObjectTypeCategory, EOObjectTypeCategory> {
    private static final String MODULE_ID = "object-type-categories";
    private IFrameProjectAgent projectAgent;
    private static IDataHandler_DataWithID<ObjectTypeCategory, String, String, String, EOObjectTypeCategory> dataHandler;
    private static IDataLabelProvider2<String> dataLabelProvider;

    public ObjectTypeCategory getCategory(ObjectTypeCategoryID categoryID) {
        return (ObjectTypeCategory)this.getItem("object-type-category", categoryID.getUID());
    }

    public Collection<ObjectTypeCategory> getAllCategoriesForObjectType(String typeID) {
        Collection allCategories = this.getAllItems("object-type-category");
        ArrayList<ObjectTypeCategory> categoriesForType = new ArrayList<ObjectTypeCategory>(allCategories.size());
        for (ObjectTypeCategory category : allCategories) {
            if (!category.getCockpitDataTypeID().equals(typeID)) continue;
            categoriesForType.add(category);
        }
        return categoriesForType;
    }

    public List<ObjectTypeCategory> getAllCategoriesForObjectTypeSorted(String typeID) {
        List categoriesForType = (List)this.getAllCategoriesForObjectType(typeID);
        Collections.sort(categoriesForType, new Comparator<ObjectTypeCategory>(){

            @Override
            public int compare(ObjectTypeCategory o1, ObjectTypeCategory o2) {
                return o1.getSortPosition() - o2.getSortPosition();
            }
        });
        return categoriesForType;
    }

    public ObjectTypeCategory getCategoryByHumanreadableID(String typeID, String humanreadableID) {
        for (ObjectTypeCategory categoryForType : this.getAllCategoriesForObjectType(typeID)) {
            if (!categoryForType.getHumanReadableID().equals(humanreadableID)) continue;
            return categoryForType;
        }
        return null;
    }

    public Collection<ObjectTypeCategory> getAllCategories() {
        return this.getAllItems("object-type-category");
    }

    public boolean hasObjectTypeCategories(String typeID) {
        Collection allCategories = this.getAllItems("object-type-category");
        for (ObjectTypeCategory category : allCategories) {
            if (!category.getCockpitDataTypeID().equals(typeID)) continue;
            return true;
        }
        return false;
    }

    public void construct(IFrameProjectAgent newProjectAgent) {
        this.projectAgent = newProjectAgent;
        PropertyChangesManager propertyChangesManager = new PropertyChangesManager();
        propertyChangesManager.construct(newProjectAgent.getPropertyChangesProviderManager(), newProjectAgent.getPropertyChangesListenerManager());
        super.init(newProjectAgent.getProjectUID(), (IProjectAgent)newProjectAgent, propertyChangesManager);
        super.construct((AbstractEncodableObjectFactory)MessageDataFactory.getInstance());
    }

    protected String getModuleID() {
        return MODULE_ID;
    }

    public String getDisplayNameForData() {
        return Messages.getString("ObjectTypeCategoriesManager.data.name");
    }

    public Image getImageForData() {
        return null;
    }

    protected Collection<String> getDataTypes() {
        return Collections.singleton("object-type-category");
    }

    protected IHasher_<? super String> getDataTypeIDHasher() {
        return IHasher_.EQUALS_HASHER;
    }

    protected String getDataTypeIDAsString(String dataTypeID) {
        return dataTypeID;
    }

    protected String getDataTypeIDFromString(String dataTypeIDAsString) {
        return dataTypeIDAsString;
    }

    protected boolean isDataTypeWithID(String dataTypeID) {
        return false;
    }

    protected IHasher_<? super String> getIDHasher() {
        return null;
    }

    protected IDataHandler_DataWithID<ObjectTypeCategory, String, String, String, EOObjectTypeCategory> createDataHandler() {
        if (dataHandler == null) {
            dataHandler = new IDataHandler_DataWithID<ObjectTypeCategory, String, String, String, EOObjectTypeCategory>(){

                public String getUIDForItem(ObjectTypeCategory item) {
                    return item.getObjectTypeCategoryID().getUID();
                }

                public String getUIDStringForItem(ObjectTypeCategory item) {
                    return this.getUIDForItem(item);
                }

                public String getUIDStringForUID(String itemID) {
                    return itemID;
                }

                public IObjectKey getObjectKeyForUID(String itemID) {
                    return new Key_UID(itemID);
                }

                public String getDataTypeForItem(ObjectTypeCategory item) {
                    return "object-type-category";
                }

                public Class<? extends ObjectTypeCategory> getClassForDataTypeID(String dataTypeID) {
                    return ObjectTypeCategory.class;
                }

                public String getIDForItem(ObjectTypeCategory item) {
                    return null;
                }

                public void setInitialModificationAttributes(ObjectTypeCategory item, long creationTimestamp, String creator) {
                    item.setModTime(new Timestamp(creationTimestamp));
                    item.setModCount(0);
                }

                public void setNewModificationAttributes(ObjectTypeCategory item, long modificationTimestamp, String modifier) {
                    item.setModTime(new Timestamp(modificationTimestamp));
                }

                public void copyAllAttributes(ObjectTypeCategory source, ObjectTypeCategory target) {
                    target.copyAllAttributes(source);
                }

                public ObjectTypeCategory getCloneOfObject(ObjectTypeCategory item) {
                    return new ObjectTypeCategory(item);
                }

                public boolean mergingHasEffect(ObjectTypeCategory baseItem, ObjectTypeCategory itemToMerge) {
                    return !baseItem.getModTime().after(itemToMerge.getModTime());
                }

                public ObjectTypeCategory merge(ObjectTypeCategory baseItem, ObjectTypeCategory itemToMerge) {
                    if (this.mergingHasEffect(baseItem, itemToMerge)) {
                        ObjectTypeCategory mergeResult = this.getCloneOfObject(baseItem);
                        mergeResult.copyAllAttributes(itemToMerge);
                        return mergeResult;
                    }
                    return baseItem;
                }

                public EOObjectTypeCategory getEOForItem(ObjectTypeCategory item) {
                    return item.createEncodableObject();
                }

                public ObjectTypeCategory getItemForEO(EOObjectTypeCategory eoItem) {
                    return ObjectTypeCategory.createObjectTypeCategory(eoItem);
                }
            };
        }
        return dataHandler;
    }

    public IDataLabelProvider2<String> getDataLabelProvider2() {
        if (dataLabelProvider == null) {
            dataLabelProvider = new IDataLabelProvider2<String>(){

                public Image getImageForType(String dataType) {
                    return null;
                }

                public String getDisplayNameForType(String dataType) {
                    return Messages.getString("ObjectTypeCategoriesManager.type-objecttypecategory.name");
                }

                public Image getImageForItem(Object item) {
                    return null;
                }

                public String getLabelForItem(Object item) {
                    return ((ObjectTypeCategory)item).getDisplayName();
                }
            };
        }
        return dataLabelProvider;
    }

    protected DataAccessAgent.IModificationDiscardCallback<ObjectTypeCategory, String> createModificationCallback() {
        return new DataAccessAgent.IModificationDiscardCallback<ObjectTypeCategory, String>(){

            public void addedItemsToBeCleared(Collection<ObjectTypeCategory> addedItems) {
            }

            public void addedItemsThatHaveBeenCommitted(Collection<ObjectTypeCategory> addedItems) {
            }

            public void asynchronousUpdateHook_post_addedItems(String dataTypeId, Collection<ObjectTypeCategory> addedItems) {
            }

            public void updatedItemsToBeCleared(Collection<ObjectTypeCategory> updatedItems) {
            }

            public void updatedItemsThatHaveBeenCommitted(Collection<ObjectTypeCategory> updatedItems) {
            }

            public void asynchronousUpdateHook_post_modifiedItems(String dataTypeId, Collection<ObjectTypeCategory> updatedItems) {
            }

            public void removedItemsToBeCleared(Collection<ObjectTypeCategory> removedItems) {
            }

            public void removedItemsThatHaveBeenCommitted(Collection<ObjectTypeCategory> removedItems) {
            }

            public void asynchronousUpdateHook_pre_removedItems(String dataTypeId, Collection<ObjectTypeCategory> removedItems) {
            }
        };
    }

    protected String getRequestGroupID() {
        return "frame.objecttypecategories";
    }

    @Override
    protected Image getImage() {
        return null;
    }

    @Override
    public String getLocalizedManagerName() {
        return Messages.getString("ObjectTypeCategoriesManager.name");
    }

    @Override
    protected EOList<? extends EOObjectTypeCategory>[] getRelevantServerDataLists(ServerDataContainer serverDataContainer) {
        EOList<EOObjectTypeCategory> objectTypeCategories = serverDataContainer.getObjectTypeCategories();
        if (objectTypeCategories != null) {
            return new EOList[]{objectTypeCategories};
        }
        return new EOList[0];
    }

    protected void removeNonDisplayableModifications(Collection<ObjectTypeCategory> items) {
        items.clear();
    }

    protected void callbackItemPropertiesModified(ObjectTypeCategory item, boolean guiUpdateRequired) {
    }

    protected void callbackItemRemoved(ObjectTypeCategory item) {
    }

    protected void callbackPrepareAddedAndUpdatedItemsForCommit(String dataTypeID, List<EOObjectTypeCategory> addedItems, List<EOObjectTypeCategory> updatedItems) {
    }

    protected void callbackCommitCompleted() {
    }

    protected void callbackAsynchronousUpdateStarted() {
    }

    protected void callbackAsynchronousUpdateCompleted() {
    }

    @Override
    public Map<IAttributeTypeDataType, Collection<IAttribute>> getAllAttributesOfType(Class<? extends IAttributeTypeDataType> dataTypeClazz) {
        return null;
    }

    @Override
    public Collection<IAttributeType> getAllAttributeTypes(Class<? extends IAttributeTypeDataType> dataTypeClass) {
        return null;
    }

    @Override
    public void visitAllAttributeOwnerRWs(IAttributeOwnerRW.IVisitor visitor) {
    }

    public void requestAddObjectTypesCategoryPermissions(ObjectTypeCategory objectTypeCategoryToAdd, ILocksAndPermissionsTransactionController transactionController, IObjectTypeCategoryModifier objectTypesCategoryModifier) {
        this.checkValidty(objectTypeCategoryToAdd, objectTypesCategoryModifier, transactionController);
        this.requestModifyObjectTypesCategoryPermissions(transactionController);
    }

    private void requestModifyObjectTypesCategoryPermissions(ILocksAndPermissionsTransactionController transactionController) {
        transactionController.addPermission("defineAttributeTypes", null, this.projectAgent);
        transactionController.addProjectLock();
    }

    public void requestModifyObjectTypesCategoryPermissions(ObjectTypeCategory objectTypeCategoryToModify, ILocksAndPermissionsTransactionController transactionController, IObjectTypeCategoryModifier objectTypesCategoryModifier) {
        this.checkValidty(objectTypeCategoryToModify, objectTypesCategoryModifier, transactionController);
        this.requestModifyObjectTypesCategoryPermissions(transactionController);
    }

    public void requestDeleteObjectTypesCategoryPermission(ObjectTypeCategory objectTypeCategoryToDelete, ILocksAndPermissionsTransactionController transactionController) {
        this.requestModifyObjectTypesCategoryPermissions(transactionController);
    }

    private void checkValidty(ObjectTypeCategory objectTypeCategoryToCheck, IObjectTypeCategoryModifier objectTypesCategoryModifier, ILocksAndPermissionsTransactionController transactionController) {
        String error = this.isValidIdOrDisplayName(objectTypeCategoryToCheck.getHumanReadableID(), true, objectTypesCategoryModifier, objectTypeCategoryToCheck);
        if (error != null) {
            transactionController.addLockModificationProblem(new ModificationProblem(error, NLS.bind((String)Messages.getString("ObjectTypeCategoriesManager.CannotAddCategoryType"), (Object)objectTypeCategoryToCheck.getDisplayName())));
        }
        if ((error = this.isValidIdOrDisplayName(objectTypeCategoryToCheck.getDisplayName(), false, objectTypesCategoryModifier, objectTypeCategoryToCheck)) != null) {
            transactionController.addLockModificationProblem(new ModificationProblem(error, NLS.bind((String)Messages.getString("ObjectTypeCategoriesManager.CannotAddCategoryType"), (Object)objectTypeCategoryToCheck.getDisplayName())));
        }
    }

    public String isValidIdOrDisplayName(String newText, boolean forID, IObjectTypeCategoryModifier typesModifier, String cockpitDataTypeID) {
        return this.isValidIdOrDisplayName(newText, forID, typesModifier, cockpitDataTypeID, null);
    }

    public String isValidIdOrDisplayName(String newText, boolean forID, IObjectTypeCategoryModifier typesModifier, ObjectTypeCategory originalType) {
        return this.isValidIdOrDisplayName(newText, forID, typesModifier, originalType.getCockpitDataTypeID(), originalType);
    }

    private String isValidIdOrDisplayName(String newText, boolean forID, IObjectTypeCategoryModifier typesModifier, String cockpitDataTypeID, ObjectTypeCategory originalType) {
        String fieldName;
        String string = fieldName = forID ? Messages.getString("ObjectTypeCategoriesManager.Field.ID") : Messages.getString("ObjectTypeCategoriesManager.Field.DisplayName");
        if (newText == null || newText.trim().equals("")) {
            return NLS.bind((String)Messages.getString("ObjectTypeCategoriesManager.FieldNotAllowedToBeEmpty"), (Object)fieldName);
        }
        if (forID) {
            int maxLength = 255;
            if (newText.length() > maxLength) {
                return NLS.bind((String)Messages.getString("ObjectTypeCategoriesManager.FieldTooLong"), (Object)fieldName, (Object)String.valueOf(maxLength));
            }
        }
        ArrayList<? extends ObjectTypeCategory> objectTypeCategories = new ArrayList<ObjectTypeCategory>();
        for (ObjectTypeCategory objectTypeCategory : this.getAllCategoriesForObjectType(cockpitDataTypeID)) {
            if (typesModifier.isDeleted(objectTypeCategory)) continue;
            ObjectTypeCategory modified = typesModifier.getModifiedObjectTypeCategory(objectTypeCategory.getObjectTypeCategoryID());
            if (modified != null) {
                objectTypeCategories.add(modified);
                continue;
            }
            objectTypeCategories.add(objectTypeCategory);
        }
        objectTypeCategories.addAll(typesModifier.getAddedObjectTypeCategories());
        for (ObjectTypeCategory objectTypeCategory : objectTypeCategories) {
            if (originalType != null && originalType.getObjectTypeCategoryID().equals((Object)objectTypeCategory.getObjectTypeCategoryID())) continue;
            boolean alreadyExists = false;
            if (forID) {
                if (objectTypeCategory.getHumanReadableID().equals(newText)) {
                    alreadyExists = true;
                }
            } else if (objectTypeCategory.getDisplayName().equalsIgnoreCase(newText)) {
                alreadyExists = true;
            }
            if (!alreadyExists) continue;
            return NLS.bind((String)Messages.getString("ObjectTypeCategoriesManager.FieldAlreadyExists"), (Object)fieldName, (Object)newText);
        }
        return null;
    }

    @Override
    public void requestAddPermission(String name, ObjectTypeCategoryID objectTypeCategoryID, Collection<IAttribute> attributes, IAttributeOwner parent, boolean forImport, ILocksAndPermissionsTransactionController transactionController) {
    }

    @Override
    public void requestDataDeletePermission(IAttributeOwner data, ILocksAndPermissionsTransactionController transactionController) {
    }

    @Override
    public void requestMovePermission(IAttributeOwner dataToMove, IAttributeOwner newParent, ILocksAndPermissionsTransactionController transactionController) {
    }

    @Override
    public void deleteData(ILocksAndPermissionsTransactionController transactionController) throws EXNoPermission {
    }

    @Override
    public Collection<? extends IAttributeOwner> getData() {
        return null;
    }

    @Override
    public IAttributeOwner getParent(IAttributeOwner child) {
        return null;
    }

    @Override
    public Collection<? extends IAttributeOwner> getChildren(IAttributeOwner parent) {
        return null;
    }

    @Override
    public Collection<? extends IAttributeOwner> addData(ILocksAndPermissionsTransactionController transactionController) throws EXNoPermission {
        return null;
    }

    @Override
    public void moveData(ILocksAndPermissionsTransactionController transactionController) throws EXNoPermission, EXNoLock {
    }

    @Override
    public void dataModified(IAttributeOwner modifiedData) {
    }

    @Override
    public boolean managesChildrenForType(String dataTypeID) {
        return false;
    }

    @Override
    public List<IFrameDataRW> importDataFromEO(List<EOFrameData> eos) {
        return null;
    }

    @Override
    public IAttributeTypesProvider getAttributeTypesProvider() {
        return null;
    }

    @Override
    public boolean isLocallyModified(String dataUID) {
        return false;
    }

    @Override
    public boolean isLocallyAdded(String dataUID) {
        return false;
    }

    @Override
    public IFrameDataFactory getDataFactory() {
        return null;
    }

    @Override
    public IAttributeOwner getServerState(String dataUID) {
        return null;
    }

    @Override
    public boolean itemExistsOnServer(String cockpitDataUID) {
        return this.itemExistsOnServer(cockpitDataUID, "object-type-category");
    }

    public boolean itemExists(String UID) {
        return this.itemExists(UID, "object-type-category");
    }

    public List<IAttributeOwner> getAllAttributeOwnerUsingCategory(final ObjectTypeCategory categoryToCheck) {
        IFrameDataManager dataManager = this.projectAgent.getDataManager(categoryToCheck.getCockpitDataTypeID());
        final ObjectWrapper isInUse = new ObjectWrapper(new ArrayList());
        dataManager.visitAllAttributeOwnerRWs(new IAttributeOwnerRW.IVisitor(){

            @Override
            public void visit(IAttributeOwnerRW attributeOwnerRW) {
                if (Equals.equals((Object)categoryToCheck.getObjectTypeCategoryID(), (Object)attributeOwnerRW.getCategoryID()) && Equals.equals((Object)categoryToCheck.getCockpitDataTypeID(), (Object)attributeOwnerRW.getTypeID())) {
                    ((List)isInUse.getWrappedObject()).add(attributeOwnerRW);
                }
            }
        });
        return (List)isInUse.getWrappedObject();
    }
}

