/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.core.categories;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeOwner;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeType;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeTypeID;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.ObjectTypeCategoryID;
import com.arcway.cockpit.client.base.interfaces.general.ICategoryOwner;
import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.project.ProjectAgent;
import com.arcway.cockpit.frame.client.project.core.categories.ObjectTypeCategoriesManager;
import com.arcway.cockpit.frame.client.project.core.categories.ObjectTypeCategory;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class ObjectTypeCategories {
    private static final ILogger LOGGER = Logger.getLogger(ObjectTypeCategories.class);

    public static final List<IAttributeType> getVisibleUserDefinedAttributeTypesForItem(IAttributeOwner attributeOwner) {
        return ObjectTypeCategories.getVisibleUserDefinedAttributeTypesForItem(attributeOwner, false);
    }

    public static final List<IAttributeType> getVisibleUserDefinedAttributeTypesForItem(IAttributeOwner attributeOwner, boolean isHistoricItem) {
        ArrayList<IAttributeType> visibleAttributeTypes = new ArrayList<IAttributeType>();
        ProjectAgent projectAgent = ProjectMgr.getProjectMgr().getProjectAgent(attributeOwner.getProjectUID());
        Set<IAttributeTypeID> visibleAttributeTypeIDs = null;
        ObjectTypeCategoryID categoryID = attributeOwner.getCategoryID();
        if (categoryID != null) {
            ObjectTypeCategory category = projectAgent.getObjectTypeCategoriesManager().getCategory(categoryID);
            if (category != null) {
                visibleAttributeTypeIDs = category.getAttributeList();
            } else assert (isHistoricItem);
        }
        List<IAttributeType> sortedAttributeTypes = projectAgent.getFrameUserDefinedAttributeTypesManager().getSortedAttributeTypes(attributeOwner.getTypeID());
        for (IAttributeType attributeType : sortedAttributeTypes) {
            if (!attributeType.isUserDefined() || visibleAttributeTypeIDs != null && !visibleAttributeTypeIDs.contains(attributeType.getAttributeTypeID())) continue;
            visibleAttributeTypes.add(attributeType);
        }
        return visibleAttributeTypes;
    }

    public static final boolean isUserDefinedAttributeTypeVisibleForItem(IAttributeOwner attributeOwner, IAttributeType attributeType) {
        assert (attributeOwner.getTypeID().equals(attributeType.getCockpitDataTypeID()));
        ObjectTypeCategoryID categoryID = attributeOwner.getCategoryID();
        if (categoryID != null) {
            ObjectTypeCategory category = ProjectMgr.getProjectMgr().getProjectAgent(attributeOwner.getProjectUID()).getObjectTypeCategoriesManager().getCategory(categoryID);
            Set<IAttributeTypeID> visibleAttributeTypeIDs = category.getAttributeList();
            return visibleAttributeTypeIDs.contains(attributeType.getAttributeTypeID());
        }
        return true;
    }

    public static final ObjectTypeCategory getCategoryForItem(ICategoryOwner dataItem) {
        ObjectTypeCategoryID categoryID = dataItem.getCategoryID();
        if (categoryID != null) {
            ObjectTypeCategoriesManager objectTypeCategoriesManager = ProjectMgr.getProjectMgr().getProjectAgent(dataItem.getProjectUID()).getObjectTypeCategoriesManager();
            return objectTypeCategoriesManager.getCategory(categoryID);
        }
        return null;
    }
}

