/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeType;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeTypeDataType;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeTypeID;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeTypeSortCriterium;
import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.global.gui.properties.AttributeTypeID;
import com.arcway.cockpit.frame.client.project.Messages;
import com.arcway.cockpit.frame.client.project.ProjectAgent;
import com.arcway.cockpit.frame.client.project.core.framedata.AbstractAttributeTypesProvider;
import com.arcway.cockpit.frame.client.project.core.framedata.AttributeType;
import com.arcway.cockpit.frame.client.project.core.framedata.AttributeTypeSortCriterium;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.DataTypeLanguage;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.DataTypeString;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.DataTypeText;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.filemanager.DataTypeImage;
import com.arcway.cockpit.frame.shared.message.EOProject;
import java.util.ArrayList;
import java.util.Collection;

public class ProjectAttributeTypeProvider
extends AbstractAttributeTypesProvider {
    public static final String ATTRHRID_NAME = "name";
    public static final IAttributeTypeID ATTRID_NAME = AttributeTypeID.getAttributeTypeID(EOProject.ATTRID_NAME.getEOAttributeTypeID());
    public static final String ATTRHRID_DESCRIPTION = "description";
    public static final IAttributeTypeID ATTRID_DESCRIPTION = ProjectAttributeTypeProvider.getUID("description");
    public static final String ATTRHRID_COPYRIGHT = "copyright";
    public static final IAttributeTypeID ATTRID_COPYRIGHT = ProjectAttributeTypeProvider.getUID("copyright");
    public static final String ATTRHRID_LANGUAGE = "language";
    public static final IAttributeTypeID ATTRID_LANGUAGE = ProjectAttributeTypeProvider.getUID("language");
    public static final String ATTRHRID_LOGO = "logo";
    public static final IAttributeTypeID ATTRID_LOGO = AttributeTypeID.getAttributeTypeID("frame.project.logo");

    private static IAttributeTypeID getUID(String uID) {
        return AttributeTypeID.getAttributeTypeID("frame.project." + uID);
    }

    public ProjectAttributeTypeProvider(String projectUID) {
        super("frame.project", projectUID);
    }

    @Override
    protected Collection<IAttributeType> getDataTypeSpecificFixAttributeTypes() {
        ArrayList<IAttributeType> attributeTypes = new ArrayList<IAttributeType>();
        ProjectAgent projectAgent = ProjectMgr.getProjectMgr().getProjectAgent(this.projectUID);
        AttributeType name = new AttributeType(this.projectUID, ATTRID_NAME, ATTRHRID_NAME, Messages.getString("ProjectAttributeTypeProvider.name"), (IAttributeTypeSortCriterium)new AttributeTypeSortCriterium(0, IAttributeTypeSortCriterium.CATEGORY_FIXED_ATTRIBUTE), (IAttributeTypeDataType)DataTypeString.getInstanceString(), "frame.project", null, true, true, false, true, false);
        AttributeType description = new AttributeType(this.projectUID, ATTRID_DESCRIPTION, ATTRHRID_DESCRIPTION, Messages.getString("ProjectAttributeTypeProvider.description"), (IAttributeTypeSortCriterium)new AttributeTypeSortCriterium(1, IAttributeTypeSortCriterium.CATEGORY_FIXED_ATTRIBUTE), (IAttributeTypeDataType)DataTypeText.getInstanceText(), "frame.project", null, true, true, false, true, false);
        AttributeType copyright = new AttributeType(this.projectUID, ATTRID_COPYRIGHT, ATTRHRID_COPYRIGHT, Messages.getString("ProjectAttributeTypeProvider.copyright"), (IAttributeTypeSortCriterium)new AttributeTypeSortCriterium(2, IAttributeTypeSortCriterium.CATEGORY_FIXED_ATTRIBUTE), (IAttributeTypeDataType)DataTypeString.getInstanceString(), "frame.project", null, true, true, false, true, false);
        AttributeType language = new AttributeType(this.projectUID, ATTRID_LANGUAGE, ATTRHRID_LANGUAGE, Messages.getString("ProjectAttributeTypeProvider.language"), (IAttributeTypeSortCriterium)new AttributeTypeSortCriterium(3, IAttributeTypeSortCriterium.CATEGORY_FIXED_ATTRIBUTE), (IAttributeTypeDataType)new DataTypeLanguage(), "frame.project", null, true, true, false, true, false);
        AttributeType logo = new AttributeType(this.projectUID, ATTRID_LOGO, ATTRHRID_LOGO, Messages.getString("ProjectAttributeTypeProvider.logo"), (IAttributeTypeSortCriterium)new AttributeTypeSortCriterium(4, IAttributeTypeSortCriterium.CATEGORY_FIXED_ATTRIBUTE), (IAttributeTypeDataType)new DataTypeImage(projectAgent), "frame.project", null, true, true, false, true, true);
        attributeTypes.add(name);
        attributeTypes.add(description);
        attributeTypes.add(copyright);
        attributeTypes.add(language);
        attributeTypes.add(logo);
        return attributeTypes;
    }

    @Override
    public IAttributeTypeID getNameAttributeTypeID() {
        return ATTRID_NAME;
    }
}

