/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttribute;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeType;
import com.arcway.cockpit.client.base.interfaces.frame.permissions.EXNoPermission;
import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.global.license.licensetypes.ClientFunctionLicenseTypeModifyCopyrightAndLogo;
import com.arcway.cockpit.frame.client.global.license.licensetypes.ClientFunctionLicenseTypeModifyProjectsAndSectionsAndPlans;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.Messages;
import com.arcway.cockpit.frame.client.project.Project;
import com.arcway.cockpit.frame.client.project.ProjectAttributeTypeProvider;
import com.arcway.cockpit.frame.client.project.core.framedata.IAttributeModificationManager;
import com.arcway.cockpit.frame.client.project.core.framedata.ModificationProblem;
import com.arcway.cockpit.frame.client.project.core.framedata.transactionmanagement.ILocksAndPermissionsTransactionController;
import com.arcway.cockpit.frame.client.project.core.framedata.transactionmanagement.LocksAndPermissionsTransactionController;
import com.arcway.cockpit.frame.client.project.core.locking.EXNoLock;
import com.arcway.cockpit.frame.client.project.core.userdefinedattributetypes.IParentOperandTree;
import com.arcway.cockpit.frame.shared.IPermissionOperand;
import com.arcway.cockpit.frame.shared.message.EOLock;
import com.arcway.cockpit.frame.shared.userdefinedattributes.ExInvalidAttributeType;
import com.arcway.cockpit.frame.shared.userdefinedattributes.ExInvalidDataType;
import com.arcway.lib.ui.IModificationProblem;
import de.plans.psc.client.communication.LoginCanceledException;
import de.plans.psc.client.communication.ServerNotAvailableException;
import de.plans.psc.client.communication.UnknownServerException;
import de.plans.psc.shared.serverexceptions.EXServerException;
import java.util.Collection;
import org.eclipse.jface.dialogs.IInputValidator;

public class ProjectAttributeModificationManager
implements IAttributeModificationManager {
    private Project project;
    private final IFrameProjectAgent projectAgent;
    private final IParentOperandTree operandTree = new IParentOperandTree(){

        @Override
        public IPermissionOperand getBaseOperand() {
            return ProjectAttributeModificationManager.this.projectAgent;
        }

        @Override
        public IPermissionOperand getParent(IPermissionOperand childOperand) {
            return null;
        }
    };

    public ProjectAttributeModificationManager(IFrameProjectAgent projectAgent) {
        this.projectAgent = projectAgent;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    @Override
    public void modifyAttribute(IAttribute newAttribute, Object oldAttributeValue) throws ExInvalidAttributeType, ExInvalidDataType, EXNoPermission, EXNoLock {
        IAttributeType attributeType = this.project.getAttributeType(newAttribute.getAttributeTypeID());
        if (!this.projectAgent.getFramePermissionChecker().hasAttributeModificationPermission(attributeType, this.operandTree, false)) {
            ModificationProblem modProblem = new ModificationProblem(attributeType, this.operandTree, this.projectAgent);
            throw new EXNoPermission(modProblem.getHumanReadableDescriptionOfCause());
        }
        if (attributeType.getAttributeTypeID().equals(ProjectAttributeTypeProvider.ATTRID_NAME)) {
            this.projectAgent.projectNameChanged(this.project.getName());
        }
        this.projectAgent.getProjectMetaDataManager().setNewProject(this.project);
    }

    @Override
    public void requestAttributeModificationPermission(IAttribute newAttribute, ILocksAndPermissionsTransactionController transactionController) {
        IAttributeType attributeType = this.project.getAttributeType(newAttribute.getAttributeTypeID());
        this.checkLicense(attributeType, transactionController);
        transactionController.addAttributeModificationPermission(attributeType, this.operandTree);
        String problem = String.valueOf(Messages.getString("ProjectAttributeModificationManager.cannot_mod_project_prop1")) + attributeType.getDisplayName() + Messages.getString("ProjectAttributeModificationManager.cannot_mod_project_prop2");
        if (newAttribute.getAttributeTypeID().equals(ProjectAttributeTypeProvider.ATTRID_NAME)) {
            String msg;
            if (this.projectAgent.getOfflineModeManager().isInOfflineMode()) {
                msg = Messages.getString("ProjectAttributeModificationManager.CannotModProjectNameInOffMode");
            } else {
                IInputValidator validator = ProjectMgr.getProjectMgr().getProjectManagerServerProxy(this.projectAgent.getServerID()).getProjectNameValidator(this.projectAgent);
                msg = validator.isValid((String)newAttribute.getAttributeValue());
            }
            if (msg != null) {
                ModificationProblem modProblem = new ModificationProblem(msg, problem);
                transactionController.addLockModificationProblem(modProblem);
            }
        } else if (newAttribute.getAttributeTypeID().equals(ProjectAttributeTypeProvider.ATTRID_LANGUAGE)) {
            transactionController.addProjectLock();
        }
        transactionController.addLockToTest(this.projectAgent, "modify");
        transactionController.addLock(this.projectAgent, "modify");
    }

    @Override
    public void requestObjectTypeCategoryModificationPermission(ILocksAndPermissionsTransactionController transactionController) {
        throw new UnsupportedOperationException();
    }

    public void checkGeneralModificationPermissions(IAttributeType attributeType, ILocksAndPermissionsTransactionController transactionController) {
        this.checkLicense(attributeType, transactionController);
        if (attributeType.getAttributeTypeID().equals(ProjectAttributeTypeProvider.ATTRID_NAME) && this.projectAgent.getOfflineModeManager().isInOfflineMode()) {
            String problem = String.valueOf(Messages.getString("ProjectAttributeModificationManager.cannot_mod_project_prop1")) + attributeType.getDisplayName() + Messages.getString("ProjectAttributeModificationManager.cannot_mod_project_prop2");
            String msg = Messages.getString("ProjectAttributeModificationManager.CannotModProjectNameInOffMode");
            ModificationProblem modProblem = new ModificationProblem(msg, problem, 4);
            transactionController.addLockModificationProblem(modProblem);
        }
        transactionController.addAttributeModificationPermission(attributeType, this.operandTree, false);
        transactionController.addLockToTest(this.projectAgent, "modify");
    }

    @Override
    public Collection<IModificationProblem> checkGeneralModificationPermissions(IAttributeType attributeType) {
        LocksAndPermissionsTransactionController transactionController = new LocksAndPermissionsTransactionController(this.projectAgent);
        this.checkGeneralModificationPermissions(attributeType, transactionController);
        Collection<IModificationProblem> modificationProblems = transactionController.checkConditions(false, true);
        return modificationProblems;
    }

    private void checkLicense(IAttributeType attributeType, ILocksAndPermissionsTransactionController transactionController) {
        if (attributeType.getAttributeTypeID().equals(ProjectAttributeTypeProvider.ATTRID_COPYRIGHT) || attributeType.getAttributeTypeID().equals(ProjectAttributeTypeProvider.ATTRID_LOGO)) {
            transactionController.addClientLicenseType(ClientFunctionLicenseTypeModifyCopyrightAndLogo.getInstance());
        } else {
            transactionController.addClientLicenseType(ClientFunctionLicenseTypeModifyProjectsAndSectionsAndPlans.getInstance());
        }
    }

    @Override
    @Deprecated
    public IModificationProblem checkLocks() {
        ModificationProblem modProblem = null;
        Throwable serverException = null;
        try {
            EOLock conflictingLock = this.projectAgent.getFrameLockManager().anotherClientHasLock(this.projectAgent, "modify");
            if (conflictingLock != null) {
                modProblem = new ModificationProblem(conflictingLock, Messages.getString("ProjectAttributeModificationManager.project_cannot_be_modified"));
            }
        }
        catch (ServerNotAvailableException e) {
            serverException = e;
        }
        catch (LoginCanceledException e) {
            serverException = e;
        }
        catch (EXServerException e) {
            serverException = e;
        }
        catch (UnknownServerException e) {
            serverException = e;
        }
        if (serverException != null) {
            modProblem = new ModificationProblem((Exception)serverException, Messages.getString("ProjectAttributeModificationManager.project_cannot_be_modified"));
        }
        return modProblem;
    }

    @Override
    public void modifyCategoryID() throws EXNoPermission, EXNoLock {
        this.projectAgent.getProjectMetaDataManager().setNewProject(this.project);
    }

    @Override
    public Collection<IModificationProblem> checkObjectTypeCategoryModificationPermission() {
        throw new UnsupportedOperationException();
    }
}

