/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.lib.relationviews.dependencynet;

import com.arcway.cockpit.frame.client.lib.relationviews.IRelationViewGraphBuilder;
import com.arcway.cockpit.frame.client.lib.relationviews.LabelCreator;
import com.arcway.cockpit.frame.client.lib.relationviews.NodeAttributes;
import com.arcway.cockpit.frame.client.lib.relationviews.dependencynet.IDependencyModel;
import com.arcway.cockpit.frame.client.lib.relationviews.gefpatch.copied.DirectedGraph;
import com.arcway.cockpit.frame.client.lib.relationviews.gefpatch.copied.HorizontalPlacement;
import com.arcway.cockpit.frame.client.lib.relationviews.gefpatch.copied.InitialRankSolver;
import com.arcway.cockpit.frame.client.lib.relationviews.gefpatch.copied.LocalOptimizer;
import com.arcway.cockpit.frame.client.lib.relationviews.gefpatch.copied.MinCross;
import com.arcway.cockpit.frame.client.lib.relationviews.gefpatch.copied.Node;
import com.arcway.cockpit.frame.client.lib.relationviews.gefpatch.copied.RankAssignmentSolver;
import com.arcway.cockpit.frame.client.lib.relationviews.gefpatch.copied.TightSpanningTreeSolver;
import com.arcway.cockpit.frame.client.lib.relationviews.gefpatch.copied.VerticalPlacement;
import com.arcway.cockpit.frame.client.lib.relationviews.gefpatch.derived.RelationViewGraphEdge;
import com.arcway.cockpit.frame.client.lib.relationviews.gefpatch.derived.RelationViewGraphNode;
import com.arcway.cockpit.frame.client.lib.relationviews.gefpatch.patched.RelationViewPopulateRanks;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.swt.graphics.Font;

public class DependencyNetGraphBuilder
implements IRelationViewGraphBuilder {
    public static final int UNLIMITED = -1;
    private IDependencyModel dependencyModel;
    private final LabelCreator labelCreator;
    private int maxLevelsUp;
    private int maxLevelsDown;

    public DependencyNetGraphBuilder(IDependencyModel model, LabelCreator labelCreator) {
        this.dependencyModel = model;
        this.labelCreator = labelCreator;
        this.maxLevelsDown = -1;
        this.maxLevelsUp = -1;
    }

    public DependencyNetGraphBuilder(IDependencyModel model, LabelCreator labelCreator, int maxLevelsUp, int maxLevelsDown) {
        this.dependencyModel = model;
        this.labelCreator = labelCreator;
        this.maxLevelsDown = maxLevelsDown;
        this.maxLevelsUp = maxLevelsUp;
    }

    @Override
    public DirectedGraph createGraph(Font labelFont, ICockpitProjectData data) {
        DirectedGraph graph = this.createDependencyGraph(labelFont, data);
        new InitialRankSolver().visit(graph);
        new TightSpanningTreeSolver().visit(graph);
        new RankAssignmentSolver().visit(graph);
        new RelationViewPopulateRanks().visit(graph);
        new VerticalPlacement().visit(graph);
        new MinCross().visit(graph);
        new LocalOptimizer().visit(graph);
        new HorizontalPlacement().visit(graph);
        return graph;
    }

    private DirectedGraph createDependencyGraph(Font nodeFont, ICockpitProjectData data) {
        HashMap<ICockpitProjectData, RelationViewGraphNode> nodeMap = new HashMap<ICockpitProjectData, RelationViewGraphNode>();
        DirectedGraph graph = new DirectedGraph();
        graph.setDefaultPadding(new Insets(20));
        RelationViewGraphNode root = new RelationViewGraphNode((Object)data, 2);
        NodeAttributes nodeAtrributes = this.labelCreator.getNodeAttributes(data, 2);
        root.width = (int)Math.ceil(nodeAtrributes.getWidth());
        root.height = (int)Math.ceil(nodeAtrributes.getHeight());
        graph.nodes.add(root);
        nodeMap.put(data, root);
        this.addDependencyChildren(nodeFont, data, data, nodeMap, Arrays.asList(data), graph, this.maxLevelsDown);
        this.addDependencyParents(nodeFont, data, nodeMap, Arrays.asList(data), new ArrayList<ICockpitProjectData>(Arrays.asList(data)), new ArrayList(nodeMap.keySet()), graph, this.maxLevelsUp);
        return graph;
    }

    private void addDependencyChildren(Font nodeFont, ICockpitProjectData data, ICockpitProjectData focussedItem, Map nodeMap, Collection ancestorItems, DirectedGraph graph, int maxLevelsDown_) {
        int remainingMayLevelsDown = maxLevelsDown_;
        if (remainingMayLevelsDown != -1) {
            --remainingMayLevelsDown;
        }
        for (ICockpitProjectData iCockpitProjectData : this.dependencyModel.getDependencySuccessors(data)) {
            Node target;
            Node source;
            if (iCockpitProjectData.equals(data)) continue;
            boolean bidirectionalEdge = this.dependencyModel.getDependencySuccessors(iCockpitProjectData).contains(data);
            if (!nodeMap.containsKey(iCockpitProjectData)) {
                RelationViewGraphNode node = new RelationViewGraphNode((Object)iCockpitProjectData, 1);
                NodeAttributes nodeAttributes = this.labelCreator.getNodeAttributes(iCockpitProjectData, 1);
                node.width = (int)Math.ceil(nodeAttributes.getWidth());
                node.height = (int)Math.ceil(nodeAttributes.getHeight());
                graph.nodes.add(node);
                nodeMap.put(iCockpitProjectData, node);
                if (remainingMayLevelsDown > 0 || remainingMayLevelsDown == -1) {
                    HashSet<ICockpitProjectData> newAncestorSet = new HashSet<ICockpitProjectData>(ancestorItems);
                    newAncestorSet.add(iCockpitProjectData);
                    this.addDependencyChildren(nodeFont, iCockpitProjectData, focussedItem, nodeMap, newAncestorSet, graph, remainingMayLevelsDown);
                }
                if (bidirectionalEdge) {
                    Node source2 = (Node)nodeMap.get(data);
                    Node target2 = (Node)nodeMap.get(iCockpitProjectData);
                    graph.edges.add(new RelationViewGraphEdge(source2, target2, 1));
                }
            } else if (bidirectionalEdge && data == focussedItem) {
                source = (Node)nodeMap.get(data);
                target = (Node)nodeMap.get(iCockpitProjectData);
                graph.edges.add(new RelationViewGraphEdge(source, target, 1));
            }
            if (bidirectionalEdge) continue;
            source = (Node)nodeMap.get(data);
            target = (Node)nodeMap.get(iCockpitProjectData);
            if (!ancestorItems.contains(iCockpitProjectData)) {
                graph.edges.add(new RelationViewGraphEdge(source, target, 2));
                continue;
            }
            graph.edges.add(new RelationViewGraphEdge(target, source, 3));
        }
    }

    private void addDependencyParents(Font nodeFont, ICockpitProjectData data, Map nodeMap, Collection descendentItems, Collection processedDependencyParents, Collection allDependencyChildren, DirectedGraph graph, int maxLevelsUp_) {
        int remainingMayLevelsUp = maxLevelsUp_;
        if (remainingMayLevelsUp != -1) {
            --remainingMayLevelsUp;
        }
        for (ICockpitProjectData iCockpitProjectData : this.dependencyModel.getDependencyPredecessors(data)) {
            if (!allDependencyChildren.contains(iCockpitProjectData)) {
                boolean bidirectionalEdge = this.dependencyModel.getDependencyPredecessors(iCockpitProjectData).contains(data);
                if (!nodeMap.containsKey(iCockpitProjectData)) {
                    RelationViewGraphNode node = new RelationViewGraphNode((Object)iCockpitProjectData, 3);
                    NodeAttributes nodeAttributes = this.labelCreator.getNodeAttributes(iCockpitProjectData, 3);
                    node.width = (int)Math.ceil(nodeAttributes.getWidth());
                    node.height = (int)Math.ceil(nodeAttributes.getHeight());
                    graph.nodes.add(node);
                    nodeMap.put(iCockpitProjectData, node);
                    if (remainingMayLevelsUp > 0 || remainingMayLevelsUp == -1) {
                        HashSet<ICockpitProjectData> newDescendentSet = new HashSet<ICockpitProjectData>(descendentItems);
                        newDescendentSet.add(iCockpitProjectData);
                        processedDependencyParents.add(iCockpitProjectData);
                        this.addDependencyParents(nodeFont, iCockpitProjectData, nodeMap, newDescendentSet, processedDependencyParents, allDependencyChildren, graph, remainingMayLevelsUp);
                    }
                    if (bidirectionalEdge) {
                        Node source = (Node)nodeMap.get(iCockpitProjectData);
                        Node target = (Node)nodeMap.get(data);
                        graph.edges.add(new RelationViewGraphEdge(source, target, 1));
                    }
                }
                if (bidirectionalEdge) continue;
                Node source = (Node)nodeMap.get(iCockpitProjectData);
                Node target = (Node)nodeMap.get(data);
                if (!descendentItems.contains(iCockpitProjectData)) {
                    graph.edges.add(new RelationViewGraphEdge(source, target, 2));
                    continue;
                }
                graph.edges.add(new RelationViewGraphEdge(target, source, 3));
                continue;
            }
            if (processedDependencyParents.contains(iCockpitProjectData) || remainingMayLevelsUp <= 0 && remainingMayLevelsUp != -1) continue;
            HashSet<ICockpitProjectData> newDescendentSet = new HashSet<ICockpitProjectData>(descendentItems);
            newDescendentSet.add(iCockpitProjectData);
            processedDependencyParents.add(iCockpitProjectData);
            this.addDependencyParents(nodeFont, iCockpitProjectData, nodeMap, newDescendentSet, processedDependencyParents, allDependencyChildren, graph, remainingMayLevelsUp);
        }
    }

    public void setMaxLevelsUp(int maxLevelsUp) {
        this.maxLevelsUp = maxLevelsUp;
    }

    public void setMaxLevelsDown(int maxLevelsDown) {
        this.maxLevelsDown = maxLevelsDown;
    }

    public void changeDependencyModel(IDependencyModel model) {
        this.dependencyModel = model;
    }
}

