/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.lib.relationviews;

import com.arcway.cockpit.frame.client.lib.relationviews.EdgeAttributes;
import com.arcway.cockpit.frame.client.lib.relationviews.IRelationView;
import com.arcway.cockpit.frame.client.lib.relationviews.IRelationViewFigureFactory;
import com.arcway.cockpit.frame.client.lib.relationviews.NodeAttributes;
import com.arcway.cockpit.frame.client.lib.relationviews.NodeSelectionListener;
import com.arcway.cockpit.frame.client.lib.relationviews.gefpatch.patched.LabelWithOutPrintError;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.draw2d.BendpointConnectionRouter;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.Panel;
import org.eclipse.draw2d.PolygonDecoration;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.draw2d.RoundedRectangle;
import org.eclipse.draw2d.XYAnchor;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public final class RelationViewFigureFactory
implements IRelationViewFigureFactory {
    private final Display display;
    private final Cursor handCursor;
    private final Map<com.arcway.lib.graphics.Color, Color> colorMaps;

    public RelationViewFigureFactory(Display display) {
        this.display = display;
        this.handCursor = new Cursor((Device)display, 21);
        this.colorMaps = new HashMap<com.arcway.lib.graphics.Color, Color>();
    }

    protected Cursor getHandCursor() {
        return this.handCursor;
    }

    protected PolylineConnection createConnection(int startX, int startY, int endX, int endY) {
        PolylineConnection connection = new PolylineConnection();
        connection.setConnectionRouter((ConnectionRouter)new BendpointConnectionRouter());
        connection.setSourceAnchor((ConnectionAnchor)new XYAnchor(new Point(startX, startY)));
        connection.setTargetAnchor((ConnectionAnchor)new XYAnchor(new Point(endX, endY)));
        connection.getConnectionRouter().route((Connection)connection);
        return connection;
    }

    private Collection<IFigure> createStandardNode(int x, int y, int width, int height, Image image, Font font, String unwrappedText, String wrappedText, boolean isLabelShortening, Object data, IRelationView relationView, Color foregroundColor, Color backgroundColor, Color toolTipColor) {
        RoundedRectangle rectangle = new RoundedRectangle();
        rectangle.setBounds(new Rectangle(x, y, width, height));
        rectangle.setBackgroundColor(backgroundColor);
        rectangle.setForegroundColor(backgroundColor);
        if (data != null) {
            rectangle.addMouseListener((MouseListener)new NodeSelectionListener(data, relationView));
            rectangle.setCursor(this.getHandCursor());
        }
        rectangle.setBounds(new Rectangle(x, y, width, height));
        LabelWithOutPrintError label = new LabelWithOutPrintError();
        label.setForegroundColor(foregroundColor);
        label.setOpaque(false);
        label.setIcon(image);
        label.setText(wrappedText);
        if (isLabelShortening) {
            label.setToolTip(this.getToolTip(unwrappedText, font, toolTipColor));
        }
        if (data != null) {
            label.addMouseListener(new NodeSelectionListener(data, relationView));
            label.setCursor(this.getHandCursor());
        }
        label.setBounds(new Rectangle(x, y, width, height));
        return Arrays.asList(new IFigure[]{rectangle, label});
    }

    public void disposeResources() {
        this.handCursor.dispose();
        for (Map.Entry<com.arcway.lib.graphics.Color, Color> colorMapsEntry : this.colorMaps.entrySet()) {
            Color color = colorMapsEntry.getValue();
            colorMapsEntry.setValue(null);
            if (color == null) continue;
            color.dispose();
        }
    }

    private IFigure getToolTip(String text, Font font, Color toolTipColor) {
        Dimension textExtent = FigureUtilities.getTextExtents((String)text, (Font)font);
        int width = textExtent.width + 8;
        int height = textExtent.height + 2;
        Panel toolTip = new Panel();
        toolTip.setBounds(new Rectangle(0, 0, width, height));
        toolTip.setBackgroundColor(toolTipColor);
        Label label = new Label(text);
        label.setBounds(new Rectangle(0, 0, width, height));
        label.setLabelAlignment(2);
        toolTip.add((IFigure)label);
        return toolTip;
    }

    @Override
    public Collection<IFigure> createEdgeFigures(int startX, int startY, int endX, int endY, EdgeAttributes edgeAttributes) {
        if (edgeAttributes.showEdge()) {
            PolygonDecoration arrow;
            PolylineConnection connection = this.createConnection(startX, startY, endX, endY);
            if (edgeAttributes.hasTargetArrow()) {
                arrow = new PolygonDecoration();
                arrow.setScale(6.0, 3.0);
                connection.setTargetDecoration((RotatableDecoration)arrow);
            }
            if (edgeAttributes.hasSourceArrow()) {
                arrow = new PolygonDecoration();
                arrow.setScale(6.0, 3.0);
                connection.setSourceDecoration((RotatableDecoration)arrow);
            }
            return Arrays.asList(connection);
        }
        return Collections.emptyList();
    }

    @Override
    public Collection<IFigure> createNodeFigures(int x, int y, int width, int height, NodeAttributes nodeAttributes, Object data, IRelationView targetRelationView) {
        Color foregroundColor = this.getMappedColor(nodeAttributes.getForegroundColor());
        Color backgroundColor = this.getMappedColor(nodeAttributes.getBackgroundColor());
        Color toolTipColor = this.getMappedColor(nodeAttributes.getToolTipColor());
        return this.createStandardNode(x, y, width, height, nodeAttributes.getIcon(), nodeAttributes.getFont(), nodeAttributes.getUnwrappedText(), nodeAttributes.getWrappedText(), nodeAttributes.isLabelShortening(), data, targetRelationView, foregroundColor, backgroundColor, toolTipColor);
    }

    private Color getMappedColor(com.arcway.lib.graphics.Color color) {
        Color mappedColor = null;
        if (this.colorMaps.containsKey(color)) {
            mappedColor = this.colorMaps.get(color);
        } else {
            mappedColor = new Color((Device)this.display, color.r, color.g, color.b);
            this.colorMaps.put(color, mappedColor);
        }
        return mappedColor;
    }

    public void dispose() {
        this.handCursor.dispose();
        this.display.dispose();
        for (Map.Entry<com.arcway.lib.graphics.Color, Color> colorMapsEntry : this.colorMaps.entrySet()) {
            Color color = colorMapsEntry.getValue();
            this.colorMaps.put(colorMapsEntry.getKey(), null);
            color.dispose();
        }
    }
}

