/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.lib.relationviews;

import com.arcway.cockpit.frame.client.lib.relationviews.IRelationViewViewPartFactory;
import com.arcway.cockpit.frame.client.lib.relationviews.LabelCreator;
import com.arcway.cockpit.frame.client.lib.relationviews.NodeAttributes;
import com.arcway.cockpit.frame.client.lib.relationviews.gefpatch.copied.DirectedGraph;
import com.arcway.cockpit.frame.client.lib.relationviews.gefpatch.copied.Edge;
import com.arcway.cockpit.frame.client.lib.relationviews.gefpatch.copied.Node;
import com.arcway.cockpit.frame.client.lib.relationviews.gefpatch.copied.VirtualNode;
import com.arcway.cockpit.frame.client.lib.relationviews.gefpatch.derived.RelationViewGraphEdge;
import com.arcway.cockpit.frame.client.lib.relationviews.gefpatch.derived.RelationViewGraphNode;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.planagent.planview.view.PVPlanViewPart;
import com.arcway.planagent.planview.view.PVView;
import org.eclipse.swt.graphics.Font;

public class GraphToViewPartConverter {
    public static PVView getViewPart(IRelationViewViewPartFactory factory, DirectedGraph graph, Font nodeFont, LabelCreator labelCreator) {
        PVView view = new PVView();
        int i = 0;
        while (i < graph.nodes.size()) {
            boolean nodeIsVirtual;
            Node node = graph.nodes.getNode(i);
            boolean nodeIsRelationViewNode = node instanceof RelationViewGraphNode && ((RelationViewGraphNode)node).getNodeType() != -1;
            boolean bl = nodeIsVirtual = node instanceof VirtualNode || node instanceof RelationViewGraphNode && ((RelationViewGraphNode)node).getNodeType() == -1;
            if (nodeIsRelationViewNode) {
                ICockpitProjectData cockpitProjectData = (ICockpitProjectData)node.data;
                NodeAttributes nodeAttributes = labelCreator.getNodeAttributes(cockpitProjectData, ((RelationViewGraphNode)node).getNodeType());
                String nodeTypeID = cockpitProjectData.getTypeID();
                String nodeID = cockpitProjectData.getUID();
                String nodeName = nodeAttributes.getUnwrappedText();
                PVPlanViewPart viewPart = factory.createNodeViewPart(node.x, node.y, node.width, node.height, nodeAttributes, node.data, nodeTypeID, nodeID, nodeName, nodeFont);
                view.addChild(viewPart);
            } else if (nodeIsVirtual) {
                PVPlanViewPart viewPart = factory.createEdgeViewPart(node.x + node.width / 2, node.y, node.x + node.width / 2, node.y + node.height, labelCreator.getEdgeAttributes(-1, true, true));
                view.addChild(viewPart);
            }
            ++i;
        }
        i = 0;
        while (i < graph.edges.size()) {
            Edge edge = graph.edges.getEdge(i);
            Node s = edge.source;
            Node t = edge.target;
            int edgeType = -1;
            if (edge instanceof RelationViewGraphEdge) {
                edgeType = ((RelationViewGraphEdge)edge).getEdgeType();
            }
            boolean sourceVirtual = s instanceof VirtualNode || s instanceof RelationViewGraphNode && ((RelationViewGraphNode)s).getNodeType() == -1;
            boolean targetVirtual = t instanceof VirtualNode || t instanceof RelationViewGraphNode && ((RelationViewGraphNode)t).getNodeType() == -1;
            PVPlanViewPart viewPart = factory.createEdgeViewPart(s.x + edge.getSourceOffset(), s.y + s.height, t.x + edge.getTargetOffset(), t.y, labelCreator.getEdgeAttributes(edgeType, sourceVirtual, targetVirtual));
            view.addChild(viewPart);
            ++i;
        }
        return view;
    }
}

