/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.lib.relationviews;

import com.arcway.cockpit.frame.client.lib.relationviews.IGraphNodeLayoutProvider;
import com.arcway.cockpit.frame.client.lib.relationviews.IRelationGraphProvider;
import com.arcway.cockpit.frame.client.lib.relationviews.ITextExtendCalculator;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.lib.graphics.Color;
import com.arcway.lib.stringtools.StringUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;

public class GraphNodeLayoutProvider
implements IGraphNodeLayoutProvider {
    protected final String shortedStringPattern = "...";
    protected ITextExtendCalculator textExtendCalculator;
    protected IRelationGraphProvider relationGraphProvider;

    public GraphNodeLayoutProvider(ITextExtendCalculator textExtendCalculator, IRelationGraphProvider relationGraphProvider) {
        this.textExtendCalculator = textExtendCalculator;
        this.relationGraphProvider = relationGraphProvider;
    }

    @Override
    public Font getFont() {
        Font font = PlatformUI.getWorkbench().getDisplay().getShells()[0].getFont();
        return font;
    }

    @Override
    public int getHeightHint(Font font, ICockpitProjectData data, int nodeType) {
        List<String> wrappedLabelLines = this.getBinarySearchWrappedLabel_internal(font, this.getTextToWrap(data, nodeType));
        return wrappedLabelLines.size() * this.textExtendCalculator.getTextHeight(font) + 10;
    }

    @Override
    public int getWidthHint(Font font, ICockpitProjectData data, int nodeType) {
        int width = 0;
        String labelText = this.getTextToWrap(data, nodeType);
        width = Math.min(this.textExtendCalculator.getTextWidth(font, labelText), 300) + 10 + (this.hasIcon(data, nodeType) ? 20 : 0);
        return width;
    }

    @Override
    public String getWrappedLabel(Font font, ICockpitProjectData data, int nodeType) {
        String unwrappedText = this.getTextToWrap(data, nodeType);
        String wrappedText = this.getBinarySearchWrappedLabel(font, unwrappedText);
        return wrappedText;
    }

    private String getTextToWrap(ICockpitProjectData data, int nodeType) {
        String text = this.getLabel(data, nodeType).trim();
        if ((text = this.getTrimmedText(text)).length() > 655) {
            text = text.substring(0, 655);
        }
        return text;
    }

    private String getTrimmedText(String textToTrim) {
        String trimmedText = null;
        List lineElements = StringUtil.trimTextLine((String)textToTrim);
        for (String lineElement : lineElements) {
            if (trimmedText == null) {
                trimmedText = lineElement.trim();
                continue;
            }
            if (lineElement.equals(" ")) continue;
            trimmedText = String.valueOf(trimmedText) + " " + lineElement.trim();
        }
        return trimmedText;
    }

    private String getBinarySearchWrappedLabel(Font font, String unwrappedText) {
        List<String> wrappedLabelLines = this.getBinarySearchWrappedLabel_internal(font, unwrappedText);
        StringBuffer result = new StringBuffer();
        Iterator<String> lineIt = wrappedLabelLines.iterator();
        while (lineIt.hasNext()) {
            String lineString = lineIt.next();
            result.append(lineString);
            if (!lineIt.hasNext()) continue;
            result.append("\n");
        }
        return result.toString();
    }

    private List<String> getBinarySearchWrappedLabel_internal(Font font, String unwrappedText) {
        ArrayList<String> wrappedText;
        block9: {
            assert (unwrappedText.indexOf(10) == -1) : "The calulated Wrap Positions will not be correct if the unwrapped Text already contains newline characters";
            wrappedText = new ArrayList<String>();
            if (this.textExtendCalculator.getTextWidth(font, unwrappedText) > 300) {
                String remainingUnwrappedText = unwrappedText;
                int numberOfLines = 0;
                do {
                    int lastWrapPosition;
                    String effectiveText = remainingUnwrappedText;
                    int lowerIndex = 0;
                    int upperIndex = remainingUnwrappedText.length() - 1;
                    while (upperIndex - lowerIndex > 1) {
                        int middleIndex = (int)Math.ceil((double)(lowerIndex + upperIndex) / 2.0);
                        effectiveText = remainingUnwrappedText.substring(0, middleIndex + 1);
                        int width = this.textExtendCalculator.getTextWidth(font, effectiveText);
                        if (width == 300) break;
                        if (width < 300) {
                            lowerIndex = middleIndex;
                            continue;
                        }
                        upperIndex = middleIndex;
                    }
                    if (this.textExtendCalculator.getTextWidth(font, effectiveText) > 300) {
                        effectiveText = effectiveText.substring(0, effectiveText.length() - 1);
                    }
                    if (++numberOfLines >= 3) {
                        String effectiveResultText = effectiveText.length() < remainingUnwrappedText.length() ? (effectiveText.length() > "...".length() ? String.valueOf(effectiveText.substring(0, effectiveText.length() - "...".length())) + "..." : effectiveText) : effectiveText;
                        wrappedText.add(effectiveResultText);
                        break block9;
                    }
                    if (remainingUnwrappedText.length() > effectiveText.length() && remainingUnwrappedText.charAt(effectiveText.length()) != ' ' && (lastWrapPosition = StringUtil.findLastWrapPosition((String)effectiveText)) >= 0 && effectiveText.length() - lastWrapPosition <= 20) {
                        effectiveText = effectiveText.substring(0, lastWrapPosition + 1);
                    }
                    remainingUnwrappedText = remainingUnwrappedText.substring(effectiveText.length()).trim();
                    wrappedText.add(effectiveText);
                } while (this.textExtendCalculator.getTextWidth(font, remainingUnwrappedText) > 300);
                wrappedText.add(remainingUnwrappedText);
            } else {
                wrappedText.add(unwrappedText);
            }
        }
        return wrappedText;
    }

    @Override
    public boolean isLabelShortening(ICockpitProjectData data, String wrappedLabel, int nodeType) {
        String unwrappedLabel = this.getLabel(data, nodeType);
        return wrappedLabel.endsWith("...") && !unwrappedLabel.endsWith("...");
    }

    @Override
    public boolean hasIcon(ICockpitProjectData data, int nodeType) {
        return this.relationGraphProvider.hasIcon(data, nodeType);
    }

    @Override
    public Color getLineColor() {
        return this.relationGraphProvider.getLineColor();
    }

    @Override
    public Color getToolTipColor() {
        return this.relationGraphProvider.getToolTipColor();
    }

    @Override
    public Color getBackgroundColor(ICockpitProjectData data, int nodeType) {
        return this.relationGraphProvider.getBackgroundColor(data, nodeType);
    }

    @Override
    public Color getForegroundColor(ICockpitProjectData data, int nodeType) {
        return this.relationGraphProvider.getForegroundColor(data, nodeType);
    }

    @Override
    public Image getIcon(ICockpitProjectData data, int nodeType) {
        return this.relationGraphProvider.getIcon(data, nodeType);
    }

    @Override
    public String getLabel(ICockpitProjectData data, int nodeType) {
        return this.relationGraphProvider.getLabel(data, nodeType);
    }

    @Override
    public boolean hasSourceArrow(int edgeType, boolean virtualSource) {
        return this.relationGraphProvider.hasSourceArrow(edgeType, virtualSource);
    }

    @Override
    public boolean hasTargetArrow(int edgeType, boolean virtualTarget) {
        return this.relationGraphProvider.hasTargetArrow(edgeType, virtualTarget);
    }

    @Override
    public boolean showEdge(int edgeType) {
        return this.relationGraphProvider.showEdge(edgeType);
    }

    @Override
    public void dispose() {
        this.relationGraphProvider.dispose();
    }
}

