/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.lib.dataviews.view.jfaceviewer.tree;

import com.arcway.cockpit.frame.client.lib.dataviews.view.jfaceviewer.tree.ITreeDataViewStateModelAccessProvider;
import com.arcway.cockpit.frame.client.lib.dataviews.view.jfaceviewer.tree.ITreeDataViewStateSerialisationHelperProvider;
import com.arcway.cockpit.frame.client.lib.dataviews.view.jfaceviewer.tree.TreeDataViewState;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.ui.IMemento;

public class TreeDataViewStatesStore<ContentType> {
    private static final String TAG_PROJECT_UID = "projectUID";
    private static final String TAG_TREE_STATE = "treeState";
    private final Map<String, TreeDataViewState<ContentType>> treeStatesMap;
    private final Map<String, IMemento> mementoMap;
    private final ITreeDataViewStateSerialisationHelperProvider<ContentType> serialisationHelperProvider;
    private final ITreeDataViewStateModelAccessProvider<ContentType> modelAccessProvider;

    public TreeDataViewStatesStore(ITreeDataViewStateSerialisationHelperProvider<ContentType> serialisationHelperProvider, ITreeDataViewStateModelAccessProvider<ContentType> modelAccessProvider) {
        this.serialisationHelperProvider = serialisationHelperProvider;
        this.modelAccessProvider = modelAccessProvider;
        this.treeStatesMap = new HashMap<String, TreeDataViewState<ContentType>>();
        this.mementoMap = new HashMap<String, IMemento>();
    }

    public void init(IMemento memento) {
        if (memento != null) {
            IMemento[] stores;
            IMemento[] iMementoArray = stores = memento.getChildren(TAG_TREE_STATE);
            int n = stores.length;
            int n2 = 0;
            while (n2 < n) {
                IMemento store = iMementoArray[n2];
                try {
                    this.mementoMap.put(store.getString(TAG_PROJECT_UID), store);
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                ++n2;
            }
        }
    }

    public void saveState(IMemento memento) {
        if (memento != null) {
            String projectUID;
            for (Map.Entry<String, TreeDataViewState<ContentType>> entry : this.treeStatesMap.entrySet()) {
                projectUID = entry.getKey();
                TreeDataViewState<ContentType> state = entry.getValue();
                IMemento treeStateMemento = memento.createChild(TAG_TREE_STATE);
                treeStateMemento.putString(TAG_PROJECT_UID, projectUID);
                state.saveState(treeStateMemento, this.serialisationHelperProvider.getTreeDataViewStateSerialisationHelperWO(projectUID));
            }
            for (Map.Entry<String, TreeDataViewState<ContentType>> entry : this.mementoMap.entrySet()) {
                projectUID = entry.getKey();
                IMemento oldStateMemento = (IMemento)entry.getValue();
                IMemento newStateMemento = memento.createChild(TAG_TREE_STATE);
                newStateMemento.putString(TAG_PROJECT_UID, projectUID);
                TreeDataViewState.copyMemento(oldStateMemento, newStateMemento, this.serialisationHelperProvider.getTreeDataViewStateSerialisationHelperWO(projectUID));
            }
        }
    }

    public TreeDataViewState<ContentType> getTreeState(String projectUID) {
        TreeDataViewState<ContentType> state = this.treeStatesMap.get(projectUID);
        if (state == null) {
            IMemento memento = this.mementoMap.get(projectUID);
            if (memento != null) {
                state = new TreeDataViewState<ContentType>(memento, this.serialisationHelperProvider.getTreeDataViewStateSerialisationHelper(projectUID), this.modelAccessProvider.getTreeDataViewStateModelAccess(projectUID));
                this.mementoMap.remove(projectUID);
            } else {
                state = new TreeDataViewState();
            }
            this.treeStatesMap.put(projectUID, state);
        } else {
            state.checkState(this.modelAccessProvider.getTreeDataViewStateModelAccess(projectUID));
        }
        return state;
    }
}

