/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.lib.dataviews.view.jfaceviewer.tree;

import com.arcway.cockpit.frame.client.global.FramePlugin;
import com.arcway.cockpit.frame.client.lib.dataviews.actions.AbstractModuleAction;
import com.arcway.cockpit.frame.client.lib.dataviews.messages.Messages;
import com.arcway.cockpit.frame.client.lib.dataviews.view.jfaceviewer.IDataViewLabelProvider;
import com.arcway.cockpit.frame.client.lib.dataviews.view.jfaceviewer.JFaceViewerDataViewProvider;
import com.arcway.cockpit.frame.client.lib.dataviews.view.jfaceviewer.tree.IColumnDescription;
import com.arcway.cockpit.frame.client.lib.dataviews.view.jfaceviewer.tree.ITreeDataViewLabelProvider;
import com.arcway.cockpit.frame.client.lib.dataviews.view.jfaceviewer.tree.ITreeDataViewStateSerialisationHelperProvider;
import com.arcway.cockpit.frame.client.lib.dataviews.view.jfaceviewer.tree.TreeDataView;
import com.arcway.cockpit.frame.client.lib.dataviews.view.jfaceviewer.tree.TreeDataViewSorter;
import com.arcway.lib.java.EitherOr;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.ui.IWorkbenchPart;

public abstract class TreeDataViewProvider<ContentType>
extends JFaceViewerDataViewProvider<ContentType> {
    private final TreeDataView<ContentType> dataView;
    private final IAction sortingModeAction;
    private ITreeDataViewLabelProvider labelProvider;

    public TreeDataViewProvider(TreeDataView<ContentType> dataView) {
        super(dataView);
        this.dataView = dataView;
        this.sortingModeAction = this.createSortingModeAction();
    }

    @Override
    protected final IDataViewLabelProvider createLabelProvider() {
        return this.getLabelProvider();
    }

    public ITreeDataViewLabelProvider getLabelProvider() {
        if (this.labelProvider == null) {
            this.labelProvider = this.createTreeLabelProvider();
        }
        return this.labelProvider;
    }

    protected abstract ITreeDataViewLabelProvider createTreeLabelProvider();

    @Override
    public List<EitherOr<IAction, IContributionItem>> getAdditionalViewMenuActions() {
        ArrayList<EitherOr<IAction, IContributionItem>> viewMenuActions = new ArrayList<EitherOr<IAction, IContributionItem>>(super.getAdditionalViewMenuActions());
        AbstractModuleAction customiseColumnsAction = new AbstractModuleAction(){

            public void run() {
                TreeDataViewProvider.this.dataView.handleCustomiseColumnsActionSelected();
            }

            @Override
            protected void handleSelectionChanged(IWorkbenchPart part, ISelection selection) {
            }

            @Override
            protected void handleProjectChanged(String newProjectUID) {
                this.setEnabled(newProjectUID != null);
            }
        };
        String label = Messages.getString("TreeDataView.CustomiseColumnsAction.Label");
        customiseColumnsAction.setText(label);
        customiseColumnsAction.setToolTipText(label);
        viewMenuActions.add((EitherOr<IAction, IContributionItem>)new EitherOr.Either((Object)customiseColumnsAction));
        viewMenuActions.add((EitherOr<IAction, IContributionItem>)new EitherOr.Or((Object)new Separator("com.arcway.cockpit.dataview.viewmenu.customisecolumns.separator")));
        return viewMenuActions;
    }

    @Override
    public List<? extends IAction> getAdditionalToolbarActions() {
        ArrayList<IAction> toolbarActions = new ArrayList<IAction>(super.getAdditionalToolbarActions());
        if (this.hasNaturalOrder()) {
            toolbarActions.add(this.sortingModeAction);
        }
        return toolbarActions;
    }

    public final IAction getSortingModeAction() {
        return this.sortingModeAction;
    }

    public abstract Collection<IColumnDescription> getColumnDescriptions(String var1);

    public abstract KeyListener createKeyListener();

    public abstract boolean hasNaturalOrder();

    public abstract TreeDataViewSorter<ContentType> getSorter(String var1);

    public abstract ITreeDataViewStateSerialisationHelperProvider<ContentType> getTreeDataViewStateSerialisationHelperProvider();

    private IAction createSortingModeAction() {
        Action sortingModeAction_ = new Action("", 2){

            public void run() {
                TreeDataViewProvider.this.dataView.handleSortingModeActionSelected();
            }
        };
        sortingModeAction_.setImageDescriptor(FramePlugin.getImageDescriptor("dataview", "naturalordersorting.gif"));
        sortingModeAction_.setToolTipText(Messages.getString("TreeDataView.NaturalOrderSortingAction.Tooltip"));
        return sortingModeAction_;
    }
}

