/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.lib.dataviews.view.jfaceviewer.tree;

import com.arcway.cockpit.frame.client.lib.dataviews.view.jfaceviewer.IDataViewContentProvider;
import com.arcway.cockpit.frame.client.lib.dataviews.view.jfaceviewer.JFaceViewerDataView;
import com.arcway.cockpit.frame.client.lib.dataviews.view.jfaceviewer.JFaceViewerDataViewProvider;
import com.arcway.cockpit.frame.client.lib.dataviews.view.jfaceviewer.tree.CachingTreeDataViewStateModelAccessProvider;
import com.arcway.cockpit.frame.client.lib.dataviews.view.jfaceviewer.tree.CustomiseColumnsDialogue;
import com.arcway.cockpit.frame.client.lib.dataviews.view.jfaceviewer.tree.IColumnDescription;
import com.arcway.cockpit.frame.client.lib.dataviews.view.jfaceviewer.tree.IDataViewColumnComparator;
import com.arcway.cockpit.frame.client.lib.dataviews.view.jfaceviewer.tree.IDataViewSortingState;
import com.arcway.cockpit.frame.client.lib.dataviews.view.jfaceviewer.tree.ITreeDataViewHierarchy;
import com.arcway.cockpit.frame.client.lib.dataviews.view.jfaceviewer.tree.ITreeDataViewLabelProvider;
import com.arcway.cockpit.frame.client.lib.dataviews.view.jfaceviewer.tree.ITreeDataViewStateModelAccess;
import com.arcway.cockpit.frame.client.lib.dataviews.view.jfaceviewer.tree.ITreeDataViewStateModelAccessProvider;
import com.arcway.cockpit.frame.client.lib.dataviews.view.jfaceviewer.tree.TreeContentProvider;
import com.arcway.cockpit.frame.client.lib.dataviews.view.jfaceviewer.tree.TreeDataViewProvider;
import com.arcway.cockpit.frame.client.lib.dataviews.view.jfaceviewer.tree.TreeDataViewSorter;
import com.arcway.cockpit.frame.client.lib.dataviews.view.jfaceviewer.tree.TreeDataViewState;
import com.arcway.cockpit.frame.client.lib.dataviews.view.jfaceviewer.tree.TreeDataViewStatesStore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;

public abstract class TreeDataView<ContentType>
extends JFaceViewerDataView<ContentType>
implements IDataViewSortingState {
    private static final String TREE_STATES_TAG = "TreeStates";
    private TreeDataViewProvider<ContentType> dataViewProvider;
    private Composite parent;
    private TreeViewer viewer;
    private final StackLayout parentLayout = new StackLayout();
    private ITreeDataViewHierarchy hierarchy;
    private TreeDataViewStatesStore<ContentType> dataViewStatesStore;
    private TreeDataViewState<ContentType> currentDataViewState;
    private ITreeDataViewStateModelAccessProvider<ContentType> treeDataViewStateModelAccessProvider;
    private IAction sortingModeAction;
    private TreeDataViewSorter<ContentType> sorter;
    private ITreeDataViewLabelProvider labelProvider;
    private List<TreePath> expandedTreePathsBeforeRefresh;
    private List<TreePath> expandedTreePathsBeforeFilterChange;
    private List<TreePath> filteredExpandedTreePaths = new ArrayList<TreePath>();

    @Override
    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        this.treeDataViewStateModelAccessProvider = new CachingTreeDataViewStateModelAccessProvider(new ITreeDataViewStateModelAccessProvider<ContentType>(){

            @Override
            public ITreeDataViewStateModelAccess<ContentType> getTreeDataViewStateModelAccess(final String projectUID) {
                return new ITreeDataViewStateModelAccess<ContentType>(){

                    @Override
                    public boolean itemExists(ContentType dataItem) {
                        return TreeDataView.this.getTreeDataViewHierarchy().itemExists(dataItem, projectUID);
                    }

                    @Override
                    public boolean isChildOfParent(ContentType parent_, ContentType child) {
                        return TreeDataView.this.getTreeDataViewHierarchy().getChildren(parent_, TreeDataView.this.viewer.getFilters(), (Viewer)TreeDataView.this.viewer, projectUID).contains(child);
                    }
                };
            }
        });
        this.dataViewStatesStore = new TreeDataViewStatesStore<ContentType>(this.dataViewProvider.getTreeDataViewStateSerialisationHelperProvider(), this.treeDataViewStateModelAccessProvider);
        if (memento != null) {
            this.dataViewStatesStore.init(memento.getChild(TREE_STATES_TAG));
        }
    }

    @Override
    protected void createPermanentParts() {
        super.createPermanentParts();
        this.sortingModeAction = this.dataViewProvider.getSortingModeAction();
        this.labelProvider = this.dataViewProvider.getLabelProvider();
        this.retrieveDataViewState(null);
    }

    @Override
    public void createPartControl(Composite parent_) {
        super.createPartControl(parent_);
        this.applySortingState();
    }

    @Override
    protected void setViewerContents(String projectUID) {
        super.setViewerContents(projectUID);
        this.applyTreeState();
    }

    @Override
    public void callbackBeforeRefreshOfViewer() {
        super.callbackBeforeRefreshOfViewer();
        this.expandedTreePathsBeforeRefresh = new ArrayList<TreePath>();
        this.expandedTreePathsBeforeRefresh.addAll(Arrays.asList(this.viewer.getExpandedTreePaths()));
    }

    @Override
    public void callbackAfterRefreshOfViewer() {
        ArrayList<TreePath> newExpandedTreePaths = new ArrayList<TreePath>();
        for (TreePath treePath : this.expandedTreePathsBeforeRefresh) {
            if (!TreeDataViewState.checkTreePath(treePath, this.treeDataViewStateModelAccessProvider.getTreeDataViewStateModelAccess(this.getCurrentlyAssociatedProject()))) continue;
            newExpandedTreePaths.add(treePath);
        }
        this.viewer.setExpandedTreePaths(newExpandedTreePaths.toArray(new TreePath[newExpandedTreePaths.size()]));
        this.expandedTreePathsBeforeRefresh = null;
        super.callbackAfterRefreshOfViewer();
    }

    @Override
    protected void callbackBeforeChangeOfFilterSettings() {
        this.expandedTreePathsBeforeFilterChange = new ArrayList<TreePath>();
        this.expandedTreePathsBeforeFilterChange.addAll(Arrays.asList(this.viewer.getExpandedTreePaths()));
    }

    @Override
    protected void callbackAfterChangeOfFilterSettings() {
        ArrayList<TreePath> potentiallyExpandedTreePaths = new ArrayList<TreePath>(this.expandedTreePathsBeforeFilterChange);
        potentiallyExpandedTreePaths.addAll(this.filteredExpandedTreePaths);
        ArrayList<TreePath> treePathsToBeExpanded = new ArrayList<TreePath>();
        this.filteredExpandedTreePaths = new ArrayList<TreePath>();
        for (TreePath treePath : potentiallyExpandedTreePaths) {
            if (!TreeDataViewState.checkTreePath(treePath, this.treeDataViewStateModelAccessProvider.getTreeDataViewStateModelAccess(this.getCurrentlyAssociatedProject()))) continue;
            if (this.applyFilters(Collections.singleton(treePath.getLastSegment())).isEmpty() || !this.hasUnfilteredChildren(treePath.getLastSegment())) {
                this.filteredExpandedTreePaths.add(treePath);
                continue;
            }
            treePathsToBeExpanded.add(treePath);
        }
        this.viewer.setExpandedTreePaths(treePathsToBeExpanded.toArray(new TreePath[treePathsToBeExpanded.size()]));
        this.expandedTreePathsBeforeFilterChange = null;
    }

    private boolean hasUnfilteredChildren(Object element) {
        Object[] objectArray = this.contentProvider.getChildren(element);
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object child = objectArray[n2];
            if (!this.applyFilters(Collections.singleton(child)).isEmpty()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public void saveState(IMemento p_memento) {
        super.saveState(p_memento);
        this.writeBackDataViewState(this.getCurrentlyAssociatedProject());
        this.dataViewStatesStore.saveState(p_memento.createChild(TREE_STATES_TAG));
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.sorter != null) {
            this.sorter.destroyInternalStructure();
        }
    }

    @Override
    protected final StructuredViewer createJFaceViewer(Composite p_parent, String projectUID, boolean exchangingViewer) {
        this.parent = p_parent;
        if (!exchangingViewer) {
            p_parent.setLayout((Layout)this.parentLayout);
        }
        p_parent.pack();
        final TreeViewer treeViewer = new TreeViewer(p_parent, 68354);
        treeViewer.setUseHashlookup(true);
        Tree tree = treeViewer.getTree();
        tree.setLinesVisible(true);
        tree.setHeaderVisible(true);
        this.parentLayout.topControl = tree;
        SelectionAdapter headerListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (treeViewer.getControl().isDisposed()) {
                    return;
                }
                int column = treeViewer.getTree().indexOf((TreeColumn)e.widget);
                TreeDataView.this.handleColumnHeaderSelected(column);
            }
        };
        for (String columnID : this.currentDataViewState.getShownColumnsInDefaultOrder()) {
            TreeColumn column = new TreeColumn(tree, 16384);
            String label = this.currentDataViewState.getColumnName(columnID);
            if (label == null) {
                label = "";
            }
            column.setText(label);
            column.setToolTipText(label);
            column.setWidth(this.currentDataViewState.getColumnWidth(columnID));
            if (projectUID != null) {
                column.addSelectionListener((SelectionListener)headerListener);
            }
            if (this.currentDataViewState.getColumnIndex(columnID) == 0) {
                column.setMoveable(false);
                continue;
            }
            column.setMoveable(true);
        }
        tree.setColumnOrder(this.currentDataViewState.getInitialPositionPermutation());
        this.labelProvider.setCurrentColumnOrder(this.currentDataViewState.getShownColumnsInDefaultOrder());
        this.sorter = projectUID != null ? this.dataViewProvider.getSorter(projectUID) : null;
        treeViewer.setSorter(this.sorter);
        KeyListener keyListener = this.dataViewProvider.createKeyListener();
        if (keyListener != null) {
            tree.addKeyListener(keyListener);
        }
        this.viewer = treeViewer;
        if (!this.dataViewProvider.hasNaturalOrder()) {
            this.currentDataViewState.setSortingMode(2);
        }
        this.applySortingState();
        return treeViewer;
    }

    @Override
    protected void callbackBeforeExchangeOfViewer(String oldProjectUID, String newProjectUID) {
        this.writeBackDataViewState(oldProjectUID);
        this.retrieveDataViewState(newProjectUID);
        if (this.sorter != null) {
            this.sorter.destroyInternalStructure();
        }
        super.callbackBeforeExchangeOfViewer(oldProjectUID, newProjectUID);
    }

    public <T> List<T> applySorters(Collection<? extends T> input) {
        ArrayList<? extends T> sortedInput = new ArrayList<T>(input);
        Collections.sort(sortedInput, new Comparator<Object>(){

            @Override
            public int compare(Object arg0, Object arg1) {
                return TreeDataView.this.viewer.getSorter().compare((Viewer)TreeDataView.this.viewer, arg0, arg1);
            }
        });
        return sortedInput;
    }

    @Override
    public void selectAll() {
        this.viewer.getTree().selectAll();
    }

    @Override
    public void deselectAll() {
        this.viewer.getTree().deselectAll();
    }

    @Override
    public int getSortingMode() {
        return this.currentDataViewState.getSortingMode();
    }

    @Override
    public int getColumnCount() {
        return this.currentDataViewState.getShownColumnCount();
    }

    @Override
    public IDataViewColumnComparator getComparator(int sortingPriority) {
        return this.currentDataViewState.getColumnComparator(this.currentDataViewState.getColumnBySortingPriority(sortingPriority));
    }

    @Override
    public int getSortingDirection(int sortingPriority) {
        return this.currentDataViewState.getColumnSortingDirection(this.currentDataViewState.getColumnBySortingPriority(sortingPriority));
    }

    public void applyTreeState() {
        this.viewer.setExpandedTreePaths(this.currentDataViewState.getInitiallyExpandedItems());
        if (this.currentDataViewState.getInitiallySelectedItems() instanceof IStructuredSelection) {
            this.setSelectionInViewer(((IStructuredSelection)this.currentDataViewState.getInitiallySelectedItems()).toList(), false);
        } else {
            this.setSelectionInViewer(null, false);
        }
        this.filteredExpandedTreePaths = this.currentDataViewState.getFilteredExpandedItems();
    }

    private void applySortingState() {
        this.sortingModeAction.setChecked(this.currentDataViewState.getSortingMode() == 2);
        if (this.currentDataViewState.getSortingMode() == 2) {
            String sortingFirstPriorityColumn = this.currentDataViewState.getColumnBySortingPriority(0);
            this.viewer.getTree().setSortColumn(this.viewer.getTree().getColumn(this.currentDataViewState.getColumnIndex(sortingFirstPriorityColumn)));
            int sortingDirection = this.currentDataViewState.getColumnSortingDirection(sortingFirstPriorityColumn);
            this.viewer.getTree().setSortDirection(sortingDirection == 1 ? 1024 : 128);
        } else {
            this.viewer.getTree().setSortDirection(0);
        }
    }

    private void retrieveDataViewState(String projectUID) {
        this.currentDataViewState = projectUID != null ? this.dataViewStatesStore.getTreeState(projectUID) : new TreeDataViewState();
        Collection<IColumnDescription> columnDescriptions = this.dataViewProvider.getColumnDescriptions(projectUID);
        this.currentDataViewState.startUsage(columnDescriptions, 1);
    }

    private void writeBackDataViewState(String projectUID) {
        int index = 0;
        for (String columnID : this.currentDataViewState.getShownColumnsInDefaultOrder()) {
            this.currentDataViewState.setColumnWidth(columnID, this.viewer.getTree().getColumn(index).getWidth());
            ++index;
        }
        this.currentDataViewState.stopUsage(this.viewer.getSelection(), this.viewer.getExpandedTreePaths(), this.viewer.getTree().getColumnOrder(), this.filteredExpandedTreePaths);
    }

    public String getAdditionalStateInformation(String key) {
        return this.currentDataViewState.getAdditionalStateInformation(key);
    }

    public void setAdditionalStateInformation(String key, String stateInformation) {
        this.currentDataViewState.setAdditionalStateInformation(key, stateInformation);
    }

    public void handleColumnHeaderSelected(int column) {
        assert (column >= 0 && column < this.currentDataViewState.getColumnCount()) : "Column index out of bounds";
        String columnID = this.currentDataViewState.getColumnByIndex(column);
        if (this.currentDataViewState.isSortingOrderFirstPriorityColumn(columnID)) {
            if (this.currentDataViewState.getSortingMode() == 2) {
                this.currentDataViewState.setColumnSortingDirection(columnID, this.currentDataViewState.getColumnSortingDirection(columnID) * -1);
            }
        } else if (this.currentDataViewState.getColumnComparator(columnID) != null) {
            this.currentDataViewState.setSortingOrderFirstPriorityColumn(columnID);
        }
        this.currentDataViewState.setSortingMode(2);
        this.applySortingState();
        this.refreshOfViewerRequired(false, null);
    }

    protected final void handleSortingModeActionSelected() {
        if (this.currentDataViewState.getSortingMode() == 2) {
            this.currentDataViewState.setSortingMode(1);
        } else {
            this.currentDataViewState.setSortingMode(2);
        }
        this.applySortingState();
        this.refreshOfViewerRequired(false, null);
    }

    protected final synchronized void handleCustomiseColumnsActionSelected() {
        CustomiseColumnsDialogue dialogue = new CustomiseColumnsDialogue(this.currentDataViewState, this.parent.getShell());
        if (dialogue.open() == 0) {
            this.exchangeOfViewerRequired();
        }
    }

    @Override
    protected final IDataViewContentProvider createContentProvider() {
        ITreeDataViewHierarchy hierarchy_ = this.getTreeDataViewHierarchy();
        return new TreeContentProvider(hierarchy_);
    }

    private ITreeDataViewHierarchy getTreeDataViewHierarchy() {
        if (this.hierarchy == null) {
            this.hierarchy = this.createTreeDataViewHierarchy();
        }
        return this.hierarchy;
    }

    protected abstract ITreeDataViewHierarchy createTreeDataViewHierarchy();

    protected abstract TreeDataViewProvider<ContentType> createTreeDataViewProvider();

    @Override
    protected final JFaceViewerDataViewProvider<ContentType> createJFaceViewerDataViewProvider() {
        this.dataViewProvider = this.createTreeDataViewProvider();
        return this.dataViewProvider;
    }
}

