/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.lib.dataviews.view.jfaceviewer.tree;

import com.arcway.cockpit.frame.client.lib.dataviews.view.jfaceviewer.IDataViewContentProvider;
import com.arcway.cockpit.frame.client.lib.dataviews.view.jfaceviewer.tree.ITreeDataViewHierarchy;
import java.util.List;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;

public class TreeContentProvider
implements IDataViewContentProvider,
ITreeContentProvider {
    private final ITreeDataViewHierarchy hierarchyProvider;
    private TreeViewer viewer;
    private String projectUID;

    public TreeContentProvider(ITreeDataViewHierarchy hierarchyProvider) {
        this.hierarchyProvider = hierarchyProvider;
    }

    @Override
    public void inputChanged(Viewer viewer_, Object oldInput, Object newInput) {
        this.projectUID = (String)newInput;
        this.viewer = (TreeViewer)viewer_;
    }

    @Override
    public Object[] getElements(Object inputElement) {
        if (this.projectUID != null) {
            return this.hierarchyProvider.getRootItems(this.projectUID).toArray();
        }
        return null;
    }

    @Override
    public boolean itemExists(Object element) {
        if (this.projectUID != null) {
            return this.hierarchyProvider.itemExists(element, this.projectUID);
        }
        return false;
    }

    @Override
    public Object[] getChildren(Object parentElement) {
        if (this.projectUID != null) {
            return this.hierarchyProvider.getChildren(parentElement, this.viewer.getFilters(), (Viewer)this.viewer, this.projectUID).toArray();
        }
        return null;
    }

    @Override
    public Object getParent(Object element) {
        if (this.projectUID != null) {
            List<?> parents = this.hierarchyProvider.getParents(element, this.projectUID);
            if (parents != null && parents.size() == 1) {
                return parents.get(0);
            }
            return null;
        }
        return null;
    }

    @Override
    public List<?> getParents(Object element) {
        if (this.projectUID != null) {
            return this.hierarchyProvider.getParents(element, this.projectUID);
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        if (this.projectUID != null) {
            return this.hierarchyProvider.hasChildren(element, this.viewer.getFilters(), (Viewer)this.viewer, this.projectUID);
        }
        return false;
    }

    public void dispose() {
    }
}

