/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.lib.dataviews.view.jfaceviewer.tree;

import com.arcway.cockpit.frame.client.lib.dataviews.messages.Messages;
import com.arcway.cockpit.frame.client.lib.dataviews.view.jfaceviewer.tree.TreeDataViewState;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class CustomiseColumnsDialogue
extends TitleAreaDialog {
    private final TreeDataViewState<?> dataViewState;
    private Map<String, Button> map_columnID_checkBox;

    public CustomiseColumnsDialogue(TreeDataViewState<?> dataViewState, Shell shell) {
        super(shell);
        this.dataViewState = dataViewState;
    }

    protected boolean isResizable() {
        return true;
    }

    protected Control createDialogArea(Composite parent) {
        parent.getShell().setText(Messages.getString("TreeDataView.CustomiseColumnsDialogue.Title"));
        this.setTitle(Messages.getString("TreeDataView.CustomiseColumnsDialogue.Title"));
        this.setMessage(Messages.getString("TreeDataView.CustomiseColumnsDialogue.Message"));
        ScrolledComposite scrollableComposite = new ScrolledComposite(parent, 768);
        scrollableComposite.setExpandHorizontal(true);
        scrollableComposite.setExpandVertical(true);
        scrollableComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite baseComposite = new Composite((Composite)scrollableComposite, 0);
        scrollableComposite.setContent((Control)baseComposite);
        baseComposite.setLayout((Layout)new GridLayout());
        Group visibilityGroup = new Group(baseComposite, 32);
        visibilityGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        visibilityGroup.setLayout((Layout)new GridLayout());
        visibilityGroup.setText(Messages.getString("TreeDataView.CustomiseColumnsDialogue.VisibilityGroup.Title"));
        this.map_columnID_checkBox = new HashMap<String, Button>();
        boolean first = true;
        for (String columnID : this.dataViewState.getAllColumnsInDefaultOrder()) {
            Button checkBox = new Button((Composite)visibilityGroup, 32);
            String label = this.dataViewState.getColumnName(columnID);
            if (label == null || label.trim().length() == 0) {
                label = this.dataViewState.getColumnDescription(columnID);
            }
            checkBox.setText(label);
            checkBox.setSelection(this.dataViewState.isColumnShown(columnID));
            if (first) {
                checkBox.setEnabled(false);
                first = false;
            }
            this.map_columnID_checkBox.put(columnID, checkBox);
        }
        scrollableComposite.setMinSize(baseComposite.computeSize(-1, -1));
        return scrollableComposite;
    }

    protected void okPressed() {
        for (Map.Entry<String, Button> entry : this.map_columnID_checkBox.entrySet()) {
            if (!(this.dataViewState.isColumnShown(entry.getKey()) ^ entry.getValue().getSelection())) continue;
            this.dataViewState.setColumnShown(entry.getKey(), entry.getValue().getSelection());
        }
        super.okPressed();
    }
}

