/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.lib.dataviews.view.jfaceviewer;

import com.arcway.cockpit.cockpitlib.client.filter.AbstractFilter;
import com.arcway.cockpit.cockpitlib.client.filter.gui.IFilterItem;
import com.arcway.cockpit.frame.client.lib.dataviews.filters.FilterDialog;
import com.arcway.cockpit.frame.client.lib.dataviews.filters.FilterStore;
import com.arcway.cockpit.frame.client.lib.dataviews.messages.Messages;
import com.arcway.cockpit.frame.client.lib.dataviews.search.SearchFilter;
import com.arcway.cockpit.frame.client.lib.dataviews.util.IModuleProjectSwitchListener;
import com.arcway.cockpit.frame.client.lib.dataviews.view.AbstractDataView;
import com.arcway.cockpit.frame.client.lib.dataviews.view.IDataViewProvider;
import com.arcway.cockpit.frame.client.lib.dataviews.view.jfaceviewer.IDataViewContentProvider;
import com.arcway.cockpit.frame.client.lib.dataviews.view.jfaceviewer.IDataViewLabelProvider;
import com.arcway.cockpit.frame.client.lib.dataviews.view.jfaceviewer.JFaceViewerDataViewProvider;
import com.arcway.lib.eclipse.gui.viewers.filters.ViewerFilterMultiplexer;
import com.arcway.lib.eclipse.resources.ResourceDisposer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.PartInitException;

public abstract class JFaceViewerDataView<ContentType>
extends AbstractDataView<ContentType> {
    private static final String MEMENTO_TYPE_FILTERS = "Filters";
    private static final Color FILTER_DESCRIPTION_COLOR = new Color((Device)Display.getDefault(), 252, 211, 150);
    private static final Color INCOMPLETESELECTION_DESCRIPTION_COLOR;
    private static final int MAX_NUMBER_OF_SELECTED_TREEITEMS = 25;
    private JFaceViewerDataViewProvider<ContentType> dataViewProvider;
    protected IDataViewContentProvider contentProvider;
    protected IDataViewLabelProvider labelProvider;
    private StructuredViewer viewer = null;
    private ViewerFilterMultiplexer filterMultiplexer;
    private String filterDescriptionKey;
    private String dialogFilterContributorID;
    private List<IFilterItem> fixFilterItems;
    private List<IFilterItem> filterItems;
    private Collection<AbstractFilter> filters;
    private boolean isFilteringSwitchedOn = true;
    private FilterStore filterStore;
    private FilterDialog filterDialog;
    private IAction filterAction;
    private String searchFilterContributorID;
    private SearchFilter searchFilter;
    private IOpenListener openListener;
    private Set<Object> selectedElementsAfterRefresh;
    private Set<Object> explicitSelectionAfterRefresh;
    private String incompleteSelectionDescriptionKey;

    static {
        ResourceDisposer.markResourceAsSingleton((Resource)FILTER_DESCRIPTION_COLOR);
        INCOMPLETESELECTION_DESCRIPTION_COLOR = new Color((Device)Display.getDefault(), 149, 210, 255);
        ResourceDisposer.markResourceAsSingleton((Resource)INCOMPLETESELECTION_DESCRIPTION_COLOR);
    }

    @Override
    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        this.filterStore = new FilterStore();
        this.filterStore.init(memento != null ? memento.getChild(MEMENTO_TYPE_FILTERS) : null);
        this.filterDescriptionKey = null;
    }

    @Override
    protected void createPermanentParts() {
        super.createPermanentParts();
        this.createFilters();
        this.filterAction = this.dataViewProvider.getFilterAction();
        this.labelProvider = this.dataViewProvider.createLabelProvider();
        if (this.labelProvider instanceof IModuleProjectSwitchListener) {
            this.registerProjectSwitchListener((IModuleProjectSwitchListener)((Object)this.labelProvider));
        }
        this.contentProvider = this.createContentProvider();
        this.createSearchAgents();
        this.openListener = this.dataViewProvider.createOpenListener();
    }

    public void saveState(IMemento memento) {
        super.saveState(memento);
        if (memento != null) {
            IMemento localFilterMemento = memento.createChild(MEMENTO_TYPE_FILTERS);
            this.filterStore.saveAndFinalise(localFilterMemento);
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.labelProvider instanceof IModuleProjectSwitchListener) {
            this.deregisterProjectSwitchListener((IModuleProjectSwitchListener)((Object)this.labelProvider));
        }
    }

    private boolean isFiltering() {
        if (this.searchFilter.isFilteringAnything()) {
            return true;
        }
        if (this.isFilteringSwitchedOn && this.filters != null) {
            for (AbstractFilter filter : this.filters) {
                if (!filter.isActive()) continue;
                return true;
            }
        }
        return false;
    }

    public <T> Set<T> applyFilters(Collection<? extends T> input) {
        HashSet<T> filteredInput = new HashSet<T>();
        ViewerFilter[] dataViewFilters = this.viewer.getFilters();
        for (T item : input) {
            Object parent = this.contentProvider instanceof ITreeContentProvider ? ((ITreeContentProvider)this.contentProvider).getParent(item) : null;
            boolean passesFilters = true;
            ViewerFilter[] viewerFilterArray = dataViewFilters;
            int n = dataViewFilters.length;
            int n2 = 0;
            while (n2 < n) {
                ViewerFilter dataViewFilter = viewerFilterArray[n2];
                ViewerFilter filter = dataViewFilter;
                if (!filter.select((Viewer)this.viewer, parent, item)) {
                    passesFilters = false;
                    break;
                }
                ++n2;
            }
            if (!passesFilters) continue;
            filteredInput.add(item);
        }
        return filteredInput;
    }

    @Override
    protected final Control createViewer(Composite p_parent, String newProjectUID, boolean exchangingViewer) {
        this.viewer = this.createJFaceViewer(p_parent, newProjectUID, exchangingViewer);
        this.viewer.setContentProvider((IContentProvider)this.contentProvider);
        this.viewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.configureFilterItemsAndFilters(newProjectUID);
        this.filterAction.setChecked(this.isFilteringSwitchedOn);
        if (newProjectUID != null) {
            this.filterMultiplexer = new ViewerFilterMultiplexer(this.viewer, this.dataViewProvider.isRetainingTreeStructuresWhenFiltering());
            this.searchFilterContributorID = this.filterMultiplexer.registerContributor();
            this.dialogFilterContributorID = this.filterMultiplexer.registerContributor();
            this.filterMultiplexer.suspendViewerUpdates();
            if (this.dataViewProvider.hasIncrementalSearch()) {
                this.searchFilter.resetSearchResult();
                this.filterMultiplexer.addFilter(this.searchFilterContributorID, (ViewerFilter)this.searchFilter);
            }
            if (this.isFilteringSwitchedOn) {
                this.filterMultiplexer.setFilters(this.dialogFilterContributorID, this.filters);
            }
            this.filterMultiplexer.resumeViewerUpdates();
            if (this.openListener != null) {
                this.viewer.addOpenListener(this.openListener);
            }
        }
        ((Tree)this.viewer.getControl()).addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JFaceViewerDataView.this.setIncompleteSelectionDescription(false);
            }
        });
        return this.viewer.getControl();
    }

    protected abstract StructuredViewer createJFaceViewer(Composite var1, String var2, boolean var3);

    @Override
    protected void callbackBeforeExchangeOfViewer(String oldProjectUID, String newProjectUID) {
        if (oldProjectUID != null) {
            this.viewer.setInput(null);
            this.filterMultiplexer.suspendViewerUpdates();
            this.filterStore.saveFilterSettings(oldProjectUID, this.filters, this.isFilteringSwitchedOn);
            this.filterMultiplexer.resetFilters(this.dialogFilterContributorID);
            this.filterMultiplexer.resetFilters(this.searchFilterContributorID);
            this.filterMultiplexer.resumeViewerUpdates();
            this.filterMultiplexer = null;
            if (this.openListener != null) {
                this.viewer.removeOpenListener(this.openListener);
            }
        }
    }

    @Override
    protected void callbackAfterExchangeOfViewer(String oldProjectUID, String newProjectUID) {
    }

    @Override
    public final void refreshViewer() {
        this.callbackBeforeRefreshOfViewer();
        this.viewer.refresh();
        this.callbackAfterRefreshOfViewer();
    }

    protected void callbackBeforeRefreshOfViewer() {
        this.selectedElementsAfterRefresh = new HashSet<Object>(((IStructuredSelection)this.viewer.getSelection()).toList());
        this.setSelectionInViewer(null, false);
        if (this.filterMultiplexer != null) {
            this.filterMultiplexer.resetCaches();
        }
    }

    protected void callbackAfterRefreshOfViewer() {
        Set<Object> elementsToReveal = Collections.emptySet();
        if (this.explicitSelectionAfterRefresh != null) {
            this.selectedElementsAfterRefresh = new HashSet<Object>(this.explicitSelectionAfterRefresh.size());
            elementsToReveal = new HashSet<Object>(this.explicitSelectionAfterRefresh.size());
            for (Object element : this.explicitSelectionAfterRefresh) {
                List<?> parents = this.contentProvider.getParents(element);
                if (parents != null && this.explicitSelectionAfterRefresh.containsAll(parents)) continue;
                this.selectedElementsAfterRefresh.add(element);
                elementsToReveal.add(element);
            }
            this.explicitSelectionAfterRefresh = null;
        }
        HashSet<Object> selectedElementsAfterRefreshCleaned = new HashSet<Object>(this.selectedElementsAfterRefresh.size());
        for (Object element : this.selectedElementsAfterRefresh) {
            if (!this.contentProvider.itemExists(element)) continue;
            selectedElementsAfterRefreshCleaned.add(element);
        }
        for (Object element : elementsToReveal) {
            this.viewer.reveal(element);
        }
        this.setSelectionInViewer(selectedElementsAfterRefreshCleaned, false);
        this.selectedElementsAfterRefresh = null;
    }

    @Override
    protected ISelectionProvider getSelectionProvider() {
        return new ISelectionProvider(){

            public ISelection getSelection() {
                return JFaceViewerDataView.this.viewer.getSelection();
            }

            public void setSelection(ISelection selection) {
                if (selection instanceof IStructuredSelection) {
                    JFaceViewerDataView.this.setSelectionInViewer(((IStructuredSelection)selection).toList(), true);
                } else {
                    JFaceViewerDataView.this.setSelectionInViewer(null, false);
                }
            }

            public void addSelectionChangedListener(ISelectionChangedListener listener) {
                JFaceViewerDataView.this.viewer.addSelectionChangedListener(listener);
            }

            public void removeSelectionChangedListener(ISelectionChangedListener listener) {
                JFaceViewerDataView.this.viewer.removeSelectionChangedListener(listener);
            }
        };
    }

    @Override
    protected void setViewerContents(String projectUID) {
        if (projectUID != null) {
            this.viewer.setInput((Object)projectUID);
        } else {
            this.viewer.setInput(null);
        }
    }

    @Override
    protected final void updateIncrementalSearchResult(Collection<?> searchResult) {
        this.refreshOfViewerRequired(false, null);
        this.callbackBeforeChangeOfFilterSettings();
        Collection<?> postProcessedSearchResult = this.postProcessSearchResult(searchResult);
        this.searchFilter.setSearchResult(postProcessedSearchResult);
        if (this.filterMultiplexer != null) {
            this.filterMultiplexer.updateViewer();
        }
        this.setFilterDescription();
        this.callbackAfterChangeOfFilterSettings();
    }

    protected abstract Collection<?> postProcessSearchResult(Collection<?> var1);

    protected final void setExplicitSelectionAfterRefresh(Collection<?> selection) {
        if (this.explicitSelectionAfterRefresh == null) {
            this.explicitSelectionAfterRefresh = new HashSet(selection);
        } else {
            this.explicitSelectionAfterRefresh.addAll(selection);
        }
    }

    @Override
    public void partActivated(IWorkbenchPartReference part) {
        ISelection selection;
        if (part.getPart(false) == this && this.viewer != null && (selection = this.viewer.getSelection()) instanceof IStructuredSelection) {
            for (Object selectedObject : ((IStructuredSelection)selection).toList()) {
                if (this.contentProvider.itemExists(selectedObject)) continue;
                this.setSelectionInViewer(null, false);
            }
        }
        super.partActivated(part);
    }

    private final void setFilterDescription() {
        if (this.isFiltering()) {
            if (this.filterDescriptionKey == null) {
                this.filterDescriptionKey = this.addDescription(Messages.getString("AbstractDataView.filtered"), Messages.getString("AbstractDataView.filtered.Tooltip"), FILTER_DESCRIPTION_COLOR);
            }
        } else if (this.filterDescriptionKey != null) {
            this.removeDescription(this.filterDescriptionKey);
            this.filterDescriptionKey = null;
        }
    }

    protected final void callbackFilterActionSelected() {
        this.refreshOfViewerRequired(false, null);
        this.callbackBeforeChangeOfFilterSettings();
        if (this.filterAction.isChecked()) {
            this.filterDialog = new FilterDialog(this.getViewSite().getShell(), this.filterItems, this.dataViewProvider.getFilterDialogueTitle(), this.dataViewProvider.getFilterDialogueDescription());
            int returnCode = this.filterDialog.open();
            if (returnCode == 0) {
                this.isFilteringSwitchedOn = true;
                this.filterMultiplexer.setFilters(this.dialogFilterContributorID, this.filters);
            } else {
                this.isFilteringSwitchedOn = false;
                this.filterMultiplexer.resetFilters(this.dialogFilterContributorID);
                this.filterAction.setChecked(false);
            }
        } else {
            this.isFilteringSwitchedOn = false;
            this.filterMultiplexer.resetFilters(this.dialogFilterContributorID);
        }
        this.setFilterDescription();
        this.callbackAfterChangeOfFilterSettings();
    }

    protected abstract void callbackBeforeChangeOfFilterSettings();

    protected abstract void callbackAfterChangeOfFilterSettings();

    private void createFilters() {
        this.fixFilterItems = new ArrayList<IFilterItem>(this.dataViewProvider.createFilterItems());
    }

    private void configureFilterItemsAndFilters(String newProjectUID) {
        if (newProjectUID != null) {
            List<IFilterItem> customPropertyFilterItems = this.dataViewProvider.createProjectSpecificFilterItems(newProjectUID);
            this.filterItems = new ArrayList<IFilterItem>(this.fixFilterItems.size() + customPropertyFilterItems.size());
            this.filterItems.addAll(this.fixFilterItems);
            this.filterItems.addAll(customPropertyFilterItems);
            this.filters = new ArrayList<AbstractFilter>(this.filterItems.size());
            for (IFilterItem filterItem : this.filterItems) {
                this.filters.add(filterItem.getFilter());
            }
            boolean[] isFilteringSwitchedOnReference = new boolean[1];
            this.filterStore.loadFilterSettings(newProjectUID, this.filters, isFilteringSwitchedOnReference);
            this.isFilteringSwitchedOn = isFilteringSwitchedOnReference[0];
        } else {
            this.isFilteringSwitchedOn = false;
            this.filterItems = Collections.emptyList();
            this.filters = Collections.emptySet();
        }
    }

    private void createSearchAgents() {
        if (this.dataViewProvider.hasIncrementalSearch()) {
            this.searchFilter = new SearchFilter();
        }
    }

    protected abstract IDataViewContentProvider createContentProvider();

    protected final void setSelectionInViewer(Collection<ContentType> selectedItems, boolean reveal) {
        if (selectedItems != null && !selectedItems.isEmpty()) {
            List selectedPaths = new ArrayList<TreePath>();
            for (ContentType selectedItem : selectedItems) {
                selectedPaths.addAll(this.getTreePaths(selectedItem, 26));
                if (selectedPaths.size() > 25) break;
            }
            if (selectedPaths.size() > 25) {
                selectedPaths = selectedPaths.subList(0, 25);
                this.setIncompleteSelectionDescription(true);
            } else {
                this.setIncompleteSelectionDescription(false);
            }
            TreeSelection selection = new TreeSelection(selectedPaths.toArray(new TreePath[selectedPaths.size()]));
            this.viewer.setSelection((ISelection)selection, reveal);
        } else {
            this.viewer.setSelection((ISelection)StructuredSelection.EMPTY);
        }
    }

    private void setIncompleteSelectionDescription(boolean isIncomplete) {
        if (isIncomplete) {
            if (this.incompleteSelectionDescriptionKey == null) {
                this.incompleteSelectionDescriptionKey = this.addDescription(Messages.getString("JFaceViewerDataView.NotAllInstancesOfTheSelectedItemsExpanded.Message"), Messages.getString("JFaceViewerDataView.NotAllInstancesOfTheSelectedItemsExpanded.Tooltip"), INCOMPLETESELECTION_DESCRIPTION_COLOR);
            }
        } else if (this.incompleteSelectionDescriptionKey != null) {
            this.removeDescription(this.incompleteSelectionDescriptionKey);
            this.incompleteSelectionDescriptionKey = null;
        }
    }

    private Collection<TreePath> getTreePaths(ContentType item, int maxpaths) {
        List<?> parents = this.contentProvider.getParents(item);
        if (parents != null) {
            parents.retainAll(this.applyFilters(parents));
        }
        if (parents != null && !parents.isEmpty()) {
            ArrayList<TreePath> treePaths = new ArrayList<TreePath>(maxpaths);
            block0: for (Object parent : parents) {
                for (TreePath treePath : this.getTreePaths(parent, maxpaths)) {
                    treePaths.add(treePath.createChildPath(item));
                    if (treePaths.size() == maxpaths) break block0;
                }
            }
            return treePaths;
        }
        return Collections.singleton(new TreePath(new Object[]{item}));
    }

    protected abstract JFaceViewerDataViewProvider<ContentType> createJFaceViewerDataViewProvider();

    @Override
    protected final IDataViewProvider<ContentType> createDataViewProvider() {
        this.dataViewProvider = this.createJFaceViewerDataViewProvider();
        return this.dataViewProvider;
    }
}

