/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.lib.dataviews.view;

import com.arcway.cockpit.cockpitlib.client.gui.DeferredRefresher;
import com.arcway.cockpit.cockpitlib.client.gui.IRefreshableDisplay;
import com.arcway.cockpit.frame.client.global.FramePlugin;
import com.arcway.cockpit.frame.client.global.selection.CockpitSelectionManager;
import com.arcway.cockpit.frame.client.global.selection.CockpitSelectionService;
import com.arcway.cockpit.frame.client.lib.dataviews.actions.IModuleAction;
import com.arcway.cockpit.frame.client.lib.dataviews.dnd.DataViewDragSourceListener;
import com.arcway.cockpit.frame.client.lib.dataviews.dnd.DataViewDropTargetListener;
import com.arcway.cockpit.frame.client.lib.dataviews.dnd.DragSource;
import com.arcway.cockpit.frame.client.lib.dataviews.messages.Messages;
import com.arcway.cockpit.frame.client.lib.dataviews.projectmanager.IProjectAssociationManager;
import com.arcway.cockpit.frame.client.lib.dataviews.search.SearchFieldContributionItem;
import com.arcway.cockpit.frame.client.lib.dataviews.search.SearchStringGenerator;
import com.arcway.cockpit.frame.client.lib.dataviews.util.IModuleProjectSwitchListener;
import com.arcway.cockpit.frame.client.lib.dataviews.util.IModuleProjectSwitchListenerManager;
import com.arcway.cockpit.frame.client.lib.dataviews.util.IViewFacade;
import com.arcway.cockpit.frame.client.lib.dataviews.view.DataViewFacade;
import com.arcway.cockpit.frame.client.lib.dataviews.view.IDataViewProvider;
import com.arcway.lib.UUIDGenerator;
import com.arcway.lib.eclipse.gui.EclipseSWTHelper;
import com.arcway.lib.java.EitherOr;
import com.arcway.lib.java.tuples.ThreeTuple;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import de.plans.lib.util.incrementalsearch.DeltaPacket;
import de.plans.lib.util.incrementalsearch.ISearchAlgorithm;
import de.plans.lib.util.incrementalsearch.ISearchCallback;
import de.plans.lib.util.incrementalsearch.IncrementalSearchProcessor;
import de.plans.lib.util.incrementalsearch.SearchProcessorIsDisposedException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.menus.CommandContributionItem;
import org.eclipse.ui.menus.CommandContributionItemParameter;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.services.IServiceLocator;

public abstract class AbstractDataView<ContentType>
extends ViewPart
implements ISelectionListener,
IRefreshableDisplay,
ISearchCallback,
IPartListener2,
IModuleProjectSwitchListenerManager {
    private static final ILogger LOGGER = Logger.getLogger(AbstractDataView.class);
    private static final int SEARCH_HISTORY_SIZE = 25;
    private static final String VIEW_CONTEXTMENU_ID_SUFFIX = ".contextmenu";
    private static final String NEWMENU_ID_SUFFIX = ".new";
    private DataViewFacade viewFacade;
    private IDataViewProvider<ContentType> dataViewProvider;
    private Composite viewParentComposite;
    private Composite baseComposite;
    private Composite descriptionComposite;
    private Composite viewerComposite;
    private Control viewer;
    private SelectionProviderWrapper selectionProviderWrapper;
    private IAction deleteAction;
    private IAction selectAllAction;
    private IAction copyAction;
    private IAction cutAction;
    private IAction pasteAction;
    private IAction pinAction;
    private List<EitherOr<IAction, IContributionItem>> viewMenuActions;
    private List<? extends IAction> toolbarActions;
    private List<EitherOr<IAction, IContributionItem>> contextMenuActions;
    private DataViewDragSourceListener dragListener;
    private DataViewDropTargetListener dropListener;
    private SearchFieldContributionItem searchFieldContributionItem;
    private DeferredRefresher searchResultUpdater;
    private Collection<?> currentSearchResult;
    private IncrementalSearchProcessor searchProcessor;
    private DeferredRefresher refresher;
    private boolean isVisible;
    private boolean refreshRequestedWhileInvisible;
    private String projectUID;
    private boolean isSelectionSensitive = true;
    private boolean isSelectionSensitivitySuspended = false;
    private boolean isDisposed = false;
    private Set<IModuleProjectSwitchListener> projectChangedListeners;
    private boolean isBroadCasting = false;
    private Set<IModuleProjectSwitchListener> toBeRemoved;
    private Set<IModuleProjectSwitchListener> toBeAdded;
    private Map<String, ThreeTuple<String, String, Color>> descriptions;

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        this.projectChangedListeners = new HashSet<IModuleProjectSwitchListener>();
        this.toBeAdded = new HashSet<IModuleProjectSwitchListener>();
        this.toBeRemoved = new HashSet<IModuleProjectSwitchListener>();
        this.descriptions = new HashMap<String, ThreeTuple<String, String, Color>>();
        this.dataViewProvider = this.createDataViewProvider();
        this.viewFacade = new DataViewFacade(this, this.getSite().getWorkbenchWindow());
        this.getSite().getPage().addPartListener((IPartListener2)this);
    }

    public void createPartControl(Composite parent) {
        this.viewParentComposite = parent;
        this.createPermanentParts();
        this.baseComposite = new Composite(parent, 0);
        GridLayout baseLayout = new GridLayout();
        baseLayout.marginWidth = 0;
        baseLayout.marginHeight = 0;
        baseLayout.horizontalSpacing = 0;
        baseLayout.verticalSpacing = 0;
        this.baseComposite.setLayout((Layout)baseLayout);
        GridData baseLayoutData = new GridData(4, 4, true, true);
        this.baseComposite.setLayoutData((Object)baseLayoutData);
        this.descriptionComposite = new Composite(this.baseComposite, 0);
        GridLayout descriptionLayout = new GridLayout();
        descriptionLayout.marginWidth = 0;
        descriptionLayout.marginHeight = 0;
        descriptionLayout.horizontalSpacing = 0;
        descriptionLayout.verticalSpacing = 0;
        this.descriptionComposite.setLayout((Layout)descriptionLayout);
        GridData descriptionLayoutData = new GridData(4, 1, true, false);
        this.descriptionComposite.setLayoutData((Object)descriptionLayoutData);
        this.viewerComposite = new Composite(this.baseComposite, 0);
        GridLayout viewerLayout = new GridLayout();
        viewerLayout.marginWidth = 0;
        viewerLayout.marginHeight = 0;
        viewerLayout.horizontalSpacing = 0;
        viewerLayout.verticalSpacing = 0;
        this.viewerComposite.setLayout((Layout)viewerLayout);
        GridData viewerLayoutData = new GridData(4, 4, true, true);
        this.viewerComposite.setLayoutData((Object)viewerLayoutData);
        this.viewer = this.createViewer(this.viewerComposite, null, false);
        this.initialiseNewViewer(null, new ViewerStateToBeTransferred());
        this.getProjectAssociationManager().activateView(this.viewFacade);
        this.updateDescriptions();
    }

    protected void createPermanentParts() {
        String helpContextID_fromDataView;
        this.createSearchAgents();
        this.createPermanentMenus();
        this.createDNDAgents();
        this.getProjectAssociationManager().storeView(this.viewFacade);
        this.registerSelectionListeners();
        this.registerProjectSwitchListeners();
        this.refresher = new DeferredRefresher((IRefreshableDisplay)this);
        this.refresher.start();
        String helpContextID_fromDataViewProvider = this.dataViewProvider.getHelpContextId();
        if (helpContextID_fromDataViewProvider != null) {
            this.registerContextSensitiveHelp((Control)this.viewParentComposite, helpContextID_fromDataViewProvider);
        }
        if ((helpContextID_fromDataView = this.getHelpContextID()) != null) {
            this.registerContextSensitiveHelp((Control)this.viewParentComposite, helpContextID_fromDataView);
        }
        this.selectionProviderWrapper = new SelectionProviderWrapper();
        this.getSite().setSelectionProvider((ISelectionProvider)this.selectionProviderWrapper);
    }

    public synchronized void dispose() {
        this.isDisposed = true;
        if (this.dataViewProvider.hasIncrementalSearch()) {
            this.searchFieldContributionItem.dispose();
            try {
                this.searchProcessor.dispose();
            }
            catch (SearchProcessorIsDisposedException searchProcessorIsDisposedException) {
                // empty catch block
            }
        }
        this.deregisterSelectionAgents();
        this.deregisterAllProjectSwitchListeners();
        this.dataViewProvider.dispose();
        this.getProjectAssociationManager().removeView(this.viewFacade);
        this.viewer.dispose();
        super.dispose();
    }

    public synchronized void projectSwitched(String projectUID_) {
        this.performProjectAndViewerExchange(true, projectUID_);
    }

    protected final void exchangeOfViewerRequired() {
        this.performProjectAndViewerExchange(false, null);
    }

    public final void refresh() {
        if (this.isVisible) {
            this.refreshViewer();
        } else {
            this.refreshRequestedWhileInvisible = true;
        }
    }

    protected abstract void refreshViewer();

    public final void refreshOfViewerRequired(boolean delayed, DeltaPacket deltaPacket) {
        if (deltaPacket != null) {
            try {
                this.searchProcessor.updateDeltas(deltaPacket.getAdds(), deltaPacket.getMods(), deltaPacket.getDels());
            }
            catch (SearchProcessorIsDisposedException spidE) {
                LOGGER.warn("Tried to set delta packet to search processor while it was already disposed.");
            }
        }
        this.refresher.scheduleDeferredRefresh();
        if (!delayed) {
            this.refresher.executePendingRefreshNow();
        }
    }

    public final synchronized void setSearchResult(Collection<?> searchResult) {
        this.currentSearchResult = searchResult;
        this.searchResultUpdater.scheduleDeferredRefresh();
    }

    protected abstract void updateIncrementalSearchResult(Collection<?> var1);

    private void performProjectAndViewerExchange(boolean isNewProject, String projectUID_) {
        String newProjectUID;
        if (this.refreshRequestedWhileInvisible) {
            this.refreshRequestedWhileInvisible = false;
        }
        String oldProjectUID = this.projectUID;
        String string = newProjectUID = isNewProject ? projectUID_ : this.projectUID;
        if (isNewProject) {
            this.projectUID = newProjectUID;
        }
        this.exchangeViewer(oldProjectUID, newProjectUID);
        this.viewParentComposite.layout();
        this.setViewerContents(newProjectUID);
    }

    protected abstract void setViewerContents(String var1);

    private synchronized void exchangeViewer(String oldProjectUID, String newProjectUID) {
        this.callbackBeforeExchangeOfViewer(oldProjectUID, newProjectUID);
        ViewerStateToBeTransferred viewerStateToBeTransferred = this.clearOldViewer(oldProjectUID);
        this.viewer.dispose();
        this.viewer = this.createViewer(this.viewerComposite, newProjectUID, true);
        this.initialiseNewViewer(newProjectUID, viewerStateToBeTransferred);
        this.callbackAfterExchangeOfViewer(oldProjectUID, newProjectUID);
    }

    private void initialiseNewViewer(String newProjectUID, ViewerStateToBeTransferred viewerStateToBeTransferred) {
        this.selectionProviderWrapper.setSelectionProvider(this.getSelectionProvider());
        this.updateDescriptions();
        if (newProjectUID != null) {
            if (this.dragListener != null) {
                this.dragListener.setSelectionProvider(this.selectionProviderWrapper);
                Control viewerControl = this.viewer;
                org.eclipse.swt.dnd.DragSource dragSource = new org.eclipse.swt.dnd.DragSource(viewerControl, this.dragListener.getSupportedOperations());
                dragSource.addDragListener((DragSourceListener)this.dragListener);
                this.dragListener.setSWTDragAgent(dragSource);
            }
            if (this.dropListener != null) {
                this.dropListener.setViewer(this.viewer);
                DropTarget dropTarget = new DropTarget(this.viewer, this.dropListener.getSupportedOperations());
                dropTarget.setTransfer(this.dropListener.getSupportedTransfers());
                dropTarget.addDropListener((DropTargetListener)this.dropListener);
            }
            this.selectionProviderWrapper.setSelection(viewerStateToBeTransferred.oldSelection);
            this.createContextMenu();
            if (this.searchProcessor != null) {
                try {
                    this.searchProcessor.setNewSearchInput(this.getAllRelevantItemsForSearch(newProjectUID), null);
                }
                catch (SearchProcessorIsDisposedException e) {
                    LOGGER.warn("Tried to empty search processor after dispose");
                }
            }
        } else {
            this.selectionProviderWrapper.setSelectionProvider(null);
            if (this.searchProcessor != null) {
                try {
                    this.searchProcessor.setNewSearchInput((Collection)Collections.EMPTY_SET, Collections.EMPTY_LIST);
                }
                catch (SearchProcessorIsDisposedException e) {
                    LOGGER.warn("Tried to empty search processor after dispose");
                }
            }
        }
    }

    private ViewerStateToBeTransferred clearOldViewer(String oldProjectUID) {
        ViewerStateToBeTransferred viewerStateToBeTransferred = new ViewerStateToBeTransferred();
        if (oldProjectUID != null) {
            this.dragListener.setSelectionProvider(null);
            this.dropListener.setViewer(null);
        }
        viewerStateToBeTransferred.oldViewer = this.viewer;
        viewerStateToBeTransferred.oldSelection = this.selectionProviderWrapper.getSelection();
        return viewerStateToBeTransferred;
    }

    protected abstract void callbackBeforeExchangeOfViewer(String var1, String var2);

    protected abstract void callbackAfterExchangeOfViewer(String var1, String var2);

    protected abstract ISelectionProvider getSelectionProvider();

    public ISelection getSelection() {
        return this.selectionProviderWrapper.getSelection();
    }

    public void setFocus() {
        this.viewParentComposite.setFocus();
    }

    protected abstract String getHelpContextID();

    protected abstract Control createViewer(Composite var1, String var2, boolean var3);

    protected final IViewFacade getViewFacade() {
        return this.viewFacade;
    }

    public abstract void selectAll();

    public abstract void deselectAll();

    private void registerSelectionListeners() {
        CockpitSelectionService cockpitSelectionService = CockpitSelectionManager.getSelectionService(this.getSite().getWorkbenchWindow().getSelectionService());
        if (this.pasteAction instanceof ISelectionListener) {
            cockpitSelectionService.addSelectionListener((ISelectionListener)this.pasteAction);
        }
        if (this.copyAction instanceof ISelectionListener) {
            cockpitSelectionService.addSelectionListener((ISelectionListener)this.copyAction);
        }
        if (this.cutAction instanceof ISelectionListener) {
            cockpitSelectionService.addSelectionListener((ISelectionListener)this.cutAction);
        }
        if (this.deleteAction instanceof ISelectionListener) {
            cockpitSelectionService.addSelectionListener((ISelectionListener)this.deleteAction);
        }
        if (this.selectAllAction instanceof ISelectionListener) {
            cockpitSelectionService.addSelectionListener((ISelectionListener)this.selectAllAction);
        }
        if (this.viewMenuActions != null) {
            for (EitherOr<IAction, IContributionItem> eitherOr : this.viewMenuActions) {
                if (!(eitherOr.getObject() instanceof ISelectionListener)) continue;
                cockpitSelectionService.addSelectionListener((ISelectionListener)eitherOr.getObject());
            }
        }
        if (this.toolbarActions != null) {
            for (IAction iAction : this.toolbarActions) {
                if (!(iAction instanceof ISelectionListener)) continue;
                cockpitSelectionService.addSelectionListener((ISelectionListener)iAction);
            }
        }
        if (this.contextMenuActions != null) {
            for (EitherOr<IAction, IContributionItem> eitherOr : this.contextMenuActions) {
                if (!(eitherOr.getObject() instanceof ISelectionListener)) continue;
                cockpitSelectionService.addSelectionListener((ISelectionListener)eitherOr.getObject());
            }
        }
        cockpitSelectionService.addSelectionListener(this);
    }

    private void registerProjectSwitchListeners() {
        if (this.searchFieldContributionItem != null) {
            this.registerProjectSwitchListener(this.searchFieldContributionItem);
        }
        if (this.deleteAction instanceof IModuleProjectSwitchListener) {
            this.registerProjectSwitchListener((IModuleProjectSwitchListener)this.deleteAction);
        }
        if (this.selectAllAction instanceof IModuleProjectSwitchListener) {
            this.registerProjectSwitchListener((IModuleProjectSwitchListener)this.selectAllAction);
        }
        if (this.copyAction instanceof IModuleProjectSwitchListener) {
            this.registerProjectSwitchListener((IModuleProjectSwitchListener)this.copyAction);
        }
        if (this.cutAction instanceof IModuleProjectSwitchListener) {
            this.registerProjectSwitchListener((IModuleProjectSwitchListener)this.cutAction);
        }
        if (this.pasteAction instanceof IModuleProjectSwitchListener) {
            this.registerProjectSwitchListener((IModuleProjectSwitchListener)this.pasteAction);
        }
        if (this.viewMenuActions != null) {
            for (EitherOr<IAction, IContributionItem> eitherOr : this.viewMenuActions) {
                if (!(eitherOr.getObject() instanceof IModuleProjectSwitchListener)) continue;
                this.registerProjectSwitchListener((IModuleProjectSwitchListener)eitherOr.getObject());
            }
        }
        if (this.toolbarActions != null) {
            for (IAction iAction : this.toolbarActions) {
                if (!(iAction instanceof IModuleProjectSwitchListener)) continue;
                this.registerProjectSwitchListener((IModuleProjectSwitchListener)iAction);
            }
        }
        if (this.contextMenuActions != null) {
            for (EitherOr<IAction, IContributionItem> eitherOr : this.contextMenuActions) {
                if (!(eitherOr.getObject() instanceof IModuleProjectSwitchListener)) continue;
                this.registerProjectSwitchListener((IModuleProjectSwitchListener)eitherOr.getObject());
            }
        }
    }

    private void registerProjectSwitchListeners(Collection<?> potentialListeners) {
        for (Object potentialListener : potentialListeners) {
            if (!(potentialListener instanceof IModuleProjectSwitchListener)) continue;
            this.registerProjectSwitchListener((IModuleProjectSwitchListener)potentialListener);
        }
    }

    private void deregisterSelectionAgents() {
        CockpitSelectionService cockpitSelectionService = CockpitSelectionManager.getSelectionService(this.getSite().getWorkbenchWindow().getSelectionService());
        if (this.pasteAction instanceof ISelectionListener) {
            cockpitSelectionService.removeSelectionListener((ISelectionListener)this.pasteAction);
        }
        if (this.copyAction instanceof ISelectionListener) {
            cockpitSelectionService.removeSelectionListener((ISelectionListener)this.copyAction);
        }
        if (this.cutAction instanceof ISelectionListener) {
            cockpitSelectionService.removeSelectionListener((ISelectionListener)this.cutAction);
        }
        if (this.deleteAction instanceof ISelectionListener) {
            cockpitSelectionService.removeSelectionListener((ISelectionListener)this.deleteAction);
        }
        if (this.selectAllAction instanceof ISelectionListener) {
            cockpitSelectionService.removeSelectionListener((ISelectionListener)this.selectAllAction);
        }
        if (this.viewMenuActions != null) {
            for (EitherOr<IAction, IContributionItem> eitherOr : this.viewMenuActions) {
                if (!(eitherOr.getObject() instanceof ISelectionListener)) continue;
                cockpitSelectionService.removeSelectionListener((ISelectionListener)eitherOr.getObject());
            }
        }
        if (this.toolbarActions != null) {
            for (IAction iAction : this.toolbarActions) {
                if (!(iAction instanceof ISelectionListener)) continue;
                cockpitSelectionService.removeSelectionListener((ISelectionListener)iAction);
            }
        }
        if (this.contextMenuActions != null) {
            for (EitherOr<IAction, IContributionItem> eitherOr : this.contextMenuActions) {
                if (!(eitherOr.getObject() instanceof ISelectionListener)) continue;
                cockpitSelectionService.removeSelectionListener((ISelectionListener)eitherOr.getObject());
            }
        }
        cockpitSelectionService.removeSelectionListener(this);
    }

    private void createPermanentMenus() {
        this.createActions();
        this.createViewMenu();
        this.createLocalToolbar();
        this.hookGlobalActions();
    }

    private void createActions() {
        this.deleteAction = this.dataViewProvider.getDeleteAction();
        this.copyAction = this.dataViewProvider.getCopyAction();
        this.cutAction = this.dataViewProvider.getCutAction();
        this.pasteAction = this.dataViewProvider.getPasteAction();
        this.selectAllAction = this.dataViewProvider.getSelectAllAction();
        this.pinAction = new Action("", 2){

            public void run() {
                AbstractDataView.this.isSelectionSensitive = AbstractDataView.this.pinAction.isChecked();
            }

            public ImageDescriptor getImageDescriptor() {
                return FramePlugin.getImageDescriptor("dataview", "synced.png");
            }

            public String getToolTipText() {
                return Messages.getString("DataView.PinDataViewAction.Tooltip");
            }
        };
        this.pinAction.setChecked(this.isSelectionSensitive);
        this.viewMenuActions = this.dataViewProvider.getAdditionalViewMenuActions();
        this.toolbarActions = this.dataViewProvider.getAdditionalToolbarActions();
        this.contextMenuActions = this.dataViewProvider.getAdditionalContextMenuActions();
    }

    protected List<IModuleAction> getDataViewTypeSpecificViewMenuActions() {
        return Collections.emptyList();
    }

    private static MenuManager createNewSubmenu(String newMenuID, List<String> newMenuSeparatorIDs) {
        MenuManager newSubmenuManager = new MenuManager(Messages.getString("AbstractDataView.newMenuLabel"), newMenuID);
        for (String newMenuSeparatorID : newMenuSeparatorIDs) {
            newSubmenuManager.add((IContributionItem)new Separator(newMenuSeparatorID));
        }
        newSubmenuManager.setVisible(true);
        return newSubmenuManager;
    }

    private void createContextMenu() {
        String contextMenuID = String.valueOf(this.getSite().getId()) + VIEW_CONTEXTMENU_ID_SUFFIX;
        MenuManager contextMenuManager = new MenuManager("#PopUp", contextMenuID);
        Menu menu = contextMenuManager.createContextMenu(this.viewer);
        this.viewer.setMenu(menu);
        if (this.dataViewProvider.hasNewMenu()) {
            String alternativeNewMenuID = this.dataViewProvider.getAlternativeNewMenuID();
            contextMenuManager.add((IContributionItem)AbstractDataView.createNewSubmenu(alternativeNewMenuID != null ? alternativeNewMenuID : String.valueOf(contextMenuID) + NEWMENU_ID_SUFFIX, this.dataViewProvider.getNewMenuSeparatorIDs()));
        }
        contextMenuManager.add((IContributionItem)new Separator("com.arcway.cockpit.module.dataview.contextmenu.new.separator"));
        contextMenuManager.add((IContributionItem)new CommandContributionItem(new CommandContributionItemParameter((IServiceLocator)this.getSite(), null, "org.eclipse.ui.edit.copy", null, null, null, null, Messages.getString("AbstractDataView.CopyActionText"), null, null, 8, null, false)));
        contextMenuManager.add((IContributionItem)new CommandContributionItem(new CommandContributionItemParameter((IServiceLocator)this.getSite(), null, "org.eclipse.ui.edit.paste", 8)));
        contextMenuManager.add((IContributionItem)new Separator("com.arcway.cockpit.contextmenu.edit.paste.separator"));
        contextMenuManager.add((IContributionItem)new CommandContributionItem(new CommandContributionItemParameter((IServiceLocator)this.getSite(), null, "org.eclipse.ui.edit.delete", 8)));
        contextMenuManager.add((IContributionItem)new Separator("com.arcway.cockpit.contextmenu.edit.delete.separator"));
        if (this.contextMenuActions != null) {
            for (EitherOr<IAction, IContributionItem> item : this.contextMenuActions) {
                if (item.isOfFirstType()) {
                    contextMenuManager.add((IAction)item.getObjectOfFirstType());
                } else if (item.isOfSecondType()) {
                    contextMenuManager.add((IContributionItem)item.getObjectOfSecondType());
                }
                if (!(item.getObject() instanceof IMenuListener)) continue;
                contextMenuManager.addMenuListener((IMenuListener)item.getObject());
            }
        }
        contextMenuManager.add((IContributionItem)new Separator("additions"));
        contextMenuManager.add((IContributionItem)new Separator("com.arcway.cockpit.contextmenu.file.properties.separator"));
        contextMenuManager.add((IContributionItem)new CommandContributionItem(new CommandContributionItemParameter((IServiceLocator)this.getSite(), null, "org.eclipse.ui.file.properties", 8)));
        contextMenuManager.setVisible(true);
        this.getSite().registerContextMenu(contextMenuID, contextMenuManager, (ISelectionProvider)this.selectionProviderWrapper);
    }

    private void createViewMenu() {
        IMenuManager viewMenuManager = this.getViewSite().getActionBars().getMenuManager();
        if (this.dataViewProvider.hasNewMenu()) {
            String alternativeNewMenuID = this.dataViewProvider.getAlternativeNewMenuID();
            viewMenuManager.add((IContributionItem)AbstractDataView.createNewSubmenu(alternativeNewMenuID != null ? alternativeNewMenuID : String.valueOf(this.getSite().getId()) + NEWMENU_ID_SUFFIX, this.dataViewProvider.getNewMenuSeparatorIDs()));
        }
        viewMenuManager.add((IContributionItem)new Separator());
        if (this.viewMenuActions != null) {
            for (EitherOr<IAction, IContributionItem> item : this.viewMenuActions) {
                if (item.isOfFirstType()) {
                    viewMenuManager.add((IAction)item.getObjectOfFirstType());
                    continue;
                }
                if (!item.isOfSecondType()) continue;
                viewMenuManager.add((IContributionItem)item.getObjectOfSecondType());
            }
        }
    }

    private void createLocalToolbar() {
        IToolBarManager toolbarManager = this.getViewSite().getActionBars().getToolBarManager();
        if (this.dataViewProvider.hasIncrementalSearch()) {
            toolbarManager.add((IContributionItem)this.searchFieldContributionItem);
        }
        if (this.toolbarActions != null) {
            for (IAction iAction : this.toolbarActions) {
                toolbarManager.add(iAction);
            }
        }
        this.addAction((IContributionManager)toolbarManager, this.pinAction);
    }

    private void hookGlobalActions() {
        IActionBars bars = this.getViewSite().getActionBars();
        if (this.deleteAction != null) {
            bars.setGlobalActionHandler(ActionFactory.DELETE.getId(), this.deleteAction);
        }
        if (this.selectAllAction != null) {
            bars.setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), this.selectAllAction);
        }
        if (this.copyAction != null) {
            bars.setGlobalActionHandler(ActionFactory.COPY.getId(), this.copyAction);
        }
        if (this.cutAction != null) {
            bars.setGlobalActionHandler(ActionFactory.CUT.getId(), this.cutAction);
        }
        if (this.pasteAction != null) {
            bars.setGlobalActionHandler(ActionFactory.PASTE.getId(), this.pasteAction);
        }
    }

    protected void addAction(IContributionManager manager, IAction action) {
        assert (manager != null) : "manager must not be null";
        if (action != null) {
            manager.add(action);
        }
    }

    private void createSearchAgents() {
        if (this.dataViewProvider.hasIncrementalSearch()) {
            ISearchAlgorithm searchAlgorithm = this.dataViewProvider.getSearchAlgorithm();
            SearchStringGenerator<ContentType> searchStringGenerator = new SearchStringGenerator<ContentType>(this.dataViewProvider.getSearchStringGenerators(), this.dataViewProvider.getItemTypeProviderForSearch());
            this.searchProcessor = new IncrementalSearchProcessor((ISearchCallback)this, this.dataViewProvider.getFullModuleID(), searchStringGenerator, 25, searchAlgorithm, 5);
            this.searchFieldContributionItem = new SearchFieldContributionItem(this.searchProcessor, searchAlgorithm, this.dataViewProvider.getRequiredLicenseTypeForSearch(), this.getViewSite().getActionBars());
            this.searchResultUpdater = new DeferredRefresher(new IRefreshableDisplay(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void refresh() {
                    AbstractDataView abstractDataView = AbstractDataView.this;
                    synchronized (abstractDataView) {
                        if (!AbstractDataView.this.isDisposed) {
                            AbstractDataView.this.updateIncrementalSearchResult(AbstractDataView.this.currentSearchResult);
                        }
                    }
                }

                public boolean isDisposed() {
                    return AbstractDataView.this.isDisposed();
                }

                public Display getDisplay() {
                    return AbstractDataView.this.getDisplay();
                }
            }, 1L, "Search Result Updater for " + this.getClass().getName());
            this.searchResultUpdater.start();
        }
    }

    private void createDNDAgents() {
        DragSource[] sources = this.dataViewProvider.createDragSources();
        this.dragListener = new DataViewDragSourceListener(null, sources);
        this.registerProjectSwitchListeners(Arrays.asList(sources));
        com.arcway.cockpit.frame.client.lib.dataviews.dnd.DropTarget[] targets = this.dataViewProvider.createDropTargets();
        this.dropListener = new DataViewDropTargetListener(null, targets);
        this.registerProjectSwitchListeners(Arrays.asList(targets));
    }

    private void registerContextSensitiveHelp(Control parent, String helpContextId) {
        if (helpContextId != null) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp(parent, helpContextId);
        }
    }

    protected String addDescription(String text, String tooltip, Color color) {
        String key = UUIDGenerator.getUniqueID();
        this.descriptions.put(key, (ThreeTuple<String, String, Color>)new ThreeTuple((Object)text, (Object)tooltip, (Object)color));
        this.updateDescriptions();
        return key;
    }

    protected void removeDescription(String key) {
        this.descriptions.remove(key);
        this.updateDescriptions();
    }

    private final void updateDescriptions() {
        Control[] controlArray = this.descriptionComposite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            child.dispose();
            ++n2;
        }
        if (this.descriptions.size() > 0) {
            for (ThreeTuple<String, String, Color> description : this.descriptions.values()) {
                Composite borderComposite = new Composite(this.descriptionComposite, 0);
                GridData borderCompositeLayoutData = new GridData(4, 2, true, false);
                borderComposite.setLayoutData((Object)borderCompositeLayoutData);
                GridLayout borderCompositeLayout = new GridLayout();
                borderCompositeLayout.marginWidth = 0;
                borderCompositeLayout.marginHeight = 0;
                borderCompositeLayout.marginTop = 0;
                borderCompositeLayout.marginBottom = 1;
                borderComposite.setLayout((Layout)borderCompositeLayout);
                borderComposite.setBackground(this.descriptionComposite.getDisplay().getSystemColor(22));
                Composite composite = new Composite(borderComposite, 0);
                GridData compositeLayoutData = new GridData(4, 2, true, false);
                composite.setLayoutData((Object)compositeLayoutData);
                GridLayout compositeLayout = new GridLayout();
                compositeLayout.marginWidth = 10;
                compositeLayout.marginHeight = 3;
                composite.setLayout((Layout)compositeLayout);
                composite.setBackground((Color)description.getComponent3());
                Label label = new Label(composite, 0);
                GridData labelLayoutData = new GridData(4, 1, true, false);
                label.setLayoutData((Object)labelLayoutData);
                label.setText((String)description.getComponent1());
                EclipseSWTHelper.setBoldFont((Control)label, (boolean)true);
                label.setBackground((Color)description.getComponent3());
                if (description.getComponent2() == null) continue;
                label.setToolTipText((String)description.getComponent2());
            }
        } else {
            Label label = new Label(this.descriptionComposite, 0);
            GridData layoutData = new GridData(4, 1, true, false);
            layoutData.heightHint = 1;
            label.setLayoutData((Object)layoutData);
            this.descriptionComposite.setBackground(this.descriptionComposite.getDisplay().getSystemColor(22));
            ((GridLayout)this.descriptionComposite.getLayout()).marginHeight = 0;
            ((GridLayout)this.descriptionComposite.getLayout()).marginWidth = 0;
        }
        this.descriptionComposite.layout();
        this.baseComposite.layout();
        this.baseComposite.redraw();
    }

    public void partActivated(IWorkbenchPartReference part) {
        if (part.getPart(false) == this && this.viewer != null && this.refresher != null) {
            this.refresher.executePendingRefreshNow();
        }
    }

    public void partDeactivated(IWorkbenchPartReference part) {
    }

    public void partBroughtToTop(IWorkbenchPartReference part) {
    }

    public void partOpened(IWorkbenchPartReference part) {
    }

    public void partClosed(IWorkbenchPartReference part) {
    }

    public void partInputChanged(IWorkbenchPartReference partRef) {
    }

    public void partVisible(IWorkbenchPartReference partRef) {
        if (partRef.getPart(false) == this) {
            this.isVisible = true;
            if (this.refreshRequestedWhileInvisible) {
                this.refreshRequestedWhileInvisible = false;
                this.refreshOfViewerRequired(false, null);
            }
        }
    }

    public void partHidden(IWorkbenchPartReference partRef) {
        if (partRef.getPart(false) == this) {
            this.isVisible = false;
        }
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        IStructuredSelection filteredSelection;
        if (part != this && this.isSelectionSensitive && !this.isSelectionSensitivitySuspended && this.projectUID != null && selection instanceof IStructuredSelection && this.viewer != null && !(filteredSelection = this.sortOutSelection((IStructuredSelection)selection)).isEmpty()) {
            ISelection oldSelection = this.selectionProviderWrapper.getSelection();
            this.selectionProviderWrapper.setSelection((ISelection)filteredSelection);
            if (this.selectionProviderWrapper.getSelection().isEmpty()) {
                this.selectionProviderWrapper.setSelection(oldSelection);
            }
        }
    }

    protected final void suspendSelectionSensitivity() {
        assert (!this.isSelectionSensitivitySuspended);
        this.pinAction.setEnabled(false);
        this.isSelectionSensitivitySuspended = true;
    }

    protected final void resumeSelectionSensitivity() {
        assert (this.isSelectionSensitivitySuspended);
        this.isSelectionSensitivitySuspended = false;
        this.pinAction.setEnabled(true);
    }

    protected abstract IStructuredSelection sortOutSelection(IStructuredSelection var1);

    protected abstract Collection<?> getAllRelevantItemsForSearch(String var1);

    public Display getDisplay() {
        return this.getSite().getWorkbenchWindow().getWorkbench().getDisplay();
    }

    public boolean isDisposed() {
        return this.isDisposed;
    }

    protected abstract IProjectAssociationManager getProjectAssociationManager();

    @Override
    public final void registerProjectSwitchListener(IModuleProjectSwitchListener listener) {
        assert (listener != null) : "listener must not be null";
        if (this.isBroadCasting) {
            this.toBeAdded.add(listener);
        } else {
            this.projectChangedListeners.add(listener);
        }
    }

    @Override
    public final void deregisterProjectSwitchListener(IModuleProjectSwitchListener listener) {
        assert (listener != null) : "listener must not be null";
        if (this.isBroadCasting) {
            this.toBeRemoved.add(listener);
        } else {
            this.projectChangedListeners.remove(listener);
        }
    }

    private void deregisterAllProjectSwitchListeners() {
        if (this.isBroadCasting) {
            this.toBeRemoved.addAll(this.projectChangedListeners);
        } else {
            this.projectChangedListeners.clear();
        }
    }

    protected final void informProjectSwitchListeners(String projectUID_) {
        this.isBroadCasting = true;
        for (IModuleProjectSwitchListener listener : this.projectChangedListeners) {
            try {
                listener.projectSwitched(projectUID_);
            }
            catch (Exception e) {
                LOGGER.error("Exception in project changed listener:" + listener + ", continuing with the other listeners.", (Throwable)e);
            }
        }
        this.isBroadCasting = false;
        this.projectChangedListeners.addAll(this.toBeAdded);
        this.toBeAdded.clear();
        this.projectChangedListeners.removeAll(this.toBeRemoved);
        this.toBeRemoved.clear();
    }

    @Override
    public String getCurrentlyAssociatedProject() {
        return this.projectUID;
    }

    protected abstract IDataViewProvider<ContentType> createDataViewProvider();

    private static class SelectionProviderWrapper
    implements ISelectionProvider {
        private final Set<ISelectionChangedListener> selectionChangedListeners = new HashSet<ISelectionChangedListener>();
        private ISelectionProvider selectionProvider = null;

        private SelectionProviderWrapper() {
        }

        public void setSelectionProvider(ISelectionProvider selectionProvider) {
            if (this.selectionProvider != null) {
                for (ISelectionChangedListener listener : this.selectionChangedListeners) {
                    this.selectionProvider.removeSelectionChangedListener(listener);
                }
            }
            this.selectionProvider = selectionProvider;
            if (selectionProvider != null) {
                for (ISelectionChangedListener listener : this.selectionChangedListeners) {
                    selectionProvider.addSelectionChangedListener(listener);
                }
            }
        }

        public void addSelectionChangedListener(ISelectionChangedListener listener) {
            this.selectionChangedListeners.add(listener);
            if (this.selectionProvider != null) {
                this.selectionProvider.addSelectionChangedListener(listener);
            }
        }

        public void removeSelectionChangedListener(ISelectionChangedListener listener) {
            this.selectionChangedListeners.remove(listener);
            if (this.selectionProvider != null) {
                this.selectionProvider.removeSelectionChangedListener(listener);
            }
        }

        public ISelection getSelection() {
            if (this.selectionProvider != null) {
                return this.selectionProvider.getSelection();
            }
            return null;
        }

        public void setSelection(ISelection selection) {
            if (this.selectionProvider != null) {
                this.selectionProvider.setSelection(selection);
            }
        }
    }

    private class ViewerStateToBeTransferred {
        public Control oldViewer = null;
        public ISelection oldSelection = StructuredSelection.EMPTY;

        private ViewerStateToBeTransferred() {
        }
    }
}

