/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.lib.dataviews.search;

import com.arcway.cockpit.frame.client.lib.dataviews.search.ICockpitSearchStringGenerator;
import com.arcway.cockpit.frame.client.lib.dataviews.search.IItemTypeForSearchProvider;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import de.plans.lib.util.incrementalsearch.ISearchStringGenerator;
import de.plans.lib.util.incrementalsearch.SearchStringNormalizer;
import java.util.Map;

public class SearchStringGenerator<ContentType>
implements ISearchStringGenerator<ContentType> {
    private static final ILogger logger = Logger.getLogger(SearchStringGenerator.class);
    private final Map<String, ICockpitSearchStringGenerator<ContentType>> generators;
    private final IItemTypeForSearchProvider<ContentType> itemTypeProvider;

    public SearchStringGenerator(Map<String, ICockpitSearchStringGenerator<ContentType>> generators, IItemTypeForSearchProvider<ContentType> itemTypeProvider) {
        assert (generators != null) : "generators must not be null";
        this.generators = generators;
        this.itemTypeProvider = itemTypeProvider;
    }

    public String getSearchString(ContentType dataItem) {
        ICockpitSearchStringGenerator<ContentType> searchStringGenerator;
        block3: {
            try {
                String typeID = this.itemTypeProvider.getTypeID(dataItem);
                searchStringGenerator = this.generators.get(typeID);
                if (searchStringGenerator != null) break block3;
                logger.error("Unknown data type");
                return "";
            }
            catch (ClassCastException e) {
                logger.error("Unknown object type");
                return "";
            }
        }
        return SearchStringNormalizer.normalizeString((String)searchStringGenerator.getSearchString(dataItem));
    }
}

