/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.lib.dataviews.search;

import com.arcway.cockpit.frame.client.global.FramePlugin;
import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.global.license.IClientFunctionLicense;
import com.arcway.cockpit.frame.client.global.license.IClientFunctionLicenseType2;
import com.arcway.cockpit.frame.client.lib.dataviews.messages.Messages;
import com.arcway.cockpit.frame.client.lib.dataviews.util.IModuleProjectSwitchListener;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.lib.eclipse.gui.DecoratedImageDescriptor;
import com.arcway.lib.eclipse.resources.ResourceDisposer;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import de.plans.lib.util.incrementalsearch.ISearchAlgorithm;
import de.plans.lib.util.incrementalsearch.ISearchHistoryListener;
import de.plans.lib.util.incrementalsearch.IncrementalSearchProcessor;
import de.plans.lib.util.incrementalsearch.SearchProcessorIsDisposedException;
import de.plans.lib.util.incrementalsearch.SearchStringNormalizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.CoolBar;
import org.eclipse.swt.widgets.CoolItem;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.ActionFactory;

public class SearchFieldContributionItem
extends ContributionItem
implements ISearchHistoryListener,
IModuleProjectSwitchListener {
    private static final ILogger logger = Logger.getLogger(SearchFieldContributionItem.class);
    private Combo combo;
    private Color comboBGCSearchCriterionActive;
    private Color comboBGCSearchCriterionModified;
    private List<String> mostRecentlyReportedSearchHistory = Arrays.asList("");
    private ToolItem toolItem;
    private CoolItem coolItem;
    private Label label;
    private final IncrementalSearchProcessor processor;
    private final ISearchAlgorithm searchAlgorithm;
    private IClientFunctionLicenseType2 requiredLicenseType = null;
    private final IActionBars actionBars;
    private IAction currentGlobalPasteAction;
    private IAction currentGlobalCopyAction;
    private boolean initialValuesSet = false;
    private boolean initialEnablement = false;
    private Image initialImage = null;
    private static final int COOL_ITEM = 1;
    private static final int TOOL_ITEM = 2;
    private static final int COMPOSITE = 3;
    private static final Image enabledImage;
    private static final Image disabledImage;
    private static final Image disabledImageNoLicense;

    static {
        disabledImage = enabledImage = SearchFieldContributionItem.createEnabledImage();
        disabledImageNoLicense = SearchFieldContributionItem.createDisabledImage();
    }

    private static Image createEnabledImage() {
        Image enabledSearchImage = FramePlugin.getImageDescriptor("dataview", "search.gif").createImage();
        ResourceDisposer.markResourceAsSingleton((Resource)enabledSearchImage);
        return enabledSearchImage;
    }

    private static Image createDisabledImage() {
        DecoratedImageDescriptor disabledSearchImageDescriptor = new DecoratedImageDescriptor(FramePlugin.getImageDescriptor("dataview", "search.gif"));
        disabledSearchImageDescriptor.addDecorator(FramePlugin.getImageDescriptor("dataview", "license_restriction.gif"), 3);
        Image disabledSearchImage = disabledSearchImageDescriptor.createImage();
        ResourceDisposer.markResourceAsSingleton((Resource)disabledSearchImage);
        return disabledSearchImage;
    }

    public SearchFieldContributionItem(IncrementalSearchProcessor processor, ISearchAlgorithm searchAlgorithm, IClientFunctionLicenseType2 licenseType, IActionBars actionBars) {
        this(processor, searchAlgorithm, actionBars);
        this.requiredLicenseType = licenseType;
    }

    public SearchFieldContributionItem(IncrementalSearchProcessor processor, ISearchAlgorithm searchAlgorithm, IActionBars actionBars) {
        assert (processor != null) : "processor must not be null";
        assert (searchAlgorithm != null) : "searchAlgorithm must not be null";
        this.processor = processor;
        this.searchAlgorithm = searchAlgorithm;
        this.actionBars = actionBars;
    }

    public void fill(Composite parent) {
        this.createControl(parent, 3);
    }

    public void fill(CoolBar parent, int index) {
        this.coolItem = new CoolItem(parent, 2, index);
        Control control = this.createControl((Composite)parent, 1);
        this.coolItem.setControl(control);
    }

    public void fill(Menu menu, int index) {
        assert (false) : "Can't add a control to a menu";
    }

    public void fill(ToolBar parent, int index) {
        Control control = this.createControl((Composite)parent, 2);
        this.toolItem = new ToolItem(parent, 2, index);
        this.toolItem.setWidth(200);
        this.toolItem.setControl(control);
    }

    protected Control createControl(Composite parent, int option) {
        Composite searchComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.horizontalSpacing = 2;
        layout.marginHeight = 1;
        searchComposite.setLayout((Layout)layout);
        this.label = new Label(searchComposite, 0);
        GridData gridData = new GridData();
        gridData.verticalAlignment = 2;
        gridData.horizontalAlignment = 3;
        this.label.setLayoutData((Object)gridData);
        this.label.setImage(disabledImage);
        this.combo = new Combo(searchComposite, 132);
        gridData = new GridData();
        gridData.widthHint = 200;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.combo.setLayoutData((Object)gridData);
        this.combo.setToolTipText(Messages.getString("SearchFieldContributionItem.PressReturnToStartSearchPlease"));
        this.comboBGCSearchCriterionActive = this.combo.getBackground();
        this.comboBGCSearchCriterionModified = new Color((Device)parent.getDisplay(), 230, 230, 255);
        this.updateComboColors();
        this.combo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SearchFieldContributionItem.this.updateSearchCriterion(SearchFieldContributionItem.this.combo.getText());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                SearchFieldContributionItem.this.updateSearchCriterion(SearchFieldContributionItem.this.combo.getText());
            }
        });
        this.combo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SearchFieldContributionItem.this.updateComboColors();
            }
        });
        this.combo.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                SearchFieldContributionItem.this.currentGlobalPasteAction = SearchFieldContributionItem.this.actionBars.getGlobalActionHandler(ActionFactory.PASTE.getId());
                SearchFieldContributionItem.this.actionBars.setGlobalActionHandler(ActionFactory.PASTE.getId(), (IAction)new Action(){

                    public void run() {
                        SearchFieldContributionItem.this.combo.paste();
                    }
                });
                SearchFieldContributionItem.this.currentGlobalCopyAction = SearchFieldContributionItem.this.actionBars.getGlobalActionHandler(ActionFactory.COPY.getId());
                SearchFieldContributionItem.this.actionBars.setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)new Action(){

                    public void run() {
                        SearchFieldContributionItem.this.combo.copy();
                    }
                });
                SearchFieldContributionItem.this.actionBars.updateActionBars();
            }

            public void focusLost(FocusEvent e) {
                SearchFieldContributionItem.this.updateSearchCriterion(SearchFieldContributionItem.this.combo.getText());
                SearchFieldContributionItem.this.actionBars.setGlobalActionHandler(ActionFactory.PASTE.getId(), SearchFieldContributionItem.this.currentGlobalPasteAction);
                SearchFieldContributionItem.this.actionBars.setGlobalActionHandler(ActionFactory.COPY.getId(), SearchFieldContributionItem.this.currentGlobalCopyAction);
                SearchFieldContributionItem.this.actionBars.updateActionBars();
            }
        });
        this.combo.setEnabled(false);
        if (option == 3 || option != 1) {
            // empty if block
        }
        try {
            this.processor.addSearchHistoryListener((ISearchHistoryListener)this);
        }
        catch (SearchProcessorIsDisposedException e1) {
            logger.error("Tried to add listener to processor that was disposed already", (Throwable)e1);
        }
        if (this.initialValuesSet) {
            this.setEnablement(this.initialEnablement, this.initialImage);
        }
        return searchComposite;
    }

    private void updateComboColors() {
        if (!this.mostRecentlyReportedSearchHistory.isEmpty() && this.combo.getText().equals(this.mostRecentlyReportedSearchHistory.iterator().next())) {
            this.combo.setBackground(this.comboBGCSearchCriterionActive);
        } else {
            this.combo.setBackground(this.comboBGCSearchCriterionModified);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSearchCriterion(String p_keystrokes) {
        SearchFieldContributionItem searchFieldContributionItem = this;
        synchronized (searchFieldContributionItem) {
            try {
                this.processor.updateSearchCriterion(p_keystrokes);
            }
            catch (SearchProcessorIsDisposedException e1) {
                logger.warn("Tried to access the search engine after dispose", (Throwable)e1);
            }
        }
    }

    public void searchHistoryChanged(List<String> querieList) {
        this.removeUnspecificQueries(querieList);
        final List<String> queries = querieList;
        if (this.combo != null && !this.combo.isDisposed()) {
            Display display = this.combo.getDisplay();
            if (display == null) {
                logger.error("Can't apply search results: Item disposed.");
                return;
            }
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (SearchFieldContributionItem.this.combo != null && !SearchFieldContributionItem.this.combo.isDisposed()) {
                        SearchFieldContributionItem.this.mostRecentlyReportedSearchHistory = new ArrayList(queries);
                        Object[] queriesArray = queries.toArray();
                        String[] sQueries = new String[queriesArray.length];
                        int i = 0;
                        while (i < queriesArray.length) {
                            sQueries[i] = (String)queriesArray[i];
                            ++i;
                        }
                        String[] queryStrings = sQueries;
                        String currentText = null;
                        if (queryStrings.length > 0) {
                            currentText = queryStrings[0];
                        }
                        int i2 = 0;
                        while (i2 < queryStrings.length) {
                            if (i2 < SearchFieldContributionItem.this.combo.getItemCount()) {
                                SearchFieldContributionItem.this.combo.setItem(i2, queryStrings[i2]);
                            } else {
                                SearchFieldContributionItem.this.combo.add(queryStrings[i2], i2);
                            }
                            ++i2;
                        }
                        try {
                            SearchFieldContributionItem.this.combo.remove(SearchFieldContributionItem.this.combo.getItemCount(), queryStrings.length - 1);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            // empty catch block
                        }
                        if (currentText != null && SearchFieldContributionItem.this.combo.getText().trim().equals("")) {
                            SearchFieldContributionItem.this.combo.setText(currentText);
                            SearchFieldContributionItem.this.combo.setSelection(new Point(0, currentText.length()));
                        }
                        if (currentText == null) {
                            SearchFieldContributionItem.this.combo.setText("");
                        } else {
                            SearchFieldContributionItem.this.combo.setText(currentText);
                            SearchFieldContributionItem.this.combo.setSelection(new Point(currentText.length(), currentText.length()));
                        }
                        SearchFieldContributionItem.this.updateComboColors();
                    }
                }
            });
        } else {
            logger.error("Tried to set query history while combo was not existing");
        }
    }

    private void removeUnspecificQueries(List<String> queries) {
        if (queries.isEmpty()) {
            return;
        }
        ListIterator<String> i = queries.listIterator(1);
        while (i.hasNext()) {
            boolean specificSearchFound = false;
            String query1 = SearchStringNormalizer.normalizeString((String)i.next());
            Object processedQuery1 = this.searchAlgorithm.processString(query1);
            ListIterator<String> j = queries.listIterator();
            while (j.hasNext()) {
                String query2 = SearchStringNormalizer.normalizeString((String)j.next());
                if (j.nextIndex() == i.nextIndex() || this.searchAlgorithm.matchSubstring(query2, query1, processedQuery1) == -1) continue;
                specificSearchFound = true;
                break;
            }
            if (!specificSearchFound) continue;
            i.remove();
            boolean bl = false;
        }
    }

    public void dispose() {
        try {
            this.processor.removeSearchHistoryListener((ISearchHistoryListener)this);
        }
        catch (SearchProcessorIsDisposedException e) {
            logger.warn((Throwable)e);
        }
        if (this.comboBGCSearchCriterionModified != null) {
            this.comboBGCSearchCriterionModified.dispose();
        }
    }

    @Override
    public void projectSwitched(String projectUID) {
        this.checkLicenseAndSetEnablement(projectUID != null ? ProjectMgr.getProjectMgr().getProjectAgent(projectUID) : null);
        this.mostRecentlyReportedSearchHistory = Arrays.asList("");
        if (this.combo != null && !this.combo.isDisposed()) {
            this.combo.removeAll();
        }
    }

    private void checkLicenseAndSetEnablement(IFrameProjectAgent projectAgent) {
        if (projectAgent != null) {
            if (this.requiredLicenseType != null) {
                IClientFunctionLicense license = projectAgent.getServerLicenseManager().findClientFunctionLicense(this.requiredLicenseType);
                boolean hasLicense = !this.requiredLicenseType.isDenial(license);
                this.setEnablement(hasLicense, hasLicense ? enabledImage : disabledImageNoLicense);
            } else {
                this.setEnablement(true, enabledImage);
            }
        } else {
            this.setEnablement(false, disabledImage);
        }
    }

    private void setEnablement(boolean enabled, Image image) {
        if (this.combo != null) {
            this.combo.setEnabled(enabled);
        } else {
            this.initialEnablement = enabled;
            this.initialImage = image;
            this.initialValuesSet = true;
        }
    }
}

