/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.lib.dataviews.search;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttribute;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeOwner;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeType;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeTypeID;
import com.arcway.cockpit.client.base.interfaces.general.ICategoryOwner;
import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.project.core.categories.ObjectTypeCategories;
import com.arcway.cockpit.frame.client.project.core.categories.ObjectTypeCategory;
import java.util.Locale;

public class CockpitSearchStringGenerator {
    public static final void appendSearchStringForMetaAttributes(StringBuilder searchString, IAttributeOwner attributeOwner, Locale language) {
        for (IAttribute attribute : attributeOwner.getAllAttributes()) {
            IAttributeTypeID attributeTypeID = attribute.getAttributeTypeID();
            IAttributeType attributeType = attributeOwner.getAttributeType(attributeTypeID);
            if (!attributeType.isMetaAttribute()) continue;
            String attributeValueAsString = attributeType.getDataType().getValueAsSingleLineString(attribute.getAttributeValue(), attributeType.getValueRange(), ",", language);
            searchString.append(" ");
            searchString.append(attributeValueAsString);
        }
    }

    public static final void appendSearchStringForCustomProperties(StringBuilder searchString, IAttributeOwner attributeOwner, Locale language) {
        for (IAttributeType attributeType : ObjectTypeCategories.getVisibleUserDefinedAttributeTypesForItem(attributeOwner)) {
            IAttribute attribute = attributeOwner.getAttribute(attributeType.getAttributeTypeID());
            String attributeValueAsString = attributeType.getDataType().getValueAsSingleLineString(attribute.getAttributeValue(), attributeType.getValueRange(), ",", language);
            searchString.append(" ");
            searchString.append(attributeValueAsString);
        }
    }

    public static final void appendSearchStringForObjectTypeCategory(StringBuilder searchString, ICategoryOwner categoryOwner) {
        if (categoryOwner.getCategoryID() != null) {
            ObjectTypeCategory category = ProjectMgr.getProjectMgr().getProjectAgent(categoryOwner.getProjectUID()).getObjectTypeCategoriesManager().getCategory(categoryOwner.getCategoryID());
            searchString.append(category.getDisplayName()).append(' ');
        }
    }
}

