/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.lib.dataviews.projectmanager;

import com.arcway.cockpit.frame.client.global.selection.CockpitSelectionManager;
import com.arcway.cockpit.frame.client.global.selection.CockpitSelectionService;
import com.arcway.cockpit.frame.client.global.selection.IFrameProjectSwitchListener;
import com.arcway.cockpit.frame.client.lib.dataviews.projectmanager.ProjectAssociationManager;
import com.arcway.cockpit.frame.client.lib.dataviews.util.IViewFacade;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.IProjectAgent;
import com.arcway.cockpit.frame.client.project.IProjectOpenListener;
import com.arcway.cockpit.frame.client.project.ProjectAgent;
import com.arcway.cockpit.frame.client.project.modules.IModuleProjectAgent;
import com.arcway.cockpit.frame.client.project.modules.IProjectCloseListener;
import com.arcway.lib.java.collectionmaps.SetMap;
import java.util.HashMap;
import org.eclipse.ui.IWorkbenchWindow;

public class ProjectSelectionService
implements IProjectCloseListener,
IProjectOpenListener {
    private final ProjectAssociationManager projectMgr;
    private final SetMap<IWorkbenchWindow, IViewFacade> map_workbenchWindow_viewFacade;
    private final HashMap<IWorkbenchWindow, IFrameProjectSwitchListener> map_workbenchWindow_projectSwitchListener;

    public ProjectSelectionService(ProjectAssociationManager projectMgr) {
        assert (projectMgr != null) : "projectMgr must not be null";
        this.projectMgr = projectMgr;
        this.map_workbenchWindow_viewFacade = new SetMap();
        this.map_workbenchWindow_projectSwitchListener = new HashMap();
        ProjectAgent.addProjectOpenListener(this);
    }

    public void registerView(IViewFacade viewFacade) {
        IWorkbenchWindow workbenchWindow = viewFacade.getWorkbenchWindow();
        if (!this.map_workbenchWindow_viewFacade.containsKey((Object)workbenchWindow)) {
            ProjectSwitchListenerForWorkbenchWindow projectSwitchHandler = new ProjectSwitchListenerForWorkbenchWindow(workbenchWindow);
            projectSwitchHandler.register();
            this.map_workbenchWindow_projectSwitchListener.put(workbenchWindow, projectSwitchHandler);
        }
        this.map_workbenchWindow_viewFacade.add((Object)workbenchWindow, (Object)viewFacade);
    }

    public void deregisterView(IViewFacade viewFacade) {
        IWorkbenchWindow workbenchWindow = viewFacade.getWorkbenchWindow();
        this.map_workbenchWindow_viewFacade.remove((Object)workbenchWindow, (Object)viewFacade);
        if (!this.map_workbenchWindow_viewFacade.containsKey((Object)workbenchWindow)) {
            ProjectSwitchListenerForWorkbenchWindow projectSwitchHandler = (ProjectSwitchListenerForWorkbenchWindow)this.map_workbenchWindow_projectSwitchListener.get(workbenchWindow);
            projectSwitchHandler.deregister();
            this.map_workbenchWindow_projectSwitchListener.remove(workbenchWindow);
        }
    }

    private void projectSwitched(IWorkbenchWindow workbenchWindow, IProjectAgent projectAgent) {
        String newProjectUID = projectAgent.isOpened() ? projectAgent.getProjectUID() : null;
        this.projectMgr.switchProject(newProjectUID, this.map_workbenchWindow_viewFacade.get((Object)workbenchWindow));
    }

    @Override
    public void projectOpened(IProjectAgent openedProject) {
        ((IModuleProjectAgent)openedProject).addProjectCloseListener(this);
        this.projectMgr.openProject(openedProject);
        for (IWorkbenchWindow workbenchWindow : this.map_workbenchWindow_projectSwitchListener.keySet()) {
            ProjectSwitchListenerForWorkbenchWindow projectSwitchHandler = (ProjectSwitchListenerForWorkbenchWindow)this.map_workbenchWindow_projectSwitchListener.get(workbenchWindow);
            IFrameProjectAgent projectAgent = projectSwitchHandler.getActiveProject();
            if (openedProject != projectAgent) continue;
            this.projectMgr.switchProject(projectAgent.getProjectUID(), this.map_workbenchWindow_viewFacade.get((Object)workbenchWindow));
        }
    }

    @Override
    public void closeProject(IFrameProjectAgent projectAgent) {
        projectAgent.removeProjectCloseListener(this);
        this.projectMgr.closeProject(projectAgent.getProjectUID());
    }

    public String getActiveProjectForView(IViewFacade viewFacade) {
        return this.getActiveProjectForWorkbenchWindow(viewFacade.getWorkbenchWindow());
    }

    public String getActiveProjectForWorkbenchWindow(IWorkbenchWindow workbenchWindow) {
        IFrameProjectAgent projectAgent;
        ProjectSwitchListenerForWorkbenchWindow projectSwitchHandler = (ProjectSwitchListenerForWorkbenchWindow)this.map_workbenchWindow_projectSwitchListener.get(workbenchWindow);
        if (projectSwitchHandler != null && (projectAgent = projectSwitchHandler.getActiveProject()) != null) {
            return projectAgent.getProjectUID();
        }
        return null;
    }

    private class ProjectSwitchListenerForWorkbenchWindow
    implements IFrameProjectSwitchListener {
        private final IWorkbenchWindow workbenchWindow;
        private CockpitSelectionService cockpitSelectionService;
        private IProjectAgent activeProject;

        public ProjectSwitchListenerForWorkbenchWindow(IWorkbenchWindow workbenchWindow) {
            this.workbenchWindow = workbenchWindow;
        }

        public void register() {
            this.cockpitSelectionService = CockpitSelectionManager.getSelectionService(this.workbenchWindow.getSelectionService());
            this.activeProject = this.cockpitSelectionService.getModuleProjectAgent();
            this.cockpitSelectionService.addProjectSwitchListener(this);
        }

        public void deregister() {
            this.cockpitSelectionService.removeProjectSwitchListener(this);
        }

        public IFrameProjectAgent getActiveProject() {
            return (IFrameProjectAgent)this.activeProject;
        }

        @Override
        public void projectSwitched(IProjectAgent projectAgent) {
            this.activeProject = projectAgent;
            ProjectSelectionService.this.projectSwitched(this.workbenchWindow, this.activeProject);
        }
    }
}

