/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.lib.dataviews.filters;

import com.arcway.cockpit.cockpitlib.client.filter.AbstractFilter;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.ui.IMemento;

public class FilterStore {
    private static final String MEMENTO_TYPE_FILTERS_FOR_PROJECT = "filtersForProject";
    private static final String MEMENTO_KEY_PROJECT_UID = "projectUID";
    private static final String MEMENTO_KEY_FILTERING_STATE = "filteringIsSwitchedOn";
    private static final String MEMENTO_TYPE_FILTER = "filter";
    private static final String MEMENTO_KEY_FILTER_ID = "filterID";
    private static final String MEMENTO_KEY_FILTER_STATE = "isActive";
    private static final String MEMENTO_KEY_FILTER_VALUE = "filterValue";
    private boolean isInitialised = false;
    private boolean isFinalised = false;
    private final Map<String, Map<String, FilterState>> filterSettingsMap = new HashMap<String, Map<String, FilterState>>();
    private final Map<String, Boolean> filteringStates = new HashMap<String, Boolean>();

    public void init(IMemento p_memento) {
        assert (!this.isInitialised) : "filter store is already initialised";
        if (p_memento != null) {
            IMemento[] projectMementos;
            IMemento[] iMementoArray = projectMementos = p_memento.getChildren(MEMENTO_TYPE_FILTERS_FOR_PROJECT);
            int n = projectMementos.length;
            int n2 = 0;
            while (n2 < n) {
                IMemento projectMemento = iMementoArray[n2];
                String projectUID = projectMemento.getString(MEMENTO_KEY_PROJECT_UID);
                if (projectUID != null) {
                    String sFilteringState = projectMemento.getString(MEMENTO_KEY_FILTERING_STATE);
                    Boolean filteringState = sFilteringState != null ? Boolean.valueOf(sFilteringState) : Boolean.FALSE;
                    this.filteringStates.put(projectUID, filteringState);
                    HashMap<String, FilterState> projectFilterMap = new HashMap<String, FilterState>();
                    this.filterSettingsMap.put(projectUID, projectFilterMap);
                    IMemento[] iMementoArray2 = projectMemento.getChildren(MEMENTO_TYPE_FILTER);
                    int n3 = iMementoArray2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IMemento filterMemento = iMementoArray2[n4];
                        String filterID = filterMemento.getString(MEMENTO_KEY_FILTER_ID);
                        String sActivation = filterMemento.getString(MEMENTO_KEY_FILTER_STATE);
                        Boolean activation = sActivation != null ? Boolean.valueOf(sActivation) : null;
                        String value = filterMemento.getString(MEMENTO_KEY_FILTER_VALUE);
                        projectFilterMap.put(filterID, new FilterState(value, activation));
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        this.isInitialised = true;
    }

    public void saveAndFinalise(IMemento p_memento) {
        assert (!this.isFinalised) : "memento is already finalised";
        assert (p_memento != null) : "memento must not be null";
        for (Map.Entry<String, Map<String, FilterState>> projectEntry : this.filterSettingsMap.entrySet()) {
            String projectUID = projectEntry.getKey();
            Map<String, FilterState> projectsFilterSettings = projectEntry.getValue();
            IMemento projectMemento = p_memento.createChild(MEMENTO_TYPE_FILTERS_FOR_PROJECT);
            projectMemento.putString(MEMENTO_KEY_PROJECT_UID, projectUID);
            Boolean filteringState = this.filteringStates.get(projectUID);
            if (filteringState != null) {
                projectMemento.putString(MEMENTO_KEY_FILTERING_STATE, filteringState.toString());
            }
            for (Map.Entry<String, FilterState> filterEntry : projectsFilterSettings.entrySet()) {
                String filterID = filterEntry.getKey();
                FilterState filterState = filterEntry.getValue();
                IMemento filterMemento = projectMemento.createChild(MEMENTO_TYPE_FILTER);
                filterMemento.putString(MEMENTO_KEY_FILTER_ID, filterID);
                if (filterState.getActive() != null) {
                    filterMemento.putString(MEMENTO_KEY_FILTER_STATE, filterState.getActive().toString());
                }
                if (filterState.getValue() == null) continue;
                filterMemento.putString(MEMENTO_KEY_FILTER_VALUE, filterState.getValue());
            }
        }
        this.isFinalised = true;
    }

    public void saveFilterSettings(String projectUID, Collection<AbstractFilter> filters, boolean isFilteringSwitchedOn) {
        assert (this.isInitialised) : "memento is not yet initialised";
        assert (!this.isFinalised) : "memento is disposed";
        Map<String, FilterState> projectsFilterSettings = this.filterSettingsMap.get(projectUID);
        if (projectsFilterSettings == null) {
            projectsFilterSettings = new HashMap<String, FilterState>();
            this.filterSettingsMap.put(projectUID, projectsFilterSettings);
        }
        this.filteringStates.put(projectUID, isFilteringSwitchedOn);
        this.saveFilterSettings(projectsFilterSettings, filters);
    }

    public void loadFilterSettings(String projectUID, Collection<AbstractFilter> filters, boolean[] isFilteringSwitchedOn) {
        assert (this.isInitialised) : "memento is not yet initialised";
        assert (!this.isFinalised) : "memento is disposed";
        assert (projectUID != null) : "modelController must not be null";
        Map<String, FilterState> projectsFilterSettings = this.filterSettingsMap.get(projectUID);
        if (projectsFilterSettings == null) {
            projectsFilterSettings = new HashMap<String, FilterState>();
            this.filterSettingsMap.put(projectUID, projectsFilterSettings);
        }
        this.loadFilterSettings(projectsFilterSettings, filters);
        Boolean filteringState = this.filteringStates.get(projectUID);
        isFilteringSwitchedOn[0] = filteringState != null ? filteringState : false;
    }

    private void loadFilterSettings(Map<String, FilterState> filterSettings, Collection<AbstractFilter> filters) {
        for (AbstractFilter filter : filters) {
            FilterState filterState = filterSettings.get(filter.getFilterID());
            if (filterState == null) {
                filterState = new FilterState(null, null);
            }
            Boolean isActive = filterState.getActive();
            String value = filterState.getValue();
            if (isActive != null) {
                filter.setActive(isActive.booleanValue());
            } else {
                filter.resetActivation();
            }
            if (value != null) {
                filter.setFilterValue(value);
                continue;
            }
            filter.resetValue();
        }
    }

    private void saveFilterSettings(Map<String, FilterState> filterSettings, Collection<AbstractFilter> filters) {
        filterSettings.clear();
        for (AbstractFilter filter : filters) {
            FilterState state = new FilterState(filter.getFilterValue(), filter.isActive());
            filterSettings.put(filter.getFilterID(), state);
        }
    }

    private static class FilterState {
        private final String value;
        private final Boolean active;

        public FilterState(String value, Boolean active) {
            this.value = value;
            this.active = active;
        }

        public Boolean getActive() {
            return this.active;
        }

        public String getValue() {
            return this.value;
        }
    }
}

