/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.lib.dataviews.dnd;

import com.arcway.cockpit.frame.client.global.license.IClientFunctionLicense;
import com.arcway.cockpit.frame.client.global.license.IClientFunctionLicenseType2;
import com.arcway.cockpit.frame.client.lib.dataviews.util.IActiveProjectProvider;
import com.arcway.cockpit.frame.client.lib.dataviews.util.IProjectAgentProvider;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.lib.eclipse.transfer.dnd.IDragHandler;
import java.util.Set;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.Transfer;

public final class DragSource
implements IDragHandler {
    private final IDragHandler dragHandler;
    private final int operations;
    private final Set<Transfer> transferTypes;
    private IClientFunctionLicenseType2 licenseType = null;
    private IProjectAgentProvider projectAgentProvider;
    private IActiveProjectProvider activeProjectProvider;

    public DragSource(int operations, Set<Transfer> transferTypes, IDragHandler dragHandler, IClientFunctionLicenseType2 licenseType, IProjectAgentProvider projectManager, IActiveProjectProvider activeProjectProvider) {
        this(operations, transferTypes, dragHandler);
        assert (licenseType == null || projectManager != null);
        this.licenseType = licenseType;
        this.projectAgentProvider = projectManager;
        this.activeProjectProvider = activeProjectProvider;
    }

    public DragSource(int operations, Set<Transfer> transferTypes, IDragHandler dragHandler) {
        assert (transferTypes != null) : "transferTypes must not be null";
        assert (dragHandler != null) : "dragSourceListener must not be null";
        this.operations = operations;
        this.transferTypes = transferTypes;
        this.dragHandler = dragHandler;
    }

    public int getOperations() {
        return this.operations;
    }

    public Set<Transfer> getTransferTypes() {
        return this.transferTypes;
    }

    public boolean isDragPossible(DragSourceEvent event, ISelectionProvider selectionProvider) {
        if (this.licenseAvailable()) {
            return this.dragHandler.isDragPossible(event, selectionProvider);
        }
        return false;
    }

    public Object getDragData(DragSourceEvent event, ISelectionProvider selectionProvider) {
        if (this.licenseAvailable()) {
            return this.dragHandler.getDragData(event, selectionProvider);
        }
        return null;
    }

    public void finishDrag(DragSourceEvent event, ISelectionProvider selectionProvider) {
        if (this.licenseAvailable()) {
            this.dragHandler.finishDrag(event, selectionProvider);
        }
    }

    public boolean licenseAvailable() {
        if (this.licenseType != null) {
            String projectUID = this.activeProjectProvider.getActiveProject();
            if (projectUID != null) {
                IFrameProjectAgent projectAgent = (IFrameProjectAgent)this.projectAgentProvider.getProjectAgent(projectUID);
                IClientFunctionLicense license = projectAgent.getServerLicenseManager().findClientFunctionLicense(this.licenseType);
                boolean hasLicense = !this.licenseType.isDenial(license);
                return hasLicense;
            }
            return false;
        }
        return true;
    }
}

