/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.lib.dataviews.actions;

import com.arcway.cockpit.frame.client.global.FramePlugin;
import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.global.gui.ProjectSelectionAnalyser;
import com.arcway.cockpit.frame.client.global.license.IClientFunctionLicense;
import com.arcway.cockpit.frame.client.global.license.IClientFunctionLicenseType2;
import com.arcway.cockpit.frame.client.lib.dataviews.actions.IActionRunListener;
import com.arcway.cockpit.frame.client.lib.dataviews.actions.IModuleAction;
import com.arcway.cockpit.frame.client.project.ProjectAgent;
import com.arcway.lib.eclipse.gui.DecoratedImageDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public abstract class AbstractModuleAction
extends Action
implements IModuleAction {
    private IWorkbenchPart containingPart;
    private String currentProjectUID = null;
    private ImageDescriptor oldDisabledImage = null;
    private ImageDescriptor oldEnabledImage = null;
    private boolean areImagesReplaced = false;
    private final Collection<IActionRunListener> runListeners = new ArrayList<IActionRunListener>();
    private IAction linkedGlobalAction;

    public AbstractModuleAction() {
        this(1);
    }

    public AbstractModuleAction(int style) {
        super(null, style);
    }

    @Override
    public void setContainingPart(IWorkbenchPart part) {
        this.containingPart = part;
    }

    protected IWorkbenchPart getContainingPart() {
        if (this.containingPart != null) {
            return this.containingPart;
        }
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart();
    }

    protected Shell getContainingShell() {
        if (this.containingPart != null) {
            return this.containingPart.getSite().getShell();
        }
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
    }

    public final void setEnabled(boolean enabled) {
        this.setActionEnablementAndIcon(enabled);
        this.updateLinkedGlobalAction();
    }

    private void setActionEnablementAndIcon(boolean enablement) {
        ProjectAgent projectAgent = ProjectMgr.getProjectMgr().getProjectAgent(this.currentProjectUID);
        if (projectAgent != null) {
            boolean hasLicense = true;
            IClientFunctionLicenseType2 licenseType = this.getRequiredLicenseType();
            if (licenseType != null) {
                IClientFunctionLicense license = projectAgent.getServerLicenseManager().findClientFunctionLicense(licenseType);
                boolean bl = hasLicense = !licenseType.isDenial(license);
            }
            if (!hasLicense) {
                this.setNoLicenseLabel();
                super.setEnabled(false);
            } else {
                this.resetImages();
                super.setEnabled(enablement);
            }
        } else {
            this.resetImages();
            super.setEnabled(enablement);
        }
    }

    private void setNoLicenseLabel() {
        if (!this.areImagesReplaced) {
            this.oldDisabledImage = this.getDisabledImageDescriptor();
            this.oldEnabledImage = this.getImageDescriptor();
            this.areImagesReplaced = true;
        }
        ImageDescriptor disabledImage = this.oldDisabledImage;
        ImageDescriptor enabledImage = this.oldEnabledImage;
        if (disabledImage == null && enabledImage != null) {
            disabledImage = ImageDescriptor.createWithFlags((ImageDescriptor)enabledImage, (int)1);
        }
        if (disabledImage != null) {
            DecoratedImageDescriptor decoratedImage = new DecoratedImageDescriptor(disabledImage);
            ImageDescriptor decorator = FramePlugin.getImageDescriptor("dataview", "license_restriction.gif");
            decoratedImage.addDecorator(decorator, 3);
            super.setDisabledImageDescriptor((ImageDescriptor)decoratedImage);
        } else {
            super.setDisabledImageDescriptor(FramePlugin.getImageDescriptor("dataview", "license_restriction_16x16.gif"));
        }
        if (enabledImage != null) {
            ImageDescriptor greyedImage = ImageDescriptor.createWithFlags((ImageDescriptor)enabledImage, (int)2);
            DecoratedImageDescriptor decoratedImage = new DecoratedImageDescriptor(greyedImage);
            ImageDescriptor decorator = FramePlugin.getImageDescriptor("dataview", "license_restriction.gif");
            decoratedImage.addDecorator(decorator, 3);
            super.setImageDescriptor((ImageDescriptor)decoratedImage);
        } else {
            super.setImageDescriptor(FramePlugin.getImageDescriptor("dataview", "license_restriction_16x16.gif"));
        }
    }

    private void resetImages() {
        if (this.areImagesReplaced) {
            super.setDisabledImageDescriptor(this.oldDisabledImage);
            super.setImageDescriptor(this.oldEnabledImage);
            this.oldDisabledImage = null;
            this.oldEnabledImage = null;
            this.areImagesReplaced = false;
        }
    }

    public final void setDisabledImageDescriptor(ImageDescriptor newImage) {
        super.setDisabledImageDescriptor(newImage);
        if (this.areImagesReplaced) {
            this.oldDisabledImage = newImage;
        }
        this.setEnabled(this.isEnabled());
    }

    public final void setImageDescriptor(ImageDescriptor newImage) {
        super.setImageDescriptor(newImage);
        if (this.areImagesReplaced) {
            this.oldEnabledImage = newImage;
        }
        this.setEnabled(this.isEnabled());
    }

    protected IClientFunctionLicenseType2 getRequiredLicenseType() {
        return null;
    }

    public final void selectionChanged(IWorkbenchPart part, ISelection selection) {
        String projectUID = ProjectSelectionAnalyser.extractProjectUID(selection);
        if (projectUID != null) {
            this.currentProjectUID = projectUID;
        }
        this.handleSelectionChanged(part, selection);
    }

    protected abstract void handleSelectionChanged(IWorkbenchPart var1, ISelection var2);

    @Override
    public final void projectSwitched(String projectUID) {
        this.currentProjectUID = projectUID != null ? projectUID : null;
        this.handleProjectChanged(projectUID);
    }

    protected abstract void handleProjectChanged(String var1);

    public final void addActionRunListener(IActionRunListener listener) {
        this.runListeners.add(listener);
    }

    public final void removeActionRunListener(IActionRunListener listener) {
        this.runListeners.remove(listener);
    }

    protected final void notifyRunListeners() {
        for (IActionRunListener listener : this.runListeners) {
            listener.actionRun(this);
        }
    }

    public void setLinkedGlobalAction(IAction globalAction) {
        this.linkedGlobalAction = null;
        if (globalAction != null) {
            this.setText(globalAction.getText());
            this.setToolTipText(globalAction.getToolTipText());
            this.setDescription(globalAction.getDescription());
            this.setImageDescriptor(globalAction.getImageDescriptor());
            this.setDisabledImageDescriptor(globalAction.getDisabledImageDescriptor());
            this.setHoverImageDescriptor(globalAction.getHoverImageDescriptor());
            this.setEnabled(globalAction.isEnabled());
            this.linkedGlobalAction = globalAction;
            this.updateLinkedGlobalAction();
        }
    }

    public void unsetLinkedGlobalAction() {
        this.linkedGlobalAction = null;
    }

    private void updateLinkedGlobalAction() {
        if (this.linkedGlobalAction != null) {
            this.linkedGlobalAction.setText(this.getText());
            this.linkedGlobalAction.setToolTipText(this.getToolTipText());
            this.linkedGlobalAction.setDescription(this.getDescription());
            this.linkedGlobalAction.setImageDescriptor(this.getImageDescriptor());
            this.linkedGlobalAction.setDisabledImageDescriptor(this.getDisabledImageDescriptor());
            this.linkedGlobalAction.setHoverImageDescriptor(this.getHoverImageDescriptor());
            this.linkedGlobalAction.setEnabled(this.isEnabled());
        }
    }

    public void projectChanged(String projectUID) {
        this.currentProjectUID = projectUID;
    }
}

