/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.tools.attributesetter;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeType;
import com.arcway.cockpit.frame.client.global.Messages;
import com.arcway.cockpit.frame.client.global.tools.attributesetter.AttributeSetterChooseAttributeWizardPage;
import com.arcway.cockpit.frame.client.global.tools.attributesetter.AttributeSetterChooseValueWizardPage;
import com.arcway.cockpit.frame.client.global.tools.attributesetter.AttributeSetterTool;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.core.framedata.ModificationProblem;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.IUniqueElement;
import com.arcway.lib.eclipse.gui.ModificationProblemsDialog;
import de.plans.psc.client.communication.LoginCanceledException;
import de.plans.psc.client.communication.ServerNotAvailableException;
import de.plans.psc.client.communication.UnknownServerException;
import de.plans.psc.shared.serverexceptions.EXServerException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;

public class AttributeSetterWizard
extends Wizard {
    private final IFrameProjectAgent projectAgent;
    private final Collection<IUniqueElement> selectedUniqueElements;
    private Collection<AttributeSetterChooseValueWizardPage> chooseValuePages;

    public AttributeSetterWizard(IFrameProjectAgent projectAgent, Collection<IUniqueElement> selectedUniqueElements) {
        this.projectAgent = projectAgent;
        this.selectedUniqueElements = selectedUniqueElements;
        this.setWindowTitle(Messages.getString("AttributeSetterWizard.Title"));
    }

    public void addPages() {
        List<IAttributeType> attributeTypes = AttributeSetterTool.getAvailableAttributeTypes(this.projectAgent);
        AttributeSetterChooseAttributeWizardPage attributeWizardPage = new AttributeSetterChooseAttributeWizardPage(attributeTypes, this.selectedUniqueElements.size());
        this.addPage((IWizardPage)attributeWizardPage);
        this.chooseValuePages = new ArrayList<AttributeSetterChooseValueWizardPage>();
        for (IAttributeType attributeType : attributeTypes) {
            AttributeSetterChooseValueWizardPage valueWizardPage = new AttributeSetterChooseValueWizardPage(attributeType, this.selectedUniqueElements.size());
            this.addPage((IWizardPage)valueWizardPage);
            this.chooseValuePages.add(valueWizardPage);
        }
    }

    public boolean performFinish() {
        Collection<ModificationProblem> problems;
        AttributeSetterChooseAttributeWizardPage attributeWizardPage = this.getAttributePage();
        IAttributeType attributeType = attributeWizardPage.getAttributeType();
        AttributeSetterChooseValueWizardPage valueWizardPage = this.getValuePage(attributeType);
        Object newValue = valueWizardPage.getAttributeValue();
        try {
            this.projectAgent.getFrameServerProxy().refreshProject();
            AttributeSetterTool attributeSetterTool = new AttributeSetterTool(this.projectAgent, attributeType.getDataType());
            problems = attributeSetterTool.process(attributeType, newValue, this.selectedUniqueElements);
        }
        catch (ServerNotAvailableException e) {
            problems = Collections.singletonList(new ModificationProblem((Exception)((Object)e), ""));
        }
        catch (EXServerException e) {
            problems = Collections.singletonList(new ModificationProblem((Exception)((Object)e), ""));
        }
        catch (LoginCanceledException e) {
            problems = Collections.singletonList(new ModificationProblem((Exception)((Object)e), ""));
        }
        catch (UnknownServerException e) {
            problems = Collections.singletonList(new ModificationProblem((Exception)((Object)e), ""));
        }
        ModificationProblemsDialog resultDialog = new ModificationProblemsDialog(problems, this.getShell());
        resultDialog.setBlockOnOpen(true);
        resultDialog.open();
        this.disposeResources();
        return true;
    }

    public boolean performCancel() {
        this.disposeResources();
        return super.performCancel();
    }

    private AttributeSetterChooseAttributeWizardPage getAttributePage() {
        AttributeSetterChooseAttributeWizardPage attributeWizardPage = (AttributeSetterChooseAttributeWizardPage)this.getPage("attribute");
        return attributeWizardPage;
    }

    private AttributeSetterChooseValueWizardPage getValuePage(IAttributeType attributeType) {
        AttributeSetterChooseValueWizardPage valueWizardPage = (AttributeSetterChooseValueWizardPage)this.getPage(AttributeSetterChooseValueWizardPage.getPageName(attributeType));
        return valueWizardPage;
    }

    public boolean canFinish() {
        return this.getContainer().getCurrentPage().getNextPage() == null;
    }

    private void disposeResources() {
        for (AttributeSetterChooseValueWizardPage page : this.chooseValuePages) {
            page.disposeResources();
        }
    }
}

