/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.tools.attributesetter;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttribute;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeType;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeTypeDataType;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeTypeID;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IValueRange;
import com.arcway.cockpit.client.base.interfaces.frame.permissions.EXNoPermission;
import com.arcway.cockpit.frame.client.global.Messages;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.core.framedata.Attribute;
import com.arcway.cockpit.frame.client.project.core.framedata.ModificationProblem;
import com.arcway.cockpit.frame.client.project.core.framedata.transactionmanagement.LocksAndPermissionsTransactionController;
import com.arcway.cockpit.frame.client.project.core.locking.EXNoLock;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.IUniqueElement;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.IUniqueElementRW;
import com.arcway.cockpit.frame.shared.userdefinedattributes.ExInvalidAttributeType;
import com.arcway.cockpit.frame.shared.userdefinedattributes.ExInvalidDataType;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.ui.IModificationProblem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.osgi.util.NLS;

public class AttributeSetterTool {
    private static final ILogger LOGGER = Logger.getLogger(AttributeSetterTool.class);
    private final IFrameProjectAgent projectAgent;
    private final IAttributeTypeDataType dataType;

    public static List<IAttributeType> getAvailableAttributeTypes(IFrameProjectAgent projectAgent) {
        List<IAttributeType> attributeTypes = projectAgent.getFrameUserDefinedAttributeTypesManager().getAllUserDefinedAttributeTypes("com.arcway.cockpit.uniqueelement");
        Collections.sort(attributeTypes, new Comparator<IAttributeType>(){

            @Override
            public int compare(IAttributeType attributeType1, IAttributeType attributeType2) {
                String name1 = attributeType1.getDisplayName();
                String name2 = attributeType2.getDisplayName();
                return name1.compareToIgnoreCase(name2);
            }
        });
        return attributeTypes;
    }

    public AttributeSetterTool(IFrameProjectAgent projectAgent, IAttributeTypeDataType dataType) {
        this.projectAgent = projectAgent;
        this.dataType = dataType;
    }

    public Collection<IAttributeType> getSupportedAttributeTypes() {
        ArrayList<IAttributeType> attributeTypes = new ArrayList<IAttributeType>();
        for (IAttributeType attributeType : this.projectAgent.getFrameUserDefinedAttributeTypesManager().getAllUserDefinedAttributeTypes("com.arcway.cockpit.uniqueelement")) {
            if (!attributeType.getDataType().getID().equals(this.dataType.getID())) continue;
            attributeTypes.add(attributeType);
        }
        return attributeTypes;
    }

    public Collection<IModificationProblem> process(final IAttributeType attributeType, final Object newValue, final Collection<IUniqueElement> uniqueElementsToProcess) {
        final ArrayList<IModificationProblem> problems = new ArrayList<IModificationProblem>();
        IValueRange valueRange = attributeType.getValueRange();
        if (this.dataType.supportsValue(newValue, valueRange)) {
            this.projectAgent.getModelTransactionManager().executeTransaction(new Runnable(){

                @Override
                public void run() {
                    problems.addAll(AttributeSetterTool.this.setAttributes(attributeType, newValue, uniqueElementsToProcess));
                }
            });
        } else {
            problems.add(new ModificationProblem(Messages.getString("AttributeSetter.ValueNotSupported"), Messages.getString("AttributeSetter.NothingDoneConsequence"), 4));
        }
        if (problems.isEmpty()) {
            problems.add(new ModificationProblem(Messages.getString("AttributeSetter.NothingDoneCause"), Messages.getString("AttributeSetter.NothingDoneConsequence"), 4));
        }
        return problems;
    }

    private Collection<IModificationProblem> setAttributes(IAttributeType attributeType, Object newValue, Collection<IUniqueElement> uniqueElementsToProcess) {
        ArrayList<IModificationProblem> problems = new ArrayList<IModificationProblem>();
        StringBuffer successMessage = new StringBuffer();
        for (IUniqueElement uniqueElement : uniqueElementsToProcess) {
            IUniqueElementRW uniqueElementRW = (IUniqueElementRW)uniqueElement;
            Object currentValue = this.getAttributeValue(uniqueElement, attributeType);
            if (currentValue.equals(newValue)) continue;
            Attribute attribute = new Attribute(attributeType.getAttributeTypeID(), newValue);
            LocksAndPermissionsTransactionController transactionController = new LocksAndPermissionsTransactionController(this.projectAgent);
            uniqueElementRW.requestAttributeModificationPermission(attribute, transactionController);
            Collection<IModificationProblem> currentProblems = transactionController.execute();
            if (currentProblems.isEmpty()) {
                try {
                    uniqueElementRW.setAttribute(attribute);
                    if (successMessage.length() > 0) {
                        successMessage.append(", ");
                    }
                    successMessage.append('\"');
                    successMessage.append(uniqueElement.getElementName());
                    successMessage.append('\"');
                }
                catch (ExInvalidAttributeType e) {
                    LOGGER.error("Unexpected error while setting unique element's attribute.", (Throwable)e);
                }
                catch (ExInvalidDataType e) {
                    LOGGER.error("Unexpected error while setting unique element's attribute.", (Throwable)e);
                }
                catch (EXNoPermission e) {
                    LOGGER.error("Unexpected error while setting unique element's attribute.", (Throwable)e);
                }
                catch (EXNoLock e) {
                    LOGGER.error("Unexpected error while setting unique element's attribute.", (Throwable)e);
                }
                continue;
            }
            problems.addAll(currentProblems);
        }
        if (successMessage.length() > 0) {
            problems.add(new ModificationProblem(Messages.getString("AttributeSetter.AttributesSetCause"), NLS.bind((String)Messages.getString("AttributeSetter.AttributesSetConsequence"), (Object)successMessage.toString()), 4));
        }
        return problems;
    }

    private Object getAttributeValue(IUniqueElement uniqueElement, IAttributeType attributeType) {
        IAttribute attribute = this.getAttribute(uniqueElement, attributeType);
        Object value = attribute != null ? attribute.getAttributeValue() : null;
        return value;
    }

    private IAttribute getAttribute(IUniqueElement uniqueElement, IAttributeType attributeType) {
        IAttributeTypeID attributeTypeID = attributeType.getAttributeTypeID();
        IAttribute attribute = uniqueElement.getAttribute(attributeTypeID);
        return attribute;
    }
}

